/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.httpclient;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.httpclient.HttpClientFactory;
import org.carrot2.util.httpclient.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static final String COMPRESSION_GZIP = "gzip";
    private static final String COMPRESSION_NONE = "uncompressed";

    private HttpUtils() {
    }

    public static Response doGET(String string, Collection<NameValuePair> arrayList, Collection<Header> collection, String string2, String string3, int n, RedirectStrategy redirectStrategy) throws IOException {
        DefaultHttpClient defaultHttpClient = HttpClientFactory.getTimeoutingClient(n);
        defaultHttpClient.setRedirectStrategy(redirectStrategy);
        defaultHttpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        HttpGet httpGet = new HttpGet();
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        Response response = new Response();
        try {
            Header header2;
            arrayList = arrayList == null ? Lists.newArrayList() : Lists.newArrayList((Iterable)arrayList);
            URI uRI = new URI(string);
            arrayList.addAll(URLEncodedUtils.parse((URI)uRI, (String)"UTF-8"));
            uRI = URIUtils.createURI((String)uRI.getScheme(), (String)uRI.getHost(), (int)uRI.getPort(), (String)uRI.getPath(), (String)URLEncodedUtils.format((List)Lists.newArrayList((Iterable)arrayList), (String)"UTF-8"), null);
            httpGet.setURI(uRI);
            httpGet.setHeader(HttpHeaders.URL_ENCODED);
            httpGet.setHeader(HttpHeaders.GZIP_ENCODING);
            if (collection != null) {
                for (Header header2 : collection) {
                    httpGet.setHeader(header2);
                }
            }
            if (string2 != null && string3 != null) {
                defaultHttpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(string2, string3));
                header2 = new BasicAuthCache();
                header2.put(new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme()), (AuthScheme)new BasicScheme());
                basicHttpContext.setAttribute("http.auth.auth-cache", (Object)header2);
            }
            logger.debug("GET: " + httpGet.getURI());
            header2 = defaultHttpClient.execute((HttpUriRequest)httpGet, (HttpContext)basicHttpContext);
            response.status = header2.getStatusLine().getStatusCode();
            response.statusMessage = header2.getStatusLine().getReasonPhrase();
            HttpEntity httpEntity = header2.getEntity();
            InputStream inputStream = httpEntity.getContent();
            Header header3 = httpEntity.getContentEncoding();
            if (header3 != null && COMPRESSION_GZIP.equalsIgnoreCase(header3.getValue())) {
                inputStream = new GZIPInputStream(inputStream);
                response.compression = COMPRESSION_GZIP;
            } else {
                response.compression = COMPRESSION_NONE;
            }
            Header[] headerArray = header2.getAllHeaders();
            response.headers = new String[headerArray.length][];
            int n2 = 0;
            while (n2 < headerArray.length) {
                response.headers[n2] = new String[]{headerArray[n2].getName(), headerArray[n2].getValue()};
                ++n2;
            }
            response.payload = StreamUtils.readFullyAndClose(inputStream);
            Response response2 = response;
            return response2;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
    }

    public static final class Response {
        public byte[] payload;
        public int status;
        public String compression;
        public String[][] headers;
        public String statusMessage;

        public InputStream getPayloadAsStream() {
            return new ByteArrayInputStream(this.payload);
        }
    }
}

