/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.pool;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.carrot2.util.Pair;
import org.carrot2.util.pool.IActivationListener;
import org.carrot2.util.pool.IDisposalListener;
import org.carrot2.util.pool.IInstantiationListener;
import org.carrot2.util.pool.IParameterizedPool;
import org.carrot2.util.pool.IPassivationListener;

public final class FixedSizePool<T, P>
implements IParameterizedPool<T, P> {
    private Map<Pair<Class<? extends T>, P>, ArrayList<T>> instances = Maps.newHashMap();
    private IInstantiationListener<T, P> instantiationListener;
    private IActivationListener<T, P> activationListener;
    private IPassivationListener<T, P> passivationListener;
    private IDisposalListener<T, P> disposalListener;
    private final int listSizePerKey;

    public FixedSizePool(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Pool size must be greater than zero: " + n);
        }
        this.listSizePerKey = n;
    }

    @Override
    public void init(IInstantiationListener<T, P> iInstantiationListener, IActivationListener<T, P> iActivationListener, IPassivationListener<T, P> iPassivationListener, IDisposalListener<T, P> iDisposalListener) {
        this.instantiationListener = iInstantiationListener;
        this.activationListener = iActivationListener;
        this.passivationListener = iPassivationListener;
        this.disposalListener = iDisposalListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I extends T> I borrowObject(Class<I> clazz, P p) throws InstantiationException, IllegalAccessException {
        T t;
        FixedSizePool fixedSizePool = this;
        synchronized (fixedSizePool) {
            if (this.instances == null) {
                throw new IllegalStateException("The pool has already been disposed of");
            }
            Pair<Class<Class<I>>, P> pair = new Pair<Class<Class<I>>, P>(clazz, p);
            ArrayList<T> arrayList = this.instances.get(pair);
            if (arrayList == null) {
                arrayList = this.createInstancePool(clazz, p);
                this.instances.put(pair, arrayList);
            }
            while (arrayList.size() == 0) {
                try {
                    this.wait();
                    if (this.instances != null) continue;
                    throw new InstantiationException("Pool disposed while waiting.");
                }
                catch (InterruptedException interruptedException) {
                    throw new InstantiationException("Interrupted while waiting for the object pool: " + clazz + ", " + p);
                }
            }
            t = arrayList.remove(arrayList.size() - 1);
        }
        if (this.activationListener != null) {
            this.activationListener.activate(t, p);
        }
        return (I)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(T t, P p) {
        if (t == null) {
            throw new IllegalArgumentException("Null could not have been acquired from this pool.");
        }
        if (this.passivationListener != null) {
            this.passivationListener.passivate(t, p);
        }
        FixedSizePool fixedSizePool = this;
        synchronized (fixedSizePool) {
            if (this.instances == null) {
                return;
            }
            Pair pair = new Pair(t.getClass(), p);
            ArrayList<T> arrayList = this.instances.get(pair);
            if (arrayList == null) {
                throw new IllegalStateException("Returning an object that was never borrowed: " + t);
            }
            for (T t2 : arrayList) {
                if (t2 == null || t2 != t) continue;
                throw new IllegalStateException("Object has not been borrowed");
            }
            arrayList.add(t);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        FixedSizePool fixedSizePool = this;
        synchronized (fixedSizePool) {
            if (this.instances == null) {
                return;
            }
            Map<Pair<Class<T>, P>, ArrayList<T>> map = this.instances;
            this.instances = null;
            this.notifyAll();
            for (Map.Entry<Pair<Class<T>, P>, ArrayList<T>> entry : map.entrySet()) {
                for (T t : entry.getValue()) {
                    if (t == null || this.disposalListener == null) continue;
                    this.disposalListener.dispose(t, entry.getKey().objectB);
                }
            }
        }
    }

    private <I extends T> ArrayList<T> createInstancePool(Class<I> clazz, P p) throws InstantiationException, IllegalAccessException {
        ArrayList arrayList = Lists.newArrayList();
        int n = 0;
        while (n < this.listSizePerKey) {
            I i = clazz.newInstance();
            if (this.instantiationListener != null) {
                this.instantiationListener.objectInstantiated(i, p);
            }
            arrayList.add(i);
            ++n;
        }
        return arrayList;
    }
}

