/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.pool;

import com.google.common.collect.Maps;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.carrot2.util.Pair;
import org.carrot2.util.pool.IActivationListener;
import org.carrot2.util.pool.IDisposalListener;
import org.carrot2.util.pool.IInstantiationListener;
import org.carrot2.util.pool.IParameterizedPool;
import org.carrot2.util.pool.IPassivationListener;

public final class SoftUnboundedPool<T, P>
implements IParameterizedPool<T, P> {
    private Map<Pair<Class<? extends T>, P>, List<SoftReference<T>>> instances = Maps.newHashMap();
    private IInstantiationListener<T, P> instantiationListener;
    private IActivationListener<T, P> activationListener;
    private IPassivationListener<T, P> passivationListener;
    private IDisposalListener<T, P> disposalListener;

    @Override
    public void init(IInstantiationListener<T, P> iInstantiationListener, IActivationListener<T, P> iActivationListener, IPassivationListener<T, P> iPassivationListener, IDisposalListener<T, P> iDisposalListener) {
        this.instantiationListener = iInstantiationListener;
        this.activationListener = iActivationListener;
        this.passivationListener = iPassivationListener;
        this.disposalListener = iDisposalListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I extends T> I borrowObject(Class<I> clazz, P p) throws InstantiationException, IllegalAccessException {
        Object t = null;
        SoftUnboundedPool softUnboundedPool = this;
        synchronized (softUnboundedPool) {
            if (this.instances == null) {
                throw new IllegalStateException("The pool has already been disposed of");
            }
            Pair<Class<Class<I>>, P> pair = new Pair<Class<Class<I>>, P>(clazz, p);
            List<SoftReference<T>> list = this.instances.get(pair);
            if (list == null) {
                list = new ArrayList<SoftReference<T>>();
                this.instances.put(pair, list);
            }
            while (list.size() > 0 && t == null) {
                t = list.remove(0).get();
            }
        }
        if (t == null) {
            t = clazz.newInstance();
            if (this.instantiationListener != null) {
                this.instantiationListener.objectInstantiated(t, p);
            }
        }
        if (this.activationListener != null) {
            this.activationListener.activate(t, p);
        }
        return (I)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(T t, P p) {
        if (t == null) {
            return;
        }
        if (this.passivationListener != null) {
            this.passivationListener.passivate(t, p);
        }
        SoftUnboundedPool softUnboundedPool = this;
        synchronized (softUnboundedPool) {
            if (this.instances == null) {
                return;
            }
            Pair pair = new Pair(t.getClass(), p);
            List<SoftReference<T>> list = this.instances.get(pair);
            if (list == null) {
                throw new IllegalStateException("Returning an object that was never borrowed: " + t);
            }
            for (SoftReference<T> softReference : list) {
                T t2 = softReference.get();
                if (t2 == null || t2 != t) continue;
                throw new IllegalStateException("Object has not been borrowed");
            }
            list.add(new SoftReference<T>(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        SoftUnboundedPool softUnboundedPool = this;
        synchronized (softUnboundedPool) {
            if (this.instances == null) {
                return;
            }
            Map<Pair<Class<T>, P>, List<SoftReference<T>>> map = this.instances;
            this.instances = null;
            for (Map.Entry<Pair<Class<T>, P>, List<SoftReference<T>>> entry : map.entrySet()) {
                for (SoftReference<T> softReference : entry.getValue()) {
                    T t = softReference.get();
                    if (t == null || this.disposalListener == null) continue;
                    this.disposalListener.dispose(t, entry.getKey().objectB);
                }
            }
        }
    }
}

