/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.lang.ObjectUtils;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;
import org.carrot2.util.resource.URLResource;

public final class ClassLoaderLocator
implements IResourceLocator {
    private final ClassLoader loader;

    public ClassLoaderLocator(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Class loader must be not-null.");
        }
        this.loader = classLoader;
    }

    @Override
    public IResource[] getAll(String string) {
        return ClassLoaderLocator.getAll(this.loader, string);
    }

    static IResource[] getAll(ClassLoader classLoader, String string) {
        ArrayList arrayList = Lists.newArrayList();
        try {
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                arrayList.add(new URLResource(uRL));
            }
        }
        catch (IOException iOException) {}
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    @Override
    public int hashCode() {
        return this.loader.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof ClassLoaderLocator) {
            return ObjectUtils.equals((Object)this.loader, (Object)((ClassLoaderLocator)object).loader);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [class loader: " + this.loader + "]";
    }
}

