/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.ObjectUtils;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.resource.IResource;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="class-loader-resource")
public final class ClassLoaderResource
implements IResource {
    private ClassLoader clazzLoader;
    @Attribute
    private String resource;

    ClassLoaderResource() {
        this(null);
    }

    public ClassLoaderResource(String string) {
        this(Thread.currentThread().getContextClassLoader(), string);
    }

    public ClassLoaderResource(ClassLoader classLoader, String string) {
        this.clazzLoader = classLoader;
        this.resource = string;
    }

    @Override
    public InputStream open() throws IOException {
        InputStream inputStream = this.clazzLoader.getResourceAsStream(this.resource);
        if (inputStream == null) {
            throw new IOException("Resource not found: " + this.toString());
        }
        return StreamUtils.prefetch(inputStream);
    }

    public boolean equals(Object object) {
        if (object instanceof ClassLoaderResource) {
            return ObjectUtils.equals((Object)((ClassLoaderResource)object).resource, (Object)this.resource) && ObjectUtils.equals((Object)((ClassLoaderResource)object).clazzLoader, (Object)this.clazzLoader);
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.clazzLoader) ^ ObjectUtils.hashCode((Object)this.resource);
    }

    public String toString() {
        return "[CLASSPATH RESOURCE: " + this.resource + "@" + this.clazzLoader.toString() + "]";
    }

    public static ClassLoaderResource valueOf(String string) {
        try {
            ClassLoaderResource classLoaderResource = new ClassLoaderResource(string);
            classLoaderResource.open().close();
            return classLoaderResource;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

