/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.File;
import org.apache.commons.lang.ObjectUtils;
import org.carrot2.util.resource.FileResource;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;

public final class DirLocator
implements IResourceLocator {
    private File dir;

    public DirLocator(File file) {
        this.dir = file;
    }

    public DirLocator(String string) {
        this(string == null ? null : new File(string));
    }

    @Override
    public IResource[] getAll(String string) {
        if (this.dir != null && this.dir.isDirectory() && this.dir.canRead()) {
            string = string.replace('/', File.separatorChar);
            while (string.startsWith(File.separator)) {
                string = string.substring(1);
            }
            File file = new File(this.dir, string);
            if (file.isFile() && file.canRead()) {
                return new IResource[]{new FileResource(file)};
            }
        }
        return new IResource[0];
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.dir);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof DirLocator) {
            return ObjectUtils.equals((Object)this.dir, (Object)((DirLocator)object).dir);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [dir: " + (this.dir == null ? "null" : this.dir.getAbsolutePath()) + "]";
    }
}

