/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;

public final class PrefixDecoratorLocator
implements IResourceLocator {
    private final IResourceLocator delegate;
    private final String prefix;

    public PrefixDecoratorLocator(IResourceLocator iResourceLocator, String string) {
        if (iResourceLocator == null) {
            throw new IllegalArgumentException("Delegate locator must not be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Prefix must not be null.");
        }
        this.delegate = iResourceLocator;
        this.prefix = string;
    }

    @Override
    public IResource[] getAll(String string) {
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        return this.delegate.getAll(String.valueOf(this.prefix) + string);
    }

    @Override
    public int hashCode() {
        return this.prefix.hashCode() ^ this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof PrefixDecoratorLocator) {
            PrefixDecoratorLocator prefixDecoratorLocator = (PrefixDecoratorLocator)object;
            return this.delegate.equals(prefixDecoratorLocator.delegate) && this.prefix.equals(prefixDecoratorLocator.prefix);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [prefix: " + this.prefix + ", delegate: " + this.delegate + "]";
    }
}

