/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.carrot2.util.annotations.ThreadSafe;
import org.carrot2.util.resource.ContextClassLoaderLocator;
import org.carrot2.util.resource.DirLocator;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ResourceLookup {
    private static final Logger logger = LoggerFactory.getLogger(ResourceLookup.class);
    private final IResourceLocator[] locators;

    public ResourceLookup(Location ... locationArray) {
        this.locators = new IResourceLocator[locationArray.length];
        int n = 0;
        while (n < this.locators.length) {
            this.locators[n] = locationArray[n].locator;
            ++n;
        }
    }

    public ResourceLookup(IResourceLocator ... iResourceLocatorArray) {
        this.locators = Arrays.copyOf(iResourceLocatorArray, iResourceLocatorArray.length);
    }

    public ResourceLookup(List<IResourceLocator> list) {
        this(list.toArray(new IResourceLocator[list.size()]));
    }

    public IResource[] getAll(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("getAll(").append("):\n\t").append(string);
        ArrayList arrayList = Lists.newArrayList();
        IResourceLocator[] iResourceLocatorArray = this.locators;
        int n = this.locators.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceLocator iResourceLocator = iResourceLocatorArray[n2];
            IResource[] iResourceArray = iResourceLocator.getAll(string);
            stringBuilder.append("\n\t- ").append(String.valueOf(iResourceArray.length) + " " + ResourceLookup.pluralize("hit", iResourceArray.length) + " from: ").append(iResourceLocator);
            int n3 = 0;
            while (n3 < iResourceArray.length) {
                stringBuilder.append("\n\t  - ").append(iResourceArray[n3]);
                if (!arrayList.contains(iResourceArray[n3])) {
                    arrayList.add(iResourceArray[n3]);
                }
                ++n3;
            }
            ++n2;
        }
        logger.debug(stringBuilder.toString());
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public IResource getFirst(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("getFirst(").append("):\n\t").append(string);
        IResource iResource = null;
        IResourceLocator[] iResourceLocatorArray = this.locators;
        int n = this.locators.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceLocator iResourceLocator = iResourceLocatorArray[n2];
            if (iResource == null) {
                IResource[] iResourceArray = iResourceLocator.getAll(string);
                int n3 = iResourceArray != null ? iResourceArray.length : 0;
                stringBuilder.append("\n\t- ").append(String.valueOf(n3) + " " + ResourceLookup.pluralize("hit", n3) + " from: ").append(iResourceLocator);
                if (iResourceArray != null && n3 > 0) {
                    int n4 = 0;
                    while (n4 < n3) {
                        stringBuilder.append("\n\t\t- ").append(iResourceArray[0]);
                        ++n4;
                    }
                    iResource = iResourceArray[0];
                }
            } else {
                stringBuilder.append("\n\t- 0 hits [not scanned] from: ").append(iResourceLocator);
            }
            ++n2;
        }
        logger.debug(stringBuilder.toString());
        return iResource;
    }

    public IResourceLocator[] getLocators() {
        return Arrays.copyOf(this.locators, this.locators.length);
    }

    private static String pluralize(String string, int n) {
        if (n == 1) {
            return string;
        }
        return String.valueOf(string) + "s";
    }

    public int hashCode() {
        return ArrayUtils.hashCode((Object)this.locators);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof ResourceLookup) {
            return ArrayUtils.isEquals((Object)this.locators, (Object)((ResourceLookup)object).locators);
        }
        return false;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + Arrays.toString(this.locators) + "]";
    }

    public static enum Location {
        CONTEXT_CLASS_LOADER(new ContextClassLoaderLocator()),
        CURRENT_WORKING_DIRECTORY(new DirLocator(new File(".")));

        public final IResourceLocator locator;

        private Location(IResourceLocator iResourceLocator) {
            this.locator = iResourceLocator;
        }
    }
}

