/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ObjectUtils;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;

public final class ServletContextLocator
implements IResourceLocator {
    private final ServletContext context;

    public ServletContextLocator(ServletContext servletContext) {
        assert (servletContext != null);
        this.context = servletContext;
    }

    @Override
    public IResource[] getAll(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        InputStream inputStream = this.context.getResourceAsStream(string);
        CloseableUtils.close((Closeable)inputStream);
        if (inputStream != null) {
            return new IResource[]{new WebAppResource(string)};
        }
        return new IResource[0];
    }

    @Override
    public int hashCode() {
        return this.context.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof ServletContextLocator) {
            return ObjectUtils.equals((Object)this.context, (Object)((ServletContextLocator)object).context);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [context: " + this.context + "]";
    }

    private final class WebAppResource
    implements IResource {
        private final String resource;

        public WebAppResource(String string) {
            this.resource = string;
        }

        @Override
        public InputStream open() throws IOException {
            return ServletContextLocator.this.context.getResourceAsStream(this.resource);
        }

        public String toString() {
            return "[webapp: " + this.resource + "]";
        }
    }
}

