/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.resource.IResource;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="url-resource")
public class URLResource
implements IResource {
    private URL url;
    @Attribute(name="url")
    private String info;

    URLResource() {
    }

    public URLResource(URL uRL) {
        this.url = uRL;
        this.info = uRL.toExternalForm();
    }

    @Override
    public InputStream open() throws IOException {
        return StreamUtils.prefetch(this.url.openStream());
    }

    public String toString() {
        return this.info;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof URLResource) {
            return ((URLResource)object).info.equals(this.info);
        }
        return false;
    }

    public final int hashCode() {
        return this.info.hashCode();
    }

    public URL getUrl() {
        return this.url;
    }

    @Commit
    void afterDeserialization() throws MalformedURLException {
        this.url = new URL(this.info);
    }
}

