/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import org.carrot2.util.StringUtils;
import org.carrot2.util.resource.IResource;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="parameterized-url-resource")
public class URLResourceWithParams
implements IResource {
    private URL url;
    @Attribute(name="url")
    private String info;

    URLResourceWithParams() {
    }

    public URLResourceWithParams(URL uRL) {
        this.url = uRL;
        this.info = uRL.toExternalForm();
    }

    @Override
    public InputStream open() throws IOException {
        return this.url.openStream();
    }

    public InputStream open(Map<String, Object> map) throws IOException {
        String string = this.url.toExternalForm();
        string = URLResourceWithParams.substituteAttributes(string, map);
        return new URL(string).openStream();
    }

    public static String substituteAttributes(String string, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Pattern pattern = Pattern.compile(URLResourceWithParams.formatAttributePlaceholder(entry.getKey()), 16);
            string = pattern.matcher(string).replaceAll(StringUtils.urlEncodeWrapException(entry.getValue().toString(), "UTF-8"));
        }
        return string;
    }

    public static boolean containsAttributePlaceholder(String string, String string2) {
        return string.contains(URLResourceWithParams.formatAttributePlaceholder(string2));
    }

    public static String formatAttributePlaceholder(String string) {
        return "${" + string + "}";
    }

    public String toString() {
        return this.info;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof URLResourceWithParams) {
            return ((URLResourceWithParams)object).info.equals(this.info);
        }
        return false;
    }

    public final int hashCode() {
        return this.info.hashCode();
    }

    public URL getUrl() {
        return this.url;
    }

    @Commit
    void afterDeserialization() throws MalformedURLException {
        this.url = new URL(this.info);
    }

    public static URLResourceWithParams valueOf(String string) {
        try {
            return new URLResourceWithParams(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

