/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.simplexml;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.ReflectionUtils;
import org.carrot2.util.simplexml.ISimpleXmlWrapper;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="value")
public class SimpleXmlWrapperValue {
    @Attribute(required=false)
    String type;
    @Attribute(required=false)
    String value;
    @Element(required=false)
    Object wrapper;
    private static final Set<Class<?>> TO_STRING_VALUE_OF_TYPES = ImmutableSet.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, (Object[])new Class[]{Boolean.class});

    static SimpleXmlWrapperValue wrap(Object object) {
        SimpleXmlWrapperValue simpleXmlWrapperValue = new SimpleXmlWrapperValue();
        if (object == null) {
            return simpleXmlWrapperValue;
        }
        Class<?> clazz = object.getClass();
        if (TO_STRING_VALUE_OF_TYPES.contains(clazz)) {
            simpleXmlWrapperValue.value = object.toString();
            simpleXmlWrapperValue.type = clazz.getName();
        } else if (object instanceof Character) {
            simpleXmlWrapperValue.value = object.toString();
            simpleXmlWrapperValue.type = Character.class.getName();
        } else if (object instanceof String) {
            simpleXmlWrapperValue.value = (String)object;
            simpleXmlWrapperValue.type = null;
        } else if (Class.class.isInstance(object)) {
            simpleXmlWrapperValue.value = ((Class)object).getName();
            simpleXmlWrapperValue.type = Class.class.getName();
        } else if (object instanceof Enum) {
            Enum enum_ = (Enum)object;
            simpleXmlWrapperValue.value = enum_.name();
            simpleXmlWrapperValue.type = enum_.getDeclaringClass().getName();
        } else {
            simpleXmlWrapperValue.wrapper = object.getClass().getAnnotation(Root.class) != null ? object : SimpleXmlWrapperValue.wrapCustom(object);
        }
        return simpleXmlWrapperValue;
    }

    Object unwrap() {
        if (this.value != null) {
            Class<?> clazz;
            if (StringUtils.isEmpty((String)this.type)) {
                this.type = String.class.getName();
            }
            if (TO_STRING_VALUE_OF_TYPES.contains(clazz = SimpleXmlWrapperValue.loadClassWrapAsRuntime(this.type))) {
                try {
                    Method method = clazz.getMethod("valueOf", String.class);
                    return method.invoke(null, this.value);
                }
                catch (Exception exception) {
                    throw ExceptionUtils.wrapAsRuntimeException(exception);
                }
            }
            if (Character.class.getName().equals(this.type)) {
                return this.value.length() > 0 ? Character.valueOf(this.value.charAt(0)) : null;
            }
            if (String.class.getName().equals(this.type)) {
                return this.value;
            }
            if (Class.class.getName().equals(this.type)) {
                return SimpleXmlWrapperValue.loadClassWrapAsRuntime(this.value);
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                return Enum.valueOf(clazz, this.value);
            }
        } else if (this.wrapper != null) {
            if (this.wrapper instanceof ISimpleXmlWrapper) {
                return ((ISimpleXmlWrapper)this.wrapper).getValue();
            }
            return this.wrapper;
        }
        return null;
    }

    static <T> ISimpleXmlWrapper<T> wrapCustom(T t) {
        Class<ISimpleXmlWrapper<?>> clazz = SimpleXmlWrappers.getWrapper(t);
        if (clazz != null) {
            ISimpleXmlWrapper<?> iSimpleXmlWrapper;
            try {
                iSimpleXmlWrapper = clazz.newInstance();
            }
            catch (Exception exception) {
                throw ExceptionUtils.wrapAsRuntimeException(exception);
            }
            iSimpleXmlWrapper.setValue(t);
            return iSimpleXmlWrapper;
        }
        return null;
    }

    private static Class<?> loadClassWrapAsRuntime(String string) {
        try {
            return ReflectionUtils.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ExceptionUtils.wrapAsRuntimeException(classNotFoundException);
        }
    }
}

