/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.simplexml;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.simplexml.DefaultConstructorSimpleXmlWrapper;
import org.carrot2.util.simplexml.ISimpleXmlWrapper;
import org.carrot2.util.simplexml.ListSimpleXmlWrapper;
import org.carrot2.util.simplexml.MapSimpleXmlWrapper;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;

public class SimpleXmlWrappers {
    static Map<Class<?>, Class<? extends ISimpleXmlWrapper<?>>> wrappers = Maps.newHashMap();
    static Map<Class<?>, Boolean> strict = Maps.newHashMap();

    public static synchronized <T> void addWrapper(Class<T> clazz, Class<? extends ISimpleXmlWrapper<? super T>> clazz2) {
        SimpleXmlWrappers.addWrapper(clazz, clazz2, true);
    }

    public static synchronized <T> void addWrapper(Class<T> clazz, Class<? extends ISimpleXmlWrapper<? super T>> clazz2, boolean bl) {
        wrappers.put(clazz, clazz2);
        strict.put(clazz, bl);
    }

    public static <K> Map<K, SimpleXmlWrapperValue> wrap(Map<K, ?> map) {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<K, ?> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), SimpleXmlWrapperValue.wrap(entry.getValue()));
        }
        return hashMap;
    }

    public static <K> Map<K, Object> unwrap(Map<K, SimpleXmlWrapperValue> map) {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<K, SimpleXmlWrapperValue> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), SimpleXmlWrappers.unwrap(entry.getValue()));
        }
        return hashMap;
    }

    public static List<SimpleXmlWrapperValue> wrap(List<?> list) {
        return (List)SimpleXmlWrappers.wrap(list, new ArrayList<SimpleXmlWrapperValue>());
    }

    public static List<Object> unwrap(List<SimpleXmlWrapperValue> list) {
        return (List)SimpleXmlWrappers.unwrap(list, new ArrayList<Object>());
    }

    public static Set<SimpleXmlWrapperValue> wrap(Set<?> set) {
        return (Set)SimpleXmlWrappers.wrap(set, new HashSet<SimpleXmlWrapperValue>());
    }

    public static Set<Object> unwrap(Set<SimpleXmlWrapperValue> set) {
        return (Set)SimpleXmlWrappers.unwrap(set, new HashSet<Object>());
    }

    public static Collection<SimpleXmlWrapperValue> wrap(Collection<?> collection, Collection<SimpleXmlWrapperValue> collection2) {
        for (Object obj : collection) {
            collection2.add(SimpleXmlWrapperValue.wrap(obj));
        }
        return collection2;
    }

    public static Collection<Object> unwrap(Collection<SimpleXmlWrapperValue> collection, Collection<Object> collection2) {
        for (SimpleXmlWrapperValue simpleXmlWrapperValue : collection) {
            collection2.add(SimpleXmlWrappers.unwrap(simpleXmlWrapperValue));
        }
        return collection2;
    }

    public static SimpleXmlWrapperValue wrap(Object object) {
        return SimpleXmlWrapperValue.wrap(object);
    }

    public static <T> T unwrap(SimpleXmlWrapperValue simpleXmlWrapperValue) {
        if (simpleXmlWrapperValue != null) {
            return (T)simpleXmlWrapperValue.unwrap();
        }
        return null;
    }

    static synchronized <T> Class<? extends ISimpleXmlWrapper<?>> getWrapper(T t) {
        Class<?> clazz = t.getClass();
        Class<? extends ISimpleXmlWrapper<?>> clazz2 = wrappers.get(clazz);
        if (clazz2 == null) {
            for (Map.Entry<Class<?>, Class<ISimpleXmlWrapper<?>>> entry : wrappers.entrySet()) {
                if (strict.get(entry.getKey()).booleanValue() || !entry.getKey().isAssignableFrom(clazz)) continue;
                return entry.getValue();
            }
            if (List.class.isInstance(t)) {
                return ListSimpleXmlWrapper.class;
            }
            if (Map.class.isInstance(t)) {
                return MapSimpleXmlWrapper.class;
            }
            try {
                t.getClass().getConstructor(new Class[0]);
                return DefaultConstructorSimpleXmlWrapper.class;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return clazz2;
    }
}

