/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.tests;

import com.google.common.base.Strings;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class SuiteResultInfoWriter
extends RunListener {
    private PrintWriter writer;
    private HashMap<String, Status> tests = new HashMap();

    public void testRunStarted(Description description) throws Exception {
        String string = System.getProperty("verbose.reports.dir");
        if (!Strings.isNullOrEmpty((String)string)) {
            this.writer = new PrintWriter(String.valueOf(new File(string).getAbsolutePath()) + "/" + "RESULTS-" + description.getClassName() + ".txt");
        }
        this.tests.clear();
    }

    public void testStarted(Description description) throws Exception {
        this.tests.put(description.getDisplayName(), Status.OK);
    }

    public void testIgnored(Description description) throws Exception {
        this.tests.put(description.getDisplayName(), Status.IGNORED);
    }

    public void testFailure(Failure failure) throws Exception {
        this.tests.put(failure.getDescription().getDisplayName(), failure.getException() instanceof AssertionError ? Status.FAILED : Status.ERROR);
    }

    public void testAssumptionFailure(Failure failure) {
        this.tests.put(failure.getDescription().getDisplayName(), Status.ASSUMPTION_IGNORED);
    }

    public void testRunFinished(Result result) throws Exception {
        if (this.writer != null) {
            try {
                for (Map.Entry<String, Status> entry : this.tests.entrySet()) {
                    this.writer.println(String.format(Locale.ENGLISH, "%-10s | %s", entry.getValue().toString(), entry.getKey()));
                }
            }
            finally {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    private static enum Status {
        OK,
        IGNORED,
        ERROR,
        FAILED,
        ASSUMPTION_IGNORED,
        UNDEFINED;


        public String toString() {
            if (this != ASSUMPTION_IGNORED) {
                return super.toString();
            }
            return "A/IGNORED";
        }
    }
}

