/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.xslt;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.carrot2.util.xslt.StylesheetErrorListener;
import org.carrot2.util.xslt.TransformerErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class TemplatesPool {
    private static final Logger logger = LoggerFactory.getLogger(TemplatesPool.class);
    public static final String TEMPLATE_CACHING_PROPERTY = "template.caching";
    private static final Set<String> reportedProcessors = Collections.synchronizedSet(new HashSet());
    private volatile HashMap<String, Templates> stylesheets = new HashMap();
    private final boolean templateCaching;
    public final SAXTransformerFactory tFactory;

    public TemplatesPool() throws Exception {
        this(true);
    }

    public TemplatesPool(boolean bl) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        String string = transformerFactory.getClass().getName();
        if (!reportedProcessors.contains(string)) {
            logger.info("XSLT transformer factory: " + string);
            reportedProcessors.add(string);
        }
        if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") || !transformerFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            throw new Exception("Required source types not supported by the transformer factory.");
        }
        if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature") || !transformerFactory.getFeature("http://javax.xml.transform.stream.StreamResult/feature")) {
            throw new Exception("Required result types not supported by the transformer factory.");
        }
        if (!(transformerFactory instanceof SAXTransformerFactory)) {
            throw new Exception("TransformerFactory not an instance of SAXTransformerFactory: " + transformerFactory.getClass().getName());
        }
        this.tFactory = (SAXTransformerFactory)transformerFactory;
        this.tFactory.setErrorListener(new StylesheetErrorListener());
        this.templateCaching = bl;
    }

    public TransformerHandler getIdentityTransformerHandler() throws TransformerConfigurationException {
        return this.tFactory.newTransformerHandler();
    }

    public Templates getTemplate(String string) {
        if (!this.isCaching()) {
            return null;
        }
        return this.stylesheets.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemplate(String string, Templates templates) {
        if (!this.isCaching()) {
            return;
        }
        TemplatesPool templatesPool = this;
        synchronized (templatesPool) {
            HashMap<String, Templates> hashMap = new HashMap<String, Templates>(this.stylesheets);
            hashMap.put(string, templates);
            this.stylesheets = hashMap;
        }
    }

    private boolean isCaching() {
        String string = System.getProperty(TEMPLATE_CACHING_PROPERTY);
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return this.templateCaching;
    }

    public Templates compileTemplate(String string) throws SAXException {
        StreamSource streamSource = new StreamSource(string);
        try {
            return this.tFactory.newTemplates(streamSource);
        }
        catch (Exception exception) {
            throw new SAXException("Could not compile stylesheet: " + string, exception);
        }
    }

    public Templates compileTemplate(InputStream inputStream) throws SAXException {
        StreamSource streamSource = new StreamSource(inputStream);
        try {
            return this.tFactory.newTemplates(streamSource);
        }
        catch (Exception exception) {
            throw new SAXException("Could not compile stylesheet.", exception);
        }
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        TransformerHandler transformerHandler = this.tFactory.newTransformerHandler(templates);
        transformerHandler.getTransformer().setErrorListener(new TransformerErrorListener());
        return transformerHandler;
    }

    public Transformer newTransformer(Templates templates) throws TransformerConfigurationException {
        return this.newTransformerHandler(templates).getTransformer();
    }
}

