
// Java World -- Fueling Innovation
// When Runtime.exec() won't -- Michael C. Daconta 
// http://www.javaworld.com/javaworld/jw-12-2000/jw-1229-traps.html
// December 2004
// IDG

import java.util.*;
import java.io.*;

class StreamGobbler extends Thread {
   
    InputStream is;
    String type;
    OutputStream os;
    
    StreamGobbler(InputStream is, String type)
    {
        this(is, type, null);
    }

    StreamGobbler(InputStream is, String type, OutputStream redirect)
    {
        this.is = is;
        this.type = type;
        this.os = redirect;
    }
    
    public void run()
    {
        try
        {
            PrintWriter pw = null;
            if (os != null)
                pw = new PrintWriter(os);
                
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line=null;
            while ( (line = br.readLine()) != null)
            {
            	
                if (pw != null)
                    pw.println(line);
                    
					 if (cd_create.verbose) System.out.println(type + ">" + line);    
            }
            if (pw != null)
                pw.flush();
        } catch (IOException ioe)
            {
            ioe.printStackTrace();  
            }
    }
}
