
/* 0123456789012345678901234567890123456789012345678901234567890123456789789 */

/*
 * verify.java
 *
 * This file is part of cd_create.
 *
 * cd_create is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cd_create is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cd_create; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright 2005 Abi Arroyo
 */

import java.io.*; 
import java.util.*;
import java.util.logging.*;

 public class verify {
   
   public static String md5_file;
   public static String md5_opts = " -r ";
   
   public static String winScript = "verify.bat";
   public static String unixScript = "verify.sh";
   
   public static String origSum = "orig_md5.txt";
   public static String results = "media_md5.txt";
   
   public static int numFiles = 0;
   
   public static Logger logger = Logger.getLogger ("verifyFile.class");                                                       
   final static int SUCCESS = 0;
   
   // Create original compilation of checksum data for later comparison
   public static boolean goodSum (List verifyFiles) {
      
      logger.setParent (CDCase.logger);
      
      // logger.log (Level.INFO, "verify.goodSum(): start\n");
      
      String thelist = "";
      for (int i = 0; i < verifyFiles.size(); i++) {
         thelist += "\"" + verifyFiles.get(i).toString() + "\" ";
      }
      
      numFiles = verifyFiles.size();
      
      if (CDCase.isWindows) {
         
         String cmd[] = new String[2];
         
         cmd[0] = "@ECHO OFF";
         cmd[1] = md5_file + md5_opts + thelist + " > " + CDCase.tempDir + File.separator + origSum;
         
         logger.log (Level.WARNING, "verify.mediaSum(): " + cmd[1] + '\n');
         
         utility.createFile (winScript, cmd);
         
         return (utility.exec(winScript));
      }
      else {
		   String cmd[] = new String[2];

			cmd[0] = "#!/bin/bash";
         cmd[1] = md5_file + md5_opts + thelist + " > " + CDCase.tempDir + File.separator + origSum;

			utility.createFile (unixScript, cmd);

			cmd = new String[1];
			cmd[0] = "chmod a+x " + CDCase.tempDir + File.separator + unixScript;
         utility.exec(cmd);

			return (utility.exec(unixScript));
      }
   }
   
   // Compare the original checksum data with the data that has just been burned
   public static boolean mediaSum (List verifyFiles) {

      String item, thelist = "";
      
      logger.setParent (CDCase.logger);
      
      //logger.log (Level.INFO, "verify.mediaSum(): start\n");
      
      if (CDCase.isWindows) {
         
         char stuff[];
         // remember if it is Windows, we have ":", otherwise nothing
         for (int i = 0; i < verifyFiles.size(); i++) {
            item = (String) verifyFiles.remove (i);
            
            if (item.indexOf(":") > 0) {
               stuff = item.toCharArray();
               stuff[0] = CDCase.cdPath.charAt(0);
               verifyFiles.add(i, new String(stuff));
            }
            else
               verifyFiles.add (i, CDCase.cdPath + item);
         }
         
         for (int i = 0; i < verifyFiles.size(); i++) {
            thelist += "\"" + verifyFiles.get(i).toString() + "\" ";
         }         
         
         String cmd[] = new String[2];
         
         cmd[0] = "@ECHO OFF";
         cmd[1] = md5_file + " -x " + CDCase.tempDir + File.separator + origSum + md5_opts + thelist + " > " + CDCase.tempDir + File.separator + results;
         
         logger.log (Level.WARNING, "verify.mediaSum(): " + cmd[1] + '\n');
         
         utility.createFile (winScript, cmd);
         
         return (utility.exec(winScript));
      }
      else {
         // UNIX code is going to go here
         for (int i = 0; i < verifyFiles.size(); i++) {
            thelist += "\"" + CDCase.cdPath + File.separator + verifyFiles.get(i).toString() + "\" ";
         }         

         String cmd[] = new String[2];

         cmd[0] = "#!/bin/sh";
         cmd[1] = md5_file + " -x " + CDCase.tempDir + File.separator + origSum + md5_opts + thelist + " > " + CDCase.tempDir + File.separator + results;
         
         logger.log (Level.WARNING, "verify.mediaSum(): " + cmd[1] + '\n');

			utility.createFile (unixScript, cmd);

			cmd = new String[1];
			cmd[0] = "chmod a+x " + CDCase.tempDir + File.separator + unixScript;
         utility.exec(cmd);

			return (utility.exec(unixScript));
      }
   }
}  
