% Copy all files in Matlab current directory and type "fingerid" on
% Matlab command window.
% 
% A simple and intuitive GUI should appear.
% If you want to create a database of known fingerprint images just press
% the button "Add a new image to database": you have to specify, for each
% image an ID. ID is a progressive, integer number associated to
% fingerprint. Once you have created database of known finngerprint you can
% perform one-to-many identification: press the button "One-to-many Fingerprint
% Identification" and select image, code will return most similar
% fingerprint image. If you want to make one-to-one fingerprint
% verification press the button "One-to-one Fingerprint Verification": in
% this case you have to select two fingerprint images. Code will return if
% selected images match or not.
% 
% 
% FUNCTIONS
%
%
% Add a new image to database:                   select an input image and add it to database. All images will be used for one-to-many fingerprint
%                                                recognition. An ID is requested.
%
% Database Info:                                 show informations about the images present in database. Images must
%                                                have the same size. If this is not true you have to resize them.
%
% One-to-many Fingerprint Identification :       One-to-many (1:N) fingerprint identification. Code returns the ID of most similar
%                                                fingerprint present in database.
%
% One-to-one Fingerprint Verification:           One-to-one (1:1) fingerprint identification. Two fingerprint images are selected and code
%                                                returns verification result.
%
% Delete Database:                               remove database from the current directory
%
% Info:                                          show informations about this software
%
% Source code for Correlation Filters AFIS:      how to obtain the complete source code
%
% Exit:                                          quit program
%
%
%
%
%
% Luigi Rosa
% Via Centrale 35
% 67042 Civita di Bagno
% L'Aquila - ITALY 
% email   luigi.rosa@tiscali.it
% mobile  +39 3207214179
% website http://www.advancedsourcecode.com
%
%
