/*
 * Decompiled with CFR 0.152.
 */
package com.rp.database;

import com.rp.database.CSConnection;
import com.rp.database.PooledConnectionManager;
import com.rp.util.Cache;
import com.rp.util.Loggable;
import com.rp.util.pool.ObjectManager;
import com.rp.util.pool.PoolException;
import java.sql.Connection;
import java.sql.SQLException;

public class CSConnectionManager
extends PooledConnectionManager {
    protected String CLASS_NAME = "CSConnectionManager::";
    protected boolean cacheable = false;
    protected Cache statementCache = null;

    public static ObjectManager getInstance(String url, String user, String password, String driver, String checkQuery, int holdTime, boolean autoCommit, String logKey, Loggable log, boolean cacheable, Cache statementCache) throws SQLException, ClassNotFoundException {
        CSConnectionManager cm = new CSConnectionManager(url, user, password, driver, checkQuery, holdTime, autoCommit, logKey, log, cacheable, statementCache);
        return cm;
    }

    protected CSConnectionManager(String url, String user, String password, String driver, String checkQuery, int holdTime, boolean autoCommit, String logKey, Loggable log, boolean cacheable, Cache statementCache) throws SQLException, ClassNotFoundException {
        super(url, user, password, driver, checkQuery, holdTime, autoCommit, logKey, log);
        this.cacheable = cacheable;
        this.statementCache = statementCache;
        super.setClassName(this.CLASS_NAME);
    }

    public Object create() throws PoolException {
        String method = "create()";
        this.info(method, "entering  . . .");
        if (this.pool == null) {
            this.fatal(method, "pool cannot be null");
            throw new PoolException("CSConnectionManager:create(): pool cannot be null");
        }
        CSConnection pConn = null;
        try {
            this.debug(method, "attempting to create connection");
            Connection con = this.createConnection();
            this.debug(method, "connection created.");
            this.debug(method, "attempting to set up pooled connection . . .");
            pConn = new CSConnection(con, this.pool, this.logKey, this.log, this.cacheable, this.statementCache);
            this.debug(method, "pooled connection set up.");
        }
        catch (SQLException e) {
            this.error(method, "SQL EXCEPTION while trying to create connections: " + e.toString());
            throw new PoolException(e.toString(), e);
        }
        this.info(method, "leaving  . . .");
        return pConn;
    }
}

