/*
 * Decompiled with CFR 0.152.
 */
package com.rp.database;

import com.rp.database.PooledConnection;
import com.rp.database.StandardConnectionManager;
import com.rp.util.Loggable;
import com.rp.util.pool.ObjectManager;
import com.rp.util.pool.ObjectPool;
import com.rp.util.pool.PoolException;
import java.sql.Connection;
import java.sql.SQLException;

public class PooledConnectionManager
extends StandardConnectionManager {
    protected String CLASS_NAME = "PooledConnectionManager::";
    protected int holdTime = 0;
    protected ObjectPool pool = null;

    public static ObjectManager getInstance(String url, String user, String password, String driver, String checkQuery, int holdTime, boolean autoCommit, String logKey, Loggable log) throws SQLException, ClassNotFoundException {
        PooledConnectionManager cm = new PooledConnectionManager(url, user, password, driver, checkQuery, holdTime, autoCommit, logKey, log);
        return cm;
    }

    protected PooledConnectionManager(String url, String user, String password, String driver, String checkQuery, int holdTime, boolean autoCommit, String logKey, Loggable log) throws SQLException, ClassNotFoundException {
        super(url, user, password, driver, checkQuery, autoCommit, logKey, log);
        this.holdTime = holdTime;
        super.setClassName(this.CLASS_NAME);
    }

    protected void setClassName(String name) {
        this.CLASS_NAME = name;
        super.setClassName(name);
    }

    public void init(ObjectPool pool) {
        this.pool = pool;
    }

    public Object create() throws PoolException {
        String method = "create()";
        this.info(method, "entering  . . .");
        if (this.pool == null) {
            throw new PoolException("ObjectPool cannot be null.  Before calling create(), an instantiated pool must be passed into this object.");
        }
        PooledConnection pConn = null;
        try {
            this.debug(method, "attempting to create connection");
            Connection con = this.createConnection();
            this.debug(method, "connection created.");
            this.debug(method, "attempting to set up pooled connection . . .");
            pConn = new PooledConnection(con, this.pool, this.logKey, this.log);
            this.debug(method, "pooled connection set up.");
        }
        catch (SQLException e) {
            this.error(method, "SQL EXCEPTION while trying to create connections: " + e.toString());
            throw new PoolException(e.toString(), e);
        }
        this.info(method, "leaving  . . .");
        return pConn;
    }

    public Object performEmpty(Object obj) throws PoolException {
        String method = "peformEmpty";
        Connection temp = null;
        this.info(method, "entering . . .");
        try {
            this.debug(method, "checking if hold timeout check is set");
            if (this.holdTime > 0) {
                this.debug(method, "hold timeout is set.  preparing to check used connections for timeout . . .");
                this.debug(method, "casting object to PooledConnection . . .");
                PooledConnection con = (PooledConnection)obj;
                this.debug(method, "cast complete");
                this.debug(method, "checking used connections for hold timeout . . .");
                temp = this.checkConnectionTime(con);
                this.debug(method, "used connections checked.");
            } else {
                this.debug(method, "hold timeout is not set.");
            }
        }
        catch (SQLException e) {
            this.error(method, "SQLException:: " + e.toString());
            throw new PoolException(e.toString(), e);
        }
        this.info(method, "leaving . . .");
        return temp;
    }

    public void destroy(Object obj) throws PoolException {
        String method = "destroy()";
        this.info(method, "entering . . .");
        try {
            this.debug(method, "checking to see if object is null . . .");
            if (obj != null) {
                this.debug(method, "object is not null");
                this.debug(method, "casting object to PooledConnection . . .");
                PooledConnection pc = (PooledConnection)obj;
                this.debug(method, "cast complete");
                this.debug(method, "calling destroy on PooledConnection . . .");
                pc.destroy();
                this.debug(method, "destroy call complete");
            } else {
                this.debug(method, "object is null");
            }
        }
        catch (SQLException e) {
            this.error(method, "Problem destroying PooledConnection.");
            this.error(method, "SQLException:: " + e.toString());
            throw new PoolException(e.toString(), e);
        }
        this.info(method, "leaving . . .");
    }

    protected Connection checkConnectionTime(Connection con) throws SQLException {
        Connection temp;
        String method;
        block4: {
            method = "checkConnectionTime()";
            PooledConnection pConn = null;
            temp = null;
            this.info(method, "entering . . .");
            try {
                this.debug(method, "checking connection ");
                this.debug(method, "casting to PooledConnection");
                pConn = (PooledConnection)con;
                long longDuration = this.getTime() - pConn.getTime();
                int duration = (int)((double)longDuration / 1000.0);
                this.debug(method, "connection in use for " + duration + " seconds");
                if (duration <= this.holdTime) break block4;
                this.debug(method, "duration greater than holdTimeout");
                this.debug(method, "attempting to destroy connection . . ..");
                try {
                    pConn.destroy();
                    this.debug(method, "connection destroyed");
                }
                catch (SQLException se) {
                    this.debug(method, "Exception caught while destorying connection: " + se.toString());
                }
                this.debug(method, "creating new connection . . .");
                temp = (Connection)this.create();
                this.debug(method, "new connection created . . .");
            }
            catch (PoolException ex) {
                this.error(method, "An error occurred while checking used connections: " + ex.toString());
                throw new SQLException(ex.toString());
            }
        }
        this.info(method, "leaving " + method + " . . .");
        return temp;
    }

    protected long getTime() {
        return System.currentTimeMillis();
    }
}

