/*
 * Decompiled with CFR 0.152.
 */
package com.rp.database;

import com.rp.database.AbstractConnectionManager;
import com.rp.util.Loggable;
import com.rp.util.pool.ObjectManager;
import com.rp.util.pool.PoolException;
import java.sql.Connection;
import java.sql.SQLException;

public class StandardConnectionManager
extends AbstractConnectionManager {
    protected String CLASS_NAME = "StandardConnectionManager::";

    public static ObjectManager getInstance(String url, String user, String password, String driver, String checkQuery, boolean autoCommit, String logKey, Loggable log) throws SQLException, ClassNotFoundException {
        StandardConnectionManager cm = new StandardConnectionManager(url, user, password, driver, checkQuery, autoCommit, logKey, log);
        return cm;
    }

    protected StandardConnectionManager(String url, String user, String password, String driver, String checkQuery, boolean autoCommit, String logKey, Loggable log) throws SQLException, ClassNotFoundException {
        super(url, user, password, driver, checkQuery, autoCommit, logKey, log);
        super.setClassName(this.CLASS_NAME);
    }

    protected void setClassName(String name) {
        this.CLASS_NAME = name;
        super.setClassName(name);
    }

    public Object create() throws PoolException {
        String method = "create()";
        this.info(method, "entering  . . .");
        Connection con = null;
        try {
            this.debug(method, "attempting to create connection");
            con = this.createConnection();
            this.debug(method, "connection created.");
        }
        catch (SQLException e) {
            this.error(method, "SQL EXCEPTION while trying to create connections: " + e.toString());
            throw new PoolException(e.toString(), e);
        }
        this.info(method, "leaving  . . .");
        return con;
    }

    public Object performEmpty(Object obj) throws PoolException {
        String method = "performEmpty()";
        this.info(method, "entering . . .");
        this.info(method, "leaving . . .");
        return null;
    }

    public void destroy(Object obj) throws PoolException {
        String method = "destroy()";
        this.info(method, "entering . . .");
        try {
            this.debug(method, "checking to see if object is null . . .");
            if (obj != null) {
                this.debug(method, "object is not null");
                this.debug(method, "casting object to Connection . . .");
                Connection con = (Connection)obj;
                this.debug(method, "cast complete");
                this.debug(method, "calling close on connection . . .");
                con.close();
                this.debug(method, "close call complete");
            } else {
                this.debug(method, "object is null");
            }
        }
        catch (SQLException e) {
            this.error(method, "Problem destroying PooledConnection.");
            this.error(method, "SQLException:: " + e.toString());
            throw new PoolException(e.toString(), e);
        }
        this.info(method, "leaving . . .");
    }
}

