/*
 * Decompiled with CFR 0.152.
 */
package com.rp.log;

import com.rp.log.LogWriter;
import com.rp.log.StandardLogger;
import com.rp.util.DateTime;
import java.io.IOException;
import java.io.Writer;

public class RpLogger
extends StandardLogger {
    public static final int HOURLY = 0;
    public static final int DAILY = 1;
    public static final int WEEKLY = 2;
    public static final int MONTHLY = 3;
    public static final int YEARLY = 4;
    public static final int FOREVER = 5;
    public static final int NODATE = 99;
    protected String fileName = null;
    protected int frequency = 1;
    protected int loggingLevel = 4;
    protected DateTime dateTime = null;

    public RpLogger() throws IOException {
    }

    public RpLogger(String fileName) throws IOException {
        this(fileName, 4, 1);
    }

    public RpLogger(String fileName, int loggingLevel) throws IOException {
        this(fileName, loggingLevel, 1);
    }

    public RpLogger(String fileName, int loggingLevel, int frequency) throws IOException {
        if (!this.verifyFrequency(frequency)) {
            throw new IllegalArgumentException("RpLogger::Constructor:USAGE EXCEPTION::Invalid Frequency::frequency = " + frequency);
        }
        if (!super.verifyLevel(loggingLevel)) {
            throw new IllegalArgumentException("RpLogger::Constructor:USAGE EXCEPTION::Invalid Logging Level::level = " + loggingLevel);
        }
        this.setFileName(fileName);
        this.setFrequency(frequency);
        this.setLoggingLevel(loggingLevel);
        this.setDateTime(new DateTime());
        this.initWriter();
    }

    public RpLogger(Writer writer) throws IOException {
        this(writer, 4);
    }

    public RpLogger(Writer writer, int loggingLevel) throws IOException {
        if (!super.verifyLevel(loggingLevel)) {
            throw new IllegalArgumentException("RpLogger::Constructor:USAGE EXCEPTION::Invalid Logging Level::level = " + loggingLevel);
        }
        this.setFrequency(99);
        this.setLoggingLevel(loggingLevel);
        this.setDateTime(new DateTime());
        super.setWriter(new LogWriter(writer));
    }

    protected void initWriter() throws IOException {
        super.setWriter(new LogWriter(this.getFileName() + this.getFileDateTime(this.getDateTime())));
    }

    protected void reload() throws IOException {
        this.initWriter();
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
    }

    protected int getFrequency() {
        return this.frequency;
    }

    protected void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    protected int getLoggingLevel() {
        return this.loggingLevel;
    }

    protected void setLoggingLevel(int level) {
        super.setLevel(level);
        this.loggingLevel = super.getLevel();
    }

    protected void setLoggingLevel(String level) {
        if (level != null) {
            super.setLevel(new Integer(level));
        }
        this.loggingLevel = super.getLevel();
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    protected void setDateTime(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    protected void write(String s) {
        this.checkDate();
        this.writer.println(s);
    }

    protected void write(boolean b) {
        this.checkDate();
        this.writer.println(b);
    }

    protected void write(char c) {
        this.checkDate();
        this.writer.println(c);
    }

    protected void write(byte b) {
        this.checkDate();
        this.writer.println(b);
    }

    protected void write(double d) {
        this.checkDate();
        this.writer.println(d);
    }

    protected void write(float f) {
        this.checkDate();
        this.writer.println(f);
    }

    protected void write(int i) {
        this.checkDate();
        this.writer.println(i);
    }

    protected void write(long l) {
        this.checkDate();
        this.writer.println(l);
    }

    protected void write(Object o) {
        this.checkDate();
        this.writer.println(o);
    }

    protected void write(char[] buf) {
        this.checkDate();
        this.writer.println(buf);
    }

    protected void checkDate() {
        DateTime tempDate = new DateTime();
        if (this.checkFile(tempDate)) {
            LogWriter tempWriter = null;
            try {
                tempWriter = new LogWriter(super.getWriter());
                this.writer = new LogWriter(this.getFileName() + this.getFileDateTime(tempDate));
                tempWriter.destroy();
                tempWriter = null;
            }
            catch (Exception e) {
                this.writer = tempWriter;
            }
            this.getDateTime().refresh();
        }
    }

    protected boolean checkFile(DateTime tempDate) {
        String newCheck;
        String oldCheck;
        int freq = this.getFrequency();
        DateTime dTime = this.getDateTime();
        if (freq == 99 || freq == 5) {
            return false;
        }
        switch (freq) {
            case 0: {
                oldCheck = dTime.getHour();
                newCheck = tempDate.getHour();
                break;
            }
            case 1: {
                oldCheck = dTime.getDate();
                newCheck = tempDate.getDate();
                break;
            }
            case 3: {
                oldCheck = dTime.getMonth();
                newCheck = tempDate.getMonth();
                break;
            }
            case 4: {
                oldCheck = dTime.getYear();
                newCheck = tempDate.getYear();
                break;
            }
            default: {
                oldCheck = "0";
                newCheck = "0";
            }
        }
        return !oldCheck.equals(newCheck);
    }

    protected String getFileDateTime(DateTime dTime) {
        int freq = this.getFrequency();
        String fileDateTime = "";
        switch (freq) {
            case 0: {
                fileDateTime = dTime.getFullDate("-") + "_" + dTime.getStandardTime("-");
                break;
            }
            case 1: {
                fileDateTime = dTime.getFullDate("-");
                break;
            }
            case 3: {
                fileDateTime = dTime.getFullDate("-");
                break;
            }
            case 4: {
                fileDateTime = dTime.getFullDate("-");
                break;
            }
            default: {
                fileDateTime = "";
            }
        }
        return fileDateTime;
    }

    protected boolean verifyFrequency(int freq) {
        switch (freq) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 99: {
                return true;
            }
        }
        return false;
    }
}

