/*
 * Decompiled with CFR 0.152.
 */
package com.rp.util;

import java.io.Serializable;
import java.util.Calendar;

public class DateTime
implements Serializable {
    private Calendar calendar = null;
    private String year;
    private String month;
    private String date;
    private String hour;
    private String minute;
    private String second;
    private String millisecond;
    private static final String SEPARATOR = "_";

    public DateTime() {
        this.init();
    }

    public String getFullDateTime() {
        return this.getFullDateTime(SEPARATOR);
    }

    public String getFullDateTime(String sep) {
        StringBuffer sb = new StringBuffer(25);
        sb.append(this.getFullDate());
        sb.append(sep);
        sb.append(this.getFullTime());
        return sb.toString();
    }

    public String getFullDate() {
        return this.getFullDate(SEPARATOR);
    }

    public String getFullDate(String sep) {
        StringBuffer sb = new StringBuffer(10);
        sb.append(this.getMonth());
        sb.append(sep);
        sb.append(this.getDate());
        sb.append(sep);
        sb.append(this.getYear());
        return sb.toString();
    }

    public String getFullTime() {
        return this.getFullTime(SEPARATOR);
    }

    public String getFullTime(String sep) {
        StringBuffer sb = new StringBuffer(11);
        sb.append(this.getHour());
        sb.append(sep);
        sb.append(this.getMinute());
        sb.append(sep);
        sb.append(this.getSecond());
        sb.append(sep);
        sb.append(this.getMillisecond());
        return sb.toString();
    }

    public String getStandardTime(String sep) {
        StringBuffer sb = new StringBuffer(8);
        sb.append(this.getHour());
        sb.append(sep);
        sb.append(this.getMinute());
        sb.append(sep);
        sb.append(this.getSecond());
        return sb.toString();
    }

    protected void init() {
        this.calendar = Calendar.getInstance();
        this.setYear(String.valueOf(this.calendar.get(1)));
        this.setMonth(String.valueOf(this.calendar.get(2)));
        this.setDate(String.valueOf(this.calendar.get(5)));
        this.setHour(String.valueOf(this.calendar.get(11)));
        this.setMinute(String.valueOf(this.calendar.get(12)));
        this.setSecond(String.valueOf(this.calendar.get(13)));
        this.setMillisecond(String.valueOf(this.calendar.get(14)));
    }

    public void refresh() {
        this.init();
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = this.padd(year, 2);
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        int x = new Integer(month);
        this.month = this.padd(String.valueOf(++x), 2);
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = this.padd(date, 2);
    }

    public String getHour() {
        return this.hour;
    }

    public void setHour(String hour) {
        this.hour = this.padd(hour, 2);
    }

    public String getMinute() {
        return this.minute;
    }

    public void setMinute(String minute) {
        this.minute = this.padd(minute, 2);
    }

    public String getSecond() {
        return this.second;
    }

    public void setSecond(String second) {
        this.second = this.padd(second, 2);
    }

    public String getMillisecond() {
        return this.millisecond;
    }

    public void setMillisecond(String millisecond) {
        this.millisecond = this.padd(millisecond, 3);
    }

    protected String padd(String s, int len) {
        int count = len - s.length();
        for (int i = 0; i < count; ++i) {
            s = "0" + s;
        }
        return s;
    }
}

