/*
 * Decompiled with CFR 0.152.
 */
package com.rp.util;

import com.rp.util.Cache;
import com.rp.util.Loggable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MemoryCache
implements Cache {
    protected String CLASS_NAME = "MemoryCache";
    protected boolean addWhenFull;
    protected Map cache = null;
    protected Map times = null;
    protected List keys = null;
    protected int maxSize = 0;
    protected int timeOut = 0;
    protected Loggable log = null;
    protected String logKey = null;

    public MemoryCache(int max, int t, boolean addWhenFull) {
        this(max, t, addWhenFull, null, null);
    }

    public MemoryCache(int max, int t, boolean addWhenFull, Loggable inLog, String inLogKey) {
        this.maxSize = max;
        this.cache = new HashMap(max);
        this.keys = new ArrayList(max);
        this.times = new HashMap(max);
        this.timeOut = t;
        this.addWhenFull = addWhenFull;
        this.log = inLog;
        this.logKey = inLogKey;
    }

    public abstract void destroy();

    public synchronized int getSize() {
        return this.cache.size();
    }

    protected synchronized Object[] getObjects() {
        String method = "getObjects()";
        this.info(method, "entering . . .");
        int size = this.cache.size();
        this.debug(method, "cache size = " + size);
        Object[] arr = new Object[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = this.cache.get((String)this.keys.get(i));
        }
        this.info(method, "leaving . . .");
        return arr;
    }

    public synchronized void remove(Object key) {
        String method = "remove(Object)";
        this.info(method, "entering . . .");
        this.times.remove(key);
        this.cache.remove(key);
        this.keys.remove(key);
        this.info(method, "leaving . . .");
    }

    public synchronized boolean put(Object key, Object obj) {
        String method = "put(Object, Object)";
        this.info(method, "entering . . .");
        boolean addFlag = false;
        if (this.maxSize > 0) {
            if (this.cache.size() >= this.maxSize) {
                this.debug(method, "cache is full.  cache size > maxSize");
                Object tempKey = this.keys.get(0);
                Object tempTimeObj = null;
                if (this.timeOut > 0) {
                    tempTimeObj = this.times.get(tempKey);
                    this.debug(method, "timeout > 0, getting time for object");
                }
                if (tempTimeObj != null) {
                    long holdTime = tempTimeObj;
                    this.debug(method, "time held = " + holdTime);
                    if (this.convertTime(this.getTime() - holdTime) > (long)this.timeOut) {
                        this.debug(method, "object in cache longer than timeout, removing");
                        this.remove(tempKey);
                        addFlag = true;
                    }
                }
                if (!addFlag && this.addWhenFull) {
                    this.debug(method, "add when full is set, removing first object");
                    this.remove(tempKey);
                    addFlag = true;
                }
            } else {
                addFlag = true;
            }
        }
        if (addFlag) {
            this.debug(method, "adding object to cache");
            this.cache.put(key, obj);
            this.times.put(key, new Long(this.getTime()));
            this.keys.add(key);
        } else {
            this.debug(method, "cache is full, not adding");
        }
        return addFlag;
    }

    public synchronized Object get(Object key) {
        String method = "get(Object";
        this.info(method, "entering . . .");
        Object retObj = null;
        if (this.timeOut > 0) {
            this.debug(method, "timeout set, checking time held of object");
            retObj = this.cache.get(key);
            if (retObj != null) {
                long tValue = (Long)this.times.get(key);
                if (this.convertTime(this.getTime() - tValue) > (long)this.timeOut) {
                    this.debug(method, "time held greater than timeout, removing object from cache");
                    this.remove(key);
                }
            }
        } else {
            retObj = this.cache.get(key);
        }
        this.info(method, "leaving . . .");
        return retObj;
    }

    protected long getTime() {
        return System.currentTimeMillis();
    }

    protected long convertTime(long t) {
        return t /= 1000L;
    }

    protected void fatal(String method, String s) {
        if (this.log != null) {
            this.log.fatal(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void error(String method, String s) {
        if (this.log != null) {
            this.log.error(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void warn(String method, String s) {
        if (this.log != null) {
            this.log.warn(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void info(String method, String s) {
        if (this.log != null) {
            this.log.info(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void debug(String method, String s) {
        if (this.log != null) {
            this.log.debug(this.CLASS_NAME, method, s, this.logKey);
        }
    }
}

