/*
 * Decompiled with CFR 0.152.
 */
package com.rp.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesFileReader {
    private Properties props = null;

    public PropertiesFileReader(String propertiesFile) throws Exception {
        try {
            this.buildFromProperties(propertiesFile);
        }
        catch (Exception e) {
            try {
                this.buildFromFile(propertiesFile);
            }
            catch (Exception ee) {
                throw new Exception("PropertiesFileReader:Constructor()::Exception--Trying to load stream" + e.toString() + ee.toString());
            }
        }
    }

    public PropertiesFileReader(InputStream stream) throws Exception {
        try {
            this.props = new Properties();
            this.props.load(new BufferedInputStream(stream));
        }
        catch (IOException io) {
            throw new Exception("PropertiesFileReader:Constructor()::Exception--Trying to load stream" + io.toString());
        }
    }

    protected void buildFromProperties(String file) throws Exception {
        String fName = null;
        try {
            fName = file.replace('.', '/') + ".properties";
            InputStream stream = ClassLoader.getSystemResourceAsStream(fName);
            BufferedInputStream bStream = new BufferedInputStream(stream);
            this.props = new Properties();
            this.props.load(bStream);
        }
        catch (Exception e) {
            throw new Exception("PropertiesFileReader:buildFromProperties()::Exception--Trying to load file " + fName + e.toString());
        }
    }

    protected void buildFromFile(String file) throws Exception {
        try {
            FileInputStream fStream = new FileInputStream(file);
            this.props = new Properties();
            this.props.load(new BufferedInputStream(fStream));
        }
        catch (Exception e) {
            throw new Exception("PropertiesFileReader:buildFromFile()::Exception--Trying to load file " + file + e.toString());
        }
    }

    public String getProperty(String propertyName) {
        return this.props.getProperty(propertyName);
    }

    public Enumeration getKeys() {
        return this.props.propertyNames();
    }

    public Map getPropertyMap() {
        Enumeration enumeration = this.getKeys();
        HashMap<String, String> hm = new HashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            String next = (String)enumeration.nextElement();
            hm.put(next, this.getProperty(next));
        }
        return hm;
    }
}

