/*
 * Decompiled with CFR 0.152.
 */
package com.rp.util.pool;

import com.rp.util.Loggable;
import com.rp.util.pool.ObjectManager;
import com.rp.util.pool.ObjectPool;
import com.rp.util.pool.PoolException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ObjectPoolImpl
implements ObjectPool {
    protected String CLASS_NAME = "ObjectPoolImpl";
    protected ObjectManager manager = null;
    protected List freeList = null;
    protected List usedList = null;
    protected int total = 0;
    protected int min = 0;
    protected long waitTime = 0L;
    protected boolean initFlag = false;
    protected Loggable log = null;
    protected String logKey = null;
    protected boolean destroyFlag = false;

    public static ObjectPool getInstance(ObjectManager iMan, int total, int min, long wt, boolean init) throws PoolException {
        return ObjectPoolImpl.getInstance(iMan, total, min, wt, init, null, null);
    }

    public static ObjectPool getInstance(ObjectManager iMan, int total, int min, long wt, boolean init, Loggable log, String logKey) throws PoolException {
        return new ObjectPoolImpl(iMan, total, min, wt, init, log, logKey);
    }

    protected ObjectPoolImpl(ObjectManager iMan, int total, int min, long wt, boolean init, Loggable inLog, String inLogKey) throws PoolException {
        this.manager = iMan;
        this.total = total;
        this.min = min;
        this.waitTime = wt;
        this.log = inLog;
        this.logKey = inLogKey;
        if (init) {
            this.init();
        }
    }

    public synchronized void init() throws PoolException {
        String method = "init()";
        this.info(method, "entering . . .");
        this.freeList = new ArrayList();
        this.usedList = new ArrayList();
        this.debug(method, "min size = " + this.min);
        this.debug(method, "creating");
        for (int i = 0; i < this.min; ++i) {
            Object obj = this.manager.create();
            this.freeList.add(obj);
        }
        this.debug(method, "done creating");
        this.info(method, "leaving . . .");
        this.initFlag = true;
        this.destroyFlag = false;
    }

    public synchronized Object getObject() throws PoolException {
        String method = "getObject()";
        this.info(method, "entering . . .");
        if (!this.initFlag) {
            throw new PoolException("ObjectPool has not been inited.  Init() needs to be called.");
        }
        Object obj = null;
        this.debug(method, "destroy flag = " + this.destroyFlag);
        if (!this.destroyFlag) {
            int freeSize = this.freeList.size();
            this.debug(method, "free size = " + freeSize);
            if (freeSize > 0) {
                obj = this.freeList.get(0);
                if (obj != null) {
                    this.debug(method, "got object from freeList, calling doGet()");
                    obj = this.doGet(obj);
                    this.debug(method, "done calling doGet()");
                } else {
                    this.debug(method, "object is null from freeList, creating new one");
                    obj = this.doCreate(true);
                    this.debug(method, "done creating");
                }
            } else {
                this.debug(method, "free list is empty");
                int usedSize = this.usedList.size();
                this.debug(method, "used size = " + usedSize);
                if (usedSize + freeSize < this.total) {
                    this.debug(method, "used + free < total, creating new object");
                    obj = this.doCreate(false);
                    this.debug(method, "done with create");
                } else {
                    this.debug(method, "no objects available.  checking existing objects - calling doEmpty()");
                    Object status = this.doEmpty();
                    this.debug(method, "done calling doEmpty()");
                    if (status != null) {
                        this.debug(method, "object returned from doEmpty call, notifying . . .");
                        this.notify();
                        obj = this.getObject();
                    } else {
                        this.debug(method, "no objects returned from doEmpty, preparing to wait");
                        try {
                            if (this.waitTime > 0L) {
                                this.debug(method, "wait time = " + this.waitTime);
                                this.debug(method, "waiting for waitTime");
                                long beginTime = this.getTime();
                                this.wait(this.waitTime);
                                long endTime = this.getTime();
                                long timeWaited = endTime - beginTime;
                                this.debug(method, "waited for " + timeWaited);
                                if (timeWaited >= this.waitTime) {
                                    this.debug(method, "wait time has expired, no objects became available, throwing exception");
                                    throw new PoolException("Waited for wait time. No Objects available during wait period.");
                                }
                            } else {
                                this.debug(method, "no wait time set, waiting until notified . . .");
                                this.wait();
                                this.debug(method, "done waiting");
                            }
                        }
                        catch (InterruptedException ie) {
                            this.debug(method, "InterruptedException caught: " + ie.toString());
                        }
                        this.debug(method, "calling getObject()");
                        obj = this.getObject();
                    }
                }
            }
        } else {
            this.debug(method, "destroy flag set, notifying and throwing exception");
            this.notify();
            throw new PoolException("Pool is in destroy mode.  Objects cannot be obtained");
        }
        this.info(method, "leaving . . .");
        return obj;
    }

    public synchronized void freeObject(Object freeObj) throws PoolException {
        String method = "freeObject(Object)";
        this.info(method, "entering . . .");
        int index = this.usedList.indexOf(freeObj);
        this.debug(method, "index of object = " + index);
        if (index >= 0) {
            this.debug(method, "object found, calling performFree and removing");
            freeObj = this.manager.performFree(freeObj);
            this.usedList.remove(index);
            this.freeList.add(freeObj);
            this.debug(method, "notifying");
            this.notify();
        }
        this.info(method, "leaving . . .");
    }

    public synchronized void recycle(boolean waitFlag) throws PoolException {
        String method = "recycle()";
        this.info(method, "entering . . .");
        this.debug(method, "waitFlag = " + waitFlag);
        if (waitFlag) {
            this.debug(method, "calling destroy(true)");
            this.destroy(true);
        } else {
            this.debug(method, "calling destory(false)");
            this.destroy(false);
        }
        this.debug(method, "calling init()");
        this.init();
        this.info(method, "leaving . . .");
    }

    public synchronized void destroy(boolean waitFlag) throws PoolException {
        String method;
        block9: {
            method = "destroy()";
            this.info(method, "entering . . .");
            try {
                this.debug(method, "waitFlag = " + waitFlag);
                if (waitFlag) {
                    this.destroyFlag = true;
                    this.debug(method, "calling doDestory");
                    this.doDestroy(this.freeList);
                    this.debug(method, "done calling doDestory");
                    if (this.freeList.size() <= 0 && this.usedList.size() <= 0) break block9;
                    this.debug(method, "used or free size > 0");
                    this.debug(method, "calling doEmpty()");
                    Object status = this.doEmpty();
                    this.debug(method, "done calling doEmpty()");
                    if (status != null) {
                        this.debug(method, "Object returned from doEmpty() not null");
                        this.debug(method, "calling destroy(true)");
                        this.destroy(true);
                        break block9;
                    }
                    this.debug(method, "status returned from doEmpty() is null");
                    try {
                        this.debug(method, "waiting");
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    this.debug(method, "calling destory(true)");
                    this.destroy(true);
                    break block9;
                }
                this.debug(method, "waitFlag is false.  destroying objects");
                this.debug(method, "calling doDestroy on used objects");
                this.doDestroy(this.usedList);
                this.debug(method, "calling doDestroy on free objects");
                this.doDestroy(this.freeList);
            }
            catch (PoolException ex) {
                this.error(method, "PoolException caught: " + ex.toString());
                throw new PoolException(ex.toString(), ex);
            }
            finally {
                this.freeList = null;
                this.usedList = null;
            }
        }
        this.info(method, "leaving . . .");
    }

    protected synchronized int getCurrentSize() {
        return this.usedList.size() + this.freeList.size();
    }

    protected Object doGet(Object obj) throws PoolException {
        String method = "doGet(Object)";
        this.info(method, "entering . . .");
        this.debug(method, "calling performGet on ObjectManager");
        obj = this.manager.performGet(obj);
        this.debug(method, "done calling performGet");
        this.freeList.remove(0);
        this.usedList.add(obj);
        this.info(method, "leaving . . .");
        return obj;
    }

    protected Object doCreate(boolean removeFlag) throws PoolException {
        String method = "doCreate(boolean)";
        this.info(method, "entering . . .");
        this.debug(method, "calling create() on ObjectManager");
        Object obj = this.manager.create();
        this.debug(method, "done calling create");
        if (obj == null) {
            this.debug(method, "object returned from ObjectManager is null.  Throwing exception");
            throw new PoolException("NULL object returned from call to " + this.manager.getClass().getName() + " create() method");
        }
        this.debug(method, "calling performGet on ObjectManager");
        obj = this.manager.performGet(obj);
        this.debug(method, "done calling performGet");
        this.debug(method, "removeFlag = " + removeFlag);
        if (removeFlag) {
            this.debug(method, "removing from free objects");
            this.freeList.remove(0);
        }
        this.usedList.add(obj);
        this.info(method, "leaving . . .");
        return obj;
    }

    protected Object doEmpty() throws PoolException {
        String method = "doEmpty()";
        this.info(method, "entering . . .");
        boolean found = false;
        Object obj = null;
        ListIterator i = this.usedList.listIterator();
        while (i.hasNext()) {
            obj = i.next();
            if (obj != null) {
                this.debug(method, "calling performEmpty on object");
                if ((obj = this.manager.performEmpty(obj)) == null) continue;
                this.debug(method, "object returned from performEmpty, adding to free objects");
                i.remove();
                this.freeList.add(obj);
                found = true;
                break;
            }
            this.debug(method, "object is null.  calling create()");
            obj = this.manager.create();
            if (obj != null) {
                this.debug(method, "object not null from create, calling performGet");
                obj = this.manager.performGet(obj);
                i.remove();
                this.debug(method, "adding object to free objects");
                this.freeList.add(obj);
                found = true;
                break;
            }
            this.error(method, "create returned null object, throwing exception");
            throw new PoolException("NULL object returned from call to " + this.manager.getClass().getName() + " create() method");
        }
        if (!found) {
            obj = null;
        }
        this.info(method, "leaving . . .");
        return obj;
    }

    protected void doDestroy(List list) throws PoolException {
        String method = "doDestory(List)";
        this.info(method, "entering . . .");
        if (list != null) {
            ListIterator i = list.listIterator();
            while (i.hasNext()) {
                Object temp = i.next();
                if (temp == null) continue;
                this.debug(method, "destroying object");
                this.manager.destroy(temp);
                i.remove();
            }
        }
        this.info(method, "leaving . . .");
    }

    protected void finalize() throws Throwable {
        this.destroy(false);
    }

    protected long getTime() {
        return System.currentTimeMillis();
    }

    protected void fatal(String method, String s) {
        if (this.log != null) {
            this.log.fatal(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void error(String method, String s) {
        if (this.log != null) {
            this.log.error(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void warn(String method, String s) {
        if (this.log != null) {
            this.log.warn(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void info(String method, String s) {
        if (this.log != null) {
            this.log.info(this.CLASS_NAME, method, s, this.logKey);
        }
    }

    protected void debug(String method, String s) {
        if (this.log != null) {
            this.log.debug(this.CLASS_NAME, method, s, this.logKey);
        }
    }
}

