package com.rp.database;

import java.sql.*;


public class ConnectionWrapper implements Connection
{
	private Connection con = null;
	
	public ConnectionWrapper (Connection con)
	{
		this.con = con;
	}
	
	Connection getConnection()
	{
		return this.con;	
	}
	
	public Statement createStatement() throws SQLException
	{
		return con.createStatement();
	}
	
	public PreparedStatement prepareStatement (String sql) throws SQLException
	{
		return con.prepareStatement(sql);
	}
	
	public CallableStatement prepareCall (String sql) throws SQLException
	{
		return con.prepareCall(sql);
	}
	
	public String nativeSQL (String sql) throws SQLException
	{
		return con.nativeSQL (sql);	
	}
	
	public void setAutoCommit (boolean b) throws SQLException
	{
		con.setAutoCommit (b);	
	}
	
	public boolean getAutoCommit () throws SQLException
	{
		return con.getAutoCommit();	
	}
	
	public void commit () throws SQLException
	{
		con.commit();	
	}
	
	public void rollback() throws SQLException
	{
		con.rollback();	
	}

    public void close() throws SQLException
    {
    	con.close();
	}
    
    public boolean isClosed() throws SQLException
    {
    	return con.isClosed();	
    }

    public DatabaseMetaData getMetaData() throws SQLException
    {
    	return con.getMetaData();	
    }

    public void setReadOnly(boolean readOnly) throws SQLException
    {
    	con.setReadOnly(readOnly);	
    }

    public boolean isReadOnly() throws SQLException
    {
    	return con.isReadOnly();	
    }

    public void setCatalog(String catalog) throws SQLException
    {
    	con.setCatalog(catalog);	
    }

    public String getCatalog() throws SQLException
    {
    	return con.getCatalog();	
    }
  
    public void setTransactionIsolation(int level) throws SQLException
    {
    	con.setTransactionIsolation(level);	
    }

    public int getTransactionIsolation() throws SQLException
    {
    	return con.getTransactionIsolation();	
    }

    public SQLWarning getWarnings() throws SQLException
    {
    	return con.getWarnings();	
    }

    public void clearWarnings() throws SQLException
    {
    	con.clearWarnings();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) 
      throws SQLException
    {
    	return con.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, 
					int resultSetConcurrency)
       throws SQLException
   	{
   		return con.prepareStatement(sql, resultSetType, resultSetConcurrency);
   	}

    public CallableStatement prepareCall(String sql, int resultSetType, 
				 int resultSetConcurrency) throws SQLException
	{
		return con.prepareCall (sql, resultSetType, resultSetConcurrency);
	}			 

    public java.util.Map getTypeMap() throws SQLException
    {
    	return con.getTypeMap();	
    }

    public void setTypeMap(java.util.Map map) throws SQLException
    {
    	con.setTypeMap (map);	
    }
    
    public void setHoldability (int i) throws SQLException
    {
    	con.setHoldability(i);
    }
    
    public int getHoldability() throws SQLException
    {
    	return con.getHoldability();	
    }
    
	public Savepoint setSavepoint() throws SQLException
    {
	 	return con.setSavepoint();
    }
    
    public Savepoint setSavepoint(String name) throws SQLException
    {
		return con.setSavepoint (name);
    }
    
    public void rollback(Savepoint savepoint) throws SQLException
    {
    	con.rollback (savepoint);
    }	

    public void releaseSavepoint(Savepoint savepoint) throws SQLException
    {
  	 	con.releaseSavepoint (savepoint);
	}
  	 
    public Statement createStatement(int resultSetType, int resultSetConcurrency, 
			      int resultSetHoldability) throws SQLException
	{
		return con.createStatement (resultSetType, resultSetConcurrency, resultSetHoldability);
	}
	 
    public PreparedStatement prepareStatement(String sql, int resultSetType, 
				       int resultSetConcurrency, int resultSetHoldability)
		throws SQLException
	{
  		return con.prepareStatement (sql, resultSetType, resultSetConcurrency, resultSetHoldability);
	}
  	 
    public CallableStatement prepareCall(String sql, int resultSetType, 
				  int resultSetConcurrency, 
				  int resultSetHoldability) throws SQLException
	 {
		return con.prepareCall (sql, resultSetType, resultSetConcurrency, resultSetHoldability);
	 }
	 
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)
		throws SQLException
	{
	 	return con.prepareStatement (sql, autoGeneratedKeys);
	}
	 
    public PreparedStatement prepareStatement(String sql, int columnIndexes[])
		throws SQLException
	{
		return con.prepareStatement (sql, columnIndexes);
	}
	 
    public PreparedStatement prepareStatement(String sql, String columnNames[])
		throws SQLException
	{
    	return con.prepareStatement (sql, columnNames);	
	}
        
    protected void finalize() throws Throwable
    {
    	close();
    }
    
    protected void destroy() throws SQLException
    {
    	con = null;
    } 
}
