/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import launcher.SwingLauncher;
import launcher.servlet.GrabFileServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyLaunch {
    static Logger logger = LoggerFactory.getLogger(SwingLauncher.class);

    public static void main(String[] args) {
        try {
            Server server = JettyLaunch.newJettyServer(8010);
            server.start();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Server newJettyServer(int port) throws Exception {
        Server server = new Server(port);
        File tmpWar = File.createTempFile("InteractiveTranscript", "war");
        logger.info("Copying .war to: " + tmpWar.getAbsolutePath());
        JettyLaunch.copy(JettyLaunch.class.getClassLoader().getResourceAsStream("InteractiveTranscript.war"), new FileOutputStream(tmpWar));
        server.setHandler(JettyLaunch.handlers(JettyLaunch.servletHandler("/grab", new GrabFileServlet()), JettyLaunch.webApp("/", tmpWar.getAbsolutePath())));
        server.setThreadPool(new QueuedThreadPool(20));
        return server;
    }

    private static Handler servletHandler(String path, HttpServlet servlet) {
        logger.info("adding servlet " + servlet + "...");
        ServletContextHandler h = new ServletContextHandler(1);
        h.setContextPath(path);
        h.addServlet(new ServletHolder(servlet), "/*");
        return h;
    }

    private static WebAppContext webApp(String path, String war) {
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath(path);
        webapp.setWar(war);
        return webapp;
    }

    private static ContextHandlerCollection handlers(Handler ... array) {
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        handlers.setHandlers(array);
        return handlers;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int bytesRead;
            byte[] bytes = new byte[1024];
            while ((bytesRead = in.read(bytes)) != -1) {
                out.write(bytes, 0, bytesRead);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }
}

