/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import launcher.About;
import launcher.JettyLaunch;
import launcher.tasks.NewVersionChecker;
import launcher.util.HttpUtil;
import launcher.util.Utilities;
import org.eclipse.jetty.server.Server;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingLauncher {
    static Logger logger = LoggerFactory.getLogger(SwingLauncher.class);
    private static final int JETTY_PORT = 8010;
    private JFrame frmDinglabsDesktopPlayer;
    private final Action exitAction = new ExitAction();
    Model model = new Model();
    Server jettyServer;
    private JTextField trsfileTextField;
    private JTextField trsfileTextField2;
    private JCheckBox chckbxUseSecondTrs;
    private JButton btnSelectTrs2;
    private JButton btnLaunchLrIn;
    private JTextField mp3fileTextField;
    private final Action aboutAction = new AboutAction();
    private final Action visitHomepageAction = new VisitHomepageAction();
    private final Action launchDemoAction = new LaunchDemoAction();

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingLauncher window = new SwingLauncher();
                    window.frmDinglabsDesktopPlayer.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SwingLauncher() throws Exception {
        this.initialize();
        final String oldLabel = this.btnLaunchLrIn.getText();
        this.btnLaunchLrIn.setEnabled(false);
        this.btnLaunchLrIn.setText("Initializing...");
        this.launchDemoAction.setEnabled(false);
        new SwingWorker<Object, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    SwingLauncher.this.initWhileUIWaits();
                }
                catch (Exception e) {
                    Utilities.alertError(SwingLauncher.this.frmDinglabsDesktopPlayer, "Error launching Jetty webserver.", e);
                }
                return null;
            }

            @Override
            protected void done() {
                SwingLauncher.this.btnLaunchLrIn.setText(oldLabel);
                SwingLauncher.this.btnLaunchLrIn.setEnabled(true);
                SwingLauncher.this.launchDemoAction.setEnabled(true);
            }
        }.execute();
    }

    private void initWhileUIWaits() throws Exception {
        NewVersionChecker.checkForNewVersionInBackground("0.1", new Runnable(){

            @Override
            public void run() {
                SwingLauncher.this.alertNewVersionAvailable();
            }
        });
        this.jettyServer = JettyLaunch.newJettyServer(8010);
        this.jettyServer.start();
    }

    private void initialize() {
        this.frmDinglabsDesktopPlayer = new JFrame();
        this.frmDinglabsDesktopPlayer.setIconImage(Toolkit.getDefaultToolkit().getImage(SwingLauncher.class.getClassLoader().getResource("favicon.png")));
        this.frmDinglabsDesktopPlayer.setTitle("DingLabs Desktop Player for Listening-Reading");
        this.frmDinglabsDesktopPlayer.setBounds(100, 100, 605, 315);
        this.frmDinglabsDesktopPlayer.setDefaultCloseOperation(3);
        JMenuBar menuBar = new JMenuBar();
        this.frmDinglabsDesktopPlayer.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        mnFile.setMnemonic('f');
        menuBar.add(mnFile);
        JMenuItem mntmLaunchDemo = mnFile.add(this.launchDemoAction);
        JMenuItem mntmExit = new JMenuItem("Exit");
        mntmExit.setAction(this.exitAction);
        mnFile.add(mntmExit);
        JMenu mnHelp = new JMenu("Help");
        mnHelp.setMnemonic('h');
        menuBar.add(mnHelp);
        JMenuItem menuItem = mnHelp.add(this.visitHomepageAction);
        JMenuItem mntmAbout = mnHelp.add(this.aboutAction);
        this.frmDinglabsDesktopPlayer.getContentPane().setLayout(new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JButton btnSelectMp3 = new JButton("Select MP3 File");
        btnSelectMp3.setToolTipText("Select Audio File (*.mp3, *.ogg)");
        btnSelectMp3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingLauncher.this.selectFileForTextField(SwingLauncher.this.mp3fileTextField, Utilities.newFileFilter("MP3/Ogg Files", "mp3", "ogg"));
            }
        });
        JLabel lblSelectFilesTo = new JLabel("Select files to view, then click 'Launch Player'.");
        this.frmDinglabsDesktopPlayer.getContentPane().add((Component)lblSelectFilesTo, "4, 4, 3, 1, default, bottom");
        this.frmDinglabsDesktopPlayer.getContentPane().add((Component)btnSelectMp3, "4, 8");
        this.mp3fileTextField = new JTextField();
        this.mp3fileTextField.setColumns(10);
        this.frmDinglabsDesktopPlayer.getContentPane().add((Component)this.mp3fileTextField, "6, 8, 3, 1, fill, default");
        JButton btnSelectTrs = new JButton("Select TRS File");
        btnSelectTrs.setToolTipText("Select Transcriber file (*.trs)");
        btnSelectTrs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingLauncher.this.selectFileForTextField(SwingLauncher.this.trsfileTextField, SwingLauncher.trsFileFilter());
            }
        });
        this.frmDinglabsDesktopPlayer.getContentPane().add((Component)btnSelectTrs, "4, 10");
        this.trsfileTextField = new JTextField();
        this.frmDinglabsDesktopPlayer.getContentPane().add((Component)this.trsfileTextField, "6, 10, 3, 1, fill, default");
        this.trsfileTextField.setColumns(10);
        this.btnSelectTrs2 = new JButton("Select 2nd TRS File");
        this.btnSelectTrs2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingLauncher.this.selectFileForTextField(SwingLauncher.this.trsfileTextField2, SwingLauncher.trsFileFilter());
            }
        });
        this.chckbxUseSecondTrs = new JCheckBox("Display dual-transcripts?");
        this.frmDinglabsDesktopPlayer.getContentPane().add((Component)this.chckbxUseSecondTrs, "4, 12, 3, 1");
        this.frmDinglabsDesktopPlayer.getContentPane().add((Component)this.btnSelectTrs2, "4, 14");
        this.trsfileTextField2 = new JTextField();
        this.trsfileTextField2.setColumns(10);
        this.frmDinglabsDesktopPlayer.getContentPane().add((Component)this.trsfileTextField2, "6, 14, 3, 1, fill, default");
        this.btnLaunchLrIn = new JButton("Launch Player");
        this.btnLaunchLrIn.setFont(new Font("Tahoma", 1, 14));
        this.btnLaunchLrIn.setBackground(UIManager.getColor("Button.background"));
        this.btnLaunchLrIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingLauncher.this.launchReader(SwingLauncher.this.model);
            }
        });
        this.frmDinglabsDesktopPlayer.getContentPane().add((Component)this.btnLaunchLrIn, "4, 18, 5, 1, center, default");
        this.initDataBindings();
    }

    private void alertNewVersionAvailable() {
        String downloadUrl = "http://www.dinglabs.com/download";
        int response = JOptionPane.showConfirmDialog(this.frmDinglabsDesktopPlayer, "Great news!\nA new version is now available.\n\nDo you want to visit the download page in your browser now?\n\n   " + downloadUrl, "New Version Available", 0, 1);
        if (response == 0) {
            Utilities.launchURLInBrowserHandleError(this.frmDinglabsDesktopPlayer, downloadUrl);
        }
    }

    private void launchReader(Model model) {
        String url = null;
        try {
            url = SwingLauncher.getBrowserUrl(model);
            Utilities.launchURLInBrowser(url);
        }
        catch (Exception e) {
            Utilities.alertError(this.frmDinglabsDesktopPlayer, "Error launching browser to visit URL:\n" + url, e);
        }
    }

    private static String getBrowserUrl(Model model) throws UnsupportedEncodingException {
        String audioFile = model.getAudioFile();
        String trsFile = model.getTrsFile();
        String trsFile2 = model.getTrsFile2();
        StringBuilder url = new StringBuilder();
        url.append(SwingLauncher.getRootUrl()).append("/InteractiveTranscript.html#").append("e:=true");
        if (!SwingLauncher.isEmpty(audioFile) || !SwingLauncher.isEmpty(trsFile)) {
            url.append(",a:=" + SwingLauncher.getGrabURL(audioFile) + ",n:=Untitled" + ",t:=" + SwingLauncher.getGrabURL(trsFile) + ",f:=18,ff:=Serif,l:=135%25");
        }
        if (model.isIncludeTrs2() && !SwingLauncher.isEmpty(trsFile2)) {
            url.append(",t2:=" + SwingLauncher.getGrabURL(trsFile2) + ",f2:=18,ff2:=Serif,l2:=135%25");
        }
        logger.info("Generated new URL: " + url.toString());
        return url.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private static String getRootUrl() {
        return "http://localhost:8010";
    }

    private static String getGrabURL(String file) throws UnsupportedEncodingException {
        String fileAsUrl = new File(file).toURI().toString();
        return String.valueOf(SwingLauncher.getRootUrl()) + "/grab/?path=" + HttpUtil.urlencode(HttpUtil.urlencode(fileAsUrl));
    }

    private void selectFileForTextField(JTextField textField, FileFilter fileFilter) {
        JFileChooser fc = new JFileChooser(textField.getText());
        if (fileFilter != null) {
            fc.addChoosableFileFilter(fileFilter);
        }
        if (fc.showOpenDialog(this.frmDinglabsDesktopPlayer) == 0) {
            String path = fc.getSelectedFile().getAbsolutePath();
            textField.setText(path);
            logger.debug("Selected file: {}", (Object)path);
        }
    }

    private static FileFilter trsFileFilter() {
        return Utilities.newFileFilter("Transcriber transcripts", "trs");
    }

    protected void initDataBindings() {
        BeanProperty modelBeanProperty = BeanProperty.create("trsFile");
        BeanProperty jTextFieldBeanProperty_1 = BeanProperty.create("text");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.model, modelBeanProperty, this.trsfileTextField, jTextFieldBeanProperty_1);
        autoBinding_2.bind();
        BeanProperty modelBeanProperty_1 = BeanProperty.create("trsFile2");
        BeanProperty jTextFieldBeanProperty_2 = BeanProperty.create("text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.model, modelBeanProperty_1, this.trsfileTextField2, jTextFieldBeanProperty_2);
        autoBinding_3.bind();
        BeanProperty modelBeanProperty_2 = BeanProperty.create("includeTrs2");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create("selected");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.model, modelBeanProperty_2, this.chckbxUseSecondTrs, jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty modelBeanProperty_3 = BeanProperty.create("audioFile");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create("text");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.model, modelBeanProperty_3, this.mp3fileTextField, jTextFieldBeanProperty_3);
        autoBinding_5.bind();
        BeanProperty jButtonBeanProperty_1 = BeanProperty.create("visible");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.chckbxUseSecondTrs, jCheckBoxBeanProperty, this.btnSelectTrs2, jButtonBeanProperty_1);
        autoBinding_6.bind();
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create("visible");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.chckbxUseSecondTrs, jCheckBoxBeanProperty, this.trsfileTextField2, jTextFieldBeanProperty_4);
        autoBinding_7.bind();
    }

    private class AboutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AboutAction() {
            this.putValue("Name", "About");
            this.putValue("ShortDescription", "About this application.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new About().setVisible(true);
        }
    }

    private class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ExitAction() {
            this.putValue("Name", "Exit");
            this.putValue("ShortDescription", "Some short description");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.info("Exiting app...");
            SwingLauncher.this.frmDinglabsDesktopPlayer.dispose();
            System.exit(0);
        }
    }

    private class LaunchDemoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LaunchDemoAction() {
            this.putValue("Name", "Launch Dual-Transcript Demo");
            this.putValue("ShortDescription", "Launch dual-transcript example in browser.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Utilities.launchURLInBrowserHandleError(SwingLauncher.this.frmDinglabsDesktopPlayer, "http://localhost:8010/InteractiveTranscript.html#a:=http://library.dinglabs.com/books/8/44.mp3,n:=Cultural%20Interviews%20with%20Chinese-Speaking%20Professionals%20by%20University%20of%20Texas%20at%20Austin,e:=true,t:=https://sites.google.com/site/dinglabs/files/cour02hsi-zw.trs?attredirects=0&d=1,f:=20,ff:=SimSun,l:=150%25,t2:=https://sites.google.com/site/dinglabs/files/cour02hsi-en.trs?attredirects=0&d=1,f2:=18,ff2:=Serif,l2:=150%25");
        }
    }

    public static class Model {
        private String audioFile;
        private String trsFile;
        private String trsFile2;
        private boolean includeTrs2;

        public String getTrsFile() {
            return this.trsFile;
        }

        public String getAudioFile() {
            return this.audioFile;
        }

        public String getTrsFile2() {
            return this.trsFile2;
        }

        public boolean isIncludeTrs2() {
            return this.includeTrs2;
        }

        public void setTrsFile(String trsFile) {
            this.trsFile = trsFile;
        }

        public void setAudioFile(String audioFile) {
            this.audioFile = audioFile;
        }

        public void setTrsFile2(String trsFile2) {
            this.trsFile2 = trsFile2;
        }

        public void setIncludeTrs2(boolean includeTrs2) {
            this.includeTrs2 = includeTrs2;
        }

        public String toString() {
            return "Model[\naudioFile  =" + this.audioFile + ",\n" + "trsFile    =" + this.trsFile + ",\n" + "includeTrs2=" + this.includeTrs2 + ",\n" + "trsFile2   =" + this.trsFile2 + "\n]";
        }
    }

    private class VisitHomepageAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public VisitHomepageAction() {
            this.putValue("Name", "Instructions...");
            this.putValue("ShortDescription", "View instructions.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Utilities.launchURLInBrowserHandleError(SwingLauncher.this.frmDinglabsDesktopPlayer, "http://www.dinglabs.com/desktop-player");
        }
    }
}

