/*
 * Decompiled with CFR 0.152.
 */
package launcher.tasks;

import java.io.IOException;
import java.util.regex.Pattern;
import launcher.util.HttpUtil;
import launcher.util.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewVersionChecker {
    static Logger logger = LoggerFactory.getLogger(NewVersionChecker.class);

    public static String whatismyIP() throws IOException {
        String ip = HttpUtil.doHttpGet("http://www.whatismyip.com/automation/n09230945.asp");
        logger.info("Fetched IP: " + ip);
        return ip;
    }

    public static String recordAndCheckLatestVersion(String ipaddress, String usingVersion) throws Exception {
        String response = HttpUtil.doHttpPost("http://spreadsheets0.google.com/formResponse?formkey=dG14YVVQT1BYNzJfZ3hCTmdydnFPZlE6MQ&ifq", HttpUtil.Pair.p("entry.0.single", usingVersion), HttpUtil.Pair.p("entry.1.single", ipaddress), HttpUtil.Pair.p("pageNumber", "0"), HttpUtil.Pair.p("backupCache", ""), HttpUtil.Pair.p("submit", "Submit"));
        return Utilities.regexSelectGroup(response, "CurVer\\(([^)]+)\\)", 1);
    }

    public static void checkForNewVersionInBackground(final String currentVersion, final Runnable newVersionAvailable) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String latest = NewVersionChecker.recordAndCheckLatestVersion(NewVersionChecker.whatismyIP(), currentVersion);
                    if (VersionNumberCompare.isNewerThan(latest, currentVersion)) {
                        newVersionAvailable.run();
                    }
                }
                catch (Exception e) {
                    logger.error("Error while checking for new version.", e);
                }
            }
        }).start();
    }

    public static void main(String[] args) {
        try {
            String ipaddress = NewVersionChecker.whatismyIP();
            logger.info("Your IP is: " + ipaddress);
            String usingVersion = "x0.00123";
            String latest = NewVersionChecker.recordAndCheckLatestVersion(ipaddress, usingVersion);
            logger.info("Response: " + latest);
        }
        catch (Throwable t) {
            logger.error("error in main()", t);
        }
    }

    static class VersionNumberCompare {
        VersionNumberCompare() {
        }

        public static boolean isNewerThan(String v1, String v2) {
            String s2;
            String s1 = VersionNumberCompare.normalisedVersion(v1);
            int cmp = s1.compareTo(s2 = VersionNumberCompare.normalisedVersion(v2));
            String cmpStr = cmp < 0 ? "<" : (cmp > 0 ? ">" : "==");
            logger.debug("Version: '" + v1 + "' " + cmpStr + " '" + v2 + "'");
            return cmp > 0;
        }

        public static String normalisedVersion(String version) {
            return VersionNumberCompare.normalisedVersion(version, ".", 4);
        }

        public static String normalisedVersion(String version, String sep, int maxWidth) {
            String[] split = Pattern.compile(sep, 16).split(version);
            StringBuilder sb = new StringBuilder();
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb.append(String.format("%" + maxWidth + 's', s));
                ++n2;
            }
            return sb.toString();
        }
    }
}

