/*
 * Decompiled with CFR 0.152.
 */
package launcher.util;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import launcher.util.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    static Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    public static String doHttpGet(String getUrl) throws IOException {
        logger.info("Fetching URL: " + getUrl);
        URL url = new URL(getUrl);
        URLConnection conn = url.openConnection();
        String response = Utilities.readToString(conn.getInputStream());
        logger.trace("Response: {}", (Object)response);
        return response;
    }

    public static String doHttpPost(String postUrl, Pair ... params) throws Exception {
        String data = HttpUtil.buildParamList(params);
        logger.info("POSTing data to " + postUrl + ": " + data);
        URL url = new URL(postUrl);
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
        wr.write(data);
        wr.flush();
        String response = Utilities.readToString(conn.getInputStream());
        wr.close();
        logger.trace("Response: {}", (Object)response);
        return response;
    }

    private static String buildParamList(Pair ... params) throws UnsupportedEncodingException {
        StringBuilder data = new StringBuilder();
        boolean isFirst = true;
        Pair[] pairArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Pair p = pairArray[n2];
            if (isFirst) {
                isFirst = false;
            } else {
                data.append("&");
            }
            data.append(HttpUtil.urlencode(p.name)).append("=").append(HttpUtil.urlencode(p.value));
            ++n2;
        }
        String dataString = data.toString();
        return dataString;
    }

    public static String urlencode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8");
    }

    public static class Pair {
        public final String name;
        public final String value;

        public Pair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public static Pair p(String name, String value) {
            return new Pair(name, value);
        }
    }
}

