/*
 * Decompiled with CFR 0.152.
 */
package launcher.util;

import java.awt.Component;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilities {
    static Logger logger = LoggerFactory.getLogger(Utilities.class);

    public static String readToString(InputStream inputStream) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            sb.append(line).append("\n");
        }
        rd.close();
        return sb.toString();
    }

    public static Matcher regexMatcher(String regex, String input) {
        Matcher m = Pattern.compile(regex).matcher(input);
        return m;
    }

    public static String regexSelectGroup(String input, String regex, int group) {
        try {
            Matcher m = Utilities.regexMatcher(regex, input);
            if (m.find()) {
                return m.group(group);
            }
        }
        catch (Exception e) {
            logger.error("Problem finding match for regex: " + regex, e);
        }
        return null;
    }

    public static void alert(Component parent, String message) {
        logger.info("Displaying popup message: " + message);
        JOptionPane.showMessageDialog(parent, message);
    }

    public static void alertError(Component parent, String errorMessage) {
        Utilities.alertError(parent, errorMessage, null);
    }

    public static void alertError(Component parent, String errorMessage, Exception exception) {
        if (exception != null) {
            logger.error(errorMessage, exception);
        }
        logger.info("Displaying error popup message: " + errorMessage);
        JOptionPane.showMessageDialog(parent, errorMessage, "Error", 0);
    }

    public static String getExtension(File f) {
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            return s.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public static FileFilter newFileFilter(final String desc, final String ... extensions) {
        return new FileFilter(){

            @Override
            public String getDescription() {
                return desc;
            }

            @Override
            public boolean accept(File f) {
                if (!f.isFile()) {
                    return true;
                }
                String ext = Utilities.getExtension(f);
                if (ext != null) {
                    String[] stringArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String e = stringArray[n2];
                        if (ext.equalsIgnoreCase(e)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        };
    }

    public static void launchURLInBrowser(String url) throws URISyntaxException, IOException {
        logger.info("Launching URL in browser: " + url);
        URI uri = new URI(url);
        Desktop.getDesktop().browse(uri);
    }

    public static void launchURLInBrowserHandleError(Component parent, String url) {
        try {
            Utilities.launchURLInBrowser(url);
        }
        catch (Exception e) {
            Utilities.alertError(parent, "Error launching browser to visit URL:\n" + url, e);
        }
    }
}

