<DOCFLEX_TEMPLATE VER='1.17'>
CREATED='2010-05-14 06:44:29'
LAST_UPDATE='2012-02-06 01:14:40'
DESIGNER_TOOL='DocFlex SDK 1.x'
DESIGNER_LICENSE_TYPE='Filigris Works Team'
APP_ID='docflex-javadoc'
APP_NAME='DocFlex/Javadoc | JavadocPro'
APP_AUTHOR='Copyright © 2004-2012 Filigris Works, Leonid Rudy Softwareprodukte. All rights reserved.'
TEMPLATE_TYPE='DocumentTemplate'
DSM_TYPE_ID='javadoc2'
ROOT_ET='<ANY>'
<TEMPLATE_PARAMS>
	PARAM={
		param.name='$type';
		param.description='Type of the document for which the navigation bar
is generated';
		param.type='enum';
		param.enum.values='default;overview;package;class;use;tree;deprecated;index;help';
	}
	PARAM={
		param.name='$location';
		param.description='Location of the navigation bar (header/footer)';
		param.type='enum';
		param.enum.values='header;footer';
	}
	PARAM={
		param.name='$text';
		param.description='The text to be displayed in the navigation bar.

This parameter is calculated dynamically 
and needs not to be specified.';
		param.type='string';
		param.trimSpaces='true';
		param.defaultValue.expr='hasParamValue("$location", "header") ?
  getStringParam("gen.navbar.headerText")
  : {
    text = getStringParam ("gen.navbar.footerText");
    text.length() > 0 ? text : 
       getStringParam("gen.navbar.headerText")
  }';
	}
	PARAM={
		param.name='gen';
		param.title='Generate';
		param.title.style.bold='true';
		param.group='true';
	}
	PARAM={
		param.name='gen.refs.use';
		param.title='Use (Package/Class)';
		param.type='boolean';
	}
	PARAM={
		param.name='gen.refs.tree';
		param.title='Tree (Class Hierarchy)';
		param.type='boolean';
	}
	PARAM={
		param.name='gen.refs.index';
		param.title='Index';
		param.type='boolean';
	}
	PARAM={
		param.name='gen.refs.allClasses';
		param.title='All Classes Summary';
		param.type='boolean';
	}
	PARAM={
		param.name='gen.help';
		param.title='Help';
		param.type='boolean';
	}
	PARAM={
		param.name='gen.navbar.headerText';
		param.title='Header Text';
		param.type='text';
	}
	PARAM={
		param.name='gen.navbar.footerText';
		param.title='Footer Text';
		param.type='text';
	}
</TEMPLATE_PARAMS>
<STYLES>
	CHAR_STYLE={
		style.name='Default Paragraph Font';
		style.id='cs1';
		style.default='true';
	}
	CHAR_STYLE={
		style.name='Hyperlink';
		style.id='cs2';
		text.decor.underline='true';
		text.color.foreground='#0000FF';
	}
	CHAR_STYLE={
		style.name='NavBar';
		style.id='cs3';
		text.font.name='Arial';
		text.color.foreground='#000000';
	}
	CHAR_STYLE={
		style.name='NavBar Highlighted';
		style.id='cs4';
		text.font.name='Arial';
		text.color.foreground='#FFFFFF';
	}
	CHAR_STYLE={
		style.name='NavBar Hyperlink';
		style.id='cs5';
		text.font.style.bold='true';
		text.color.foreground='#000000';
	}
	CHAR_STYLE={
		style.name='NavBar Small';
		style.id='cs6';
		text.font.name='Arial';
		text.font.size='6.5';
	}
	CHAR_STYLE={
		style.name='NavBar Small Hyperlink';
		style.id='cs7';
		text.font.style.bold='true';
	}
	PAR_STYLE={
		style.name='Normal';
		style.id='s1';
		style.default='true';
	}
</STYLES>
FMT={
	doc.lengthUnits='pt';
	doc.hlink.style.link='cs2';
	doc.paper.width='750';
}
<ROOT>
	<AREA_SEC>
		COND='hasParamValue("$location", "footer")'
		<AREA>
			<HR>
			</HR>
		</AREA>
	</AREA_SEC>
	<FOLDER>
		DESCR='Navigation bars for different document types'
		<BODY>
			<AREA_SEC>
				DESCR='Class'
				COND='hasParamValue("$type", "class")'
				MATCHING_ET='ClassDoc'
				BREAK_PARENT_BLOCK='when-executed'
				COLLAPSED
				FMT={
					sec.outputStyle='table';
					table.sizing='Relative';
					table.cell.padding.both='0';
					table.border.style='none';
				}
				<AREA>
					<CTRL_GROUP>
						FMT={
							trow.cell.align.vert='Top';
						}
						<CTRLS>
							<PANEL>
								FMT={
									content.outputStyle='table';
									ctrl.size.width='592.5';
									ctrl.size.height='194.3';
									text.font.name='Arial';
									table.sizing='Relative';
									table.cell.padding.both='0.5';
									table.border.style='none';
								}
								<AREA>
									<CTRL_GROUP>
										<CTRLS>
											<PANEL>
												FMT={
													content.outputStyle='table';
													ctrl.size.width='571.5';
													ctrl.size.height='59.3';
													tcell.bkgr.color='#EEEEFF';
													text.style='cs3';
													text.hlink.fmt='style';
													text.hlink.style='cs5';
													text.hlink.style.use='override';
													text.option.nbsps='true';
													txtfl.delimiter.type='none';
													table.cell.spacing.both='2';
													table.cell.padding.both='0';
													table.border.style='none';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<PANEL>
																COND='findHyperTarget ("overview") != null'
																FMT={
																	ctrl.size.width='79.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Overview'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='74.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Package'
																				<DOC_HLINK>
																					HKEYS={
																						'getAttrValue("containingPackage")';
																						'"detail"';
																					}
																				</DOC_HLINK>
																				<URL_HLINK>
																					COND='/* This hyperlink definition is used to generate a hyperlink to the external docs
(specified with -link/-linkoffline options on Javadoc command line),  when 
by the previous definition no internal target (within the currently generated docs) 
can be found.
Note that both hyperlink definitions compete for the same targeted frame.
However, the one defined the first will be executed the first */'
																					URL_EXPR='getExternalDocURL(getElementByLinkAttr("containingPackage"))'
																				</URL_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='75.8';
																	ctrl.size.height='38.3';
																	tcell.bkgr.color='#00008B';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT='Class'
																				FMT={
																					text.style='cs4';
																					text.font.style.bold='true';
																					text.color.foreground='#FFFFFF';
																				}
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.use")'
																FMT={
																	ctrl.size.width='56.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Use'
																				<DOC_HLINK>
																					HKEYS={
																						'contextElement.id';
																						'"use"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.tree")'
																FMT={
																	ctrl.size.width='59.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Tree'
																				<DOC_HLINK>
																					HKEYS={
																						'getAttrValue("containingPackage")';
																						'"package-tree"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='findHyperTarget ("deprecated-list") != null'
																FMT={
																	ctrl.size.width='84';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Deprecated'
																				<DOC_HLINK>
																					HKEYS={
																						'"deprecated-list"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.index")'
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Index'
																				<DOC_HLINK>
																					HKEYS={
																						'"index"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.help")'
																FMT={
																	ctrl.size.width='61.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Help'
																				<DOC_HLINK>
																					HKEYS={
																						'"help-doc"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										FMT={
											text.style='cs6';
											text.hlink.fmt='style';
											text.hlink.style='cs7';
											text.hlink.style.use='modify';
										}
										<CTRLS>
											<PANEL>
												FMT={
													ctrl.size.width='268.5';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='PREV CLASS'
																<DOC_HLINK>
																	HKEYS={
																		'mainContext.iterator.prevItem.toElement().id';
																		'"detail"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='   ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NEXT CLASS'
																<DOC_HLINK>
																	HKEYS={
																		'mainContext.iterator.nextItem.toElement().id';
																		'"detail"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
											<PANEL>
												FMT={
													ctrl.size.width='303';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='makeRelativePath (mainContext.output.file, output.dir).toURL()
+ \'?\' +
makeRelativePath (output.file, mainContext.output.dir).toURL()'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NO FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='output.fileName'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getBooleanParam("gen.refs.allClasses")'
																TEXT='All Classes'
																<DOC_HLINK>
																	HKEYS={
																		'"all-classes-summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										FMT={
											text.style='cs6';
										}
										<CTRLS>
											<PANEL>
												FMT={
													ctrl.size.width='267.8';
													ctrl.size.height='56.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='SUMMARY:'
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbsp';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isInterface") ||
getAttrBooleanValue("isClass")'
																TEXT='NESTED'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"nested_class_summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text=' | ';
																	txtfl.delimiter.override='false';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isEnum")'
																TEXT='ENUM CONSTANTS'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"enum_constant_summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text=' | ';
																	txtfl.delimiter.override='false';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isInterface") ||
getAttrBooleanValue("isClass")'
																TEXT='FIELD'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"field_summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text=' | ';
																	txtfl.delimiter.override='false';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isInterface") ||
getAttrBooleanValue("isClass") && ! getAttrBooleanValue("isEnum")'
																TEXT='CONSTR'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"constructor_summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text=' | ';
																	txtfl.delimiter.override='false';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isInterface") ||
getAttrBooleanValue("isClass") ||
getAttrBooleanValue("isEnum")'
																TEXT='METHOD'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"method_summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text=' | ';
																	txtfl.delimiter.override='false';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isAnnotationType")'
																TEXT='REQUIRED'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"annotation_type_required_element_summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text=' | ';
																	txtfl.delimiter.override='false';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isAnnotationType")'
																TEXT='OPTIONAL'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"annotation_type_optional_element_summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
											<PANEL>
												FMT={
													ctrl.size.width='303.8';
													ctrl.size.height='56.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='DETAIL:'
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbsp';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isEnum")'
																TEXT='ENUM CONSTANTS'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"enum_constant_detail"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text=' | ';
																	txtfl.delimiter.override='false';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isInterface") ||
getAttrBooleanValue("isClass")'
																TEXT='FIELD'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"field_detail"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text=' | ';
																	txtfl.delimiter.override='false';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isInterface") ||
getAttrBooleanValue("isClass") && ! getAttrBooleanValue("isEnum")'
																TEXT='CONSTR'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"constructor_detail"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text=' | ';
																	txtfl.delimiter.override='false';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isInterface") ||
getAttrBooleanValue("isClass")'
																TEXT='METHOD'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"method_detail"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text=' | ';
																	txtfl.delimiter.override='false';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getAttrBooleanValue("isAnnotationType")'
																TEXT='ELEMENT'
																<DOC_HLINK>
																	HKEYS={
																		'contextElement.id';
																		'"annotation_type_element_detail"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
								</AREA>
							</PANEL>
							<DATA_CTRL>
								COND='getStringParam("$text").length() > 0'
								FORMULA='getParam("$text")'
								FMT={
									ctrl.size.width='61.5';
									ctrl.size.height='194.3';
									tcell.align.horz='Right';
									text.font.style.italic='true';
									txtfl.ehtml.render='true';
								}
							</DATA_CTRL>
						</CTRLS>
					</CTRL_GROUP>
				</AREA>
			</AREA_SEC>
			<AREA_SEC>
				DESCR='Use'
				COND='hasParamValue("$type", "use")'
				MATCHING_ETS={'ClassDoc';'PackageDoc'}
				BREAK_PARENT_BLOCK='when-executed'
				COLLAPSED
				FMT={
					sec.outputStyle='table';
					table.sizing='Relative';
					table.cell.padding.both='0';
					table.border.style='none';
				}
				<AREA>
					<CTRL_GROUP>
						FMT={
							trow.cell.align.vert='Top';
						}
						<CTRLS>
							<PANEL>
								FMT={
									content.outputStyle='table';
									ctrl.size.width='592.5';
									ctrl.size.height='128.3';
									text.font.name='Arial';
									table.sizing='Relative';
									table.cell.padding.both='0.5';
									table.border.style='none';
								}
								<AREA>
									<CTRL_GROUP>
										<CTRLS>
											<PANEL>
												FMT={
													content.outputStyle='table';
													ctrl.size.width='571.5';
													ctrl.size.height='59.3';
													tcell.bkgr.color='#EEEEFF';
													text.style='cs3';
													text.hlink.fmt='style';
													text.hlink.style='cs5';
													text.hlink.style.use='override';
													text.option.nbsps='true';
													txtfl.delimiter.type='none';
													table.cell.spacing.both='2';
													table.cell.padding.both='0';
													table.border.style='none';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<PANEL>
																COND='findHyperTarget ("overview") != null'
																FMT={
																	ctrl.size.width='79.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Overview'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='75';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Package'
																				<DOC_HLINK>
																					HKEYS={
																						'instanceOf ("ClassDoc")
  ? getAttrValue("containingPackage")
  : contextElement.id
';
																						'"detail"';
																					}
																				</DOC_HLINK>
																				<URL_HLINK>
																					COND='instanceOf ("ClassDoc")

/* This hyperlink definition is used to generate a hyperlink to the external docs
(specified with -link/-linkoffline options on Javadoc command line),  when 
by the previous definition no internal target (within the currently generated docs) 
can be found.
Note that both hyperlink definitions compete for the same targeted frame.
However, the one defined the first will be executed the first */'
																					URL_EXPR='getExternalDocURL(getElementByLinkAttr("containingPackage"))'
																				</URL_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='64.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Class'
																				<DOC_HLINK>
																					COND='instanceOf ("ClassDoc")'
																					HKEYS={
																						'contextElement.id';
																						'"detail"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='69.8';
																	ctrl.size.height='38.3';
																	tcell.bkgr.color='#00008B';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT='Use'
																				FMT={
																					text.style='cs4';
																					text.font.style.bold='true';
																					text.color.foreground='#FFFFFF';
																				}
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.tree")'
																FMT={
																	ctrl.size.width='56.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Tree'
																				<DOC_HLINK>
																					HKEYS={
																						'instanceOf ("ClassDoc")
  ? getAttrValue("containingPackage")
  : contextElement.id
';
																						'"package-tree"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='findHyperTarget ("deprecated-list") != null'
																FMT={
																	ctrl.size.width='84';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Deprecated'
																				<DOC_HLINK>
																					HKEYS={
																						'"deprecated-list"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.index")'
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Index'
																				<DOC_HLINK>
																					HKEYS={
																						'"index"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.help")'
																FMT={
																	ctrl.size.width='61.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Help'
																				<DOC_HLINK>
																					HKEYS={
																						'"help-doc"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										FMT={
											text.style='cs6';
											text.hlink.fmt='style';
											text.hlink.style='cs7';
											text.hlink.style.use='modify';
										}
										<CTRLS>
											<PANEL>
												FMT={
													ctrl.size.width='268.5';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='PREV'
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='   ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NEXT'
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
											<PANEL>
												FMT={
													ctrl.size.width='303';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='makeRelativePath (mainContext.output.file, output.dir).toURL()
+ \'?\' +
makeRelativePath (output.file, mainContext.output.dir).toURL()'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NO FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='output.fileName'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getBooleanParam("gen.refs.allClasses")'
																TEXT='All Classes'
																<DOC_HLINK>
																	HKEYS={
																		'"all-classes-summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
								</AREA>
							</PANEL>
							<DATA_CTRL>
								COND='getStringParam("$text").length() > 0'
								FORMULA='getParam("$text")'
								FMT={
									ctrl.size.width='61.5';
									ctrl.size.height='128.3';
									tcell.align.horz='Right';
									text.font.style.italic='true';
									txtfl.ehtml.render='true';
								}
							</DATA_CTRL>
						</CTRLS>
					</CTRL_GROUP>
				</AREA>
			</AREA_SEC>
			<AREA_SEC>
				DESCR='Package'
				COND='hasParamValue("$type", "package")'
				MATCHING_ET='PackageDoc'
				BREAK_PARENT_BLOCK='when-executed'
				COLLAPSED
				FMT={
					sec.outputStyle='table';
					table.sizing='Relative';
					table.cell.padding.both='0';
					table.border.style='none';
				}
				<AREA>
					<CTRL_GROUP>
						FMT={
							trow.cell.align.vert='Top';
						}
						<CTRLS>
							<PANEL>
								FMT={
									content.outputStyle='table';
									ctrl.size.width='592.5';
									ctrl.size.height='128.3';
									text.font.name='Arial';
									table.sizing='Relative';
									table.cell.padding.both='0.5';
									table.border.style='none';
								}
								<AREA>
									<CTRL_GROUP>
										<CTRLS>
											<PANEL>
												FMT={
													content.outputStyle='table';
													ctrl.size.width='571.5';
													ctrl.size.height='59.3';
													tcell.bkgr.color='#EEEEFF';
													text.style='cs3';
													text.hlink.fmt='style';
													text.hlink.style='cs5';
													text.hlink.style.use='override';
													text.option.nbsps='true';
													txtfl.delimiter.type='none';
													table.cell.spacing.both='2';
													table.cell.padding.both='0';
													table.border.style='none';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<PANEL>
																COND='findHyperTarget ("overview") != null'
																FMT={
																	ctrl.size.width='79.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Overview'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='85.5';
																	ctrl.size.height='38.3';
																	tcell.bkgr.color='#00008B';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT='Package'
																				FMT={
																					text.style='cs4';
																					text.font.style.bold='true';
																					text.color.foreground='#FFFFFF';
																				}
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='64.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Class'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.use")'
																FMT={
																	ctrl.size.width='56.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Use'
																				<DOC_HLINK>
																					HKEYS={
																						'contextElement.id';
																						'"use"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.tree")'
																FMT={
																	ctrl.size.width='59.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Tree'
																				<DOC_HLINK>
																					HKEYS={
																						'contextElement.id';
																						'"package-tree"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='findHyperTarget ("deprecated-list") != null'
																FMT={
																	ctrl.size.width='84';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Deprecated'
																				<DOC_HLINK>
																					HKEYS={
																						'"deprecated-list"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.index")'
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Index'
																				<DOC_HLINK>
																					HKEYS={
																						'"index"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.help")'
																FMT={
																	ctrl.size.width='61.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Help'
																				<DOC_HLINK>
																					HKEYS={
																						'"help-doc"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										FMT={
											text.style='cs6';
											text.hlink.fmt='style';
											text.hlink.style='cs7';
											text.hlink.style.use='modify';
										}
										<CTRLS>
											<PANEL>
												FMT={
													ctrl.size.width='268.5';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='PREV PACKAGE'
																<DOC_HLINK>
																	HKEYS={
																		'mainContext.iterator.prevItem.toElement().id';
																		'"detail"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='   ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NEXT PACKAGE'
																<DOC_HLINK>
																	HKEYS={
																		'mainContext.iterator.nextItem.toElement().id';
																		'"detail"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
											<PANEL>
												FMT={
													ctrl.size.width='303';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='makeRelativePath (mainContext.output.file, output.dir).toURL()
+ \'?\' +
makeRelativePath (output.file, mainContext.output.dir).toURL()'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NO FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='output.fileName'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getBooleanParam("gen.refs.allClasses")'
																TEXT='All Classes'
																<DOC_HLINK>
																	HKEYS={
																		'"all-classes-summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
								</AREA>
							</PANEL>
							<DATA_CTRL>
								COND='getStringParam("$text").length() > 0'
								FORMULA='getParam("$text")'
								FMT={
									ctrl.size.width='61.5';
									ctrl.size.height='128.3';
									tcell.align.horz='Right';
									text.font.style.italic='true';
									txtfl.ehtml.render='true';
								}
							</DATA_CTRL>
						</CTRLS>
					</CTRL_GROUP>
				</AREA>
			</AREA_SEC>
			<AREA_SEC>
				DESCR='Tree'
				COND='hasParamValue("$type", "tree")'
				MATCHING_ETS={'PackageDoc';'RootDoc'}
				BREAK_PARENT_BLOCK='when-executed'
				COLLAPSED
				FMT={
					sec.outputStyle='table';
					table.sizing='Relative';
					table.cell.padding.both='0';
					table.border.style='none';
				}
				<AREA>
					<CTRL_GROUP>
						FMT={
							trow.cell.align.vert='Top';
						}
						<CTRLS>
							<PANEL>
								FMT={
									content.outputStyle='table';
									ctrl.size.width='592.5';
									ctrl.size.height='128.3';
									text.font.name='Arial';
									table.sizing='Relative';
									table.cell.padding.both='0.5';
									table.border.style='none';
								}
								<AREA>
									<CTRL_GROUP>
										<CTRLS>
											<PANEL>
												FMT={
													content.outputStyle='table';
													ctrl.size.width='571.5';
													ctrl.size.height='59.3';
													tcell.bkgr.color='#EEEEFF';
													text.style='cs3';
													text.hlink.fmt='style';
													text.hlink.style='cs5';
													text.hlink.style.use='override';
													text.option.nbsps='true';
													txtfl.delimiter.type='none';
													table.cell.spacing.both='2';
													table.cell.padding.both='0';
													table.border.style='none';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<PANEL>
																COND='findHyperTarget ("overview") != null'
																FMT={
																	ctrl.size.width='79.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Overview'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='75';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Package'
																				<DOC_HLINK>
																					HKEYS={
																						'contextElement.id';
																						'"detail"';
																					}
																				</DOC_HLINK>
																				<DOC_HLINK>
																					HKEYS={
																						'"single-package"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='64.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Class'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.use")'
																FMT={
																	ctrl.size.width='56.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Use'
																				<DOC_HLINK>
																					HKEYS={
																						'contextElement.id';
																						'"use"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='69.8';
																	ctrl.size.height='38.3';
																	tcell.bkgr.color='#00008B';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT='Tree'
																				FMT={
																					text.style='cs4';
																					text.font.style.bold='true';
																					text.color.foreground='#FFFFFF';
																				}
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='findHyperTarget ("deprecated-list") != null'
																FMT={
																	ctrl.size.width='84';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Deprecated'
																				<DOC_HLINK>
																					HKEYS={
																						'"deprecated-list"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.index")'
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Index'
																				<DOC_HLINK>
																					HKEYS={
																						'"index"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.help")'
																FMT={
																	ctrl.size.width='61.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Help'
																				<DOC_HLINK>
																					HKEYS={
																						'"help-doc"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										FMT={
											text.style='cs6';
											text.hlink.fmt='style';
											text.hlink.style='cs7';
											text.hlink.style.use='modify';
										}
										<CTRLS>
											<PANEL>
												FMT={
													ctrl.size.width='268.5';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='PREV'
																<DOC_HLINK>
																	HKEYS={
																		'mainContext.iterator.prevItem.toElement().id';
																		'"package-tree"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='   ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NEXT'
																<DOC_HLINK>
																	HKEYS={
																		'mainContext.iterator.nextItem.toElement().id';
																		'"package-tree"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
											<PANEL>
												FMT={
													ctrl.size.width='303';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='makeRelativePath (mainContext.output.file, output.dir).toURL()
+ \'?\' +
makeRelativePath (output.file, mainContext.output.dir).toURL()'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NO FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='output.fileName'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getBooleanParam("gen.refs.allClasses")'
																TEXT='All Classes'
																<DOC_HLINK>
																	HKEYS={
																		'"all-classes-summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
								</AREA>
							</PANEL>
							<DATA_CTRL>
								COND='getStringParam("$text").length() > 0'
								FORMULA='getParam("$text")'
								FMT={
									ctrl.size.width='61.5';
									ctrl.size.height='128.3';
									tcell.align.horz='Right';
									text.font.style.italic='true';
									txtfl.ehtml.render='true';
								}
							</DATA_CTRL>
						</CTRLS>
					</CTRL_GROUP>
				</AREA>
			</AREA_SEC>
			<AREA_SEC>
				DESCR='Index'
				COND='hasParamValue("$type", "index")'
				MATCHING_ETS={'#CUSTOM';'RootDoc'}
				BREAK_PARENT_BLOCK='when-executed'
				COLLAPSED
				FMT={
					sec.outputStyle='table';
					table.sizing='Relative';
					table.cell.padding.both='0';
					table.border.style='none';
				}
				<AREA>
					<CTRL_GROUP>
						<CTRLS>
							<PANEL>
								FMT={
									content.outputStyle='table';
									ctrl.size.width='592.5';
									ctrl.size.height='155.3';
									text.font.name='Arial';
									table.sizing='Relative';
									table.cell.padding.both='0.5';
									table.border.style='none';
								}
								<AREA>
									<CTRL_GROUP>
										<CTRLS>
											<PANEL>
												FMT={
													content.outputStyle='table';
													ctrl.size.width='571.5';
													ctrl.size.height='59.3';
													tcell.bkgr.color='#EEEEFF';
													text.style='cs3';
													text.hlink.fmt='style';
													text.hlink.style='cs5';
													text.hlink.style.use='override';
													text.option.nbsps='true';
													txtfl.delimiter.type='none';
													table.cell.spacing.both='2';
													table.cell.padding.both='0';
													table.border.style='none';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<PANEL>
																COND='findHyperTarget ("overview") != null'
																FMT={
																	ctrl.size.width='78.8';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Overview'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='74.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Package'
																				<DOC_HLINK>
																					HKEYS={
																						'"single-package"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Class'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.use")'
																FMT={
																	ctrl.size.width='56.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Use'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.tree")'
																FMT={
																	ctrl.size.width='59.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Tree'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview-tree"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='findHyperTarget ("deprecated-list") != null'
																FMT={
																	ctrl.size.width='84';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Deprecated'
																				<DOC_HLINK>
																					HKEYS={
																						'"deprecated-list"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='75.8';
																	ctrl.size.height='38.3';
																	tcell.bkgr.color='#00008B';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT='Index'
																				FMT={
																					text.style='cs4';
																					text.font.style.bold='true';
																					text.color.foreground='#FFFFFF';
																				}
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.help")'
																FMT={
																	ctrl.size.width='62.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Help'
																				<DOC_HLINK>
																					HKEYS={
																						'"help-doc"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										FMT={
											text.style='cs6';
											text.hlink.fmt='style';
											text.hlink.style='cs7';
											text.hlink.style.use='modify';
										}
										<CTRLS>
											<PANEL>
												FMT={
													ctrl.size.width='267.8';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='PREV LETTER'
																<DOC_HLINK>
																	HKEYS={
																		'mainContext.iterator.prevItem.toElement().value';
																		'"index"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='   ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NEXT LETTER'
																<DOC_HLINK>
																	HKEYS={
																		'mainContext.iterator.nextItem.toElement().value';
																		'"index"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
											<PANEL>
												FMT={
													ctrl.size.width='303.8';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='makeRelativePath (mainContext.output.file, output.dir).toURL()
+ \'?\' +
makeRelativePath (output.file, mainContext.output.dir).toURL()'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NO FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='output.fileName'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getBooleanParam("gen.refs.allClasses")'
																TEXT='All Classes'
																<DOC_HLINK>
																	HKEYS={
																		'"all-classes-summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										<CTRLS>
											<SS_CALL_CTRL>
												SS_NAME='Letter Bar'
												FMT={
													ctrl.size.width='571.5';
													ctrl.size.height='17.3';
													text.style='cs3';
												}
											</SS_CALL_CTRL>
										</CTRLS>
									</CTRL_GROUP>
								</AREA>
							</PANEL>
							<DATA_CTRL>
								COND='getStringParam("$text").length() > 0'
								FORMULA='getParam("$text")'
								FMT={
									ctrl.size.width='61.5';
									ctrl.size.height='155.3';
									tcell.align.horz='Right';
									tcell.align.vert='Top';
									text.font.style.italic='true';
									txtfl.ehtml.render='true';
								}
							</DATA_CTRL>
						</CTRLS>
					</CTRL_GROUP>
				</AREA>
			</AREA_SEC>
			<AREA_SEC>
				DESCR='Overview'
				COND='hasParamValue("$type", "overview")'
				MATCHING_ET='RootDoc'
				BREAK_PARENT_BLOCK='when-executed'
				COLLAPSED
				FMT={
					sec.outputStyle='table';
					table.sizing='Relative';
					table.cell.padding.both='0';
					table.border.style='none';
				}
				<AREA>
					<CTRL_GROUP>
						FMT={
							trow.cell.align.vert='Top';
						}
						<CTRLS>
							<PANEL>
								FMT={
									content.outputStyle='table';
									ctrl.size.width='592.5';
									ctrl.size.height='128.3';
									text.font.name='Arial';
									table.sizing='Relative';
									table.cell.padding.both='0.5';
									table.border.style='none';
								}
								<AREA>
									<CTRL_GROUP>
										<CTRLS>
											<PANEL>
												FMT={
													content.outputStyle='table';
													ctrl.size.width='571.5';
													ctrl.size.height='59.3';
													tcell.bkgr.color='#EEEEFF';
													text.style='cs3';
													text.hlink.fmt='style';
													text.hlink.style='cs5';
													text.hlink.style.use='override';
													text.option.nbsps='true';
													txtfl.delimiter.type='none';
													table.cell.spacing.both='2';
													table.cell.padding.both='0';
													table.border.style='none';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<PANEL>
																FMT={
																	ctrl.size.width='93.8';
																	ctrl.size.height='38.3';
																	tcell.bkgr.color='#00008B';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT='Overview'
																				FMT={
																					text.style='cs4';
																					text.font.style.bold='true';
																					text.color.foreground='#FFFFFF';
																				}
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='74.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Package'
																				<DOC_HLINK>
																					HKEYS={
																						'"single-package"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='61.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Class'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.use")'
																FMT={
																	ctrl.size.width='56.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Use'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.tree")'
																FMT={
																	ctrl.size.width='59.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Tree'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview-tree"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='findHyperTarget ("deprecated-list") != null'
																FMT={
																	ctrl.size.width='84';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Deprecated'
																				<DOC_HLINK>
																					HKEYS={
																						'"deprecated-list"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.index")'
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Index'
																				<DOC_HLINK>
																					HKEYS={
																						'"index"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.help")'
																FMT={
																	ctrl.size.width='61.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Help'
																				<DOC_HLINK>
																					HKEYS={
																						'"help-doc"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										FMT={
											text.style='cs6';
											text.hlink.fmt='style';
											text.hlink.style='cs7';
											text.hlink.style.use='modify';
										}
										<CTRLS>
											<PANEL>
												FMT={
													ctrl.size.width='268.5';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='PREV'
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='   ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NEXT'
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
											<PANEL>
												FMT={
													ctrl.size.width='303';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='makeRelativePath (mainContext.output.file, output.dir).toURL()
+ \'?\' +
makeRelativePath (output.file, mainContext.output.dir).toURL()'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NO FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='output.fileName'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getBooleanParam("gen.refs.allClasses")'
																TEXT='All Classes'
																<DOC_HLINK>
																	HKEYS={
																		'"all-classes-summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
								</AREA>
							</PANEL>
							<DATA_CTRL>
								COND='getStringParam("$text").length() > 0'
								FORMULA='getParam("$text")'
								FMT={
									ctrl.size.width='61.5';
									ctrl.size.height='128.3';
									tcell.align.horz='Right';
									text.font.style.italic='true';
									txtfl.ehtml.render='true';
								}
							</DATA_CTRL>
						</CTRLS>
					</CTRL_GROUP>
				</AREA>
			</AREA_SEC>
			<AREA_SEC>
				DESCR='Deprecated'
				COND='hasParamValue("$type", "deprecated")'
				MATCHING_ET='RootDoc'
				BREAK_PARENT_BLOCK='when-executed'
				COLLAPSED
				FMT={
					sec.outputStyle='table';
					table.sizing='Relative';
					table.cell.padding.both='0';
					table.border.style='none';
				}
				<AREA>
					<CTRL_GROUP>
						FMT={
							trow.cell.align.vert='Top';
						}
						<CTRLS>
							<PANEL>
								FMT={
									content.outputStyle='table';
									ctrl.size.width='592.5';
									ctrl.size.height='128.3';
									text.font.name='Arial';
									table.sizing='Relative';
									table.cell.padding.both='0.5';
									table.border.style='none';
								}
								<AREA>
									<CTRL_GROUP>
										<CTRLS>
											<PANEL>
												FMT={
													content.outputStyle='table';
													ctrl.size.width='571.5';
													ctrl.size.height='59.3';
													tcell.bkgr.color='#EEEEFF';
													text.style='cs3';
													text.hlink.fmt='style';
													text.hlink.style='cs5';
													text.hlink.style.use='override';
													text.option.nbsps='true';
													txtfl.delimiter.type='none';
													table.cell.spacing.both='2';
													table.cell.padding.both='0';
													table.border.style='none';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<PANEL>
																COND='findHyperTarget ("overview") != null'
																FMT={
																	ctrl.size.width='79.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Overview'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='75';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Package'
																				<DOC_HLINK>
																					HKEYS={
																						'contextElement.id';
																						'"detail"';
																					}
																				</DOC_HLINK>
																				<DOC_HLINK>
																					HKEYS={
																						'"single-package"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='64.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Class'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.use")'
																FMT={
																	ctrl.size.width='56.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Use'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.tree")'
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Tree'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview-tree"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='95.3';
																	ctrl.size.height='38.3';
																	tcell.bkgr.color='#00008B';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT='Deprecated'
																				FMT={
																					text.style='cs4';
																					text.font.style.bold='true';
																					text.color.foreground='#FFFFFF';
																				}
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.index")'
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Index'
																				<DOC_HLINK>
																					HKEYS={
																						'"index"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.help")'
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Help'
																				<DOC_HLINK>
																					HKEYS={
																						'"help-doc"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										FMT={
											text.style='cs6';
											text.hlink.fmt='style';
											text.hlink.style='cs7';
											text.hlink.style.use='modify';
										}
										<CTRLS>
											<PANEL>
												FMT={
													ctrl.size.width='268.5';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='PREV'
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='   ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NEXT'
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
											<PANEL>
												FMT={
													ctrl.size.width='303';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='makeRelativePath (mainContext.output.file, output.dir).toURL()
+ \'?\' +
makeRelativePath (output.file, mainContext.output.dir).toURL()'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NO FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='output.fileName'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getBooleanParam("gen.refs.allClasses")'
																TEXT='All Classes'
																<DOC_HLINK>
																	HKEYS={
																		'"all-classes-summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
								</AREA>
							</PANEL>
							<DATA_CTRL>
								COND='getStringParam("$text").length() > 0'
								FORMULA='getParam("$text")'
								FMT={
									ctrl.size.width='61.5';
									ctrl.size.height='128.3';
									tcell.align.horz='Right';
									text.font.style.italic='true';
									txtfl.ehtml.render='true';
								}
							</DATA_CTRL>
						</CTRLS>
					</CTRL_GROUP>
				</AREA>
			</AREA_SEC>
			<AREA_SEC>
				DESCR='Help'
				COND='hasParamValue("$type", "help")'
				MATCHING_ET='RootDoc'
				BREAK_PARENT_BLOCK='when-executed'
				COLLAPSED
				FMT={
					sec.outputStyle='table';
					table.sizing='Relative';
					table.cell.padding.both='0';
					table.border.style='none';
				}
				<AREA>
					<CTRL_GROUP>
						FMT={
							trow.cell.align.vert='Top';
						}
						<CTRLS>
							<PANEL>
								FMT={
									content.outputStyle='table';
									ctrl.size.width='592.5';
									ctrl.size.height='128.3';
									text.font.name='Arial';
									table.sizing='Relative';
									table.cell.padding.both='0.5';
									table.border.style='none';
								}
								<AREA>
									<CTRL_GROUP>
										<CTRLS>
											<PANEL>
												FMT={
													content.outputStyle='table';
													ctrl.size.width='571.5';
													ctrl.size.height='59.3';
													tcell.bkgr.color='#EEEEFF';
													text.style='cs3';
													text.hlink.fmt='style';
													text.hlink.style='cs5';
													text.hlink.style.use='override';
													text.option.nbsps='true';
													txtfl.delimiter.type='none';
													table.cell.spacing.both='2';
													table.cell.padding.both='0';
													table.border.style='none';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<PANEL>
																COND='findHyperTarget ("overview") != null'
																FMT={
																	ctrl.size.width='79.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Overview'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='75';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Package'
																				<DOC_HLINK>
																					HKEYS={
																						'contextElement.id';
																						'"detail"';
																					}
																				</DOC_HLINK>
																				<DOC_HLINK>
																					HKEYS={
																						'"single-package"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='64.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Class'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.use")'
																FMT={
																	ctrl.size.width='56.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Use'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.tree")'
																FMT={
																	ctrl.size.width='61.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Tree'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview-tree"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='findHyperTarget ("deprecated-list") != null'
																FMT={
																	ctrl.size.width='84';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Deprecated'
																				<DOC_HLINK>
																					HKEYS={
																						'"deprecated-list"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.index")'
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Index'
																				<DOC_HLINK>
																					HKEYS={
																						'"index"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='69.8';
																	ctrl.size.height='38.3';
																	tcell.bkgr.color='#00008B';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT='Help'
																				FMT={
																					text.style='cs4';
																					text.font.style.bold='true';
																					text.color.foreground='#FFFFFF';
																				}
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										FMT={
											text.style='cs6';
											text.hlink.fmt='style';
											text.hlink.style='cs7';
											text.hlink.style.use='modify';
										}
										<CTRLS>
											<PANEL>
												FMT={
													ctrl.size.width='268.5';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='PREV'
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='   ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NEXT'
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
											<PANEL>
												FMT={
													ctrl.size.width='303';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='makeRelativePath (mainContext.output.file, output.dir).toURL()
+ \'?\' +
makeRelativePath (output.file, mainContext.output.dir).toURL()'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NO FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='output.fileName'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getBooleanParam("gen.refs.allClasses")'
																TEXT='All Classes'
																<DOC_HLINK>
																	HKEYS={
																		'"all-classes-summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
								</AREA>
							</PANEL>
							<DATA_CTRL>
								COND='getStringParam("$text").length() > 0'
								FORMULA='getParam("$text")'
								FMT={
									ctrl.size.width='61.5';
									ctrl.size.height='128.3';
									tcell.align.horz='Right';
									text.font.style.italic='true';
									txtfl.ehtml.render='true';
								}
							</DATA_CTRL>
						</CTRLS>
					</CTRL_GROUP>
				</AREA>
			</AREA_SEC>
			<AREA_SEC>
				DESCR='(default)'
				COLLAPSED
				FMT={
					sec.outputStyle='table';
					table.sizing='Relative';
					table.cell.padding.both='0';
					table.border.style='none';
				}
				<AREA>
					<CTRL_GROUP>
						FMT={
							trow.cell.align.vert='Top';
						}
						<CTRLS>
							<PANEL>
								FMT={
									content.outputStyle='table';
									ctrl.size.width='592.5';
									ctrl.size.height='128.3';
									text.font.name='Arial';
									table.sizing='Relative';
									table.cell.padding.both='0.5';
									table.border.style='none';
								}
								<AREA>
									<CTRL_GROUP>
										<CTRLS>
											<PANEL>
												FMT={
													content.outputStyle='table';
													ctrl.size.width='571.5';
													ctrl.size.height='59.3';
													tcell.bkgr.color='#EEEEFF';
													text.style='cs3';
													text.hlink.fmt='style';
													text.hlink.style='cs5';
													text.hlink.style.use='override';
													text.option.nbsps='true';
													txtfl.delimiter.type='none';
													table.cell.spacing.both='2';
													table.cell.padding.both='0';
													table.border.style='none';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<PANEL>
																COND='findHyperTarget ("overview") != null'
																FMT={
																	ctrl.size.width='81.8';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Overview'
																				FMT={
																					text.style='cs3';
																				}
																				<DOC_HLINK>
																					HKEYS={
																						'"overview"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='78';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Package'
																				<DOC_HLINK>
																					HKEYS={
																						'"single-package"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																FMT={
																	ctrl.size.width='69.8';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Class'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.use")'
																FMT={
																	ctrl.size.width='56.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Use'
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.tree")'
																FMT={
																	ctrl.size.width='59.3';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Tree'
																				<DOC_HLINK>
																					HKEYS={
																						'"overview-tree"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='findHyperTarget ("deprecated-list") != null'
																FMT={
																	ctrl.size.width='84';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Deprecated'
																				<DOC_HLINK>
																					HKEYS={
																						'"deprecated-list"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.refs.index")'
																FMT={
																	ctrl.size.width='60';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Index'
																				<DOC_HLINK>
																					HKEYS={
																						'"index"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
															<PANEL>
																COND='getBooleanParam("gen.help")'
																FMT={
																	ctrl.size.width='61.5';
																	ctrl.size.height='38.3';
																}
																<AREA>
																	<CTRL_GROUP>
																		<CTRLS>
																			<TEXT_CTRL>
																				TEXT='Help'
																				<DOC_HLINK>
																					HKEYS={
																						'"help-doc"';
																					}
																				</DOC_HLINK>
																			</TEXT_CTRL>
																			<TEXT_CTRL>
																				TEXT=' '
																			</TEXT_CTRL>
																		</CTRLS>
																	</CTRL_GROUP>
																</AREA>
															</PANEL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
									<CTRL_GROUP>
										FMT={
											text.style='cs6';
											text.hlink.fmt='style';
											text.hlink.style='cs7';
											text.hlink.style.use='modify';
										}
										<CTRLS>
											<PANEL>
												FMT={
													ctrl.size.width='268.5';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='PREV'
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='   ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NEXT'
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
											<PANEL>
												FMT={
													ctrl.size.width='303';
													ctrl.size.height='38.3';
												}
												<AREA>
													<CTRL_GROUP>
														<CTRLS>
															<TEXT_CTRL>
																TEXT='FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='makeRelativePath (mainContext.output.file, output.dir).toURL()
+ \'?\' +
makeRelativePath (output.file, mainContext.output.dir).toURL()'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																TEXT='NO FRAMES'
																<URL_HLINK>
																	TARGET_FRAME_EXPR='"_top"'
																	URL_EXPR='output.fileName'
																</URL_HLINK>
															</TEXT_CTRL>
															<DELIMITER>
																FMT={
																	txtfl.delimiter.type='nbtxt';
																	txtfl.delimiter.text='    ';
																}
															</DELIMITER>
															<TEXT_CTRL>
																COND='getBooleanParam("gen.refs.allClasses")'
																TEXT='All Classes'
																<DOC_HLINK>
																	COND='findHyperTarget (
  Array ("all-classes-summary")
).file != output.file'
																	HKEYS={
																		'"all-classes-summary"';
																	}
																</DOC_HLINK>
															</TEXT_CTRL>
														</CTRLS>
													</CTRL_GROUP>
												</AREA>
											</PANEL>
										</CTRLS>
									</CTRL_GROUP>
								</AREA>
							</PANEL>
							<DATA_CTRL>
								COND='getStringParam("$text").length() > 0'
								FORMULA='getParam("$text")'
								FMT={
									ctrl.size.width='61.5';
									ctrl.size.height='128.3';
									tcell.align.horz='Right';
									text.font.style.italic='true';
									txtfl.ehtml.render='true';
								}
							</DATA_CTRL>
						</CTRLS>
					</CTRL_GROUP>
				</AREA>
			</AREA_SEC>
		</BODY>
	</FOLDER>
	<AREA_SEC>
		COND='hasParamValue("$location", "header")'
		<AREA>
			<HR>
			</HR>
		</AREA>
	</AREA_SEC>
</ROOT>
<STOCK_SECTIONS>
	<ELEMENT_ITER>
		SS_NAME='Letter Bar'
		TARGET_ET='#CUSTOM'
		SCOPE='custom'
		ELEMENT_ENUM_EXPR='CustomElements (getElementMapKeys ("index"))'
		SORTING='by-expr'
		SORTING_KEY={expr='/* this sorting key places \'_\' at the end of the list */

letter = contextElement.value.toString();
letter != "_" ? "!" + letter : letter',ascending}
		FMT={
			sec.outputStyle='list';
			list.type='delimited';
			list.item.delimiter.type='space';
			list.item.delimiter.text='';
		}
		<BODY>
			<AREA_SEC>
				<AREA>
					<CTRL_GROUP>
						<CTRLS>
							<DATA_CTRL>
								ELEMENT_VALUE
								<DOC_HLINK>
									HKEYS={
										'"index"';
										'contextElement.value';
									}
								</DOC_HLINK>
							</DATA_CTRL>
						</CTRLS>
					</CTRL_GROUP>
				</AREA>
			</AREA_SEC>
		</BODY>
	</ELEMENT_ITER>
</STOCK_SECTIONS>
CHECKSUM='5OVB5sMFoG1uLnsZ?tmAEfaXOhevVxUPW4ovB4A1GqI'
</DOCFLEX_TEMPLATE>