/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class ECrawler
implements ActionListener {
    static int filesDownloaded;
    JFrame mainFrame;
    private static DefaultListModel listModel;
    private static JList list;
    private JButton submitButton;
    private JButton stopButton;
    private JButton browseButton;
    private JTextField urlField;
    private JComboBox extensionComboBox;
    private CrawlTask task;
    private static JLabel statusLabel;
    private static JLabel crawlLabel;
    private JTextField folderField;
    CrawlIcon crawlIcon;

    public ECrawler() {
        filesDownloaded = 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ECrawler.this.drawGUI();
                ECrawler.this.task = new CrawlTask(listModel, ECrawler.this.urlField.getText(), (String)ECrawler.this.extensionComboBox.getSelectedItem());
                ECrawler.this.task.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if ("progress".equals(e.getPropertyName())) {
                            listModel.addElement(e.getNewValue());
                        }
                    }
                });
                ECrawler.this.crawlIcon = new CrawlIcon();
                ECrawler.this.crawlIcon.start();
            }
        });
    }

    private static String parseURL(String s) {
        return s.replace('/', '-').replace(':', '-');
    }

    public static void setStatus(String status) {
        statusLabel.setText(status);
    }

    private static int downloadFile(String url, String dir) {
        block6: {
            int oneChar;
            URL file = new URL(url);
            String filename = String.valueOf(dir) + ECrawler.parseURL(url);
            File fileCheck = new File(filename);
            if (fileCheck.exists()) break block6;
            InputStream is = file.openStream();
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            BufferedInputStream bis = new BufferedInputStream(is);
            int count = 0;
            while ((oneChar = bis.read()) != -1) {
                bos.write(oneChar);
                ++count;
            }
            bis.close();
            is.close();
            bos.close();
            fos.close();
            ECrawler.setStatus(String.valueOf(count) + " byte(s) copied.");
            ++filesDownloaded;
            return 0;
        }
        try {
            ECrawler.setStatus("File already exists.");
            return 2;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            ECrawler.setStatus("Malformed URL Exception.");
            return -1;
        }
        catch (FileNotFoundException e) {
            ECrawler.setStatus("File not found.");
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            ECrawler.setStatus("IO Exception.");
            return -1;
        }
    }

    public void drawGUI() {
        this.mainFrame = new JFrame("ECrawler");
        this.mainFrame.setMinimumSize(new Dimension(800, 600));
        this.mainFrame.setDefaultCloseOperation(3);
        Container contentPane = this.mainFrame.getContentPane();
        String[] extensionStrings = new String[]{".html", ".php", ".pdf", ".jpg", ".png", ".gif", ".wmv", ".avi", ".swf", "/"};
        this.extensionComboBox = new JComboBox<String>(extensionStrings);
        this.extensionComboBox.setSelectedIndex(0);
        this.extensionComboBox.setEditable(true);
        this.extensionComboBox.addActionListener(this);
        this.extensionComboBox.setPreferredSize(new Dimension(80, 26));
        this.extensionComboBox.setMaximumRowCount(25);
        JLabel titleLabel = new JLabel("ECrawler");
        JLabel websiteLabel = new JLabel("Elliot Walmsley");
        titleLabel.setAlignmentX(0.5f);
        JLabel urlLabel = new JLabel("URL: ");
        urlLabel.setPreferredSize(new Dimension(45, 20));
        JLabel folderLabel = new JLabel("Folder: ");
        folderLabel.setPreferredSize(new Dimension(45, 20));
        statusLabel = new JLabel(" ");
        statusLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        crawlLabel = new JLabel("_");
        this.urlField = new JTextField(50);
        this.urlField.setText("http://en.wikipedia.org/wiki/Main_Page");
        this.folderField = new JTextField(50);
        File folder = new File("files");
        this.folderField.setText(folder.getAbsolutePath());
        this.submitButton = new JButton("Crawl");
        this.submitButton.addActionListener(this);
        this.submitButton.setMaximumSize(new Dimension(Short.MAX_VALUE, 26));
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(this);
        this.stopButton.setMaximumSize(new Dimension(Short.MAX_VALUE, 26));
        this.browseButton = new JButton("Browse");
        this.browseButton.addActionListener(this);
        this.browseButton.setPreferredSize(new Dimension(80, 26));
        listModel = new DefaultListModel();
        list = new JList(listModel);
        list.setBackground(new Color(0, 0, 0));
        list.setForeground(Color.YELLOW);
        list.setFont(new Font("Courier New", 0, 12));
        JScrollPane scrollPane = new JScrollPane(list);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 3));
        rightPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new BoxLayout(scrollPanel, 3));
        scrollPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 3));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel urlPanel = new JPanel();
        urlPanel.setLayout(new BoxLayout(urlPanel, 2));
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 2));
        JPanel folderPanel = new JPanel();
        folderPanel.setLayout(new BoxLayout(folderPanel, 2));
        JPanel topSplitPanel = new JPanel(new BorderLayout());
        topSplitPanel.add((Component)topPanel, "Center");
        topSplitPanel.add((Component)rightPanel, "East");
        topPanel.add(titleLabel);
        topPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        topPanel.add(urlPanel);
        topPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        topPanel.add(folderPanel);
        urlPanel.add(urlLabel);
        urlPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        urlPanel.add(this.urlField);
        urlPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        urlPanel.add(this.extensionComboBox);
        rightPanel.add(crawlLabel);
        rightPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        rightPanel.add(this.submitButton);
        rightPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        rightPanel.add(this.stopButton);
        mainPanel.add((Component)centerPanel, "Center");
        centerPanel.add((Component)topSplitPanel, "North");
        centerPanel.add(scrollPanel);
        centerPanel.add((Component)statusPanel, "South");
        statusPanel.add(statusLabel);
        statusPanel.add(Box.createHorizontalGlue());
        statusPanel.add(websiteLabel);
        statusPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        scrollPanel.add(scrollPane);
        folderPanel.add(folderLabel);
        folderPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        folderPanel.add(this.folderField);
        folderPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        folderPanel.add(this.browseButton);
        this.mainFrame.add(mainPanel);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    public static void addToList(String s) {
        listModel.addElement(s);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int lastIndex = list.getModel().getSize() - 1;
                if (lastIndex >= 0) {
                    list.ensureIndexIsVisible(lastIndex);
                }
            }
        });
    }

    public static void main(String[] args) {
        ECrawler c = new ECrawler();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.submitButton) {
            this.task = new CrawlTask(listModel, this.urlField.getText(), (String)this.extensionComboBox.getSelectedItem());
            this.task.execute();
            this.crawlIcon.setCrawling(true);
            this.submitButton.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.urlField.setEnabled(false);
            this.folderField.setEnabled(false);
            this.extensionComboBox.setEnabled(false);
        } else if (e.getSource() == this.stopButton) {
            this.task.cancel(true);
            this.crawlIcon.setCrawling(false);
            this.browseButton.setEnabled(true);
            this.urlField.setEnabled(true);
            this.folderField.setEnabled(true);
            this.extensionComboBox.setEnabled(true);
        } else if (e.getSource() == this.browseButton) {
            JFileChooser fc = new JFileChooser(this.folderField.getText());
            fc.setFileSelectionMode(1);
            int returnVal = fc.showDialog(this.mainFrame, "Set Download Folder");
            File check = null;
            if (returnVal == 0) {
                check = fc.getSelectedFile();
                this.folderField.setText(check.getAbsolutePath());
            }
        }
    }

    public class CrawlIcon
    extends Thread {
        boolean crawling = false;

        public CrawlIcon() {
            crawlLabel.setText("_");
        }

        public void exit() {
            this.crawling = false;
        }

        public void setCrawling(boolean crawling) {
            this.crawling = crawling;
        }

        @Override
        public void run() {
            char[] crawlingAnimation = new char[7];
            int stage = 0;
            crawlingAnimation[0] = 124;
            crawlingAnimation[1] = 47;
            crawlingAnimation[2] = 47;
            crawlingAnimation[3] = 45;
            crawlingAnimation[4] = 45;
            crawlingAnimation[5] = 92;
            crawlingAnimation[6] = 92;
            while (true) {
                if (!this.crawling) {
                    continue;
                }
                stage = stage < crawlingAnimation.length - 1 ? ++stage : 0;
                char[] singleChar = new char[]{crawlingAnimation[stage]};
                crawlLabel.setText(String.valueOf(ECrawler.this.task.getWebsitesLeft()) + " " + new String(singleChar));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class CrawlTask
    extends SwingWorker<Integer, String> {
        String websiteURL;
        String fileExtension;
        private URL url;
        private String fullPath;
        private String hostUrl;
        Queue<String> webpages;
        private ArrayList<String> crawled;
        private int newWebpages;
        private String dir;

        CrawlTask(DefaultListModel listModel, String websiteURL, String fileExtension) {
            this.websiteURL = websiteURL;
            this.fileExtension = fileExtension;
            this.webpages = new LinkedList<String>();
            this.crawled = new ArrayList();
        }

        @Override
        protected void done() {
            crawlLabel.setText("_");
            ECrawler.this.submitButton.setEnabled(true);
            ECrawler.this.crawlIcon.setCrawling(false);
            ECrawler.this.browseButton.setEnabled(true);
            ECrawler.this.urlField.setEnabled(true);
            ECrawler.this.folderField.setEnabled(true);
            ECrawler.this.extensionComboBox.setEnabled(true);
        }

        public int getWebsitesLeft() {
            return this.webpages.size();
        }

        private void searchForURLs(String matchedUrl) {
            if (matchedUrl.length() > 2 && matchedUrl.substring(0, 2).equals("..")) {
                return;
            }
            if (!matchedUrl.contains(this.url.getHost()) && !matchedUrl.contains("://")) {
                String newWebpage;
                if (matchedUrl.charAt(0) == '/') {
                    matchedUrl = matchedUrl.substring(1);
                }
                if ((newWebpage = this.fullPath).charAt(newWebpage.length() - 1) != '/') {
                    newWebpage = String.valueOf(newWebpage) + "/";
                }
                matchedUrl = newWebpage = String.valueOf(newWebpage) + matchedUrl;
            }
            if (matchedUrl.contains(this.hostUrl)) {
                if (!this.crawled.contains(matchedUrl) && !this.webpages.contains(matchedUrl)) {
                    int pageLen = matchedUrl.length();
                    int extensionLen = this.fileExtension.length();
                    ECrawler.setStatus("Crawling: " + matchedUrl);
                    this.webpages.add(matchedUrl);
                    if (pageLen > extensionLen && matchedUrl.substring(pageLen - extensionLen, pageLen).equals(this.fileExtension)) {
                        ECrawler.setStatus("Found file: " + matchedUrl);
                        int status = ECrawler.downloadFile(matchedUrl, this.dir);
                        if (status == 0) {
                            ECrawler.addToList("  " + matchedUrl);
                        } else if (status != 2) {
                            ECrawler.addToList("X " + matchedUrl);
                        }
                    } else {
                        ECrawler.setStatus("Found new URL: " + matchedUrl);
                        ++this.newWebpages;
                    }
                }
            } else if (matchedUrl.substring(matchedUrl.length() - this.fileExtension.length(), matchedUrl.length()).equals(this.fileExtension)) {
                ECrawler.setStatus("Found file: " + matchedUrl);
                int status = ECrawler.downloadFile(matchedUrl, this.dir);
                if (status == 0) {
                    ECrawler.addToList("  " + matchedUrl);
                } else if (status != 2) {
                    ECrawler.addToList("X " + matchedUrl);
                }
            }
        }

        @Override
        protected Integer doInBackground() throws Exception {
            filesDownloaded = 0;
            listModel.clear();
            this.webpages.add(this.websiteURL);
            String date = ECrawler.parseURL(new Date().toString());
            this.dir = String.valueOf(ECrawler.this.folderField.getText()) + "/" + date + "/";
            File dirCheck = new File(this.dir);
            if (!dirCheck.exists()) {
                dirCheck.mkdirs();
            }
            Pattern linkPattern = Pattern.compile("href=\"+[a-zA-Z0-9-_\\./:]+\"");
            Pattern imagePattern = Pattern.compile("src=\"+[a-zA-Z0-9-_\\./:]+\"");
            while (!this.webpages.isEmpty() && !this.isCancelled()) {
                this.newWebpages = 0;
                try {
                    String line;
                    this.url = new URL(this.webpages.poll());
                    this.fullPath = String.valueOf(this.url.getProtocol()) + "://" + this.url.getHost() + this.url.getPath();
                    int i = this.fullPath.length() - 1;
                    boolean found = false;
                    while (i > 0 && !found) {
                        if (this.fullPath.charAt(i) == '/') {
                            found = true;
                        }
                        if (found) continue;
                        --i;
                    }
                    this.fullPath = this.fullPath.substring(0, i + 1);
                    String fullUrl = String.valueOf(this.url.getProtocol()) + "://" + this.url.getHost() + this.url.getFile();
                    this.hostUrl = this.url.getHost();
                    this.crawled.add(fullUrl);
                    ECrawler.setStatus("Searching in: " + fullUrl);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.url.openStream()));
                    while ((line = reader.readLine()) != null && !this.isCancelled()) {
                        String matchedUrl;
                        Matcher matcher = linkPattern.matcher(line);
                        while (matcher.find()) {
                            matchedUrl = matcher.group().substring(6, matcher.group().length() - 1);
                            this.searchForURLs(matchedUrl);
                        }
                        matcher = imagePattern.matcher(line);
                        while (matcher.find()) {
                            matchedUrl = matcher.group().substring(5, matcher.group().length() - 1);
                            this.searchForURLs(matchedUrl);
                        }
                    }
                    reader.close();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    ECrawler.setStatus("Malformed URL Exception.");
                }
                catch (FileNotFoundException e) {
                    ECrawler.setStatus("File not Found.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ECrawler.setStatus("Found " + this.newWebpages + " new webpages. " + this.webpages.size() + " webpages to crawl left.");
            }
            ECrawler.setStatus("Files downloaded: " + filesDownloaded);
            return null;
        }
    }
}

