/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeNUMBER
extends OracleType
implements Serializable {
    static final long serialVersionUID = -7182242886677299812L;
    int precision;
    int scale;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:36:02_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected OracleTypeNUMBER() {
    }

    protected OracleTypeNUMBER(int n2) {
        super(n2);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection, l2, n2);
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.precision = tDSReader.readUnsignedByte();
        this.scale = tDSReader.readByte();
    }

    protected static Object unpickle81NativeArray(PickleContext pickleContext, long l2, int n2, int n3) throws SQLException {
        int n4 = 1;
        while ((long)n4 < l2 && n2 > 0) {
            pickleContext.skipDataValue();
            ++n4;
        }
        byte[] byArray = null;
        switch (n3) {
            case 4: {
                int[] nArray = new int[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    byArray = pickleContext.readDataValue();
                    if (byArray == null) continue;
                    nArray[i2] = NUMBER.toInt(byArray);
                }
                return nArray;
            }
            case 5: {
                double[] dArray = new double[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    byArray = pickleContext.readDataValue();
                    if (byArray == null) continue;
                    dArray[i3] = NUMBER.toDouble(byArray);
                }
                return dArray;
            }
            case 7: {
                long[] lArray = new long[n2];
                for (int i4 = 0; i4 < n2; ++i4) {
                    byArray = pickleContext.readDataValue();
                    if (byArray == null) continue;
                    lArray[i4] = NUMBER.toLong(byArray);
                }
                return lArray;
            }
            case 6: {
                float[] fArray = new float[n2];
                for (int i5 = 0; i5 < n2; ++i5) {
                    byArray = pickleContext.readDataValue();
                    if (byArray == null) continue;
                    fArray[i5] = NUMBER.toFloat(byArray);
                }
                return fArray;
            }
            case 8: {
                short[] sArray = new short[n2];
                for (int i6 = 0; i6 < n2; ++i6) {
                    byArray = pickleContext.readDataValue();
                    if (byArray == null) continue;
                    sArray[i6] = NUMBER.toShort(byArray);
                }
                return sArray;
            }
        }
        DatabaseError.throwSqlException(null, 23);
        return null;
    }

    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(byArray, n2, map);
    }

    static Object toNumericObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new NUMBER(byArray);
            }
            case 2: {
                return NUMBER.toBigDecimal(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        DatabaseError.throwSqlException(null, 23);
        return null;
    }

    public static NUMBER toNUMBER(Object object, OracleConnection oracleConnection) throws SQLException {
        NUMBER nUMBER = null;
        if (object != null) {
            try {
                nUMBER = object instanceof NUMBER ? (NUMBER)object : new NUMBER(object);
            }
            catch (SQLException sQLException) {
                DatabaseError.throwSqlException(null, 59, object);
            }
        }
        return nUMBER;
    }

    public static Datum[] toNUMBERArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[] && !(object instanceof char[][])) {
                Object[] objectArray = (Object[])object;
                int n3 = (int)(n2 == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    datumArray[i2] = OracleTypeNUMBER.toNUMBER(objectArray[(int)l2 + i2 - 1], oracleConnection);
                }
            } else {
                datumArray = OracleTypeNUMBER.cArrayToNUMBERArray(object, oracleConnection, l2, n2);
            }
        }
        return datumArray;
    }

    static Datum[] cArrayToNUMBERArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                int n3 = (int)(n2 == -1 ? (long)sArray.length : Math.min((long)sArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    datumArray[i2] = new NUMBER(sArray[(int)l2 + i2 - 1]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                int n4 = (int)(n2 == -1 ? (long)nArray.length : Math.min((long)nArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n4];
                for (int i3 = 0; i3 < n4; ++i3) {
                    datumArray[i3] = new NUMBER(nArray[(int)l2 + i3 - 1]);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                int n5 = (int)(n2 == -1 ? (long)lArray.length : Math.min((long)lArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n5];
                for (int i4 = 0; i4 < n5; ++i4) {
                    datumArray[i4] = new NUMBER(lArray[(int)l2 + i4 - 1]);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                int n6 = (int)(n2 == -1 ? (long)fArray.length : Math.min((long)fArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n6];
                for (int i5 = 0; i5 < n6; ++i5) {
                    datumArray[i5] = new NUMBER(fArray[(int)l2 + i5 - 1]);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                int n7 = (int)(n2 == -1 ? (long)dArray.length : Math.min((long)dArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n7];
                for (int i6 = 0; i6 < n7; ++i6) {
                    datumArray[i6] = new NUMBER(dArray[(int)l2 + i6 - 1]);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                int n8 = (int)(n2 == -1 ? (long)blArray.length : Math.min((long)blArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n8];
                for (int i7 = 0; i7 < n8; ++i7) {
                    datumArray[i7] = new NUMBER(new Boolean(blArray[(int)l2 + i7 - 1]));
                }
            } else if (object instanceof char[][]) {
                char[][] cArray = (char[][])object;
                int n9 = (int)(n2 == -1 ? (long)cArray.length : Math.min((long)cArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n9];
                for (int i8 = 0; i8 < n9; ++i8) {
                    datumArray[i8] = new NUMBER(new String(cArray[(int)l2 + i8 - 1]));
                }
            } else {
                DatabaseError.throwSqlException(null, 59, object);
            }
        }
        return datumArray;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.scale);
        objectOutputStream.writeInt(this.precision);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.scale = objectInputStream.readInt();
        this.precision = objectInputStream.readInt();
    }
}

