/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.app.DB2Binary2AsciiInputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.sql.SQLException;

public class DB2Binary2UnicodeInputStream
extends DB2Binary2AsciiInputStream {
    private byte[] cvtBuffer;
    private int cvtBufPos = 0;
    private int cvtAvailable = 0;

    public DB2Binary2UnicodeInputStream(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        super(dB2Statement, n, n2);
        if (this.maxFieldSize != 0 && this.docLength > this.maxFieldSize / 4) {
            this.docLength = this.maxFieldSize / 4;
        }
    }

    public int available() throws IOException {
        return super.available() * 2;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        super.mark(n / 2);
    }

    public void reset() throws IOException {
        super.reset();
    }

    private byte[] getData(int n) throws IOException {
        if (n == 0) {
            return null;
        }
        if (this.cvtAvailable == 0 && !super.hasMore()) {
            return null;
        }
        if (this.cvtAvailable >= n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray, 0, n);
            this.cvtAvailable -= n;
            this.cvtBufPos += n;
            return byArray;
        }
        if (!super.hasMore()) {
            byte[] byArray = new byte[this.cvtAvailable];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray, 0, this.cvtAvailable);
            this.cvtAvailable = 0;
            return byArray;
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.cvtAvailable != 0) {
            byArray = new byte[this.cvtAvailable];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray, 0, this.cvtAvailable);
            byArray2 = new byte[(n - this.cvtAvailable) / 2];
        } else {
            byArray2 = new byte[n / 2];
        }
        int n2 = super.read(byArray2);
        if (n2 > 0) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            this.cvtBuffer = new byte[n2 * 2];
            int n3 = 0;
            while (n3 < n2) {
                this.cvtBuffer[n3 * 2] = 0;
                this.cvtBuffer[n3 * 2 + 1] = byArray3[n3];
                ++n3;
            }
            this.cvtAvailable = this.cvtBuffer.length;
            this.cvtBufPos = 0;
            int n4 = this.cvtAvailable;
            if (byArray != null) {
                byte[] byArray4 = new byte[byArray.length + n4];
                System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
                System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray4, byArray.length, n4);
                this.cvtBufPos += n4;
                this.cvtAvailable -= n4;
                return byArray4;
            }
            byte[] byArray5 = new byte[n4];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, byArray5, 0, n4);
            this.cvtBufPos += n4;
            this.cvtAvailable -= n4;
            return byArray5;
        }
        return byArray;
    }

    public int read() throws IOException {
        byte[] byArray = this.getData(1);
        if (byArray == null) {
            return -1;
        }
        if (byArray[0] < 0) {
            return byArray[0] + 256;
        }
        return byArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        byte[] byArray2 = this.getData(byArray.length);
        if (byArray2 == null) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        return byArray2.length;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.getData(n2);
        if (byArray2 == null) {
            return -1;
        }
        System.arraycopy(byArray, 0, byArray2, n, byArray2.length);
        return byArray2.length;
    }
}

