/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class DB2CallableStatement
extends DB2PreparedStatement
implements CallableStatement {
    private boolean wasNull = true;
    private int year;
    private int month;
    private int date;
    private int hour;
    private int minute;
    private int second;
    private int nano;

    protected native int SQLBindOutParameter(int var1, int var2, int var3, int var4, int var5, long var6, long[] var8, int var9, boolean var10);

    protected native String SQLGetChar(int var1, long var2);

    protected native String SQLGetNumericString(int var1, long var2);

    protected native byte[] SQLGetBinary(long var1);

    protected native int SQLGetShort(long var1);

    protected native int SQLGetInt(long var1);

    protected native long SQLGetLong(long var1);

    protected native float SQLGetFloat(long var1);

    protected native double SQLGetDouble(long var1);

    protected native void SQLGetDate(long var1);

    protected native void SQLGetTime(long var1);

    protected native void SQLGetTimestamp(long var1);

    protected native int SQLisNull(long var1);

    public String toString() {
        return this.toString("", true);
    }

    public String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2CallableStatement \r\n" + string + "{");
        stringBuffer.append(super.toString(String.valueOf(string) + "    ", bl));
        stringBuffer.append("\r\n" + string + "    wasNull = " + this.wasNull + "\r\n");
        return stringBuffer.toString();
    }

    protected int SQLisNull2(int n) {
        return this.SQLisNull(this.parameters[n - 1]);
    }

    public DB2CallableStatement(String string, DB2Connection dB2Connection, int n, int n2) throws SQLException {
        super(string, dB2Connection, n, n2);
    }

    public DB2CallableStatement(String string, DB2Connection dB2Connection) throws SQLException {
        super(string, dB2Connection);
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        int n4 = n - 1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "registerOutParameter( " + n + ", " + n2 + ", " + n3 + "  )");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            n2 = this.convert2SQLType(n2);
            if (this.direction[n4] == 0) {
                this.direction[n4] = 4;
                this.sqltypes[n4] = n2;
                this.ctypes[n4] = this.sqlType2cType(n2);
                this.scales[n4] = n3;
            } else if (this.direction[n4] == 1) {
                this.direction[n4] = 2;
                this.sqltypes[n4] = n2;
                if (n3 > this.scales[n4]) {
                    this.scales[n4] = n3;
                }
            }
            this.executed = false;
        }
        catch (Throwable throwable) {
            block11: {
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) break block11;
                DB2Trace.methodExit(this, "registerOutParameter() ");
            }
            throw throwable;
        }
        Object var6_5 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "registerOutParameter() ");
        }
    }

    protected void checkParameters() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "checkParameters() ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            int n = 0;
            int n2 = 0;
            while (n2 < this.maxNumParams) {
                if (this.direction[n2] == 4) {
                    int n3 = this.sqltypes[n2];
                    int n4 = this.scales[n2];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "direction[" + n2 + "]", this.direction[n2]);
                        DB2Trace.data(10, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
                        DB2Trace.data(10, "scales[" + n2 + "]", this.scales[n2]);
                    }
                    switch (n3) {
                        case -7: 
                        case -6: {
                            n3 = 5;
                            break;
                        }
                        case -5: {
                            n3 = -5;
                            break;
                        }
                        case 7: {
                            n3 = this.connection.getRealSqlType();
                            break;
                        }
                        case 2: 
                        case 3: {
                            n = this.connection.getDecMaxLength(2, 4);
                            break;
                        }
                    }
                    int n5 = this.SQLBindOutParameter(this.direction[n2], n2 + 1, n3, n, n4, this.parameters[n2], this.parameters, this.statementHandle, this.connection.isDescribeParamSupported());
                    if (n5 != this.sqlSuccess) {
                        this.sqlExcptGen.check_return_code(this, n5);
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            block14: {
                Object var2_7 = null;
                if (!DB2Trace.TraceOn) break block14;
                DB2Trace.methodExit(this, "checkParameters() ");
            }
            throw throwable;
        }
        Object var2_6 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "checkParameters() ");
        }
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(int n) throws SQLException {
        String string;
        String string2;
        block18: {
            String string3;
            block17: {
                string2 = null;
                try {
                    block22: {
                        block20: {
                            int n2;
                            block21: {
                                block19: {
                                    if (DB2Trace.TraceOn) {
                                        DB2Trace.methodEntry(this, "getString( " + n + " ) ");
                                        DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                                    }
                                    int n3 = this.validateParameter(n);
                                    n2 = this.sqltypes[n3];
                                    switch (n2) {
                                        case -95: 
                                        case -8: {
                                            n2 = 1;
                                            break;
                                        }
                                        case -96: 
                                        case -9: {
                                            n2 = 12;
                                            break;
                                        }
                                        case -97: 
                                        case -10: {
                                            n2 = -1;
                                            break;
                                        }
                                        case -350: {
                                            n2 = -99;
                                            break;
                                        }
                                    }
                                    if (n2 != 1 && n2 != 12 && n2 != -1 && n2 != -99) {
                                        this.sqlExcptGen.throwTypeError();
                                    }
                                    DB2Connection dB2Connection = this.connection;
                                    synchronized (dB2Connection) {
                                        string2 = this.SQLGetChar(this.connection.connectionHandle, this.parameters[n - 1]);
                                    }
                                    if (this.SQLisNull2(n) != 0) break block19;
                                    this.wasNull = false;
                                    if (n2 == 1) break block20;
                                    break block21;
                                }
                                this.wasNull = true;
                                string3 = null;
                                Object var5_8 = null;
                                if (!DB2Trace.TraceOn) return string3;
                                break block17;
                            }
                            if (n2 != 12 && n2 != -1) break block22;
                        }
                        if (this.maxFieldSize != 0 && string2.length() > this.maxFieldSize) {
                            string2 = string2.substring(0, this.maxFieldSize);
                        }
                    }
                    string = string2;
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "retStr", string2);
                    DB2Trace.methodExit(this, "getString()");
                    throw throwable;
                }
            }
            DB2Trace.data(10, "retStr", string2);
            DB2Trace.methodExit(this, "getString()");
            return string3;
        }
        Object var5_9 = null;
        if (!DB2Trace.TraceOn) return string;
        DB2Trace.data(10, "retStr", string2);
        DB2Trace.methodExit(this, "getString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(int n) throws SQLException {
        boolean bl;
        int n2 = -1;
        boolean bl2 = true;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBoolean( " + n + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            this.validateParameter(n, 5);
            n2 = this.SQLGetShort(this.parameters[n - 1]);
            bl2 = true;
            if (n2 == 0) {
                bl2 = false;
            }
            this.wasNull = this.SQLisNull2(n) != 0;
            bl = bl2;
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "retval ", n2);
            DB2Trace.data(10, "retBool ", String.valueOf(bl2));
            DB2Trace.methodExit(this, "getBoolean() ");
            throw throwable;
        }
        DB2Trace.data(10, "retval ", n2);
        DB2Trace.data(10, "retBool ", String.valueOf(bl2));
        DB2Trace.methodExit(this, "getBoolean() ");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte getByte(int n) throws SQLException {
        byte by;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getByte( " + n + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            this.validateParameter(n, 5);
            byte by2 = (byte)this.SQLGetShort(this.parameters[n - 1]);
            this.wasNull = this.SQLisNull2(n) != 0;
            by = by2;
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) return by;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getByte() ");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getByte() ");
        return by;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short getShort(int n) throws SQLException {
        short s;
        short s2 = -1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getShort( " + n + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            this.validateParameter(n, 5);
            s2 = (short)this.SQLGetShort(this.parameters[n - 1]);
            this.wasNull = this.SQLisNull2(n) != 0;
            s = s2;
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return s;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "retShort ", s2);
            DB2Trace.methodExit(this, "getShort() ");
            throw throwable;
        }
        DB2Trace.data(10, "retShort ", s2);
        DB2Trace.methodExit(this, "getShort() ");
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInt(int n) throws SQLException {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getInt( " + n + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            this.validateParameter(n, 4);
            n3 = this.SQLGetInt(this.parameters[n - 1]);
            this.wasNull = this.SQLisNull2(n) != 0;
            n2 = n3;
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "retInt ", n3);
            DB2Trace.methodExit(this, "getInt() ");
            throw throwable;
        }
        DB2Trace.data(10, "retInt ", n3);
        DB2Trace.methodExit(this, "getInt() ");
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLong(int n) throws SQLException {
        long l;
        long l2 = -1L;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getLong( " + n + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            this.validateParameter(n, -5);
            l2 = this.SQLGetLong(this.parameters[n - 1]);
            this.wasNull = this.SQLisNull2(n) != 0;
            l = l2;
            Object var7_4 = null;
            if (!DB2Trace.TraceOn) return l;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "retLong ", l2);
            DB2Trace.methodExit(this, "getLong() ");
            throw throwable;
        }
        DB2Trace.data(10, "retLong ", l2);
        DB2Trace.methodExit(this, "getLong() ");
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getFloat(int n) throws SQLException {
        float f;
        float f2 = -1.0f;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getFloat( " + n + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            this.validateParameter(n, 7);
            int n2 = this.connection.getRealSqlType();
            if (n2 == 7) {
                f2 = this.SQLGetFloat(this.parameters[n - 1]);
            } else {
                double d = this.SQLGetDouble(this.parameters[n - 1]);
                f2 = (float)d;
            }
            this.wasNull = this.SQLisNull2(n) != 0;
            f = f2;
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) return f;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "retFloat ", String.valueOf(f2));
            DB2Trace.methodExit(this, "getFloat() ");
            throw throwable;
        }
        DB2Trace.data(10, "retFloat ", String.valueOf(f2));
        DB2Trace.methodExit(this, "getFloat() ");
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getDouble(int n) throws SQLException {
        double d;
        double d2 = 0.0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDouble( " + n + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            this.validateParameter(n, 8);
            d2 = this.SQLGetDouble(this.parameters[n - 1]);
            this.wasNull = this.SQLisNull2(n) != 0;
            d = d2;
            Object var7_4 = null;
            if (!DB2Trace.TraceOn) return d;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "retDouble ", String.valueOf(d2));
            DB2Trace.methodExit(this, "getDouble() ");
            throw throwable;
        }
        DB2Trace.data(10, "retDouble ", String.valueOf(d2));
        DB2Trace.methodExit(this, "getDouble() ");
        return d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal;
        String string;
        block8: {
            BigDecimal bigDecimal2;
            block7: {
                BigDecimal bigDecimal3;
                block6: {
                    string = null;
                    try {
                        block10: {
                            block11: {
                                block9: {
                                    if (DB2Trace.TraceOn) {
                                        DB2Trace.methodEntry(this, "getBigDecimal( " + n + " ) ");
                                        DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                                    }
                                    this.validateParameter(n, 2);
                                    DB2Connection dB2Connection = this.connection;
                                    synchronized (dB2Connection) {
                                        string = this.SQLGetNumericString(this.connection.connectionHandle, this.parameters[n - 1]);
                                    }
                                    if (this.SQLisNull2(n) != 0) break block9;
                                    this.wasNull = false;
                                    if (n2 != -1) break block10;
                                    break block11;
                                }
                                this.wasNull = true;
                                bigDecimal3 = null;
                                Object var6_8 = null;
                                if (!DB2Trace.TraceOn) return bigDecimal3;
                                break block6;
                            }
                            bigDecimal2 = new BigDecimal(string);
                            break block7;
                        }
                        bigDecimal = new BigDecimal(string).setScale(n2, 4);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.data(10, "scale ", n2);
                        DB2Trace.data(10, "retval ", string);
                        DB2Trace.methodExit(this, "getBigDecimal() ");
                        throw throwable;
                    }
                }
                DB2Trace.data(10, "scale ", n2);
                DB2Trace.data(10, "retval ", string);
                DB2Trace.methodExit(this, "getBigDecimal() ");
                return bigDecimal3;
            }
            Object var6_9 = null;
            if (!DB2Trace.TraceOn) return bigDecimal2;
            DB2Trace.data(10, "scale ", n2);
            DB2Trace.data(10, "retval ", string);
            DB2Trace.methodExit(this, "getBigDecimal() ");
            return bigDecimal2;
        }
        Object var6_10 = null;
        if (!DB2Trace.TraceOn) return bigDecimal;
        DB2Trace.data(10, "scale ", n2);
        DB2Trace.data(10, "retval ", string);
        DB2Trace.methodExit(this, "getBigDecimal() ");
        return bigDecimal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        block11: {
            byte[] byArray2;
            block10: {
                try {
                    byte[] byArray3;
                    block15: {
                        block13: {
                            int n2;
                            block14: {
                                block12: {
                                    if (DB2Trace.TraceOn) {
                                        DB2Trace.methodEntry(this, "getBytes( " + n + " ) ");
                                        DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                                    }
                                    int n3 = this.validateParameter(n);
                                    n2 = this.sqltypes[n3];
                                    if (DB2Trace.TraceOn) {
                                        DB2Trace.data(10, "type ", n2);
                                    }
                                    if (n2 != -2 && n2 != -3 && n2 != -4 && n2 != -98) {
                                        this.sqlExcptGen.throwTypeError();
                                    }
                                    byArray3 = this.SQLGetBinary(this.parameters[n - 1]);
                                    if (this.SQLisNull2(n) != 0) break block12;
                                    this.wasNull = false;
                                    if (n2 == -2) break block13;
                                    break block14;
                                }
                                this.wasNull = true;
                                byArray2 = null;
                                Object var4_7 = null;
                                if (!DB2Trace.TraceOn) return byArray2;
                                break block10;
                            }
                            if (n2 != -3 && n2 != -4) break block15;
                        }
                        if (this.maxFieldSize != 0 && byArray3.length > this.maxFieldSize) {
                            byte[] byArray4 = byArray3;
                            byArray3 = new byte[this.maxFieldSize];
                            int n4 = 0;
                            while (n4 < this.maxFieldSize) {
                                byArray3[n4] = byArray4[n4];
                                ++n4;
                            }
                        }
                    }
                    byArray = byArray3;
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "getBytes() ");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "getBytes() ");
            return byArray2;
        }
        Object var4_8 = null;
        if (!DB2Trace.TraceOn) return byArray;
        DB2Trace.methodExit(this, "getBytes() ");
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate2(n, Calendar.getInstance());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Date getDate2(int n, Calendar calendar) throws SQLException {
        Date date;
        Date date2 = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDate2(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            this.validateParameter(n, 91);
            this.SQLGetDate(this.parameters[n - 1]);
            if (this.year == -1 && this.month == -1 && this.date == -1) {
                this.wasNull = true;
                Date date3 = null;
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) return date3;
                DB2Trace.methodExit((Object)this, "getDate2()", date2 == null ? "NULL" : date2.toString());
                return date3;
            }
            this.wasNull = false;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Year", this.year);
                DB2Trace.data(10, "Month", this.month);
                DB2Trace.data(10, "Date", this.date);
            }
            calendar = (Calendar)calendar.clone();
            calendar.set(this.year, this.month - 1, this.date, 0, 0, 0);
            calendar.set(14, 0);
            date2 = new Date(calendar.getTime().getTime());
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "Date ", date2.toString());
            }
            date = date2;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getDate2()", date2 == null ? "NULL" : date2.toString());
            throw throwable;
        }
        Object var6_7 = null;
        if (!DB2Trace.TraceOn) return date;
        DB2Trace.methodExit((Object)this, "getDate2()", date2 == null ? "NULL" : date2.toString());
        return date;
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime2(n, Calendar.getInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Time getTime2(int n, Calendar calendar) throws SQLException {
        Time time;
        block7: {
            Time time2;
            block6: {
                Time time3 = null;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getTime2(" + n + " calTimeZone=" + calendar.getTimeZone().getID() + ")");
                        DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                    }
                    this.validateParameter(n, 92);
                    this.SQLGetTime(this.parameters[n - 1]);
                    if (this.hour == -1 && this.minute == -1 && this.second == -1) {
                        this.wasNull = true;
                        time2 = null;
                        Object var6_6 = null;
                        if (!DB2Trace.TraceOn) return time2;
                        break block6;
                    }
                    this.wasNull = false;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Hour ", this.hour);
                        DB2Trace.data(10, "Minute ", this.minute);
                        DB2Trace.data(10, "Second ", this.second);
                    }
                    calendar = (Calendar)calendar.clone();
                    calendar.set(1970, 0, 1, this.hour, this.minute, this.second);
                    calendar.set(14, 0);
                    time3 = new Time(calendar.getTime().getTime());
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "retTime", time3.toString());
                    }
                    time = time3;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "getTime2() ");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "getTime2() ");
            return time2;
        }
        Object var6_7 = null;
        if (!DB2Trace.TraceOn) return time;
        DB2Trace.methodExit(this, "getTime2() ");
        return time;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp2(n, Calendar.getInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Timestamp getTimestamp2(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        block7: {
            Timestamp timestamp2;
            block6: {
                Timestamp timestamp3 = null;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getTimestamp2(" + n + " calTimeZone=" + calendar.getTimeZone().getID() + ")");
                        DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                    }
                    this.validateParameter(n, 93);
                    this.SQLGetTimestamp(this.parameters[n - 1]);
                    if (this.year == -1 && this.month == -1 && this.date == -1) {
                        this.wasNull = true;
                        timestamp2 = null;
                        Object var6_6 = null;
                        if (!DB2Trace.TraceOn) return timestamp2;
                        break block6;
                    }
                    this.wasNull = false;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Year", this.year);
                        DB2Trace.data(10, "Month", this.month);
                        DB2Trace.data(10, "Date", this.date);
                        DB2Trace.data(10, "Hour", this.hour);
                        DB2Trace.data(10, "Minute", this.minute);
                        DB2Trace.data(10, "Second", this.second);
                        DB2Trace.data(10, "Nano", this.nano);
                    }
                    calendar = (Calendar)calendar.clone();
                    calendar.set(this.year, this.month - 1, this.date, this.hour, this.minute, this.second);
                    calendar.set(14, 0);
                    timestamp3 = new Timestamp(calendar.getTime().getTime());
                    timestamp3.setNanos(this.nano);
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "retTimestamp", timestamp3.toString());
                    }
                    timestamp = timestamp3;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "getTimestamp2() ");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "getTimestamp2() ");
            return timestamp2;
        }
        Object var6_7 = null;
        if (!DB2Trace.TraceOn) return timestamp;
        DB2Trace.methodExit(this, "getTimestamp2() ");
        return timestamp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(int n) throws SQLException {
        Object object;
        block25: {
            Object var2_5;
            block24: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getObject( " + n + " ) ");
                        DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                    }
                    this.validateParameter(n);
                    Object object2 = null;
                    int n2 = this.sqltypes[n - 1];
                    int n3 = this.scales[n - 1];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "sqlType ", n2);
                        DB2Trace.data(20, "scale ", n3);
                    }
                    switch (n2) {
                        case -350: 
                        case -97: 
                        case -96: 
                        case -95: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -1: 
                        case 1: 
                        case 12: {
                            object2 = this.getString(n);
                            break;
                        }
                        case 2: {
                            object2 = this.getBigDecimal(n, n3);
                            break;
                        }
                        case 3: {
                            object2 = this.getBigDecimal(n, n3);
                            break;
                        }
                        case -2: {
                            object2 = this.getBytes(n);
                            break;
                        }
                        case -3: {
                            object2 = this.getBytes(n);
                            break;
                        }
                        case -4: {
                            object2 = this.getBytes(n);
                            break;
                        }
                        case 5: {
                            object2 = new Integer(this.getShort(n));
                            break;
                        }
                        case 4: {
                            object2 = new Integer(this.getInt(n));
                            break;
                        }
                        case 6: {
                            object2 = new Double(this.getDouble(n));
                            break;
                        }
                        case 7: {
                            object2 = new Float(this.getFloat(n));
                            break;
                        }
                        case 8: {
                            object2 = new Double(this.getDouble(n));
                            break;
                        }
                        case 91: {
                            object2 = this.getDate(n);
                            break;
                        }
                        case 92: {
                            object2 = this.getTime(n);
                            break;
                        }
                        case 93: {
                            object2 = this.getTimestamp(n);
                            break;
                        }
                        case -7: {
                            object2 = new Boolean(this.getBoolean(n));
                            break;
                        }
                        case -6: {
                            object2 = new Integer(this.getByte(n));
                            break;
                        }
                        case -5: {
                            object2 = new Long(this.getLong(n));
                            break;
                        }
                        default: {
                            this.sqlExcptGen.rsException("S1004");
                        }
                    }
                    if (this.wasNull) {
                        var2_5 = null;
                        Object var4_7 = null;
                        if (!DB2Trace.TraceOn) return var2_5;
                        break block24;
                    }
                    object = object2;
                    break block25;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "getObject()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "getObject()");
            return var2_5;
        }
        Object var4_8 = null;
        if (!DB2Trace.TraceOn) return object;
        DB2Trace.methodExit(this, "getObject()");
        return object;
    }

    private int validateParameter(int n) throws SQLException {
        return this.validateParameter(n, 0, false);
    }

    private int validateParameter(int n, int n2) throws SQLException {
        return this.validateParameter(n, n2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int validateParameter(int n, int n2, boolean bl) throws SQLException {
        int n3;
        int n4 = -1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "validateParameter( " + n + ", " + bl + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (!this.executed) {
                this.sqlExcptGen.throwNotExecutedError();
            }
            if (this.direction[n4 = n - 1] != 4 && this.direction[n4] != 2) {
                this.sqlExcptGen.throwNotOutputParameterError();
            }
            if (bl && this.sqltypes[n4] != n2) {
                this.sqlExcptGen.throwTypeError();
            }
            n3 = n4;
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) return n3;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "return value- index ", n4);
            DB2Trace.methodExit(this, "validateParameter()");
            throw throwable;
        }
        DB2Trace.data(10, "return value- index ", n4);
        DB2Trace.methodExit(this, "validateParameter()");
        return n3;
    }
}

