/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CallableStatement;
import COM.ibm.db2.jdbc.app.DB2DatabaseMetaData;
import COM.ibm.db2.jdbc.app.DB2DatabaseMetaDataTrace;
import COM.ibm.db2.jdbc.app.DB2Driver;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2Statement;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;

public class DB2Connection
implements Connection {
    protected int connectionHandle;
    protected boolean SPConnected;
    protected String source;
    protected String user;
    protected String password;
    protected String conArgs;
    protected boolean closed;
    protected boolean describeCached;
    protected boolean describeParam;
    protected int realSqlType;
    protected int blobSqlType;
    protected int returnCode;
    protected int hostType;
    private int typeMaxChar;
    private int typeMaxVarChar;
    private int typeMaxLongVarChar;
    private int typeMaxDecimal;
    private Boolean supportsLOB;
    private DB2Statement inputStreamStmt;
    int JDBCLevel;
    protected ResourceBundle errMsgClass;
    protected SQLExceptionGenerator sqlExcptGen;
    private int sqlSuccess;
    private boolean isLDCompat;
    protected boolean isReadOnly;
    protected boolean autoClose;
    private boolean disconnected;
    SQLWarning warnings;

    protected native int SQLConnect(String var1, int var2, int var3);

    protected native int SPConnect(int var1, int var2);

    protected native int SQLDisconnect(int var1);

    protected native int SQLFreeConnect(int var1);

    protected native int SQLSetConnectOptionInt(int var1, int var2, int var3);

    protected native int SQLSetConnectOptionString(int var1, String var2, int var3);

    protected native int SQLGetConnectOption(int var1, int var2);

    protected native int SQLGetDescribeParamSupported(int var1);

    protected native int SQLCommit(int var1, int var2);

    protected native int SQLRollback(int var1, int var2);

    protected native int SQLHasType(int var1, int var2);

    protected native String SQLNativeSQL(String var1, int var2);

    protected native boolean isConnectionAlive(int var1);

    protected native int SQLSetCodePage(int var1);

    protected native int SQLGetTypeMaxLen(int var1, int var2);

    protected native int SQLGetHostType(int var1);

    public String toString() {
        return this.toString("");
    }

    protected String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("\n" + string + "DB2Connection\n" + string + "{\n");
        stringBuffer.append(String.valueOf(string) + "    connectionHandle = " + this.connectionHandle + "\n");
        stringBuffer.append(String.valueOf(string) + "    SPConnected = " + this.SPConnected + "\n");
        stringBuffer.append(String.valueOf(string) + "    source = " + this.source + "\n");
        stringBuffer.append(String.valueOf(string) + "    user = " + this.user + "\n");
        stringBuffer.append(String.valueOf(string) + "    conArgs = " + this.conArgs + "\n");
        stringBuffer.append(String.valueOf(string) + "    closed = " + this.closed + "\n");
        stringBuffer.append(String.valueOf(string) + "    describeCached = " + this.describeCached + "\n");
        stringBuffer.append(String.valueOf(string) + "    describeParam = " + this.describeParam + "\n");
        stringBuffer.append(String.valueOf(string) + "    isReadOnly = " + this.isReadOnly + "\n");
        stringBuffer.append(String.valueOf(string) + "    autoClose = " + this.autoClose + "\n");
        stringBuffer.append(String.valueOf(string) + "    LONGDATA compat = " + this.isLDCompat + "\n");
        stringBuffer.append(String.valueOf(string) + "}\n");
        return stringBuffer.toString();
    }

    protected void loadDefaultMessage() {
        this.errMsgClass = ResourceBundle.getBundle("COM.ibm.db2.mri.DB2ErrorMessages");
    }

    public String getSource() {
        return this.source;
    }

    public DB2Connection() {
        this.user = "";
        this.password = "";
        this.conArgs = "";
        this.closed = true;
        this.describeCached = false;
        this.describeParam = true;
        this.realSqlType = -1;
        this.blobSqlType = 0;
        this.hostType = 0;
        this.typeMaxChar = -1;
        this.typeMaxVarChar = -1;
        this.typeMaxLongVarChar = -1;
        this.typeMaxDecimal = -1;
        this.JDBCLevel = 122;
        this.sqlSuccess = 0;
        this.isLDCompat = false;
        this.isReadOnly = false;
        this.autoClose = false;
        this.disconnected = true;
    }

    public DB2Connection(Properties properties, DB2Driver dB2Driver) throws SQLException {
        block10: {
            this.user = "";
            this.password = "";
            this.conArgs = "";
            this.closed = true;
            this.describeCached = false;
            this.describeParam = true;
            this.realSqlType = -1;
            this.blobSqlType = 0;
            this.hostType = 0;
            this.typeMaxChar = -1;
            this.typeMaxVarChar = -1;
            this.typeMaxLongVarChar = -1;
            this.typeMaxDecimal = -1;
            this.JDBCLevel = 122;
            this.sqlSuccess = 0;
            this.isLDCompat = false;
            this.isReadOnly = false;
            this.autoClose = false;
            this.disconnected = true;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "DB2Connection( info, " + dB2Driver + " )");
                }
                this.loadDefaultMessage();
                this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
                this.warnings = null;
                this.returnCode = this.sqlSuccess;
                this.connectionHandle = this.SPConnect(this.connectionHandle, DB2Driver.getJVMHenv());
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "connectionHandle", this.connectionHandle);
                }
                if (this.returnCode != this.sqlSuccess) {
                    try {
                        this.sqlExcptGen.check_return_code(this, this.returnCode);
                    }
                    catch (SQLException sQLException) {
                        if (this.connectionHandle > 0) {
                            this.SQLFreeConnect(this.connectionHandle);
                        }
                        throw sQLException;
                    }
                }
                this.isReadOnly = false;
                this.realSqlType = -1;
                this.closed = false;
                this.autoClose = false;
                this.SPConnected = true;
                this.disconnected = false;
                try {
                    this.setAutoCommit2(true);
                }
                catch (SQLException sQLException) {
                }
                Object var4_4 = null;
                if (!DB2Trace.TraceOn) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var4_5 = null;
                    if (!DB2Trace.TraceOn) break block11;
                    DB2Trace.methodExit(this, "DB2Connection()");
                }
                throw throwable;
            }
            DB2Trace.methodExit(this, "DB2Connection()");
        }
    }

    public DB2Connection(String string, Properties properties, DB2Driver dB2Driver) throws SQLException {
        this.user = "";
        this.password = "";
        this.conArgs = "";
        this.closed = true;
        this.describeCached = false;
        this.describeParam = true;
        this.realSqlType = -1;
        this.blobSqlType = 0;
        this.hostType = 0;
        this.typeMaxChar = -1;
        this.typeMaxVarChar = -1;
        this.typeMaxLongVarChar = -1;
        this.typeMaxDecimal = -1;
        this.JDBCLevel = 122;
        this.sqlSuccess = 0;
        this.isLDCompat = false;
        this.isReadOnly = false;
        this.autoClose = false;
        this.disconnected = true;
        this.connect(string, properties, dB2Driver, 0, false);
    }

    public DB2Connection(String string, Properties properties, DB2Driver dB2Driver, int n) throws SQLException {
        this.user = "";
        this.password = "";
        this.conArgs = "";
        this.closed = true;
        this.describeCached = false;
        this.describeParam = true;
        this.realSqlType = -1;
        this.blobSqlType = 0;
        this.hostType = 0;
        this.typeMaxChar = -1;
        this.typeMaxVarChar = -1;
        this.typeMaxLongVarChar = -1;
        this.typeMaxDecimal = -1;
        this.JDBCLevel = 122;
        this.sqlSuccess = 0;
        this.isLDCompat = false;
        this.isReadOnly = false;
        this.autoClose = false;
        this.disconnected = true;
        this.connect(string, properties, dB2Driver, n, false);
    }

    public DB2Connection(String string, Properties properties, int n, boolean bl) throws SQLException {
        this.user = "";
        this.password = "";
        this.conArgs = "";
        this.closed = true;
        this.describeCached = false;
        this.describeParam = true;
        this.realSqlType = -1;
        this.blobSqlType = 0;
        this.hostType = 0;
        this.typeMaxChar = -1;
        this.typeMaxVarChar = -1;
        this.typeMaxLongVarChar = -1;
        this.typeMaxDecimal = -1;
        this.JDBCLevel = 122;
        this.sqlSuccess = 0;
        this.isLDCompat = false;
        this.isReadOnly = false;
        this.autoClose = false;
        this.disconnected = true;
        this.connect(string, properties, null, n, bl);
    }

    private void connect(String string, Properties properties, DB2Driver dB2Driver, int n, boolean bl) throws SQLException {
        try {
            Object object;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "connect( " + string + ", info, " + dB2Driver + ", " + n + ", " + bl + " )");
            }
            this.loadDefaultMessage();
            this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
            this.warnings = null;
            this.source = string;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (((String)object).equals("user")) {
                    this.user = properties.getProperty("user", "");
                    continue;
                }
                if (((String)object).equals("password")) {
                    this.password = properties.getProperty("password", "");
                    continue;
                }
                if (((String)object).equalsIgnoreCase("JDBCVERSION")) {
                    String string2 = (String)((Hashtable)properties).get(object);
                    if (string2 == null) continue;
                    this.JDBCLevel = new Integer(string2);
                    if (!DB2Trace.TraceOn) continue;
                    DB2Trace.data(20, "JDBCLevel key", this.JDBCLevel);
                    continue;
                }
                if (((String)object).equals("connectionAttribute")) {
                    this.conArgs = String.valueOf(this.conArgs) + ";" + properties.getProperty((String)object, "");
                    continue;
                }
                if (((String)object).equals("language")) continue;
                this.conArgs = String.valueOf(this.conArgs) + ";" + (String)object + "=" + properties.getProperty((String)object, "");
            }
            this.connectionHandle = n;
            this.returnCode = this.sqlSuccess;
            if (!bl) {
                object = this;
                synchronized (object) {
                    this.connectionHandle = this.SQLConnect("DSN=" + string + ";UID=" + this.user + ";PWD=" + this.password + this.conArgs, this.connectionHandle, DB2Driver.getJVMHenv());
                }
            }
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "conArg", this.conArgs);
                DB2Trace.data(10, "connectionHandle", this.connectionHandle);
            }
            if (this.returnCode != this.sqlSuccess) {
                try {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
                catch (SQLException sQLException) {
                    if (this.connectionHandle > 0) {
                        this.SQLFreeConnect(this.connectionHandle);
                    }
                    throw sQLException;
                }
            }
            this.isReadOnly = false;
            this.closed = false;
            this.autoClose = false;
            this.SPConnected = false;
            this.disconnected = false;
        }
        catch (Throwable throwable) {
            block18: {
                Object var7_11 = null;
                if (!DB2Trace.TraceOn) break block18;
                DB2Trace.methodExit(this, "connect()");
            }
            throw throwable;
        }
        Object var7_10 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "connect()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Statement createStatement() throws SQLException {
        DB2Statement dB2Statement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "createStatement()");
            }
            dB2Statement = new DB2Statement(this);
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2Statement;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "createStatement()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "createStatement()");
        return dB2Statement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Statement createStatement(boolean bl) throws SQLException {
        DB2Statement dB2Statement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "createStatement( " + bl + " )");
            }
            dB2Statement = new DB2Statement(this, bl);
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return dB2Statement;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "createStatement()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "createStatement()");
        return dB2Statement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        DB2PreparedStatement dB2PreparedStatement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "prepareStatement( " + string + " )");
            }
            dB2PreparedStatement = new DB2PreparedStatement(string, this);
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return dB2PreparedStatement;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "prepareStatement()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "prepareStatement()");
        return dB2PreparedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        DB2CallableStatement dB2CallableStatement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "prepareCall( " + string + " )");
            }
            dB2CallableStatement = new DB2CallableStatement(string, this);
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return dB2CallableStatement;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "prepareCall()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "prepareCall()");
        return dB2CallableStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String nativeSQL(String string) throws SQLException {
        String string2;
        String string3 = null;
        this.returnCode = this.sqlSuccess;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "nativeSQL( " + string + " )");
            }
            DB2Connection dB2Connection = this;
            synchronized (dB2Connection) {
                string3 = this.SQLNativeSQL(string, this.connectionHandle);
            }
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            string2 = string3;
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return string2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "nativeSQL()", string3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "nativeSQL()", string3);
        return string2;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.setAutoCommit2(bl);
            return;
        }
    }

    protected void setAutoCommit2(boolean bl) throws SQLException {
        int n;
        block4: {
            n = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setAutoCommit2( " + bl + " )");
                    DB2Trace.data(10, "Connection handle ", this.connectionHandle);
                }
                if ((n = bl ? this.SQLSetConnectOptionInt(102, 1, this.connectionHandle) : this.SQLSetConnectOptionInt(102, 0, this.connectionHandle)) == this.sqlSuccess) break block4;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var4_4 = null;
                    if (!DB2Trace.TraceOn) break block5;
                    DB2Trace.methodExit((Object)this, "setAutoCommit2()", n);
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "setAutoCommit2()", n);
        }
    }

    public void commit() throws SQLException {
        int n;
        block4: {
            n = this.sqlSuccess;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "commit()");
                    DB2Trace.data(10, "Connection handle ", this.connectionHandle);
                }
                if ((n = this.SQLCommit(this.connectionHandle, DB2Driver.getJVMHenv())) == this.sqlSuccess) break block4;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var3_3 = null;
                    if (!DB2Trace.TraceOn) break block5;
                    DB2Trace.methodExit((Object)this, "commit()", n);
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "commit()", n);
        }
    }

    public void rollback() throws SQLException {
        int n;
        block4: {
            n = this.sqlSuccess;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "rollback()");
                    DB2Trace.data(10, "Connection handle ", this.connectionHandle);
                }
                if ((n = this.SQLRollback(this.connectionHandle, DB2Driver.getJVMHenv())) == this.sqlSuccess) break block4;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var3_3 = null;
                    if (!DB2Trace.TraceOn) break block5;
                    DB2Trace.methodExit((Object)this, "rollback()", n);
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "rollback()", n);
        }
    }

    public void close() throws SQLException {
        block4: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "close( Closed=" + this.closed + " )");
                }
                if (this.closed) break block4;
                this.close2();
            }
            catch (Throwable throwable) {
                block5: {
                    Object var2_2 = null;
                    if (!DB2Trace.TraceOn) break block5;
                    DB2Trace.methodExit((Object)this, "close()", String.valueOf(this.closed));
                    DB2Trace.flush();
                }
                throw throwable;
            }
        }
        Object var2_1 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "close()", String.valueOf(this.closed));
            DB2Trace.flush();
        }
    }

    protected synchronized void close2() throws SQLException {
        int n;
        int n2;
        block10: {
            n2 = -99999;
            n = -99999;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "close2( Closed=" + this.closed + " Disconnected=" + this.disconnected + ")");
                    DB2Trace.data(10, "connectionHandle", this.connectionHandle);
                }
                if (!this.disconnected) {
                    if (this.inputStreamStmt != null) {
                        try {
                            this.inputStreamStmt.close();
                        }
                        catch (SQLException sQLException) {}
                        this.inputStreamStmt = null;
                    }
                    if ((n2 = this.SQLDisconnect(this.connectionHandle)) != this.sqlSuccess) {
                        this.sqlExcptGen.check_return_code(this, n2);
                    }
                    this.disconnected = true;
                }
                if (this.connectionHandle <= 0) break block10;
                n = this.SQLFreeConnect(this.connectionHandle);
                if (n != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this, n);
                }
                this.closed = true;
                this.connectionHandle = 0;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var4_4 = null;
                    if (!DB2Trace.TraceOn) break block11;
                    DB2Trace.data(20, "SQLDisconnect()", n2);
                    DB2Trace.data(20, "SQLFreeConnect()", n);
                    DB2Trace.methodExit((Object)this, "close2()", String.valueOf(this.closed));
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(20, "SQLDisconnect()", n2);
            DB2Trace.data(20, "SQLFreeConnect()", n);
            DB2Trace.methodExit((Object)this, "close2()", String.valueOf(this.closed));
        }
    }

    public void finalize() throws SQLException {
        block13: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "finalize()");
                }
                if (!this.closed) {
                    String string = "DB2Connection closed in finalizer" + this.toString();
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, string);
                    }
                    DriverManager.println(string);
                    try {
                        this.close();
                    }
                    finally {
                        Object var5_2 = null;
                        if (!this.closed) {
                            this.rollback();
                            this.close();
                        }
                    }
                }
                Object var2_7 = null;
                if (!DB2Trace.TraceOn) break block13;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var2_8 = null;
                    if (!DB2Trace.TraceOn) break block14;
                    DB2Trace.methodExit(this, "finalize()");
                }
                throw throwable;
            }
            DB2Trace.methodExit(this, "finalize()");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    synchronized void setClosed(boolean bl) {
        this.closed = bl;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        DB2DatabaseMetaData dB2DatabaseMetaData = DB2Trace.TraceOn ? new DB2DatabaseMetaDataTrace(this) : new DB2DatabaseMetaData(this);
        return dB2DatabaseMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (this.isReadOnly != bl) {
            int n = 0;
            DB2Connection dB2Connection = this;
            synchronized (dB2Connection) {
                n = bl ? this.SQLSetConnectOptionInt(101, 1, this.connectionHandle) : this.SQLSetConnectOptionInt(101, 0, this.connectionHandle);
            }
            if (n != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, n);
            }
            this.isReadOnly = !this.isReadOnly;
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setLongDataCompat(boolean bl) throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            int n = bl ? this.SQLSetConnectOptionInt(1253, 1, this.connectionHandle) : this.SQLSetConnectOptionInt(1253, 0, this.connectionHandle);
            if (n != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, n);
            }
            this.isLDCompat = bl;
            return;
        }
    }

    public boolean isLongDataCompat() {
        return this.isLDCompat;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            int n2 = this.SQLSetConnectOptionInt(108, n, this.connectionHandle);
            if (n2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
            return;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.returnCode = this.sqlSuccess;
            int n = this.SQLGetConnectOption(108, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            int n2 = n;
            Object var3_4 = null;
            return n2;
        }
    }

    public void setAutoClose(boolean bl) throws SQLException {
        if (bl) {
            this.sqlExcptGen.connException("S1C00");
        }
    }

    public boolean getAutoClose() {
        return this.autoClose;
    }

    public boolean getAutoCommit() throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.returnCode = this.sqlSuccess;
            int n = this.SQLGetConnectOption(102, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            if (n == 1) {
                boolean bl = true;
                Object var3_5 = null;
                return bl;
            }
            boolean bl = false;
            Object var3_6 = null;
            return bl;
        }
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public synchronized void clearWarnings() {
        this.warnings = null;
    }

    public synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
            return;
        }
        SQLWarning sQLWarning2 = this.warnings;
        while (sQLWarning2.getNextWarning() != null) {
            sQLWarning2 = sQLWarning2.getNextWarning();
        }
        sQLWarning2.setNextWarning(sQLWarning);
    }

    ResourceBundle getErrMsgClass() {
        return this.errMsgClass;
    }

    void setErrMsgClass(ResourceBundle resourceBundle) {
        this.errMsgClass = resourceBundle;
        this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
    }

    protected boolean isDescribeParamSupported() {
        if (this.describeCached) {
            return this.describeParam;
        }
        int n = this.SQLGetDescribeParamSupported(this.connectionHandle);
        this.describeParam = n == this.sqlSuccess;
        this.describeCached = true;
        return this.describeParam;
    }

    public void setConnectOption(int n, String string) throws SQLException {
        int n2;
        if (string == null) {
            string = "";
        }
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            n2 = this.SQLSetConnectOptionString(n, string, this.connectionHandle);
        }
        if (n2 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
    }

    public void setConnectOption(int n, int n2) throws SQLException {
        int n3 = this.SQLSetConnectOptionInt(n, n2, this.connectionHandle);
        if (n3 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this, n3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getConnectOption(int n) throws SQLException {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getConnectOption( " + n + " )");
            }
            this.returnCode = this.sqlSuccess;
            n3 = this.SQLGetConnectOption(n, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            n2 = n3;
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getConnectOption()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getConnectOption()", n3);
        return n2;
    }

    protected int getRealSqlType() throws SQLException {
        if (this.realSqlType == -1) {
            int n = this.SQLHasType(this.connectionHandle, 7);
            this.realSqlType = n == 0 ? 7 : 8;
        }
        return this.realSqlType;
    }

    protected boolean isLOBSupported() throws SQLException {
        if (this.supportsLOB == null) {
            int n = this.SQLHasType(this.connectionHandle, -98);
            this.supportsLOB = n == 0 ? new Boolean(true) : new Boolean(false);
        }
        return this.supportsLOB;
    }

    protected int getBlobSqlType() throws SQLException {
        if (this.blobSqlType == 0) {
            int n = this.SQLHasType(this.connectionHandle, -98);
            this.blobSqlType = n == 0 ? -98 : -4;
        }
        return this.blobSqlType;
    }

    protected int getDecMaxLength(int n, int n2) throws SQLException {
        return this.getTypeMaxLength(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getTypeMaxLength(int n) throws SQLException {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTypeMaxLength( " + n + " )");
            }
            switch (n) {
                case -2: 
                case 1: {
                    n3 = this.typeMaxChar;
                    break;
                }
                case -3: 
                case 12: {
                    n3 = this.typeMaxVarChar;
                    break;
                }
                case -4: 
                case -1: {
                    n3 = this.typeMaxLongVarChar;
                    break;
                }
                case -99: 
                case -98: {
                    n3 = Integer.MAX_VALUE;
                    break;
                }
                case -95: {
                    n3 = this.typeMaxChar;
                    if (n3 == -1) break;
                    n3 /= 2;
                    break;
                }
                case -96: {
                    n3 = this.typeMaxVarChar;
                    if (n3 == -1) break;
                    n3 /= 2;
                    break;
                }
                case -97: {
                    n3 = this.typeMaxLongVarChar;
                    if (n3 == -1) break;
                    n3 /= 2;
                    break;
                }
                case -350: {
                    n3 = 0x3FFFFFFF;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = this.typeMaxDecimal;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Length", n3);
            }
            if (n3 == -1) {
                this.returnCode = this.sqlSuccess;
                n3 = this.SQLGetTypeMaxLen(this.connectionHandle, n);
                if (this.sqlSuccess != this.returnCode) {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
                switch (n) {
                    case -2: 
                    case 1: {
                        this.typeMaxChar = n3;
                        break;
                    }
                    case -3: 
                    case 12: {
                        this.typeMaxVarChar = n3;
                        break;
                    }
                    case -4: 
                    case -1: {
                        this.typeMaxLongVarChar = n3;
                        break;
                    }
                    case -95: {
                        this.typeMaxChar = n3 * 2;
                        break;
                    }
                    case -96: {
                        this.typeMaxVarChar = n3 * 2;
                        break;
                    }
                    case -97: {
                        this.typeMaxLongVarChar = n3 * 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.typeMaxDecimal = n3;
                        break;
                    }
                }
            }
            n2 = n3;
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getTypeMaxLength()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getTypeMaxLength()", n3);
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized DB2Statement getInputStreamStmt() throws SQLException {
        DB2Statement dB2Statement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getInputStreamStmt()");
            }
            if (this.inputStreamStmt == null) {
                this.inputStreamStmt = new DB2Statement(this, true);
            }
            dB2Statement = this.inputStreamStmt;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2Statement;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getInputStreamStmt()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getInputStreamStmt()");
        return dB2Statement;
    }

    public void setCodePage(int n) throws SQLException {
        int n2 = this.SQLSetCodePage(n);
        if (n2 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
    }

    public int getHandle() {
        return this.connectionHandle;
    }

    public int getConnectionHandle() {
        return this.connectionHandle;
    }

    public final boolean is20() {
        return this.JDBCLevel == 200;
    }

    public final int getJDBCLevel() {
        return this.JDBCLevel;
    }

    int adjust(int n) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "adjust( " + n + " )");
        }
        int n2 = n;
        switch (n) {
            case 9: {
                n2 = 91;
                break;
            }
            case 10: {
                n2 = 92;
                break;
            }
            case 11: {
                n2 = 93;
                break;
            }
            case -95: 
            case -8: {
                n2 = 1;
                break;
            }
            case -96: 
            case -9: {
                n2 = 12;
                break;
            }
            case -97: 
            case -10: {
                n2 = -1;
                break;
            }
            case -350: {
                n2 = -99;
                break;
            }
            case -400: {
                n2 = 70;
                break;
            }
        }
        if (n2 == -99 || n2 == -98) {
            n2 = n2 == -99 ? -1 : -4;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "adjust()", n2);
        }
        return n2;
    }

    public void setDQPFlag(int n) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setDQPFlag( " + n + " )");
            }
            this.setConnectOption(2466, n);
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!DB2Trace.TraceOn) break block4;
                DB2Trace.methodExit(this, "setDQPFlag()");
            }
            throw throwable;
        }
        Object var3_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setDQPFlag()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDQPFlag() throws SQLException {
        int n;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDQPFlag()");
            }
            n = n2 = this.getConnectOption(2466);
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getDQPFlag()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getDQPFlag()", n2);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getHostType() {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getHostType()");
            }
            if (this.hostType == 0) {
                this.hostType = this.SQLGetHostType(this.connectionHandle);
            }
            n = this.hostType;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getHostType()", this.hostType);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getHostType()", this.hostType);
        return n;
    }
}

