/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2BaseConstants;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2ColumnMappingResultSet;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.app.DB2SQLTypeMappingResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DB2DatabaseMetaData
implements DatabaseMetaData {
    protected DB2Connection connection;
    private static final String bogusSchema = new String("SysBogus");
    public int procedureResultUnknown;
    public int procedureNoResult = 1;
    public int procedureReturnsResult = 2;
    public int procedureColumnUnknown;
    public int procedureColumnIn = 1;
    public int procedureColumnInOut = 2;
    public int procedureColumnResult = 3;
    public int procedureColumnOut = 4;
    public int procedureColumnReturn = 5;
    int bestRowTemporary;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown;
    int bestRowNotPseudo = 1;
    int bestRowPseudo = 2;
    int versionColumnUnknown;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int typeUnSearchable;
    int typeSearchLikeOnly = 1;
    int typeSearchNotLike = 2;
    int typeSearchable = 3;
    short tableIndexStatistic;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;

    public DB2DatabaseMetaData(DB2Connection dB2Connection) {
        this.connection = dB2Connection;
    }

    protected native String SQLGetStrInfo(int var1, Integer var2, int var3);

    protected native int SQLGetIntInfo(int var1, Integer var2, int var3);

    protected native int SQLGetShortInfo(int var1, Integer var2, int var3);

    protected native int SQLGetProcedures(int var1, String var2, String var3, String var4, int var5);

    protected native int SQLGetProcedureColumns(int var1, String var2, String var3, String var4, String var5, int var6);

    protected native int SQLGetTables(int var1, String var2, String var3, String var4, String var5, int var6);

    protected native int SQLGetSchemas(int var1);

    protected native int SQLGetCatalogs(int var1);

    protected native int SQLGetTableTypes(int var1);

    protected native int SQLGetColumns(int var1, String var2, String var3, String var4, String var5, int var6);

    protected native int SQLGetColumnPrivileges(int var1, String var2, String var3, String var4, String var5, int var6);

    protected native int SQLTablePrivileges(int var1, String var2, String var3, int var4);

    protected native int SQLSpecialColumns(int var1, int var2, String var3, String var4, int var5, int var6, int var7);

    protected native int SQLPrimaryKeys(int var1, String var2, String var3, int var4);

    protected native int SQLGetTypeInfo(int var1, int var2);

    protected native int SQLStatistics(int var1, String var2, String var3, int var4, int var5, int var6);

    protected native int SQLForeignKeys(int var1, String var2, String var3, String var4, String var5, int var6);

    protected String SQLGetStringInfo(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        Integer n2 = new Integer(0);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLGetStrInfo(n, n2, this.connection.connectionHandle);
        }
        int n3 = n2;
        if (n3 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.connection, n3);
        }
        return string;
    }

    protected int SQLGetIntegerInfo(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        Integer n2 = new Integer(0);
        int n3 = this.SQLGetIntInfo(n, n2, this.connection.connectionHandle);
        int n4 = n2;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.connection, n4);
        }
        return n3;
    }

    protected short getShortInfo(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        Integer n2 = new Integer(0);
        short s = (short)this.SQLGetShortInfo(n, n2, this.connection.connectionHandle);
        int n3 = n2;
        if (n3 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.connection, n3);
        }
        return s;
    }

    protected boolean SQLGetBooleanInfo(int n) throws SQLException {
        String string = this.SQLGetStringInfo(n);
        return string.equals("Y");
    }

    protected boolean SQLGetBooleanInfo(int n, int n2) throws SQLException {
        int n3 = this.SQLGetIntegerInfo(n);
        return (n3 & n2) > 0;
    }

    protected boolean SQLCompShort(int n, int n2) throws SQLException {
        short s = this.getShortInfo(n);
        return s == n2;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return this.SQLGetBooleanInfo(20);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return this.SQLGetBooleanInfo(19);
    }

    public String getURL() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        return "jdbc:db2:" + this.connection.getSource();
    }

    public String getUserName() throws SQLException {
        return this.SQLGetStringInfo(47);
    }

    public boolean isReadOnly() throws SQLException {
        return this.SQLGetBooleanInfo(25);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return this.SQLCompShort(85, 0);
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return this.SQLCompShort(85, 1);
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.SQLCompShort(85, 2);
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.SQLCompShort(85, 4);
    }

    public String getDatabaseProductName() throws SQLException {
        return this.SQLGetStringInfo(17);
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.SQLGetStringInfo(18);
    }

    public String getDriverName() throws SQLException {
        return "IBM DB2 JDBC 1.2 Type 2";
    }

    public String getDriverVersion() throws SQLException {
        return this.SQLGetStringInfo(7);
    }

    public int getDriverMajorVersion() {
        return 7;
    }

    public int getDriverMinorVersion() {
        return 1;
    }

    public boolean usesLocalFiles() throws SQLException {
        return this.SQLCompShort(84, 2);
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return this.SQLCompShort(84, 1);
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.getShortInfo(28) == 3;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.getShortInfo(28) == 1;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.getShortInfo(28) == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.getShortInfo(28) == 4;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getShortInfo(93) == 3;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.getShortInfo(93) == 1;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.getShortInfo(93) == 2;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getShortInfo(93) == 4;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return this.SQLGetStringInfo(29);
    }

    public String getSQLKeywords() throws SQLException {
        return this.SQLGetStringInfo(89);
    }

    public String getNumericFunctions() throws SQLException {
        int n = this.SQLGetIntegerInfo(49);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < DB2BaseConstants.SQL_FN_NUM_MAPPING.length) {
            if (DB2BaseConstants.SQL_FN_NUM_MAPPING[n2].bitMask == (n & DB2BaseConstants.SQL_FN_NUM_MAPPING[n2].bitMask)) {
                stringBuffer.append(',');
                stringBuffer.append(DB2BaseConstants.SQL_FN_NUM_MAPPING[n2].nameStr);
            }
            ++n2;
        }
        String string = stringBuffer.toString();
        if (string.charAt(0) == ',') {
            return string.substring(1);
        }
        return string;
    }

    public String getStringFunctions() throws SQLException {
        int n = this.SQLGetIntegerInfo(50);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < DB2BaseConstants.SQL_FN_STR_MAPPING.length) {
            if (DB2BaseConstants.SQL_FN_STR_MAPPING[n2].bitMask == (n & DB2BaseConstants.SQL_FN_STR_MAPPING[n2].bitMask)) {
                stringBuffer.append(',');
                stringBuffer.append(DB2BaseConstants.SQL_FN_STR_MAPPING[n2].nameStr);
            }
            ++n2;
        }
        String string = stringBuffer.toString();
        if (string.charAt(0) == ',') {
            return string.substring(1);
        }
        return string;
    }

    public String getSystemFunctions() throws SQLException {
        int n = this.SQLGetIntegerInfo(51);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < DB2BaseConstants.SQL_FN_SYS_MAPPING.length) {
            if (DB2BaseConstants.SQL_FN_SYS_MAPPING[n2].bitMask == (n & DB2BaseConstants.SQL_FN_SYS_MAPPING[n2].bitMask)) {
                stringBuffer.append(',');
                stringBuffer.append(DB2BaseConstants.SQL_FN_SYS_MAPPING[n2].nameStr);
            }
            ++n2;
        }
        String string = stringBuffer.toString();
        if (string.charAt(0) == ',') {
            return string.substring(1);
        }
        return string;
    }

    public String getTimeDateFunctions() throws SQLException {
        int n = this.SQLGetIntegerInfo(52);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < DB2BaseConstants.SQL_FN_TD_MAPPING.length) {
            if (DB2BaseConstants.SQL_FN_TD_MAPPING[n2].bitMask == (n & DB2BaseConstants.SQL_FN_TD_MAPPING[n2].bitMask)) {
                stringBuffer.append(',');
                stringBuffer.append(DB2BaseConstants.SQL_FN_TD_MAPPING[n2].nameStr);
            }
            ++n2;
        }
        String string = stringBuffer.toString();
        if (string.charAt(0) == ',') {
            return string.substring(1);
        }
        return string;
    }

    public String getSearchStringEscape() throws SQLException {
        return this.SQLGetStringInfo(14);
    }

    public String getExtraNameCharacters() throws SQLException {
        return this.SQLGetStringInfo(94);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.SQLGetBooleanInfo(86, 1);
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.SQLGetBooleanInfo(86, 2);
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return this.SQLGetBooleanInfo(87);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.SQLCompShort(22, 0);
    }

    public boolean supportsConvert() throws SQLException {
        return this.SQLGetBooleanInfo(48, 1);
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        switch (n) {
            case -7: {
                n = 55;
                break;
            }
            case -6: {
                n = 68;
                break;
            }
            case 5: {
                n = 65;
                break;
            }
            case 4: {
                n = 61;
                break;
            }
            case -5: {
                n = 53;
                break;
            }
            case 6: {
                n = 60;
                break;
            }
            case 7: {
                n = 64;
                break;
            }
            case 8: {
                n = 59;
                break;
            }
            case 2: {
                n = 63;
                break;
            }
            case 3: {
                n = 58;
                break;
            }
            case 1: {
                n = 56;
                break;
            }
            case 12: {
                n = 70;
                break;
            }
            case -1: {
                n = 62;
                break;
            }
            case 91: {
                n = 57;
                break;
            }
            case 92: {
                n = 66;
                break;
            }
            case 93: {
                n = 67;
                break;
            }
            case -2: {
                n = 54;
                break;
            }
            case -3: {
                n = 69;
                break;
            }
            case -4: {
                n = 71;
                break;
            }
            default: {
                n = 0;
            }
        }
        switch (n2) {
            case -7: {
                n2 = 4096;
                break;
            }
            case -6: {
                n2 = 8192;
                break;
            }
            case 5: {
                n2 = 16;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case -5: {
                n2 = 16384;
                break;
            }
            case 6: {
                n2 = 32;
                break;
            }
            case 7: {
                n2 = 64;
                break;
            }
            case 8: {
                n2 = 128;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 12: {
                n2 = 256;
                break;
            }
            case -1: {
                n2 = 512;
                break;
            }
            case 91: {
                n2 = 32768;
                break;
            }
            case 92: {
                n2 = 65536;
                break;
            }
            case 93: {
                n2 = 131072;
                break;
            }
            case -2: {
                n2 = 1024;
                break;
            }
            case -3: {
                n2 = 2048;
                break;
            }
            case -4: {
                n2 = 262144;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return this.SQLGetBooleanInfo(n, n2);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return !this.SQLCompShort(74, 0);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.SQLCompShort(74, 1);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.SQLGetBooleanInfo(27);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return !this.SQLGetBooleanInfo(90);
    }

    public boolean supportsGroupBy() throws SQLException {
        return !this.SQLCompShort(88, 0);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.SQLCompShort(88, 3);
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.SQLCompShort(88, 2);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.SQLGetBooleanInfo(113);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return this.SQLGetBooleanInfo(36);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return this.SQLGetBooleanInfo(37);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return this.SQLCompShort(75, 1);
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.SQLCompShort(15, 0);
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.SQLCompShort(15, 1);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.SQLCompShort(15, 2);
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        String string = this.getDriverVersion();
        int n = new Integer(string.substring(0, 2));
        return n >= 3;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.SQLGetBooleanInfo(73);
    }

    public boolean supportsOuterJoins() throws SQLException {
        return !this.SQLGetStringInfo(38).equals("N");
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return this.SQLGetBooleanInfo(115, 4);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        String string = this.SQLGetStringInfo(38);
        return string.equals("P") || string.equals("Y");
    }

    public String getSchemaTerm() throws SQLException {
        return this.SQLGetStringInfo(39);
    }

    public String getProcedureTerm() throws SQLException {
        return this.SQLGetStringInfo(40);
    }

    public String getCatalogTerm() throws SQLException {
        return this.SQLGetStringInfo(42);
    }

    public boolean isCatalogAtStart() throws SQLException {
        return this.SQLCompShort(114, 1);
    }

    public String getCatalogSeparator() throws SQLException {
        return this.SQLGetStringInfo(41);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.SQLGetBooleanInfo(91, 1);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.SQLGetBooleanInfo(91, 2);
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(91, 4);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(91, 8);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(91, 16);
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.SQLGetBooleanInfo(92, 1);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.SQLGetBooleanInfo(92, 2);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(92, 4);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(92, 8);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.SQLGetBooleanInfo(92, 16);
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return this.SQLGetBooleanInfo(80, 1);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return this.SQLGetBooleanInfo(80, 2);
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return this.SQLGetBooleanInfo(80, 4);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return this.SQLGetBooleanInfo(21);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.SQLGetBooleanInfo(95, 1);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.SQLGetBooleanInfo(95, 2);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.SQLGetBooleanInfo(95, 4);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.SQLGetBooleanInfo(95, 8);
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.SQLGetBooleanInfo(95, 16);
    }

    public boolean supportsUnion() throws SQLException {
        return this.SQLGetBooleanInfo(96, 1);
    }

    public boolean supportsUnionAll() throws SQLException {
        return this.SQLGetBooleanInfo(95, 2);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.SQLCompShort(23, 2);
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.SQLCompShort(24, 2);
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        short s = this.getShortInfo(23);
        return s == 2 || s == 1;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        short s = this.getShortInfo(24);
        return s == 2 || s == 1;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.SQLGetIntegerInfo(112);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this.SQLGetIntegerInfo(108);
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getShortInfo(30);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getShortInfo(97);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getShortInfo(98);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getShortInfo(99);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.getShortInfo(100);
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.getShortInfo(101);
    }

    public int getMaxConnections() throws SQLException {
        return this.getShortInfo(0);
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getShortInfo(31);
    }

    public int getMaxIndexLength() throws SQLException {
        return this.SQLGetIntegerInfo(102);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getShortInfo(32);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getShortInfo(33);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getShortInfo(34);
    }

    public int getMaxRowSize() throws SQLException {
        return this.SQLGetIntegerInfo(104);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.SQLGetBooleanInfo(103);
    }

    public int getMaxStatementLength() throws SQLException {
        return this.SQLGetIntegerInfo(105);
    }

    public int getMaxStatements() throws SQLException {
        return this.getShortInfo(1);
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getShortInfo(35);
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.getShortInfo(106);
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getShortInfo(107);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return this.SQLGetIntegerInfo(26);
    }

    public boolean supportsTransactions() throws SQLException {
        return !this.SQLCompShort(46, 0);
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return this.SQLGetBooleanInfo(72, n);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.SQLCompShort(46, 2);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.SQLCompShort(46, 1);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.SQLCompShort(46, 3);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.SQLCompShort(46, 4);
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        AutoCloseable autoCloseable = this.connection;
        synchronized (autoCloseable) {
            n = this.SQLGetProcedures(dB2Statement.statementHandle, null, string2, string3, this.connection.connectionHandle);
        }
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        autoCloseable = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, 8) : new DB2ResultSet(dB2Statement, 8);
        return autoCloseable;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        Object object = this.connection;
        synchronized (object) {
            n = this.SQLGetProcedureColumns(dB2Statement.statementHandle, null, string2, string3, string4, this.connection.connectionHandle);
        }
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        object = new int[1];
        object[0] = 6;
        String[] stringArray = new String[13];
        stringArray[7] = "PRECISION";
        stringArray[8] = "LENGTH";
        stringArray[9] = "SCALE";
        stringArray[10] = "RADIX";
        return new DB2SQLTypeMappingResultSet(dB2Statement, (int[])object, 13, stringArray);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        String string4 = null;
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null) {
                    stringBuffer.append('\'');
                    stringBuffer.append(stringArray[n2]);
                    stringBuffer.append('\'');
                    if (n2 != stringArray.length - 1) {
                        stringBuffer.append(',');
                    }
                }
                ++n2;
            }
            string4 = stringBuffer.toString();
        } else {
            string4 = new String("");
        }
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        AutoCloseable autoCloseable = this.connection;
        synchronized (autoCloseable) {
            n = this.SQLGetTables(dB2Statement.statementHandle, null, string2, string3, string4, this.connection.connectionHandle);
        }
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        autoCloseable = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, 5) : new DB2ResultSet(dB2Statement, 5);
        return autoCloseable;
    }

    public ResultSet getSchemas() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        int n = this.SQLGetSchemas(dB2Statement.statementHandle);
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        int[] nArray = new int[]{2};
        return new DB2ColumnMappingResultSet(dB2Statement, nArray);
    }

    public ResultSet getCatalogs() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        int n = this.SQLGetCatalogs(dB2Statement.statementHandle);
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        DB2ResultSet dB2ResultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, 1) : new DB2ResultSet(dB2Statement, 1);
        return dB2ResultSet;
    }

    public ResultSet getTableTypes() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        int n = this.SQLGetTableTypes(dB2Statement.statementHandle);
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        int[] nArray = new int[]{4};
        return new DB2ColumnMappingResultSet(dB2Statement, nArray);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        Object object = this.connection;
        synchronized (object) {
            n = this.SQLGetColumns(dB2Statement.statementHandle, null, string2, string3, string4, this.connection.connectionHandle);
        }
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        object = new int[1];
        object[0] = 5;
        return new DB2SQLTypeMappingResultSet(dB2Statement, (int[])object, 18);
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        AutoCloseable autoCloseable = this.connection;
        synchronized (autoCloseable) {
            n = this.SQLGetColumnPrivileges(dB2Statement.statementHandle, null, string2, string3, string4, this.connection.connectionHandle);
        }
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        autoCloseable = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, 8) : new DB2ResultSet(dB2Statement, 8);
        return autoCloseable;
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        AutoCloseable autoCloseable = this.connection;
        synchronized (autoCloseable) {
            n = this.SQLTablePrivileges(dB2Statement.statementHandle, string2, string3, this.connection.connectionHandle);
        }
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        autoCloseable = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, 7) : new DB2ResultSet(dB2Statement, 7);
        return autoCloseable;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        int n2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        int n3 = bl ? 1 : 0;
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        Object object = this.connection;
        synchronized (object) {
            n2 = this.SQLSpecialColumns(dB2Statement.statementHandle, 1, string2, string3, n, n3, this.connection.connectionHandle);
        }
        if (n2 != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n2);
        }
        object = new int[1];
        object[0] = 3;
        return new DB2SQLTypeMappingResultSet(dB2Statement, (int[])object, 8);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        if ((n = this.SQLSpecialColumns(dB2Statement.statementHandle, 2, string2, string3, 0, 0, this.connection.connectionHandle)) != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        int[] nArray = new int[]{3};
        return new DB2SQLTypeMappingResultSet(dB2Statement, nArray, 8);
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        AutoCloseable autoCloseable = this.connection;
        synchronized (autoCloseable) {
            n = this.SQLPrimaryKeys(dB2Statement.statementHandle, string2, string3, this.connection.connectionHandle);
        }
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        autoCloseable = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, 6) : new DB2ResultSet(dB2Statement, 6);
        return autoCloseable;
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getCrossReference(string, null, null, string, string2, string3);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getCrossReference(string, string2, string3, string, null, null);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        if (!this.isCatalogValid(string4) || string5 != null && string5.length() == 0) {
            string5 = bogusSchema;
        }
        AutoCloseable autoCloseable = this.connection;
        synchronized (autoCloseable) {
            n = this.SQLForeignKeys(dB2Statement.statementHandle, string2, string3, string5, string6, this.connection.connectionHandle);
        }
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        autoCloseable = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, 14) : new DB2ResultSet(dB2Statement, 14);
        return autoCloseable;
    }

    public ResultSet getTypeInfo() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        int n = this.SQLGetTypeInfo(dB2Statement.statementHandle, 0);
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        int[] nArray = new int[]{2};
        String[] stringArray = new String[18];
        stringArray[2] = "PRECISION";
        stringArray[11] = "AUTO_INCREMENT";
        return new DB2SQLTypeMappingResultSet(dB2Statement, nArray, 18, stringArray);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        int n;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = (DB2Statement)this.connection.createStatement(true);
        int n2 = bl ? 0 : 1;
        if (!this.isCatalogValid(string) || string2 != null && string2.length() == 0) {
            string2 = bogusSchema;
        }
        AutoCloseable autoCloseable = this.connection;
        synchronized (autoCloseable) {
            n = this.SQLStatistics(dB2Statement.statementHandle, string2, string3, n2, 0, this.connection.connectionHandle);
        }
        if (n != 0) {
            this.connection.sqlExcptGen.check_return_code(dB2Statement, n);
        }
        autoCloseable = DB2Trace.TraceOn ? new DB2ResultSetTrace(dB2Statement, 13) : new DB2ResultSet(dB2Statement, 13);
        return autoCloseable;
    }

    private boolean isCatalogValid(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != '%') {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

