/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.mri.DB2Messages;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DB2Driver
implements Driver {
    private static DB2Driver ourDriver = null;
    public static final int MajorVersion = 7;
    public static final int MinorVersion = 1;
    private static final String libraryName = "libdb2jdbc.so";
    private static final String HPlibraryName = "libdb2jdbc.sl";
    private static final String libpath_unix = "lib";
    private static final String libpath_nt = "bin";
    private static final String libpath_os2 = "dll";
    private static final String DLLName = "db2jdbc";
    private static final String MSDLLName = "db2jms";
    private static String language = "C";
    public static boolean loaded;
    protected int traceOn;
    protected static int jvmHenv;
    public static final String buildLevel = "n030617";

    protected native int SQLAllocEnv(int[] var1);

    protected native String SQLGetTracePath(Integer var1, Integer var2, Integer var3, int var4);

    protected native int SQLFreeEnv(int var1);

    public native String getDLLVersion();

    public String toString() {
        return "DB2Driver: JDBC 1.22 n030617";
    }

    public DB2Driver() throws SQLException {
        if (!loaded) {
            this.traceOn = 0;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            try {
                string2 = System.getProperty("ibm.db2.instance.path");
                string4 = System.getProperty("file.separator");
                string5 = System.getProperty("os.arch");
                string3 = System.getProperty("os.name");
                string6 = System.getProperty("java.vendor");
                if (string2 != null) {
                    if (string4 != null && string4.equals("/")) {
                        string = String.valueOf(string2) + "/" + libpath_unix + "/";
                        string = string3 != null && string3.startsWith("HP-UX") ? String.valueOf(string) + HPlibraryName : String.valueOf(string) + libraryName;
                    } else {
                        string = String.valueOf(string2) + "\\";
                        if (string3 != null && string3.startsWith("OS/2")) {
                            string = String.valueOf(string) + "dll\\db2jdbc";
                        } else {
                            string = String.valueOf(string) + "bin\\";
                            string = string6 != null && string6.toLowerCase().indexOf("microsoft") != -1 ? String.valueOf(string) + MSDLLName : String.valueOf(string) + DLLName;
                        }
                        string = String.valueOf(string) + ".dll";
                    }
                    System.load(string);
                } else {
                    string = string6 != null && string6.toLowerCase().indexOf("microsoft") != -1 ? MSDLLName : DLLName;
                    System.loadLibrary(string);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                String[] stringArray = new String[]{DLLName};
                String string7 = new DB2Messages().getString("0646", stringArray);
                DriverManager.println(string7);
                DriverManager.println(unsatisfiedLinkError.toString());
                throw new SQLException(unsatisfiedLinkError.toString());
            }
            int[] nArray = new int[1];
            int n = this.SQLAllocEnv(nArray);
            jvmHenv = nArray[0];
            if (n != 0) {
                String[] stringArray = new String[]{String.valueOf(n)};
                String string8 = new DB2Messages().getString("0647", stringArray);
                DriverManager.println(string8);
                throw new SQLException(string8);
            }
            loaded = true;
            if (this.traceOn == 1) {
                Integer n2 = new Integer(0);
                Integer n3 = new Integer(0);
                Integer n4 = new Integer(0);
                String string9 = this.SQLGetTracePath(n2, n3, n4, jvmHenv);
                if (n4 != 0) {
                    DB2Trace.setTraceFlush(true);
                }
                if (n2 == 0 && string9 != null) {
                    DB2Trace.setTracePath(string9);
                }
                if (!DB2Trace.isInitialized()) {
                    DB2Trace dB2Trace = new DB2Trace(n3);
                    DB2Trace.methodEntry(this, "DB2Driver()");
                    if (string2 != null) {
                        dB2Trace.println("OS            : " + string3);
                        dB2Trace.println("Library loaded: " + string);
                    } else {
                        dB2Trace.println("Library loaded: " + string);
                    }
                    dB2Trace.println("DB2Driver: JDBC 1.22, BuildLevel: n030617");
                    DB2Trace.methodExit(this, "DB2Driver()");
                }
            }
        }
    }

    public static void setLanguage(String string) {
        language = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        Connection connection;
        block9: {
            DB2Connection dB2Connection;
            block8: {
                Connection connection2;
                block7: {
                    Connection connection3;
                    block6: {
                        try {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.methodEntry(this, "connect( " + string + ",  info )");
                            }
                            String string2 = new String();
                            String string3 = new String();
                            String string4 = new String();
                            int n = string.indexOf(58);
                            if (n == -1) {
                                connection3 = null;
                                Object var5_11 = null;
                                if (!DB2Trace.TraceOn) return connection3;
                                break block6;
                            }
                            string2 = string.substring(0, n);
                            int n2 = string.indexOf(58, n + 1);
                            if (n2 == -1) {
                                connection2 = null;
                                break block7;
                            }
                            string3 = string.substring(n + 1, n2);
                            string4 = string.substring(n2 + 1);
                            if (string2.equalsIgnoreCase("JDBC") && string3.equalsIgnoreCase("DB2") && !string4.startsWith("//")) {
                                ((Hashtable)properties).put("language", language);
                                dB2Connection = new DB2Connection(string4, properties, this);
                                break block8;
                            }
                            connection = null;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            Object var5_15 = null;
                            if (!DB2Trace.TraceOn) throw throwable;
                            DB2Trace.methodExit(this, "connect");
                            throw throwable;
                        }
                    }
                    DB2Trace.methodExit(this, "connect");
                    return connection3;
                }
                Object var5_12 = null;
                if (!DB2Trace.TraceOn) return connection2;
                DB2Trace.methodExit(this, "connect");
                return connection2;
            }
            Object var5_13 = null;
            if (!DB2Trace.TraceOn) return dB2Connection;
            DB2Trace.methodExit(this, "connect");
            return dB2Connection;
        }
        Object var5_14 = null;
        if (!DB2Trace.TraceOn) return connection;
        DB2Trace.methodExit(this, "connect");
        return connection;
    }

    public Connection connect() throws SQLException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("language", language);
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().println("DB2Driver - connect()");
        }
        return new DB2Connection(properties, this);
    }

    public int getMajorVersion() {
        return 7;
    }

    public int getMinorVersion() {
        return 1;
    }

    public int getRelease() {
        return 0;
    }

    public boolean acceptsURL(String string) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "acceptsURL (" + string + ")");
        }
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        int n = string.indexOf(58);
        string2 = string.substring(0, n);
        int n2 = string.indexOf(58, n + 1);
        string3 = string.substring(n + 1, n2);
        string4 = string.substring(n2 + 1);
        boolean bl = string2.equalsIgnoreCase("JDBC") && string3.equalsIgnoreCase("DB2") && !string4.startsWith("//");
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "acceptsURL", bl);
        }
        return bl;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{new DriverPropertyInfo("user", null), new DriverPropertyInfo("password", null)};
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("user")) {
                driverPropertyInfoArray[0].value = properties.getProperty("user");
                continue;
            }
            if (!string2.equals("password")) continue;
            driverPropertyInfoArray[1].value = properties.getProperty("password");
        }
        return driverPropertyInfoArray;
    }

    public static int getJVMHenv() throws SQLException {
        return jvmHenv;
    }

    public void finalize() throws SQLException {
        if (this == ourDriver) {
            this.SQLFreeEnv(jvmHenv);
            ourDriver = null;
            loaded = false;
            language = "C";
            jvmHenv = 0;
        }
    }

    static {
        try {
            if (ourDriver == null) {
                ourDriver = new DB2Driver();
                DriverManager.registerDriver(ourDriver);
            }
        }
        catch (SQLException sQLException) {
            String[] stringArray = new String[]{"COM.ibm.db2.jdbc.app.DB2Driver", sQLException.getMessage(), sQLException.getSQLState(), String.valueOf(sQLException.getErrorCode())};
            String string = new DB2Messages().getString("0645", stringArray);
            DriverManager.println(string);
        }
    }
}

