/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2ParameterMetaData;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaData;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2PreparedStatement
extends DB2Statement
implements PreparedStatement {
    protected final short NOT_DESCRIBED = 0;
    protected final short DESCRIBED = 1;
    protected final short DESCRIBE_FAILED = 2;
    protected short maxNumParams;
    protected byte[] SQLJPID;
    protected long[] parameters;
    protected int[] direction;
    protected int[] sqltypes;
    protected long[] precisions;
    protected boolean[] sqltypeGuessed;
    protected int[] ctypes;
    protected int[] maxWholeDigits;
    protected int[] scales;
    protected boolean[] wasBound;
    protected short[] described;
    protected ParamElement[] paramRow;
    protected Vector paramSet;
    protected static final int BUFLEN = 32699;
    protected boolean executed;
    private boolean resetParamSetSize;
    protected short statementType;
    private boolean[] SQLJParmIsGraphic;
    private String sqljDescribeInfo;

    protected native int SQLPrepare(String var1, int var2, int var3, byte[] var4);

    protected native int SQLExecute(int var1, boolean var2);

    protected native int SQLBindNull(int var1, int var2, int var3, long var4, int var6, int var7, long var8, long[] var10, int var11);

    protected native int SQLBindNull2(long var1);

    protected native int SQLBindSmallInt(int var1, int var2, int var3, int var4, long var5, int var7, long var8, long[] var10, int var11);

    protected native int SQLBindSmallInt2(int var1, long var2);

    protected native int SQLBindInteger(int var1, int var2, int var3, int var4, long var5, int var7, long var8, long[] var10, int var11);

    protected native int SQLBindInteger2(int var1, long var2);

    protected native int SQLBindBigInt(int var1, int var2, long var3, int var5, long var6, int var8, long var9, long[] var11, int var12);

    protected native int SQLBindBigInt2(long var1, long var3);

    protected native int SQLBindReal(int var1, int var2, long var3, int var5, int var6, float var7, long var8, long[] var10, int var11);

    protected native int SQLBindReal2(float var1, long var2);

    protected native int SQLBindDouble(int var1, int var2, double var3, int var5, long var6, int var8, long var9, long[] var11, int var12);

    protected native int SQLBindDouble2(double var1, long var3);

    protected native int SQLBindNumeric(int var1, int var2, int var3, String var4, long var5, int var7, long var8, long[] var10, int var11);

    protected native int SQLBindChar(int var1, int var2, long var3, int var5, String var6, int var7, long var8, long[] var10, int var11, int var12, boolean var13);

    protected native int SQLBindBinary(int var1, int var2, long var3, int var5, int var6, byte[] var7, long var8, long[] var10, int var11, boolean var12);

    protected native int SQLBindDate(int var1, int var2, int var3, int var4, int var5, int var6, long var7, int var9, long var10, long[] var12, int var13);

    protected native int SQLBindDate2(int var1, int var2, int var3, long var4);

    protected native int SQLBindTime(int var1, int var2, int var3, int var4, int var5, int var6, long var7, int var9, long var10, long[] var12, int var13);

    protected native int SQLBindTime2(int var1, int var2, int var3, long var4);

    protected native int SQLBindTimestamp(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, int var13, long var14, long[] var16, int var17);

    protected native int SQLBindTimestamp2(int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    protected native int SQLBindStream(int var1, int var2, long var3, int var5, int var6, int var7, int var8, boolean var9, long var10, long[] var12, int var13);

    protected native int SQLPutByteData(byte[] var1, int var2, int var3);

    protected native int SQLPutStringData(String var1, int var2, int var3, int var4);

    protected native int SQLGetNumParams(int var1);

    protected native int SQLParamData(int var1);

    protected native int SQLDescribeParam(int var1, int var2, int[] var3, long[] var4, int[] var5);

    protected native int SQLFreeStmtClearParameters(int var1);

    protected native void freeArrays(int var1, long[] var2);

    public String toString() {
        return this.toString("", true);
    }

    public String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2PreparedStatement \r\n" + string + "{");
        stringBuffer.append(super.toString(String.valueOf(string) + "    ", bl));
        stringBuffer.append("\r\n");
        stringBuffer.append(String.valueOf(string) + "    statementType = " + this.statementType + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    executed = " + this.executed + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    maxNumParams = " + this.maxNumParams + "\r\n");
        int n = 0;
        while (n < this.maxNumParams) {
            stringBuffer.append(String.valueOf(string) + "    parameters[" + n + "] = " + this.parameters[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    direction[" + n + "] = " + this.direction[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    sqltypes[" + n + "] = " + this.sqltypes[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    sqltypeGuessed[" + n + "] = " + this.sqltypeGuessed[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    precisions[" + n + "] = " + this.precisions[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    ctypes[" + n + "] = " + this.ctypes[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    maxWholeDigits[" + n + "] = " + this.maxWholeDigits[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    scales[" + n + "] = " + this.scales[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    described[" + n + "] = " + this.described[n] + "\r\n");
            ++n;
        }
        stringBuffer.append(String.valueOf(string) + "}\r\n");
        return stringBuffer.toString();
    }

    public DB2PreparedStatement(String string, DB2Connection dB2Connection, int n, int n2) throws SQLException {
        block12: {
            super(dB2Connection, n, n2);
            this.DESCRIBED = 1;
            this.DESCRIBE_FAILED = (short)2;
            this.executed = false;
            this.resetParamSetSize = false;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "DB2PreparedStatement( \"" + string + "\", con, " + n + ", " + n2 + " )");
                }
                if (string == null || string.trim().length() == 0) {
                    this.sqlExcptGen.throwNullError();
                }
                this.statementType = this.getStatementType(string);
                this.sql = this.statementType == 27 ? this.parseSQLJ(string) : string;
                this.returnCode = 0;
                DB2Connection dB2Connection2 = this.connection;
                synchronized (dB2Connection2) {
                    this.maxNumParams = (short)this.SQLPrepare(this.sql, this.statementHandle, dB2Connection.connectionHandle, this.SQLJPID);
                }
                if (this.returnCode != 0) {
                    try {
                        this.sqlExcptGen.check_return_code(this, this.returnCode);
                        this.maxNumParams = (short)this.SQLGetNumParams(this.statementHandle);
                    }
                    catch (SQLException sQLException) {
                        this.close();
                        throw sQLException;
                    }
                }
                this.parameters = new long[this.maxNumParams];
                this.direction = new int[this.maxNumParams];
                this.sqltypes = new int[this.maxNumParams];
                this.precisions = new long[this.maxNumParams];
                this.sqltypeGuessed = new boolean[this.maxNumParams];
                this.ctypes = new int[this.maxNumParams];
                this.maxWholeDigits = new int[this.maxNumParams];
                this.scales = new int[this.maxNumParams];
                this.wasBound = new boolean[this.maxNumParams];
                this.described = new short[this.maxNumParams];
                this.paramSet = new Vector();
                this.paramRow = new ParamElement[this.maxNumParams];
                int n3 = 0;
                while (n3 < this.maxNumParams) {
                    this.parameters[n3] = 0L;
                    this.direction[n3] = 0;
                    this.sqltypes[n3] = 0;
                    this.precisions[n3] = 0L;
                    this.sqltypeGuessed[n3] = false;
                    this.ctypes[n3] = 0;
                    this.maxWholeDigits[n3] = 0;
                    this.scales[n3] = 0;
                    this.wasBound[n3] = false;
                    this.described[n3] = 0;
                    this.paramRow[n3] = new ParamElement();
                    ++n3;
                }
                if (this.statementType != 27 || this.sqljDescribeInfo == null) break block12;
                this.processSQLJDescribeInfo();
            }
            catch (Throwable throwable) {
                block13: {
                    Object var6_9 = null;
                    if (!DB2Trace.TraceOn) break block13;
                    DB2Trace.data(10, "maxNumParam", this.maxNumParams);
                    DB2Trace.methodExit(this, "DB2PreparedStatement()");
                }
                throw throwable;
            }
        }
        Object var6_8 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "maxNumParam", this.maxNumParams);
            DB2Trace.methodExit(this, "DB2PreparedStatement()");
        }
    }

    public DB2PreparedStatement(String string, DB2Connection dB2Connection) throws SQLException {
        this(string, dB2Connection, 1003, 1007);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseSQLJ(String var1_1) throws SQLException {
        block27: {
            block26: {
                var2_2 = null;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "parseSQLJ( " + var1_1 + " )");
                    }
                    var2_2 = var1_1.substring(var1_1.indexOf("{"));
                    var6_3 = var2_2.indexOf("db2jrt");
                    var7_5 = 6;
                    var8_6 = var1_1.indexOf(",");
                    var9_7 = Integer.parseInt(var1_1.substring(1, var8_6));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "numOfTokens", var9_7);
                    }
                    if (var9_7 > 0) {
                        var10_8 = new int[var9_7];
                        var11_10 = 0;
                        ++var8_6;
                        var12_11 = 0;
                        while (var12_11 < var9_7) {
                            var11_10 = var1_1.indexOf(",", var8_6);
                            var10_8[var12_11] = Integer.parseInt(var1_1.substring(var8_6, var11_10));
                            var8_6 = var11_10 + 1;
                            ++var12_11;
                        }
                        this.colCount4JSQL = var9_7;
                        this.colNames4JSQL = new String[var9_7];
                        var13_12 = 0;
                        while (var13_12 < var9_7) {
                            var11_10 = var8_6 + var10_8[var13_12];
                            this.colNames4JSQL[var13_12] = new String(var1_1.substring(var8_6, var11_10));
                            var8_6 = var11_10;
                            ++var13_12;
                        }
                    }
                    var10_9 = var1_1.indexOf(",", ++var8_6);
                    var11_10 = Integer.parseInt(var1_1.substring(var8_6, var10_9));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "cursorName_len", var11_10);
                    }
                    if (var11_10 > 0) {
                        var8_6 = var10_9 + 1;
                        var10_9 = var1_1.indexOf(",", var8_6);
                        var12_11 = Integer.parseInt(var1_1.substring(var8_6, var10_9));
                        var8_6 = var10_9 + 1;
                        var10_9 = var1_1.indexOf(",", var8_6);
                        var13_12 = Integer.parseInt(var1_1.substring(var8_6, var10_9));
                        var14_13 = var2_2.substring(var12_11, var13_12);
                        var8_6 = var10_9 + 1;
                        var10_9 = var8_6 + var11_10;
                        var15_14 = String.valueOf(new String(var1_1.substring(var8_6, var10_9))) + "," + var14_13;
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(20, "cursor_pid_ep", var13_12);
                            DB2Trace.data(20, "cursorName", var15_14);
                        }
                        this.setCursorName(var15_14);
                    } else {
                        var13_12 = var2_2.lastIndexOf(125);
                        var13_12 = var2_2.lastIndexOf(41, var13_12 - 1);
                        var13_12 = var2_2.lastIndexOf(39, var13_12 - 1);
                        var12_11 = var2_2.lastIndexOf("','", var13_12 - 1);
                        var14_13 = var2_2.substring(var12_11 + 3, var13_12);
                        var13_12 = var12_11;
                        var15_14 = var2_2.substring((var12_11 = var2_2.lastIndexOf("','", var13_12 - 1)) + 3, var13_12);
                        if (var15_14.length() > 0 || var14_13.length() > 0) {
                            var12_11 = var6_3 + var7_5;
                            var12_11 = var2_2.indexOf("'", var12_11) + 1;
                            var13_12 = var2_2.indexOf(44, var12_11);
                            var16_15 = var2_2.indexOf("',", var13_12);
                            var17_16 = var2_2.substring(var12_11, var13_12);
                            var18_17 = var2_2.substring(var13_12 + 1, var16_15);
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(20, "CursorName", var17_16);
                                DB2Trace.data(20, "PIDString", var18_17);
                            }
                            var2_2 = String.valueOf(var15_14) + var17_16 + var14_13;
                            var19_18 = new ByteArrayOutputStream(162);
                            var20_19 = 0;
                            var21_20 = var18_17.length();
                            var23_21 = 0;
                            while (var23_21 < var21_20) {
                                var22_22 = var18_17.charAt(var23_21);
                                if (var22_22 == ',') {
                                    var19_18.write(var20_19);
                                    var20_19 = 0;
                                } else if (var22_22 != ' ') {
                                    var20_19 = var20_19 * 10 + Character.digit(var22_22, 10);
                                }
                                ++var23_21;
                            }
                            this.SQLJPID = var19_18.toByteArray();
                        }
                    }
                    if (var2_2.indexOf("db2jrt") != -1) {
                        var8_6 = var2_2.indexOf("db2jrt");
                        var12_11 = 0;
                        while (var12_11 < 5) {
                            var8_6 = var2_2.indexOf("'", var8_6 + 1);
                            ++var12_11;
                        }
                        var10_9 = var2_2.indexOf("'", var8_6 + 1);
                        if (var2_2.substring(var8_6, var10_9 + 1).indexOf(",") != -1) {
                            this.sqljDescribeInfo = var2_2.substring(var8_6 + 1, var10_9);
                        }
                    }
                    if (this.sqljDescribeInfo == null) {
                        var8_6 = var2_2.indexOf(39, var6_3 + var7_5 + 1);
                        var8_6 = var2_2.indexOf(39, var8_6 + 1);
                        var8_6 = var2_2.indexOf(44, var8_6 + 1);
                        var8_6 = var2_2.indexOf(44, var8_6 + 1);
                        var8_6 = var2_2.indexOf(44, var8_6 + 1);
                        var8_6 = var2_2.indexOf(44, var8_6 + 1);
                        var10_9 = var2_2.indexOf(39, (var8_6 = var2_2.indexOf(39, var8_6 + 1)) + 1);
                        if (var10_9 - var8_6 > 1) {
                            this.SQLJParmIsGraphic = new boolean[var10_9 - var8_6 - 1];
                            ++var8_6;
                            var12_11 = 0;
                            while (var12_11 < this.SQLJParmIsGraphic.length) {
                                if (var2_2.charAt(var8_6) == '1') {
                                    this.SQLJParmIsGraphic[var12_11] = true;
                                }
                                ++var12_11;
                                ++var8_6;
                            }
                        }
                    }
                    var3_23 = var2_2;
                    var5_24 = null;
                    if (DB2Trace.TraceOn == false) return var3_23;
                    if (this.SQLJParmIsGraphic == null) break block26;
                    var6_3 = 0;
                    ** while (var6_3 < this.SQLJParmIsGraphic.length)
                }
                catch (Throwable var4_26) {
                    var5_25 = null;
                    if (!DB2Trace.TraceOn) throw var4_26;
                    if (this.SQLJParmIsGraphic == null) break block27;
                    var6_4 = 0;
                    ** while (var6_4 < this.SQLJParmIsGraphic.length)
                }
lbl-1000:
                // 1 sources

                {
                    DB2Trace.data(100, "SQLJParmIsGraphic[" + var6_3 + "]", String.valueOf(this.SQLJParmIsGraphic[var6_3]));
                    ++var6_3;
                    continue;
                }
            }
            DB2Trace.methodExit((Object)this, "parseSQLJ()", var2_2);
            return var3_23;
lbl-1000:
            // 1 sources

            {
                DB2Trace.data(100, "SQLJParmIsGraphic[" + var6_4 + "]", String.valueOf(this.SQLJParmIsGraphic[var6_4]));
                ++var6_4;
                continue;
            }
        }
        DB2Trace.methodExit((Object)this, "parseSQLJ()", var2_2);
        throw var4_26;
    }

    private void checkForSQLJGraphic(int n) {
        int n2;
        block10: {
            n2 = n - 1;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "checkForSQLJGraphic( " + n + " )");
                    DB2Trace.data(10, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
                }
                if (this.statementType != 27 || this.SQLJParmIsGraphic == null || this.SQLJParmIsGraphic.length <= n2 || !this.SQLJParmIsGraphic[n2]) break block10;
                int n3 = this.sqltypes[n2];
                switch (this.sqltypes[n2]) {
                    case 1: {
                        this.sqltypes[n2] = -95;
                        break;
                    }
                    case 12: {
                        this.sqltypes[n2] = -96;
                        break;
                    }
                    case -1: {
                        this.sqltypes[n2] = -97;
                        break;
                    }
                    case -99: {
                        this.sqltypes[n2] = -350;
                        break;
                    }
                }
                if (this.sqltypes[n2] == n3) break block10;
                this.wasBound[n2] = false;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var4_5 = null;
                    if (!DB2Trace.TraceOn) break block11;
                    DB2Trace.data(100, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
                    DB2Trace.methodExit(this, "checkForSQLJGraphic()");
                }
                throw throwable;
            }
        }
        Object var4_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(100, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
            DB2Trace.methodExit(this, "checkForSQLJGraphic()");
        }
    }

    private void processSQLJDescribeInfo() {
        block9: {
            try {
                StringTokenizer stringTokenizer;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "processSQLJDescribeInfo()");
                }
                if ((stringTokenizer = new StringTokenizer(this.sqljDescribeInfo, ",", false)).countTokens() <= 0) break block9;
                int n = stringTokenizer.countTokens() - 1;
                String string = "";
                stringTokenizer.nextToken();
                int n2 = 0;
                while (n2 < n) {
                    string = stringTokenizer.nextToken();
                    int n3 = 0;
                    int n4 = 0;
                    if (string.indexOf(" ") != -1) {
                        n4 = string.indexOf("(");
                        this.sqltypes[n2] = new Integer(string.substring(n3, n4));
                        n3 = n4 + 1;
                        n4 = string.indexOf(" ");
                        this.precisions[n2] = new Integer(string.substring(n3, n4)).intValue();
                        string.substring(n3, n4);
                        n3 = n4 + 1;
                        n4 = string.indexOf(")");
                        this.scales[n2] = new Integer(string.substring(n3, n4));
                    } else if (string.indexOf("(") != -1) {
                        n4 = string.indexOf("(");
                        this.sqltypes[n2] = new Integer(string.substring(n3, n4));
                        n3 = n4 + 1;
                        n4 = string.indexOf(")");
                        this.precisions[n2] = new Integer(string.substring(n3, n4)).intValue();
                    } else {
                        this.sqltypes[n2] = new Integer(string);
                    }
                    this.described[n2] = this.sqltypes[n2] == 0 ? (short)0 : 1;
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                block10: {
                    Object var2_8 = null;
                    if (!DB2Trace.TraceOn) break block10;
                    DB2Trace.methodExit(this, "processSQLJDescribeInfo()");
                }
                throw throwable;
            }
        }
        Object var2_7 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "processSQLJDescribeInfo()");
        }
    }

    protected void close2(boolean bl) throws SQLException {
        block4: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "close2( " + bl + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    DB2Trace.data(10, "Closed (Entry)", String.valueOf(this.closed));
                }
                if (this.closed) break block4;
                super.close2(bl);
                if (this.parameters == null || this.maxNumParams == 0) break block4;
                this.freeArrays(this.maxNumParams, this.parameters);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var3_3 = null;
                    if (!DB2Trace.TraceOn) break block5;
                    DB2Trace.data(20, "Closed (Exit)", String.valueOf(this.closed));
                    DB2Trace.methodExit(this, "close2()");
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(20, "Closed (Exit)", String.valueOf(this.closed));
            DB2Trace.methodExit(this, "close2()");
        }
    }

    protected void setDirection(int n, int n2, int n3) throws SQLException {
        this.setDirection(n, n2, n3, -1);
    }

    protected void setDirection(int n, int n2, int n3, int n4) throws SQLException {
        int n5;
        block10: {
            n5 = n - 1;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setDirection( " + n + ", " + n2 + ", " + n3 + ", " + n4 + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.direction[n5] == 4) {
                    this.direction[n5] = 2;
                    this.wasBound[n5] = false;
                } else if (this.direction[n5] == 0) {
                    this.direction[n5] = 1;
                    this.wasBound[n5] = false;
                }
                if (this.described[n5] != 1 && n2 != 0) {
                    if (this.sqltypes[n5] != n2) {
                        this.sqltypes[n5] = n2;
                        this.wasBound[n5] = false;
                    }
                    this.sqltypeGuessed[n5] = false;
                }
                if ((this.sqltypes[n5] == 3 || this.sqltypes[n5] == 2 && this.sqljDescribeInfo == null) && n4 != -1 && n4 != this.scales[n5]) {
                    this.scales[n5] = n4;
                    this.wasBound[n5] = false;
                }
                if (this.ctypes[n5] == n3) break block10;
                this.ctypes[n5] = n3;
                this.wasBound[n5] = false;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) break block11;
                    DB2Trace.data(20, "direction[" + n5 + "]", this.direction[n5]);
                    DB2Trace.data(20, "wasBound[" + n5 + "]", String.valueOf(this.wasBound[n5]));
                    DB2Trace.data(20, "sqltypes[" + n5 + "]", this.sqltypes[n5]);
                    DB2Trace.data(20, "ctypes[" + n5 + "]", this.ctypes[n5]);
                    DB2Trace.data(20, "scales[" + n5 + "]", this.scales[n5]);
                    DB2Trace.methodExit(this, "setDirection()");
                }
                throw throwable;
            }
        }
        Object var7_6 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(20, "direction[" + n5 + "]", this.direction[n5]);
            DB2Trace.data(20, "wasBound[" + n5 + "]", String.valueOf(this.wasBound[n5]));
            DB2Trace.data(20, "sqltypes[" + n5 + "]", this.sqltypes[n5]);
            DB2Trace.data(20, "ctypes[" + n5 + "]", this.ctypes[n5]);
            DB2Trace.data(20, "scales[" + n5 + "]", this.scales[n5]);
            DB2Trace.methodExit(this, "setDirection()");
        }
    }

    protected void checkParameters() throws SQLException {
    }

    protected int loadBatchParameters() throws SQLException {
        this.returnCode = 0;
        return this.returnCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int loadParameters() throws SQLException {
        int n;
        this.returnCode = 0;
        int n2 = -1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "loadParameters()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            n2 = this.SQLParamData(this.statementHandle);
            if (this.returnCode != 99 && this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            while (this.returnCode == 99) {
                this.loadParameters2(-1, n2 - 1);
                n2 = this.SQLParamData(this.statementHandle);
                if (this.returnCode == 99 || this.returnCode == 0) continue;
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            n = this.returnCode;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "loadParameters()", this.returnCode);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "loadParameters()", this.returnCode);
        return n;
    }

    private void loadParameters2(int n, int n2) throws SQLException {
        block19: {
            this.returnCode = 0;
            int n3 = -99999;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "loadParameters2(setNum=" + n + ",paramNum=" + n2 + ")");
                }
                try {
                    byte[] byArray = new byte[32699];
                    int n4 = this.maxFieldSize;
                    int n5 = n4 != 0 ? Math.min(this.paramRow[n2].getLength(), n4) : this.paramRow[n2].getLength();
                    boolean bl = false;
                    if (this.paramRow[n2].doConversion()) {
                        BufferedReader bufferedReader = new BufferedReader((Reader)this.paramRow[n2].getValue());
                        int n6 = this.paramRow[n2].getLength();
                        int n7 = Math.min(16349, n6);
                        char[] cArray = new char[n7];
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(20, "paramRow[" + n2 + "].doConversion", "True");
                            DB2Trace.data(20, "charsToRead", n6);
                            DB2Trace.data(20, "toRead", n7);
                        }
                        while (n6 != 0) {
                            int n8;
                            int n9 = 0;
                            n7 = Math.min(16349, n6);
                            while (n9 < n7 && (cArray[n9] = (char)bufferedReader.read()) != '\uffffffff') {
                                ++n9;
                            }
                            if (n9 == 0) {
                                n6 = 0;
                                continue;
                            }
                            n6 -= n9;
                            String string = new String(cArray, 0, n9);
                            DB2Connection dB2Connection = this.connection;
                            synchronized (dB2Connection) {
                                n8 = this.SQLPutStringData(string, n9, this.statementHandle, this.connection.connectionHandle);
                            }
                            if (n8 != 0) {
                                this.sqlExcptGen.check_return_code(this, n8);
                            }
                            bl = true;
                        }
                    } else {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(20, "paramRow[" + n2 + "].doConversion", "False");
                            DB2Trace.data(20, "bytesToRead", n5);
                        }
                        InputStream inputStream = (InputStream)this.paramRow[n2].getValue();
                        while ((n3 = inputStream.read(byArray, 0, Math.min(32699, n5))) != -1 && n5 != 0) {
                            n5 -= n3;
                            int n10 = this.SQLPutByteData(byArray, n3, this.statementHandle);
                            if (n10 != 0) {
                                this.sqlExcptGen.check_return_code(this, n10);
                            }
                            bl = true;
                        }
                    }
                    if (!bl) {
                        DB2Trace.data(30, "No data read from InputStream. Throwing IOException");
                        throw new IOException("No data available from InputStream");
                    }
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.throw_IOException(iOException);
                }
                Object var5_19 = null;
                if (!DB2Trace.TraceOn) break block19;
            }
            catch (Throwable throwable) {
                block20: {
                    Object var5_20 = null;
                    if (!DB2Trace.TraceOn) break block20;
                    DB2Trace.methodExit((Object)this, "loadParameters2()", this.returnCode);
                }
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "loadParameters2()", this.returnCode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet executeQuery() throws SQLException {
        DB2ResultSet dB2ResultSet;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeQuery()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "statementType", this.statementType);
            }
            if (this.statementType != 24 && this.statementType != 25 && this.statementType != 27) {
                this.sqlExcptGen.throwInvalidQueryError();
            }
            this.execute2();
            this.getResultSet();
            dB2ResultSet = this.resultSet;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2ResultSet;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "executeQuery()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "executeQuery()");
        return dB2ResultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate() throws SQLException {
        int n;
        int n2 = -2;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeUpdate()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.data(10, "statementType", this.statementType);
            }
            if (this.statementType == 24) {
                this.sqlExcptGen.throwInvalidUpdateError();
            }
            this.execute2();
            n = n2 = this.getUpdateCount();
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "executeUpdate()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "executeUpdate()", n2);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute2() throws SQLException {
        this.moreResults = true;
        this.prefetchedMoreResults = false;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "execute2()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.warnings = null;
            int n = 0;
            while (n < this.maxNumParams) {
                if (this.paramRow[n].isSet()) {
                    int n2;
                    Object object = this.paramRow[n].getValue();
                    if (this.paramRow[n].isStream() && this.direction[n] == 2) {
                        this.sqlExcptGen.pstmtException("S1003");
                    }
                    if (this.sqltypes[n] == 0 || this.sqltypeGuessed[n]) {
                        this.guessSQLType(n + 1, this.paramRow[n].getLength());
                    }
                    if (this.statementType == 27 && this.sqljDescribeInfo == null) {
                        this.checkForSQLJGraphic(n + 1);
                    }
                    if (!this.wasBound[n]) {
                        this.setPrecision(n + 1);
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "wasBound[" + n + "] = " + this.wasBound[n]);
                        DB2Trace.data(10, "sqltypes[" + n + "] = " + this.sqltypes[n]);
                        DB2Trace.data(10, "sqltypeGuessed[" + n + "] = " + this.sqltypeGuessed[n]);
                        DB2Trace.data(10, "precisions[" + n + "] = " + this.precisions[n]);
                        DB2Trace.data(10, "scales[" + n + "] = " + this.scales[n]);
                        DB2Trace.data(10, "ctypes[" + n + "] = " + this.ctypes[n]);
                        DB2Trace.data(10, "described[" + n + "] = " + this.described[n]);
                        DB2Trace.data(10, "direction[" + n + "] = " + this.direction[n]);
                        DB2Trace.data(10, "About to BIND...");
                    }
                    if (object == null) {
                        n2 = !this.wasBound[n] ? this.SQLBindNull(this.direction[n], n + 1, this.sqltypes[n], this.precisions[n], this.scales[n], this.ctypes[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindNull2(this.parameters[n]);
                        this.sqlExcptGen.check_return_code(this, n2);
                    } else {
                        switch (this.ctypes[n]) {
                            case -25: {
                                n2 = !this.wasBound[n] ? this.SQLBindBigInt(this.direction[n], n + 1, ((PrimitiveData)object).longValue(), this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindBigInt2(((PrimitiveData)object).longValue(), this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 4: {
                                n2 = !this.wasBound[n] ? this.SQLBindInteger(this.direction[n], n + 1, ((PrimitiveData)object).intValue(), this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindInteger2(((PrimitiveData)object).intValue(), this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case -7: 
                            case -6: 
                            case 5: {
                                n2 = !this.wasBound[n] ? this.SQLBindSmallInt(this.direction[n], n + 1, ((PrimitiveData)object).shortValue(), this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindSmallInt2(((PrimitiveData)object).shortValue(), this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 7: {
                                n2 = !this.wasBound[n] ? this.SQLBindReal(this.direction[n], this.sqltypes[n], this.precisions[n], this.scales[n], n + 1, ((PrimitiveData)object).floatValue(), this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindReal2(((PrimitiveData)object).floatValue(), this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 8: {
                                n2 = !this.wasBound[n] ? this.SQLBindDouble(this.direction[n], n + 1, ((PrimitiveData)object).doubleValue(), this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindDouble2(((PrimitiveData)object).doubleValue(), this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case -8: 
                            case 1: {
                                if (this.paramRow[n].isStream()) {
                                    n2 = this.SQLBindStream(this.direction[n], this.sqltypes[n], this.precisions[n], this.scales[n], this.ctypes[n], n + 1, this.paramRow[n].getLength() * 2, this.paramRow[n].doConversion(), this.parameters[n], this.parameters, this.statementHandle);
                                } else if (this.sqltypes[n] == 2 || this.sqltypes[n] == 3) {
                                    n2 = this.SQLBindNumeric(this.direction[n], this.sqltypes[n], n + 1, (String)object, this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle);
                                } else {
                                    DB2Connection dB2Connection = this.connection;
                                    synchronized (dB2Connection) {
                                        n2 = this.SQLBindChar(this.direction[n], this.sqltypes[n], this.precisions[n], n + 1, (String)object, this.scales[n], this.parameters[n], this.parameters, this.statementHandle, this.connection.connectionHandle, !this.wasBound[n]);
                                    }
                                }
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case -2: {
                                n2 = this.paramRow[n].isStream() ? this.SQLBindStream(this.direction[n], this.sqltypes[n], this.precisions[n], this.scales[n], this.ctypes[n], n + 1, this.paramRow[n].getLength(), this.paramRow[n].doConversion(), this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindBinary(this.direction[n], this.sqltypes[n], this.precisions[n], this.scales[n], n + 1, (byte[])object, this.parameters[n], this.parameters, this.statementHandle, !this.wasBound[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 9: {
                                n2 = !this.wasBound[n] ? this.SQLBindDate(this.direction[n], n + 1, ((int[])object)[0], ((int[])object)[1], ((int[])object)[2], this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindDate2(((int[])object)[0], ((int[])object)[1], ((int[])object)[2], this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 10: {
                                n2 = !this.wasBound[n] ? this.SQLBindTime(this.direction[n], n + 1, ((int[])object)[0], ((int[])object)[1], ((int[])object)[2], this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindTime2(((int[])object)[0], ((int[])object)[1], ((int[])object)[2], this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            case 11: {
                                n2 = !this.wasBound[n] ? this.SQLBindTimestamp(this.direction[n], n + 1, ((int[])object)[0], ((int[])object)[1], ((int[])object)[2], ((int[])object)[3], ((int[])object)[4], ((int[])object)[5], ((int[])object)[6], this.sqltypes[n], this.precisions[n], this.scales[n], this.parameters[n], this.parameters, this.statementHandle) : this.SQLBindTimestamp2(((int[])object)[0], ((int[])object)[1], ((int[])object)[2], ((int[])object)[3], ((int[])object)[4], ((int[])object)[5], ((int[])object)[6], this.parameters[n]);
                                this.sqlExcptGen.check_return_code(this, n2);
                                break;
                            }
                            default: {
                                this.sqlExcptGen.pstmtException("S1003");
                                break;
                            }
                        }
                    }
                    this.wasBound[n] = true;
                } else {
                    if (this.statementType == 27 && this.sqljDescribeInfo == null) {
                        this.checkForSQLJGraphic(n + 1);
                    }
                    if (DB2Trace.TraceOn && this.direction[n] != 4) {
                        DB2Trace.data(20, "Error: param[" + n + "].isSet()", "false");
                    }
                }
                ++n;
            }
            if (this.resultSet != null) {
                this.resultSet.realClose();
            }
            this.rowCount = 0;
            this.colCount = 0;
            this.checkParameters();
            this.returnCode = 0;
            this.returnCode = this.SQLExecute(this.statementHandle, this.resetParamSetSize);
            if (this.returnCode == 0 || this.returnCode == 1) {
                this.resetParamSetSize = false;
            }
            if (DB2Trace.TraceOn) {
                switch (this.returnCode) {
                    case 0: {
                        DB2Trace.data(10, "SQLExecute()- returnCode", "SQL_SUCCESS");
                        break;
                    }
                    case 99: {
                        DB2Trace.data(10, "SQLExecute()- returnCode", "SQL_NEED_DATA");
                        break;
                    }
                    case 100: {
                        DB2Trace.data(10, "SQLExecute()- returnCode", "SQL_NO_DATA_FOUND");
                        break;
                    }
                    default: {
                        DB2Trace.data(10, "SQLExecute()- returnCode", this.returnCode);
                        break;
                    }
                }
            }
            if (this.returnCode == 99) {
                this.returnCode = this.loadParameters();
            }
            if (this.returnCode == 100) {
                this.rowCount = 0;
                Object var2_5 = null;
                if (!DB2Trace.TraceOn) return;
                DB2Trace.data(20, "executed (Exit)", String.valueOf(this.executed));
                DB2Trace.methodExit(this, "execute2()");
                return;
            }
            if (this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            this.executed = true;
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(20, "executed (Exit)", String.valueOf(this.executed));
            DB2Trace.methodExit(this, "execute2()");
            throw throwable;
        }
        Object var2_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(20, "executed (Exit)", String.valueOf(this.executed));
        DB2Trace.methodExit(this, "execute2()");
    }

    public void setNull(int n, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setNull( " + n + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            if (n2 == 0) {
                this.sqlExcptGen.pstmtException("S1003");
            }
            int n3 = this.convert2SQLType(n2);
            int n4 = this.ctypes[n - 1];
            if (n4 == 0) {
                n4 = this.sqlType2cType(n3);
            }
            this.setDirection(n, n3, n4);
            this.paramRow[n - 1].set(-1, null);
        }
        catch (Throwable throwable) {
            block9: {
                Object var4_6 = null;
                if (!DB2Trace.TraceOn) break block9;
                DB2Trace.methodExit(this, "setNull()");
            }
            throw throwable;
        }
        Object var4_5 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setNull()");
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setBoolean(n, bl, 5);
    }

    protected void setBoolean(int n, boolean bl, int n2) throws SQLException {
        block5: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setBoolean( " + n + ", " + bl + ", " + n2 + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (bl) {
                    this.setShort(n, (short)1, n2);
                    break block5;
                }
                this.setShort(n, (short)0, n2);
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (!DB2Trace.TraceOn) break block6;
                    DB2Trace.methodExit(this, "setBoolean()");
                }
                throw throwable;
            }
        }
        Object var5_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setBoolean()");
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setByte(n, by, 5);
    }

    protected void setByte(int n, byte by, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setByte( " + n + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            this.setShort(n, by, n2);
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                if (!DB2Trace.TraceOn) break block4;
                DB2Trace.methodExit(this, "setByte()");
            }
            throw throwable;
        }
        Object var5_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setByte()");
        }
    }

    public void setShort(int n, short s) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setShort(n, s, 5);
    }

    protected void setShort(int n, short s, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setShort( " + n + ", " + s + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            this.setDirection(n, n2, 5);
            this.paramRow[n - 1].set(0, s);
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_5 = null;
                if (!DB2Trace.TraceOn) break block5;
                DB2Trace.methodExit(this, "setShort()");
            }
            throw throwable;
        }
        Object var5_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setShort()");
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setInt(n, n2, 4);
    }

    protected void setInt(int n, int n2, int n3) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setInt( " + n + ", " + n2 + ", " + n3 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            this.setDirection(n, n3, 4);
            this.paramRow[n - 1].set(0, n2);
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_5 = null;
                if (!DB2Trace.TraceOn) break block5;
                DB2Trace.methodExit(this, "setInt()");
            }
            throw throwable;
        }
        Object var5_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setInt()");
        }
    }

    public void setLong(int n, long l) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setLong(n, l, -5);
    }

    protected void setLong(int n, long l, int n2) throws SQLException {
        block6: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setLong( " + n + ", " + l + ", " + n2 + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (n < 1 || n > this.maxNumParams) {
                    this.sqlExcptGen.throwParamIndexError();
                }
                int n3 = this.convert2SQLType(-5);
                this.setDirection(n, n3, -25);
                if (n3 == -5) {
                    this.paramRow[n - 1].set(0, l);
                    break block6;
                }
                this.paramRow[n - 1].set(0, (int)l);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_6 = null;
                    if (!DB2Trace.TraceOn) break block7;
                    DB2Trace.methodExit(this, "setLong()");
                }
                throw throwable;
            }
        }
        Object var6_5 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setLong()");
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setFloat(n, f, 7);
    }

    protected void setFloat(int n, float f, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFloat( " + n + ", " + f + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            n2 = this.convert2SQLType(n2);
            this.setDirection(n, n2, 7);
            this.paramRow[n - 1].set(0, f);
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_5 = null;
                if (!DB2Trace.TraceOn) break block5;
                DB2Trace.methodExit(this, "setFloat()");
            }
            throw throwable;
        }
        Object var5_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setFloat()");
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setDouble(n, d, 8);
    }

    protected void setDouble(int n, double d, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setDouble( " + n + ", " + d + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (n < 1 || n > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            this.setDirection(n, n2, 8);
            this.paramRow[n - 1].set(0, d);
        }
        catch (Throwable throwable) {
            block5: {
                Object var6_5 = null;
                if (!DB2Trace.TraceOn) break block5;
                DB2Trace.methodExit(this, "setDouble()");
            }
            throw throwable;
        }
        Object var6_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setDouble()");
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setBigDecimal(n, bigDecimal, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setBigDecimal(int n, BigDecimal bigDecimal, int n2) throws SQLException {
        block6: {
            block5: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setBigDecimal( " + n + ", " + bigDecimal + ", " + n2 + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    if (bigDecimal == null) {
                        this.setNull(n, n2);
                        Object var5_4 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block5;
                    }
                    this.setDirection(n, n2, -8);
                    int n3 = n - 1;
                    this.setPrecisionAndScale(n3, bigDecimal);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setBigDecimal()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setBigDecimal()");
            return;
        }
        Object var5_5 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setBigDecimal()");
    }

    protected void setPrecisionAndScale(int n, BigDecimal bigDecimal) {
        block11: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setPrecisionAndScale( " + n + ", " + bigDecimal + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.statementType == 27 && this.sqljDescribeInfo != null) {
                    this.maxWholeDigits[n] = (int)(this.precisions[n] - (long)this.scales[n]);
                    this.paramRow[n].set((int)this.precisions[n], bigDecimal.toString());
                    break block11;
                }
                String string = bigDecimal.abs().toString();
                int n2 = 0;
                int n3 = string.length();
                if (string.indexOf(46) != -1) {
                    n2 = 1;
                }
                int n4 = 0;
                while (n4 < n3) {
                    if (!string.startsWith("0", n4)) break;
                    ++n2;
                    ++n4;
                }
                int n5 = bigDecimal.scale();
                int n6 = n3 - n2;
                int n7 = (n6 = Math.max(n6, 1)) - n5;
                if (n7 > this.maxWholeDigits[n]) {
                    this.maxWholeDigits[n] = n7;
                }
                if (n5 > this.scales[n]) {
                    this.scales[n] = n5;
                } else {
                    n6 += this.scales[n] - n5;
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "scale", n5);
                    DB2Trace.data(10, "precision", n6);
                }
                this.paramRow[n].set(n6, bigDecimal.toString());
            }
            catch (Throwable throwable) {
                block12: {
                    Object var4_11 = null;
                    if (!DB2Trace.TraceOn) break block12;
                    DB2Trace.methodExit(this, "setPrecisionAndScale()");
                }
                throw throwable;
            }
        }
        Object var4_10 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setPrecisionAndScale()");
        }
    }

    public void setString(int n, String string) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (string == null) {
            int n2 = n - 1;
            if (this.ctypes[n2] == 0) {
                this.ctypes[n2] = -8;
                this.wasBound[n2] = false;
            }
            this.setDirection(n, 0, this.ctypes[n2]);
            this.paramRow[n - 1].set(-1, null);
            return;
        }
        this.setString(n, string, 0, -1);
    }

    protected void setString(int n, String string, int n2) throws SQLException {
        this.setString(n, string, n2, -1);
    }

    protected void setString(int n, String string, int n2, int n3) throws SQLException {
        block8: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setString( " + n + ", " + string + ", " + n2 + ", " + n3 + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.connection.closed && this.maxFieldSize != 0 && string.length() > this.maxFieldSize) {
                    string = string.substring(0, this.maxFieldSize);
                }
                this.setDirection(n, n2, -8, n3);
                int n4 = string.length();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "String length", n4);
                }
                this.paramRow[n - 1].set(n4, string);
                if (n3 <= 0) {
                    if (n4 > this.maxWholeDigits[n - 1]) {
                        this.maxWholeDigits[n - 1] = n4;
                    }
                    break block8;
                }
                int n5 = n4 - n3;
                if (n5 <= this.maxWholeDigits[n - 1]) break block8;
                this.maxWholeDigits[n - 1] = n5;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_8 = null;
                    if (!DB2Trace.TraceOn) break block9;
                    DB2Trace.methodExit(this, "setString()");
                }
                throw throwable;
            }
        }
        Object var6_7 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setString()");
        }
    }

    protected byte[] toByteArray(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        while (n < cArray.length) {
            byArray[n * 2] = (byte)((cArray[n] & 0xFF00) >> 8);
            byArray[n * 2 + 1] = (byte)(cArray[n] & 0xFF);
            ++n;
        }
        return byArray;
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (byArray == null) {
            int n2 = n - 1;
            if (this.ctypes[n2] == 0) {
                this.ctypes[n2] = -2;
                this.wasBound[n2] = false;
            }
            this.setDirection(n, 0, this.ctypes[n2]);
            this.paramRow[n - 1].set(-1, null);
            return;
        }
        this.setBytes(n, byArray, 0);
    }

    protected void setBytes(int n, byte[] byArray, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setBytes( " + n + ", " + n2 + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            switch (n2) {
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 91: 
                case 92: 
                case 93: {
                    this.sqlExcptGen.pstmtException("22003");
                    break;
                }
            }
            if (this.maxFieldSize != 0 && byArray.length > this.maxFieldSize) {
                byte[] byArray2 = byArray;
                byArray = new byte[this.maxFieldSize];
                System.arraycopy(byArray2, 0, byArray, 0, this.maxFieldSize);
            }
            this.setDirection(n, n2, -2);
            this.paramRow[n - 1].set(byArray.length, byArray);
        }
        catch (Throwable throwable) {
            block8: {
                Object var5_6 = null;
                if (!DB2Trace.TraceOn) break block8;
                DB2Trace.methodExit(this, "setBytes()");
            }
            throw throwable;
        }
        Object var5_5 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setBytes()");
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, 91, Calendar.getInstance());
    }

    protected void setDate(int n, Date date, int n2) throws SQLException {
        this.setDate(n, date, n2, Calendar.getInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setDate(int n, Date date, int n2, Calendar calendar) throws SQLException {
        block9: {
            block8: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setDate( " + n + ", sqlType=" + n2 + ", Date=" + date + ",calTimeZone=" + calendar.getTimeZone().getID() + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    if (date == null) {
                        this.setNull(n, n2);
                        Object var6_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block8;
                    }
                    this.setDirection(n, n2, 9);
                    calendar = (Calendar)calendar.clone();
                    calendar.setTime(date);
                    int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5)};
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Year", nArray[0]);
                        DB2Trace.data(10, "Month", nArray[1]);
                        DB2Trace.data(10, "Day", nArray[2]);
                    }
                    this.paramRow[n - 1].set(0, nArray);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setDate()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setDate()");
            return;
        }
        Object var6_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setDate()");
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, 92, Calendar.getInstance());
    }

    protected void setTime(int n, Time time, int n2) throws SQLException {
        this.setTime(n, time, n2, Calendar.getInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setTime(int n, Time time, int n2, Calendar calendar) throws SQLException {
        block9: {
            block8: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setTime( " + n + ",sqlType=" + n2 + ", Time=" + time + ", calTimeZone=" + calendar.getTimeZone().getID() + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    if (time == null) {
                        this.setNull(n, n2);
                        Object var6_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block8;
                    }
                    this.setDirection(n, n2, 10);
                    calendar = (Calendar)calendar.clone();
                    calendar.setTime(time);
                    int[] nArray = new int[]{calendar.get(11), calendar.get(12), calendar.get(13)};
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Hour", nArray[0]);
                        DB2Trace.data(10, "Minute", nArray[1]);
                        DB2Trace.data(10, "Second", nArray[2]);
                    }
                    this.paramRow[n - 1].set(0, nArray);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setTime()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setTime()");
            return;
        }
        Object var6_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setTime()");
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, 93, Calendar.getInstance());
    }

    protected void setTimestamp(int n, Timestamp timestamp, int n2) throws SQLException {
        this.setTimestamp(n, timestamp, n2, Calendar.getInstance());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setTimestamp(int n, Timestamp timestamp, int n2, Calendar calendar) throws SQLException {
        block9: {
            block8: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setTimestamp( " + n + ", sqlType=" + n2 + ",TimeStamp=" + timestamp + ", calTimeZone=" + calendar.getTimeZone().getID() + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    if (timestamp == null) {
                        this.setNull(n, n2);
                        Object var6_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block8;
                    }
                    this.setDirection(n, n2, 11);
                    calendar = (Calendar)calendar.clone();
                    calendar.setTime(timestamp);
                    int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), timestamp.getNanos()};
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Year", nArray[0]);
                        DB2Trace.data(10, "Month", nArray[1]);
                        DB2Trace.data(10, "Day", nArray[2]);
                        DB2Trace.data(10, "Hour_of_Day", nArray[3]);
                        DB2Trace.data(10, "Minute", nArray[4]);
                        DB2Trace.data(10, "Second", nArray[5]);
                        DB2Trace.data(10, "Nano", nArray[6]);
                    }
                    this.paramRow[n - 1].set(0, nArray);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setTimestamp()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setTimestamp()");
            return;
        }
        Object var6_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setTimestamp()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        block11: {
            block10: {
                block9: {
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "setAsciiStream(" + n + ", " + inputStream + ", " + n2 + " )");
                            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        if (this.closed) {
                            this.sqlExcptGen.throwClosedError();
                        }
                        if (n < 1 || n > this.maxNumParams) {
                            this.sqlExcptGen.throwParamIndexError();
                        }
                        if (inputStream == null) {
                            int n3 = n - 1;
                            if (this.ctypes[n3] == 0) {
                                this.ctypes[n3] = 1;
                                this.wasBound[n3] = false;
                            }
                            this.setDirection(n, 0, this.ctypes[n3]);
                            this.paramRow[n - 1].set(-1, null);
                            Object var5_6 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block9;
                        }
                        if (n2 == 0) {
                            String string = new String();
                            this.setString(n, string);
                            break block10;
                        }
                        this.setDirection(n, 0, 1);
                        this.paramRow[n - 1].set(n2, inputStream, true, false);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit(this, "setAsciiStream()");
                        throw throwable;
                    }
                }
                DB2Trace.methodExit(this, "setAsciiStream()");
                return;
            }
            Object var5_7 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "setAsciiStream()");
            return;
        }
        Object var5_8 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setAsciiStream()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        block13: {
            block12: {
                block11: {
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "setUnicodeStream(" + n + ", " + n2 + " )");
                            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        if (this.closed) {
                            this.sqlExcptGen.throwClosedError();
                        }
                        if (n < 1 || n > this.maxNumParams) {
                            this.sqlExcptGen.throwParamIndexError();
                        }
                        if (inputStream == null) {
                            int n3 = n - 1;
                            if (this.ctypes[n3] == 0) {
                                this.ctypes[n3] = -8;
                                this.wasBound[n3] = false;
                            }
                            this.setDirection(n, 0, this.ctypes[n3]);
                            this.paramRow[n - 1].set(-1, null);
                            Object var5_7 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block11;
                        }
                        if (n2 == 0) {
                            String string = new String();
                            this.setString(n, string);
                            break block12;
                        }
                        this.setDirection(n, 0, -8);
                        InputStreamReader inputStreamReader = null;
                        try {
                            inputStreamReader = new InputStreamReader(inputStream, "UnicodeBig");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            unsupportedEncodingException.printStackTrace();
                        }
                        this.paramRow[n - 1].set(n2 / 2, inputStreamReader, true, true);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit(this, "setUnicodeStream()");
                        throw throwable;
                    }
                }
                DB2Trace.methodExit(this, "setUnicodeStream()");
                return;
            }
            Object var5_8 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit(this, "setUnicodeStream()");
            return;
        }
        Object var5_9 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setUnicodeStream()");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (inputStream == null) {
            int n3 = n - 1;
            if (this.ctypes[n3] == 0) {
                this.ctypes[n3] = -2;
                this.wasBound[n3] = false;
            }
            this.setDirection(n, 0, this.ctypes[n3]);
            this.paramRow[n - 1].set(-1, null);
            return;
        }
        this.setBinaryStream(n, inputStream, n2, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setBinaryStream(int n, InputStream inputStream, int n2, int n3) throws SQLException {
        block5: {
            block4: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setBinaryStream( " + n + " , " + inputStream + ", " + n2 + " , " + n3 + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (n2 == 0) {
                        this.setBytes(n, new byte[0], n3);
                        Object var6_5 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block4;
                    }
                    this.setDirection(n, n3, -2);
                    this.paramRow[n - 1].set(n2, inputStream, true, false);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit(this, "setBinaryStream()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setBinaryStream()");
            return;
        }
        Object var6_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "setBinaryStream()");
    }

    public void clearParameters() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "clearParameters()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (this.parameters != null && this.maxNumParams != 0) {
                this.freeArrays(this.maxNumParams, this.parameters);
            }
            int n = 0;
            while (n < this.maxNumParams) {
                this.parameters[n] = 0L;
                this.paramRow[n].unset();
                this.wasBound[n] = false;
                ++n;
            }
            this.SQLFreeStmtClearParameters(this.statementHandle);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            DB2Trace.methodExit(this, "clearParameters()");
            throw throwable;
        }
        Object var2_2 = null;
        DB2Trace.methodExit(this, "clearParameters()");
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, 0, -1);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        block45: {
            block44: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setObject( " + n + ", " + object + ", " + n2 + ", " + n3 + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (n < 1 || n > this.maxNumParams) {
                        this.sqlExcptGen.throwParamIndexError();
                    }
                    if (object == null) {
                        this.setNull(n, n2);
                        Object var6_5 = null;
                        break block44;
                    }
                    if (n2 == 0) {
                        try {
                            if (object instanceof String) {
                                this.setString(n, (String)object);
                                break block45;
                            }
                            if (object instanceof Character) {
                                this.setString(n, ((Character)object).toString());
                                break block45;
                            }
                            if (object instanceof BigDecimal) {
                                BigDecimal bigDecimal = n3 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n3, 4);
                                this.setBigDecimal(n, bigDecimal);
                                break block45;
                            }
                            if (object instanceof Boolean) {
                                this.setBoolean(n, (Boolean)object);
                                break block45;
                            }
                            if (object instanceof Short) {
                                this.setShort(n, (Short)object);
                                break block45;
                            }
                            if (object instanceof Integer) {
                                this.setInt(n, (Integer)object);
                                break block45;
                            }
                            if (object instanceof Long) {
                                this.setLong(n, (Long)object);
                                break block45;
                            }
                            if (object instanceof Float) {
                                this.setFloat(n, ((Float)object).floatValue());
                                break block45;
                            }
                            if (object instanceof Double) {
                                this.setDouble(n, (Double)object);
                                break block45;
                            }
                            if (object instanceof byte[]) {
                                this.setBytes(n, (byte[])object);
                                break block45;
                            }
                            if (object instanceof Date) {
                                this.setDate(n, (Date)object);
                                break block45;
                            }
                            if (object instanceof Time) {
                                this.setTime(n, (Time)object);
                                break block45;
                            }
                            if (object instanceof Timestamp) {
                                this.setTimestamp(n, (Timestamp)object);
                                break block45;
                            }
                            this.sqlExcptGen.pstmtException("S1003");
                        }
                        catch (ClassCastException classCastException) {
                            this.sqlExcptGen.pstmtException("S1003");
                        }
                        break block45;
                    }
                    n2 = this.convert2SQLType(n2);
                    try {
                        if (object instanceof String) {
                            if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 7) {
                                this.setString(n, DB2PreparedStatement.translateFloat((String)object), n2, n3);
                                break block45;
                            } else {
                                this.setString(n, (String)object, n2);
                            }
                            break block45;
                        }
                        if (object instanceof Character) {
                            if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 7) {
                                this.setString(n, DB2PreparedStatement.translateFloat(((Character)object).toString()), n2, n3);
                                break block45;
                            } else {
                                this.setString(n, ((Character)object).toString(), n2);
                            }
                            break block45;
                        }
                        if (object instanceof BigDecimal) {
                            BigDecimal bigDecimal = n3 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n3, 4);
                            this.setBigDecimal(n, bigDecimal, n2);
                            break block45;
                        }
                        if (object instanceof Boolean) {
                            if (n2 == 1 || n2 == 12 || n2 == -1 || n2 == -99) {
                                this.setString(n, ((Boolean)object).toString(), n2);
                                break block45;
                            } else {
                                this.setBoolean(n, (Boolean)object, n2);
                            }
                            break block45;
                        }
                        if (object instanceof Short) {
                            this.setShort(n, (Short)object, n2);
                            break block45;
                        }
                        if (object instanceof Integer) {
                            this.setInt(n, (Integer)object, n2);
                            break block45;
                        }
                        if (object instanceof Long) {
                            this.setLong(n, (Long)object, n2);
                            break block45;
                        }
                        if (object instanceof Float) {
                            this.setFloat(n, ((Float)object).floatValue(), n2);
                            break block45;
                        }
                        if (object instanceof Double) {
                            this.setDouble(n, (Double)object, n2);
                            break block45;
                        }
                        if (object instanceof byte[]) {
                            this.setBytes(n, (byte[])object, n2);
                            break block45;
                        }
                        if (object instanceof Date) {
                            this.setDate(n, (Date)object, n2);
                            break block45;
                        }
                        if (object instanceof Time) {
                            this.setTime(n, (Time)object, n2);
                            break block45;
                        }
                        if (object instanceof Timestamp) {
                            this.setTimestamp(n, (Timestamp)object, n2);
                            break block45;
                        }
                        this.sqlExcptGen.pstmtException("S1003");
                    }
                    catch (ClassCastException classCastException) {
                        this.sqlExcptGen.pstmtException("S1003");
                    }
                    break block45;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    DB2Trace.methodExit(this, "setObject()");
                    throw throwable;
                }
            }
            DB2Trace.methodExit(this, "setObject()");
            return;
        }
        Object var6_6 = null;
        DB2Trace.methodExit(this, "setObject()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws SQLException {
        boolean bl;
        boolean bl2;
        block5: {
            boolean bl3;
            block4: {
                bl2 = false;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "execute()");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    this.execute2();
                    this.getResultSet();
                    if (this.resultSet.numCols > 0) {
                        bl2 = true;
                        bl3 = true;
                        Object var4_4 = null;
                        if (!DB2Trace.TraceOn) return bl3;
                        break block4;
                    }
                    bl2 = false;
                    bl = false;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "execute()", bl2);
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "execute()", bl2);
            return bl3;
        }
        Object var4_5 = null;
        if (!DB2Trace.TraceOn) return bl;
        DB2Trace.methodExit((Object)this, "execute()", bl2);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2ParameterMetaData getParameterMetaData() throws SQLException {
        DB2ParameterMetaData dB2ParameterMetaData;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getParameterMetaData()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            dB2ParameterMetaData = new DB2ParameterMetaData(this);
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2ParameterMetaData;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getParameterMetaData()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getParameterMetaData()");
        return dB2ParameterMetaData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2ResultSetMetaData getResultSetMetaData() throws SQLException {
        DB2ResultSetMetaData dB2ResultSetMetaData;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getResultSetMetaData()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            dB2ResultSetMetaData = new DB2ResultSetMetaData(this);
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2ResultSetMetaData;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getParameterMetaData()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getParameterMetaData()");
        return dB2ResultSetMetaData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int convert2SQLType(int n) throws SQLException {
        int n2;
        int n3 = n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "convert2SQLType( " + n + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            switch (n3) {
                case -7: 
                case -6: {
                    n3 = 5;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
                case 6: {
                    n3 = 8;
                    break;
                }
                case -5: {
                    n3 = -5;
                    break;
                }
                case 7: {
                    n3 = this.connection.getRealSqlType();
                    break;
                }
                case 70: {
                    n3 = -400;
                    break;
                }
            }
            n2 = n3;
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "convert2SQLType()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "convert2SQLType()", n3);
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int sqlType2cType(int n) {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "sqlType2cType( " + n + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            switch (n) {
                case -5: {
                    n3 = -25;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = -8;
                    break;
                }
                case -98: 
                case -4: 
                case -3: 
                case -2: {
                    n3 = -2;
                    break;
                }
                case -400: 
                case -99: 
                case -1: 
                case 1: 
                case 12: 
                case 70: {
                    n3 = -8;
                    break;
                }
                case 91: {
                    n3 = 9;
                    break;
                }
                case 92: {
                    n3 = 10;
                    break;
                }
                case 93: {
                    n3 = 11;
                    break;
                }
                default: {
                    n3 = n;
                }
            }
            n2 = n3;
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "sqlType2cType()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "sqlType2cType()", n3);
        return n2;
    }

    private static String translateFloat(String string) {
        char c = new DecimalFormatSymbols().getDecimalSeparator();
        if (c != '.') {
            return string.replace(c, '.');
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setPrecision(int n) throws SQLException {
        int n2;
        block18: {
            block16: {
                n2 = n - 1;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "setPrecision( " + n + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.described[n2] == 1) {
                        Object var4_3 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block16;
                    }
                    long l = this.precisions[n2];
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "precisions[" + n2 + "]", this.precisions[n2]);
                        DB2Trace.data(20, "direction[" + n2 + "]", this.direction[n2]);
                        DB2Trace.data(20, "ctypes[" + n2 + "]", this.ctypes[n2]);
                        DB2Trace.data(20, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
                    }
                    if (this.direction[n2] != 1 && (this.ctypes[n2] == 1 || this.ctypes[n2] == -8 || this.ctypes[n2] == -2)) {
                        if (this.sqltypes[n2] == 1 || this.sqltypes[n2] == 12 || this.sqltypes[n2] == -1 || this.sqltypes[n2] == -2 || this.sqltypes[n2] == -3 || this.sqltypes[n2] == -4 || this.sqltypes[n2] == -95 || this.sqltypes[n2] == -96 || this.sqltypes[n2] == -97) {
                            if (this.described[n2] != 2 && this.connection.isDescribeParamSupported()) {
                                try {
                                    this.describeParam(n);
                                }
                                catch (SQLException sQLException) {
                                    if (!sQLException.getSQLState().equals("HYC00")) {
                                        throw sQLException;
                                    }
                                    if (DB2Trace.TraceOn) {
                                        DB2Trace.data(10, "Ignoring SQLState", "HYC00");
                                    }
                                }
                            }
                        } else if (this.sqltypes[n2] == -98 || this.sqltypes[n2] == -99 || this.sqltypes[n2] == -350) {
                            this.describeParam(n);
                        }
                    }
                    if (this.described[n2] != 1) {
                        this.precisions[n2] = this.connection.getTypeMaxLength(this.sqltypes[n2]);
                    }
                    if (this.precisions[n2] != l) {
                        this.wasBound[n2] = false;
                    }
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "wasBound[" + n2 + "]", String.valueOf(this.wasBound[n2]));
                    DB2Trace.data(10, "precisions[" + n2 + "]", this.precisions[n2]);
                    DB2Trace.methodExit(this, "setPrecision()");
                    throw throwable;
                }
            }
            DB2Trace.data(10, "wasBound[" + n2 + "]", String.valueOf(this.wasBound[n2]));
            DB2Trace.data(10, "precisions[" + n2 + "]", this.precisions[n2]);
            DB2Trace.methodExit(this, "setPrecision()");
            return;
        }
        Object var4_4 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "wasBound[" + n2 + "]", String.valueOf(this.wasBound[n2]));
        DB2Trace.data(10, "precisions[" + n2 + "]", this.precisions[n2]);
        DB2Trace.methodExit(this, "setPrecision()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void describeParam(int n) throws SQLException {
        int n2;
        int n3;
        block7: {
            block6: {
                n3 = 0;
                n2 = n - 1;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "describeParam( " + n + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.described[n2] == 1) {
                        Object var5_4 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block6;
                    }
                    n3 = this.SQLDescribeParam(this.statementHandle, n, this.sqltypes, this.precisions, this.scales);
                    if (n3 == 0) {
                        this.described[n2] = 1;
                        this.sqltypeGuessed[n2] = false;
                        break block7;
                    } else {
                        this.described[n2] = 2;
                        this.sqlExcptGen.check_return_code(this, n3);
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "described[" + n2 + "]", this.described[n2]);
                    DB2Trace.data(10, "sqltypeGuessed[" + n2 + "]", String.valueOf(this.sqltypeGuessed[n2]));
                    DB2Trace.methodExit((Object)this, "describeParam()", n3);
                    throw throwable;
                }
            }
            DB2Trace.data(10, "described[" + n2 + "]", this.described[n2]);
            DB2Trace.data(10, "sqltypeGuessed[" + n2 + "]", String.valueOf(this.sqltypeGuessed[n2]));
            DB2Trace.methodExit((Object)this, "describeParam()", n3);
            return;
        }
        Object var5_5 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "described[" + n2 + "]", this.described[n2]);
        DB2Trace.data(10, "sqltypeGuessed[" + n2 + "]", String.valueOf(this.sqltypeGuessed[n2]));
        DB2Trace.methodExit((Object)this, "describeParam()", n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void guessSQLType(int n, int n2) throws SQLException {
        int n3;
        block19: {
            block18: {
                block17: {
                    n3 = n - 1;
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "guessSQLType( " + n + "," + n2 + ")");
                        }
                        if (this.sqltypes[n3] != 0 && !this.sqltypeGuessed[n3]) {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Cannot override user provided sqlType");
                            }
                            Object var5_4 = null;
                            if (!DB2Trace.TraceOn) return;
                            break block17;
                        }
                        this.sqltypeGuessed[n3] = true;
                        if (this.sqltypes[n3] == -99 || this.sqltypes[n3] == -350 || this.sqltypes[n3] == -98) {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "sqlType already at maximum type (LOB)");
                            }
                            break block18;
                        }
                        int n4 = n2;
                        int n5 = this.sqltypes[n3];
                        if (n2 == -1) {
                            n2 = 0;
                        } else if (this.ctypes[n3] == 1 || this.ctypes[n3] == -8) {
                            n2 *= 3;
                        }
                        if (!(n2 > this.connection.getTypeMaxLength(12) || this.paramRow[n3].isStream() || this.ctypes[n3] == 1 && this.sqltypes[n3] == -1 || this.ctypes[n3] == -8 && this.sqltypes[n3] == -1 || this.ctypes[n3] == -2 && this.sqltypes[n3] == -4)) {
                            this.sqltypes[n3] = this.ctypes[n3] == -2 ? -3 : 12;
                        } else if (n2 <= this.connection.getTypeMaxLength(-1) || !this.connection.isLOBSupported()) {
                            this.sqltypes[n3] = this.ctypes[n3] == -2 ? -4 : -1;
                        } else {
                            if (n4 <= this.connection.getTypeMaxLength(-1) && this.connection.isDescribeParamSupported()) {
                                this.describeParam(n);
                            }
                            if (this.described[n3] != 1) {
                                int n6 = this.sqltypes[n3] = this.ctypes[n3] == -2 ? -98 : -99;
                            }
                        }
                        if (this.sqltypes[n3] != n5) {
                            this.wasBound[n3] = false;
                        }
                        break block19;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.data(20, "sqltype[" + n3 + "]", this.sqltypes[n3]);
                        DB2Trace.data(20, "wasBound[" + n3 + "]", String.valueOf(this.wasBound[n3]));
                        DB2Trace.data(20, "length", n2);
                        DB2Trace.methodExit(this, "guessSQLType");
                        throw throwable;
                    }
                }
                DB2Trace.data(20, "sqltype[" + n3 + "]", this.sqltypes[n3]);
                DB2Trace.data(20, "wasBound[" + n3 + "]", String.valueOf(this.wasBound[n3]));
                DB2Trace.data(20, "length", n2);
                DB2Trace.methodExit(this, "guessSQLType");
                return;
            }
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.data(20, "sqltype[" + n3 + "]", this.sqltypes[n3]);
            DB2Trace.data(20, "wasBound[" + n3 + "]", String.valueOf(this.wasBound[n3]));
            DB2Trace.data(20, "length", n2);
            DB2Trace.methodExit(this, "guessSQLType");
            return;
        }
        Object var5_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(20, "sqltype[" + n3 + "]", this.sqltypes[n3]);
        DB2Trace.data(20, "wasBound[" + n3 + "]", String.valueOf(this.wasBound[n3]));
        DB2Trace.data(20, "length", n2);
        DB2Trace.methodExit(this, "guessSQLType");
    }

    class PrimitiveData {
        double doubleVal;
        int intVal;
        float floatVal;
        long longVal;
        short shortVal;

        public PrimitiveData() {
            DB2PreparedStatement.this = DB2PreparedStatement.this;
        }

        public double doubleValue() {
            return this.doubleVal;
        }

        public int intValue() {
            return this.intVal;
        }

        public float floatValue() {
            return this.floatVal;
        }

        public long longValue() {
            return this.longVal;
        }

        public short shortValue() {
            return this.shortVal;
        }

        public void set(double d) {
            this.doubleVal = d;
        }

        public void set(int n) {
            this.intVal = n;
        }

        public void set(float f) {
            this.floatVal = f;
        }

        public void set(long l) {
            this.longVal = l;
        }

        public void set(short s) {
            this.shortVal = s;
        }
    }

    class ParamElement {
        int length;
        Object value;
        boolean isStream;
        boolean doConversion;
        boolean fSet = false;
        PrimitiveData primitiveData = new PrimitiveData();

        public ParamElement() {
            DB2PreparedStatement.this = DB2PreparedStatement.this;
        }

        public ParamElement(int n, Object object) {
            DB2PreparedStatement.this = DB2PreparedStatement.this;
            this.length = n;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = false;
            this.doConversion = false;
            this.fSet = true;
        }

        public ParamElement(int n, Object object, boolean bl, boolean bl2) {
            this(n, object);
            this.isStream = bl;
            this.doConversion = bl2;
        }

        public void set(int n, double d) {
            this.primitiveData.set(d);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, int n2) {
            this.primitiveData.set(n2);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, float f) {
            this.primitiveData.set(f);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, long l) {
            this.primitiveData.set(l);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, short s) {
            this.primitiveData.set(s);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, Object object) {
            this.set(n, object, false, false);
        }

        public void set(int n, Object object, boolean bl, boolean bl2) {
            this.length = n;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = bl;
            this.doConversion = bl2;
            this.fSet = true;
        }

        public void unset() {
            this.fSet = false;
            this.value = null;
        }

        public final boolean isSet() {
            return this.fSet;
        }

        public final int getLength() {
            return this.length;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean isStream() {
            return this.isStream;
        }

        public final boolean doConversion() {
            return this.doConversion;
        }
    }
}

