/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Binary2AsciiInputStream;
import COM.ibm.db2.jdbc.app.DB2Binary2UnicodeInputStream;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaData;
import COM.ibm.db2.jdbc.app.DB2ResultSetMetaDataTrace;
import COM.ibm.db2.jdbc.app.DB2Statement;
import COM.ibm.db2.jdbc.app.DB2UnicodeStream;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2ResultSet
implements ResultSet {
    private Hashtable name2Index;
    private DB2ResultSetMetaData rsMetaData;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected SQLExceptionGenerator sqlExcptGen;
    protected int numCols;
    protected boolean mappedRS = false;
    protected boolean nullTag = true;
    protected boolean closed = false;
    protected Vector isList = new Vector();
    protected int currentRowId;
    private int year;
    private int month;
    private int date;
    private int hour;
    private int minute;
    private int second;
    private int nano;
    private int sqlSuccess = 0;
    protected int maxFieldSize;
    protected int[] colTypes;
    protected int[] colSizes;
    protected String[] mappedColumnNames;
    protected int returnCode;
    protected int returnLen;

    protected native int SQLGetColumnCount(int var1);

    protected native int SQLSetPos(int var1, int var2, int var3, int var4);

    protected native int SQLFetchScroll(int var1, int var2, int var3, int var4);

    protected native int SQLFetch(int var1);

    protected native int SQLFreeStmtClose(int var1);

    protected native String SQLGetCursorName(int var1, int var2);

    protected native int SQLGetDateData(int var1, int var2);

    protected native double SQLGetDoubleData(int var1, int var2);

    protected native float SQLGetFloatData(int var1, int var2);

    protected native int SQLGetIntegerData(int var1, int var2);

    protected native long SQLGetLongData(int var1, int var2);

    protected native int SQLGetLocator(int var1, int var2, Integer var3, int var4);

    protected native byte[] SQLGetLongBinaryData(int var1, int var2, int var3, int var4, int var5);

    protected native byte[] SQLGetLongCharData(int var1, int var2, int var3);

    protected native String SQLGetNumericStringData(int var1, int var2);

    protected native int SQLGetSmallIntData(int var1, int var2);

    protected native String SQLGetStringData(int var1, int var2, int var3, int var4, int var5);

    protected native int SQLGetTimeData(int var1, int var2);

    protected native int SQLGetTimestampData(int var1, int var2);

    protected native int SQLGetType(int var1, int var2, int var3);

    protected native byte[] SQLGetRowDataInternal(int var1);

    public String toString() {
        return this.toString("", true);
    }

    protected String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2ResultSet \r\n" + string + "{");
        if (bl) {
            if (this.statement != null) {
                stringBuffer.append(String.valueOf(this.statement.toString(String.valueOf(string) + "    Statement -> ", false)) + "\r\n");
            } else {
                stringBuffer.append(String.valueOf(string) + "    Statement -> null\r\n    ");
            }
        } else {
            stringBuffer.append("\r\n");
        }
        stringBuffer.append(String.valueOf(string) + "    numCols = " + this.numCols + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    mappedRS = " + this.mappedRS + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    nullTag = " + this.nullTag + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    closed = " + this.closed + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    maxFieldSize = " + this.maxFieldSize + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    returnCode = " + this.returnCode + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    returnLen = " + this.returnLen + "\r\n");
        int n = 0;
        while (n < this.numCols) {
            stringBuffer.append(String.valueOf(string) + "    colTypes[" + n + "] = " + this.colTypes[n] + "\r\n");
            stringBuffer.append(String.valueOf(string) + "    colSizes[" + n + "] = " + this.colSizes[n] + "\r\n");
            ++n;
        }
        stringBuffer.append(String.valueOf(string) + "}\r\n");
        return stringBuffer.toString();
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2ResultSet( stmt, nCols=" + n + ")");
            }
            this.statement = dB2Statement;
            this.connection = this.statement.getDB2Connection();
            this.maxFieldSize = this.statement.maxFieldSize;
            this.sqlExcptGen = dB2Statement.sqlExcptGen;
            this.numCols = this.getColCount();
            this.nullTag = true;
            this.closed = false;
            this.mappedRS = false;
            this.rsMetaData = null;
            this.name2Index = null;
            this.colTypes = new int[this.numCols];
            this.colSizes = new int[this.numCols];
            int n2 = 0;
            while (n2 < this.numCols) {
                this.colTypes[n2] = 0;
                this.colSizes[n2] = 0;
                ++n2;
            }
        }
        catch (Throwable throwable) {
            block5: {
                Object var4_5 = null;
                if (!DB2Trace.TraceOn) break block5;
                DB2Trace.data(10, "numCols", this.numCols);
                DB2Trace.methodExit(this, "DB2ResultSet()");
            }
            throw throwable;
        }
        Object var4_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "numCols", this.numCols);
            DB2Trace.methodExit(this, "DB2ResultSet()");
        }
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n, int n2) throws SQLException {
        this(dB2Statement, n);
        this.numCols = n2;
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n, int n2, String[] stringArray) throws SQLException {
        this(dB2Statement, n);
        this.mappedColumnNames = stringArray;
        this.numCols = n2;
    }

    protected void addIsList(DB2InputStream dB2InputStream) {
        if (dB2InputStream != null) {
            this.isList.addElement(dB2InputStream);
        }
    }

    protected void clearIsList() throws SQLException {
        if (!this.isList.isEmpty()) {
            Enumeration enumeration = this.isList.elements();
            while (enumeration.hasMoreElements()) {
                DB2InputStream dB2InputStream = (DB2InputStream)enumeration.nextElement();
                dB2InputStream.close();
            }
            this.isList.removeAllElements();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getColType(int n, boolean bl) throws SQLException {
        int n2;
        int n3 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getColType( " + n + ", " + bl + " ) ");
            }
            if (this.colTypes != null) {
                n3 = this.colTypes[n - 1];
            }
            if (n3 == 0) {
                int n4 = 0;
                if (bl) {
                    n4 = 1;
                }
                this.returnCode = this.sqlSuccess;
                this.returnLen = 0;
                n3 = this.SQLGetType(n, n4, this.statement.statementHandle);
                if (this.returnCode != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "sqlType", n3);
                }
                switch (n3) {
                    case -97: 
                    case -10: {
                        n3 = -1;
                        break;
                    }
                    case -95: 
                    case -8: {
                        n3 = 1;
                        break;
                    }
                    case -96: 
                    case -9: {
                        n3 = 12;
                        break;
                    }
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "sqlType", n3);
                    DB2Trace.data(20, "returnLen", this.returnLen);
                }
                this.colTypes[n - 1] = n3;
                this.colSizes[n - 1] = this.returnLen;
            }
            n2 = n3;
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getColType()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getColType()", n3);
        return n2;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void setClosed(boolean bl) {
        this.closed = bl;
    }

    public boolean next() throws SQLException {
        boolean bl;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.clearIsList();
        this.clearWarnings();
        int n = this.SQLFetch(this.statement.statementHandle);
        if (n != 100) {
            if (n != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n);
            }
            this.closed = false;
            bl = true;
            ++this.currentRowId;
        } else {
            bl = false;
            this.currentRowId = 0;
        }
        return bl;
    }

    public boolean wasNull() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.nullTag;
    }

    public String getString(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getString2(n);
    }

    protected String getString2(int n) throws SQLException {
        String string;
        if (this.colTypes[n - 1] == 0) {
            this.getColType(n, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 1;
        Object object = this.connection;
        synchronized (object) {
            string = this.SQLGetStringData(n, this.colTypes[n - 1], this.colSizes[n - 1], this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
            return null;
        }
        if (this.returnLen == 0) {
            string = "";
        } else if (this.colTypes[n - 1] == -400) {
            object = new StringTokenizer(string, ",");
            String string2 = ((StringTokenizer)object).nextToken();
            string2 = ((StringTokenizer)object).nextToken();
            string2 = ((StringTokenizer)object).nextToken();
            int n2 = Integer.parseInt(string2);
            int n3 = string.lastIndexOf(44) + 1;
            string = string.substring(n3, n3 + n2);
        }
        this.nullTag = false;
        if (this.maxFieldSize != 0 && string.length() > this.maxFieldSize) {
            string = new String(string.substring(0, this.maxFieldSize));
        }
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getBoolean2(n);
    }

    protected boolean getBoolean2(int n) throws SQLException {
        short s;
        String string;
        boolean bl = false;
        if (this.colTypes[n - 1] == 0) {
            this.getColType(n, false);
        }
        bl = this.colTypes[n - 1] == 1 || this.colTypes[n - 1] == 12 || this.colTypes[n - 1] == -1 || this.colTypes[n - 1] == -99 ? ((string = this.getString(n)) == null ? false : ((string = string.trim()).equals("1") ? true : new Boolean(string))) : (s = this.getShort2(n)) != 0;
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getByte2(n);
    }

    protected byte getByte2(int n) throws SQLException {
        return (byte)this.getShort2(n);
    }

    public short getShort(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getShort2(n);
    }

    protected short getShort2(int n) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        int n2 = this.SQLGetSmallIntData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
        }
        return (short)n2;
    }

    public int getInt(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getInt2(n);
    }

    protected int getInt2(int n) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        int n2 = this.SQLGetIntegerData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
        }
        return n2;
    }

    public long getLong(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getLong2(n);
    }

    protected long getLong2(int n) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        long l = this.SQLGetLongData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
        }
        return l;
    }

    public float getFloat(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getFloat2(n);
    }

    protected float getFloat2(int n) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        float f = this.SQLGetFloatData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
        }
        return f;
    }

    public double getDouble(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getDouble2(n);
    }

    protected double getDouble2(int n) throws SQLException {
        this.nullTag = false;
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        double d = this.SQLGetDoubleData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
        }
        return d;
    }

    protected static String cvtScientific(String string) throws NumberFormatException {
        char c;
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < n) {
            c = string.charAt(n6);
            if (n2 < 0) {
                if (!Character.isWhitespace(c)) {
                    n2 = n5 = n6;
                    if (c == '.' || c == ',') {
                        n3 = n6;
                    }
                }
            } else if (n3 < 0 && n4 < 0 && (c == ',' || c == '.')) {
                n3 = n5 = n6;
            } else if (n4 < 0 && (c == 'e' || c == 'E')) {
                n4 = n5 = n6;
            } else if (!Character.isWhitespace(c)) {
                n5 = n6;
            }
            ++n6;
        }
        if (n2 < 0) {
            return "";
        }
        if (n4 < 0) {
            if (n2 > 0 || n5 < n - 1) {
                string = string.substring(n2, n5 + 1);
            }
            if (n3 >= 0 && string.charAt(n3) == ',') {
                string = string.replace(',', '.');
            }
        } else {
            int n7 = 1;
            int n8 = 0;
            n6 = n4 + 1;
            c = string.charAt(n6);
            if (c == '-') {
                n7 = -1;
                ++n6;
            } else if (c == '+') {
                ++n6;
            }
            while (n6 <= n5) {
                if (!Character.isDigit(c = string.charAt(n6++))) {
                    throw new NumberFormatException();
                }
                n8 = n8 * 10 + Character.digit(c, 10);
            }
            n8 *= n7;
            if (n3 >= 0) {
                n8 -= n4 - n3 - 1;
            }
            if ((c = string.charAt(n2)) == '-') {
                n7 = -1;
                ++n2;
            } else if (c == '+') {
                n7 = 1;
                ++n2;
            } else {
                n7 = 1;
            }
            int n9 = n4 - n2 - (n3 >= 0 ? 1 : 0);
            int n10 = 0;
            int n11 = -1;
            int n12 = 0;
            if (n8 >= 0) {
                n11 = -1;
                n10 = 0;
                n12 = n9 + n8;
            } else if (n8 < 0 && -n8 >= n9) {
                n11 = 0;
                n10 = -n8 - n9 + 1;
                n12 = n10 + n9;
            } else {
                n11 = n9 + n8;
                n10 = 0;
                n12 = n9 + 1;
            }
            if (n7 < 0) {
                if (n11 >= 0) {
                    ++n11;
                }
                ++n10;
                ++n12;
            }
            char[] cArray = new char[n12];
            n6 = 0;
            while (n6 < n12) {
                cArray[n6] = 48;
                ++n6;
            }
            if (n7 < 0) {
                cArray[0] = 45;
            }
            if (n11 >= 0) {
                cArray[n11] = 46;
            }
            n6 = n10;
            int n13 = n2;
            while (n13 < n4) {
                if (n13 == n3 && ++n13 >= n4) break;
                if (n6 == n11) {
                    ++n6;
                }
                cArray[n6] = string.charAt(n13);
                ++n6;
                ++n13;
            }
            string = new String(cArray);
        }
        return string;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getBigDecimal2(n, n2);
    }

    protected BigDecimal getBigDecimal2(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal2(n);
        if (bigDecimal == null || n2 == -1) {
            return bigDecimal;
        }
        return bigDecimal.setScale(n2, 4);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getBigDecimal2(n);
    }

    protected BigDecimal getBigDecimal2(int n) throws SQLException {
        int n2 = this.getColType(n, false);
        if (n2 == -2 || n2 == -3 || n2 == -4 || n2 == 91 || n2 == 92 || n2 == 93) {
            this.sqlExcptGen.rsException("07006");
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        String string = this.SQLGetNumericStringData(n, this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen != -1) {
            this.nullTag = false;
            BigDecimal bigDecimal = null;
            try {
                string = DB2ResultSet.cvtScientific(string);
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.sqlExcptGen.rsException("22005");
            }
            return bigDecimal;
        }
        this.nullTag = true;
        return null;
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getBytes2(n);
    }

    protected byte[] getBytes2(int n) throws SQLException {
        if (this.colTypes[n - 1] == 0) {
            this.getColType(n, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 0;
        byte[] byArray = this.SQLGetLongBinaryData(n, this.colTypes[n - 1], this.colSizes[n - 1], this.statement.statementHandle, this.connection.connectionHandle);
        if (this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        if (this.maxFieldSize == 0 || byArray.length <= this.maxFieldSize) {
            return byArray;
        }
        byte[] byArray2 = new byte[this.maxFieldSize];
        System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
        return byArray2;
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate2(n, Calendar.getInstance());
    }

    protected Date getDate2(int n) throws SQLException {
        return this.getDate2(n, Calendar.getInstance());
    }

    protected Date getDate2(int n, Calendar calendar) throws SQLException {
        Date date = null;
        this.nullTag = true;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDate2(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.numCols) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            this.returnCode = this.sqlSuccess;
            this.returnLen = this.sqlSuccess;
            this.year = this.SQLGetDateData(n, this.statement.statementHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
            }
            if (this.returnLen != -1) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Year from DB", this.year);
                    DB2Trace.data(10, "Month from DB (1 less)", this.month);
                    DB2Trace.data(10, "Date from DB", this.date);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(this.year + 1900, this.month, this.date, 0, 0, 0);
                calendar.set(14, 0);
                date = new Date(calendar.getTime().getTime());
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "Date", date.toString());
                }
                this.nullTag = false;
            } else {
                this.nullTag = true;
            }
            Date date2 = date;
            Object var6_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getDate2()", date == null ? "NULL" : date.toString());
            }
            return date2;
        }
        catch (Throwable throwable) {
            block12: {
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) break block12;
                DB2Trace.methodExit((Object)this, "getDate2()", date == null ? "NULL" : date.toString());
            }
            throw throwable;
        }
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime2(n, Calendar.getInstance());
    }

    protected Time getTime2(int n) throws SQLException {
        return this.getTime2(n, Calendar.getInstance());
    }

    protected Time getTime2(int n, Calendar calendar) throws SQLException {
        Time time = null;
        this.nullTag = true;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTime2(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.numCols) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            this.returnCode = this.sqlSuccess;
            this.returnLen = this.sqlSuccess;
            this.hour = this.SQLGetTimeData(n, this.statement.statementHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
            }
            if (this.returnLen != -1) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Hour", this.hour);
                    DB2Trace.data(10, "Minute", this.minute);
                    DB2Trace.data(10, "Second", this.second);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(1970, 0, 1, this.hour, this.minute, this.second);
                calendar.set(14, 0);
                time = new Time(calendar.getTime().getTime());
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "Time", time.toString());
                }
                this.nullTag = false;
            } else {
                this.nullTag = true;
            }
            Time time2 = time;
            Object var6_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTime2()", time == null ? "NULL" : time.toString());
            }
            return time2;
        }
        catch (Throwable throwable) {
            block12: {
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) break block12;
                DB2Trace.methodExit((Object)this, "getTime2()", time == null ? "NULL" : time.toString());
            }
            throw throwable;
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp2(n, Calendar.getInstance());
    }

    protected Timestamp getTimestamp2(int n) throws SQLException {
        return this.getTimestamp2(n, Calendar.getInstance());
    }

    protected Timestamp getTimestamp2(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        this.nullTag = true;
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTimestamp2(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.numCols) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            if ((n2 = this.getColType(n, false)) == 92) {
                this.sqlExcptGen.rsException("07006");
            }
            this.returnCode = this.sqlSuccess;
            this.returnLen = this.sqlSuccess;
            this.year = this.SQLGetTimestampData(n, this.statement.statementHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
            }
            if (this.returnLen != -1) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "Year", this.year);
                    DB2Trace.data(10, "Month", this.month);
                    DB2Trace.data(10, "Date", this.date);
                    DB2Trace.data(10, "Hour", this.hour);
                    DB2Trace.data(10, "Minute", this.minute);
                    DB2Trace.data(10, "Second", this.second);
                    DB2Trace.data(10, "Nano", this.nano);
                }
                calendar = (Calendar)calendar.clone();
                calendar.set(this.year + 1900, this.month, this.date, this.hour, this.minute, this.second);
                calendar.set(14, 0);
                timestamp = new Timestamp(calendar.getTime().getTime());
                timestamp.setNanos(this.nano);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "Timestamp", timestamp.toString());
                }
                this.nullTag = false;
            } else {
                this.nullTag = true;
            }
            Timestamp timestamp2 = timestamp;
            Object var6_6 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTimestamp2()", timestamp == null ? "NULL" : timestamp.toString());
            }
            return timestamp2;
        }
        catch (Throwable throwable) {
            block13: {
                Object var6_7 = null;
                if (!DB2Trace.TraceOn) break block13;
                DB2Trace.methodExit((Object)this, "getTimestamp2()", timestamp == null ? "NULL" : timestamp.toString());
            }
            throw throwable;
        }
    }

    protected byte[] getAsciiString(int n) throws SQLException {
        this.returnCode = this.sqlSuccess;
        this.returnLen = this.sqlSuccess;
        byte[] byArray = this.SQLGetLongCharData(n, this.statement.statementHandle, this.connection.connectionHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1) {
            this.nullTag = true;
            return null;
        }
        this.nullTag = false;
        if (this.maxFieldSize == 0 || byArray.length <= this.maxFieldSize) {
            return byArray;
        }
        byte[] byArray2 = new byte[this.maxFieldSize];
        System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
        return byArray2;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getAsciiStream2(n);
    }

    protected InputStream getAsciiStream2(int n) throws SQLException {
        int n2 = 41;
        int n3 = this.getColType(n, true);
        if (n3 == -99 || n3 == -98 || n3 == -350) {
            switch (n3) {
                case -99: {
                    n2 = 41;
                    break;
                }
                case -98: {
                    n2 = 31;
                    break;
                }
                case -350: {
                    n2 = -351;
                    break;
                }
            }
            Integer n4 = new Integer(this.sqlSuccess);
            int n5 = this.SQLGetLocator(n, n2, n4, this.statement.statementHandle);
            int n6 = n4;
            if (n6 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n6);
            }
            if (this.returnLen != -1) {
                this.nullTag = false;
                if (n2 != 31) {
                    DB2InputStream dB2InputStream = new DB2InputStream(this.statement, n5, n2);
                    this.addIsList(dB2InputStream);
                    return dB2InputStream;
                }
                DB2Binary2AsciiInputStream dB2Binary2AsciiInputStream = new DB2Binary2AsciiInputStream(this.statement, n5, n2);
                this.addIsList(dB2Binary2AsciiInputStream);
                return dB2Binary2AsciiInputStream;
            }
            this.nullTag = true;
            return null;
        }
        byte[] byArray = this.getAsciiString(n);
        if (byArray != null) {
            this.nullTag = false;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream;
        }
        this.nullTag = true;
        return null;
    }

    protected byte[] getUniString(int n) throws SQLException {
        String string = null;
        if (this.colTypes[n - 1] == 0) {
            this.getColType(n, true);
        }
        this.returnCode = this.sqlSuccess;
        this.returnLen = 1;
        Object object = this.connection;
        synchronized (object) {
            string = this.SQLGetStringData(n, this.colTypes[n - 1], this.colSizes[n - 1], this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        if (this.returnLen == -1 || this.returnCode == 100) {
            this.nullTag = true;
            return null;
        }
        if (this.returnLen == 0) {
            string = "";
        }
        this.nullTag = false;
        object = null;
        try {
            object = this.maxFieldSize == 0 || string.length() <= this.maxFieldSize ? (Object)string.getBytes("UTF8") : (Object)string.substring(0, this.maxFieldSize).getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return object;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getUnicodeStream2(n);
    }

    protected InputStream getUnicodeStream2(int n) throws SQLException {
        int n2 = 41;
        int n3 = this.getColType(n, true);
        if (n3 == -99 || n3 == -98 || n3 == -350) {
            switch (n3) {
                case -99: {
                    n2 = 41;
                    break;
                }
                case -98: {
                    n2 = 31;
                    break;
                }
                case -350: {
                    n2 = -351;
                    break;
                }
            }
            Integer n4 = new Integer(this.sqlSuccess);
            int n5 = this.SQLGetLocator(n, n2, n4, this.statement.statementHandle);
            int n6 = n4;
            if (n6 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n6);
            }
            if (this.returnLen != -1) {
                this.nullTag = false;
                DB2InputStream dB2InputStream = null;
                switch (n2) {
                    case -351: 
                    case 41: {
                        dB2InputStream = new DB2UnicodeStream(this.statement, n5, n2);
                        break;
                    }
                    case 31: {
                        dB2InputStream = new DB2Binary2UnicodeInputStream(this.statement, n5, n2);
                    }
                }
                this.addIsList(dB2InputStream);
                return dB2InputStream;
            }
            this.nullTag = true;
            return null;
        }
        byte[] byArray = this.getUniString(n);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.numCols) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        return this.getBinaryStream2(n);
    }

    protected InputStream getBinaryStream2(int n) throws SQLException {
        int n2 = 41;
        int n3 = this.getColType(n, true);
        if (n3 == -99 || n3 == -98 || n3 == -350) {
            switch (n3) {
                case -99: {
                    n2 = 41;
                    break;
                }
                case -98: {
                    n2 = 31;
                    break;
                }
                case -350: {
                    n2 = -351;
                    break;
                }
            }
            Integer n4 = new Integer(this.sqlSuccess);
            int n5 = this.SQLGetLocator(n, n2, n4, this.statement.statementHandle);
            int n6 = n4;
            if (n6 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this.statement, n6);
            }
            if (this.returnLen != -1) {
                this.nullTag = false;
                DB2InputStream dB2InputStream = new DB2InputStream(this.statement, n5, n2);
                this.addIsList(dB2InputStream);
                return dB2InputStream;
            }
            this.nullTag = true;
            return null;
        }
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public void close() throws SQLException {
        if (!this.closed && this.statement != null && !this.statement.closed) {
            this.statement.getMoreResults();
            if (this.statement.moreResults) {
                this.statement.prefetchedMoreResults = true;
                this.closed = true;
                return;
            }
            this.realClose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void realClose() throws SQLException {
        block18: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "realClose()");
                }
                this.closed = true;
                if (this.statement == null) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(5, "statement is null");
                    }
                    Object var2_1 = null;
                    if (!DB2Trace.TraceOn) return;
                    DB2Trace.methodExit(this, "realClose()");
                    return;
                }
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    if (this.statement.closed) {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(10, "statement is closed");
                        }
                        Object var4_8 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 14] lbl21 : MonitorExitStatement: MONITOREXIT : var3_7
                        Object var2_2 = null;
                        if (!DB2Trace.TraceOn) return;
                        DB2Trace.methodExit(this, "realClose()");
                        return;
                    }
                    if (this.connection == null) {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(20, "connection is null");
                        }
                        Object var4_9 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 12] lbl32 : MonitorExitStatement: MONITOREXIT : var3_7
                        Object var2_3 = null;
                        if (!DB2Trace.TraceOn) return;
                        DB2Trace.methodExit(this, "realClose()");
                        return;
                    }
                    DB2Connection dB2Connection = this.connection;
                    synchronized (dB2Connection) {
                        int n;
                        if (this.connection.closed) {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(25, "connection is closed");
                            }
                            Object var6_12 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 4, 10] lbl46 : MonitorExitStatement: MONITOREXIT : var5_11
                            Object var4_10 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 10] lbl49 : MonitorExitStatement: MONITOREXIT : var3_7
                            Object var2_4 = null;
                            if (!DB2Trace.TraceOn) return;
                            DB2Trace.methodExit(this, "realClose()");
                            return;
                        }
                        this.clearIsList();
                        if (!this.connection.SPConnected && (n = this.SQLFreeStmtClose(this.statement.statementHandle)) != this.sqlSuccess) {
                            this.sqlExcptGen.check_return_code(this.statement, n);
                        }
                        this.statement.prefetchedMoreResults = false;
                    }
                }
                if (!this.statement.internalStmt) break block18;
                this.statement.close2(true);
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                if (!DB2Trace.TraceOn) throw throwable;
                DB2Trace.methodExit(this, "realClose()");
                throw throwable;
            }
        }
        Object var2_5 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit(this, "realClose()");
    }

    public String getString(String string) throws SQLException {
        return this.getString2(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean2(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte2(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort2(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt2(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong2(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat2(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble2(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal2(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes2(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream2(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream2(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream2(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.statement.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.statement.warnings = null;
    }

    protected void addWarning(SQLWarning sQLWarning) {
        this.statement.addWarning(sQLWarning);
    }

    public String getCursorName() throws SQLException {
        String string;
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLGetCursorName(this.statement.statementHandle, this.connection.connectionHandle);
        }
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return string;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.rsMetaData != null) {
            return this.rsMetaData;
        }
        return this.getMetaData2();
    }

    public DB2ResultSetMetaData getMetaData2() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.rsMetaData = DB2Trace.TraceOn ? new DB2ResultSetMetaDataTrace(this.statement, this, this.numCols, this.mappedRS) : new DB2ResultSetMetaData(this.statement, this, this.numCols, this.mappedRS);
        return this.rsMetaData;
    }

    protected Object getObject(int n, int n2, int n3) throws SQLException {
        Object object = null;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n);
                break;
            }
            case 2: 
            case 3: {
                object = this.getBigDecimal(n, n3);
                break;
            }
            case -7: {
                boolean bl = this.getBoolean(n);
                if (this.wasNull()) break;
                object = new Boolean(bl);
                break;
            }
            case -6: {
                short s = this.getShort(n);
                if (this.wasNull()) break;
                object = new Integer(s);
                break;
            }
            case 5: {
                short s = this.getShort(n);
                if (this.wasNull()) break;
                object = new Integer(s);
                break;
            }
            case 4: {
                int n4 = this.getInt(n);
                if (this.wasNull()) break;
                object = new Integer(n4);
                break;
            }
            case -5: {
                long l = this.getLong(n);
                if (this.wasNull()) break;
                object = new Long(l);
                break;
            }
            case 7: {
                float f = this.getFloat(n);
                if (this.wasNull()) break;
                object = new Float(f);
                break;
            }
            case 6: 
            case 8: {
                double d = this.getDouble(n);
                if (this.wasNull()) break;
                object = new Double(d);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
                break;
            }
            case -98: {
                object = this.getBytes(n);
                break;
            }
            case -350: 
            case -99: {
                object = this.getString(n);
                break;
            }
            default: {
                this.sqlExcptGen.rsException("22005");
            }
        }
        return object;
    }

    protected Object getObject(int n, int n2) throws SQLException {
        return this.getObject(n, n2, -1);
    }

    public Object getObject(int n) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n2 = this.getColType(n, true);
        return this.getObject(n, n2);
    }

    protected Object getObject(String string, int n, int n2) throws SQLException {
        return this.getObject(this.findColumn(string), n, n2);
    }

    protected Object getObject(String string, int n) throws SQLException {
        return this.getObject(this.findColumn(string), n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n = 0;
        int n2 = 0;
        if (this.rsMetaData == null) {
            this.rsMetaData = this.getMetaData2();
        }
        string = string.toUpperCase(Locale.US);
        if (this.name2Index == null) {
            n2 = this.statement.colCount4JSQL > 0 ? this.statement.colCount4JSQL : this.rsMetaData.getColumnCount();
            this.name2Index = new Hashtable((int)((double)n2 / 0.75 + 0.7));
            int n3 = 1;
            while (n3 <= n2) {
                String string2 = this.statement.colCount4JSQL > 0 ? this.statement.colNames4JSQL[n3 - 1] : this.rsMetaData.getColumnName(n3);
                if (string2 != null && !this.name2Index.containsKey(string2 = string2.toUpperCase(Locale.US))) {
                    this.name2Index.put(string2, new Integer(n3));
                    if (string2.equals(string)) {
                        n = n3;
                    }
                }
                ++n3;
            }
        } else {
            Integer n4 = (Integer)this.name2Index.get(string);
            if (n4 != null) {
                return n4;
            }
        }
        if (n == 0) {
            this.sqlExcptGen.rsException("S0022");
        }
        return n;
    }

    protected DB2Statement getStmt() {
        return this.statement;
    }

    protected int getMappedColumn(int n) throws SQLException {
        return n;
    }

    protected int getColCount() throws SQLException {
        int n = this.SQLGetColumnCount(this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return n;
    }

    protected void reset(int n, int n2) throws SQLException {
        this.reset(n);
    }

    protected void reset(int n) throws SQLException {
        block7: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "reset( " + n + ") ");
                }
                this.numCols = this.statement.moreResults ? this.getColCount() : 0;
                this.nullTag = true;
                this.closed = false;
                this.mappedRS = false;
                this.name2Index = null;
                this.colTypes = new int[this.numCols];
                this.colSizes = new int[this.numCols];
                int n2 = 0;
                while (n2 < this.numCols) {
                    this.colTypes[n2] = 0;
                    this.colSizes[n2] = 0;
                    ++n2;
                }
                if (this.rsMetaData == null) break block7;
                this.rsMetaData.numberOfColumns = this.numCols;
                if (this.rsMetaData.colBaseTypesNotAdjusted == null) break block7;
                if (this.rsMetaData.colBaseTypesNotAdjusted.length < this.numCols) {
                    this.rsMetaData.colBaseTypesNotAdjusted = null;
                    break block7;
                }
                int n3 = 0;
                while (n3 < this.numCols) {
                    this.rsMetaData.colBaseTypesNotAdjusted[n3] = -99999;
                    ++n3;
                }
            }
            catch (Throwable throwable) {
                block8: {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) break block8;
                    DB2Trace.methodExit(this, "reset()");
                }
                throw throwable;
            }
        }
        Object var3_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "reset()");
        }
    }

    protected void resetRows(int n) throws SQLException {
    }

    public synchronized byte[] getDB2RowData() throws SQLException {
        if (this.connection.closed) {
            this.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        byte[] byArray = this.SQLGetRowDataInternal(this.statement.statementHandle);
        if (this.returnCode != this.sqlSuccess && this.returnCode != 100) {
            this.sqlExcptGen.check_return_code(this.statement, this.returnCode);
        }
        return byArray;
    }

    protected String getTraceHandle() {
        String string = "??";
        if (this.statement != null) {
            string = this.statement.getTraceHandle();
        }
        return string;
    }
}

