/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DB2ResultSetMetaData
implements ResultSetMetaData {
    protected DB2Statement statement;
    protected DB2Connection connection;
    protected DB2ResultSet resultset;
    protected int numberOfColumns;
    protected boolean mappedRS;
    protected int[] colBaseTypesNotAdjusted;

    protected native String SQLColAttributes(int var1, int var2, Integer var3, Integer var4, int var5, int var6);

    public DB2ResultSetMetaData(DB2Statement dB2Statement, DB2ResultSet dB2ResultSet, int n, boolean bl) {
        this.statement = dB2Statement;
        this.connection = dB2Statement.getDB2Connection();
        this.resultset = dB2ResultSet;
        this.numberOfColumns = n;
        this.mappedRS = bl;
    }

    public DB2ResultSetMetaData(DB2PreparedStatement dB2PreparedStatement) {
        this.statement = dB2PreparedStatement;
        this.connection = dB2PreparedStatement.getDB2Connection();
        this.resultset = null;
        this.numberOfColumns = 0;
        this.mappedRS = false;
    }

    public int getColumnCount() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        if (this.resultset == null || this.resultset.numCols <= 0) {
            Integer n = new Integer(0);
            Integer n2 = new Integer(0);
            DB2Connection dB2Connection = this.connection;
            synchronized (dB2Connection) {
                String string = this.SQLColAttributes(1, 0, n2, n, this.statement.statementHandle, this.connection.connectionHandle);
            }
            int n3 = n2;
            if (n3 != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, n3);
            }
            this.numberOfColumns = n;
            if (this.resultset != null) {
                this.resultset.numCols = this.numberOfColumns;
            }
        } else {
            this.numberOfColumns = this.resultset.numCols;
        }
        return this.numberOfColumns;
    }

    protected int getMappedColumn(int n) throws SQLException {
        if (this.mappedRS) {
            int n2 = this.resultset.getMappedColumn(n);
            return n2;
        }
        return n;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 11, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2 == 1;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 12, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2 == 1;
    }

    public boolean isSearchable(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 13, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2 != 0;
    }

    public boolean isCurrency(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 9, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2 == 1;
    }

    public int isNullable(int n) throws SQLException {
        int n2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n3 = new Integer(0);
        Integer n4 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 7, n4, n3, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n5 = n4;
        if (n5 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n5);
        }
        if ((n2 = n3.intValue()) == 1) {
            return 1;
        }
        if (n2 == 0) {
            return 0;
        }
        return 2;
    }

    public boolean isSigned(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 8, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2 != 1;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 6, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2;
    }

    public String getColumnLabel(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 18, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return string;
    }

    public String getColumnName(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        if (this.resultset != null && this.resultset.mappedColumnNames != null && this.resultset.mappedColumnNames.length >= n && this.resultset.mappedColumnNames[n - 1] != null) {
            return this.resultset.mappedColumnNames[n - 1];
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 1, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return string;
    }

    public String getSchemaName(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 16, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        if (string == null) {
            return new String("");
        }
        return string;
    }

    public int getPrecision(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 4, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2;
    }

    public int getScale(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 5, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2;
    }

    public String getTableName(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 15, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        if (string == null) {
            return new String("");
        }
        return string;
    }

    public String getCatalogName(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 17, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        if (string == null) {
            return new String("");
        }
        return string;
    }

    public int getColumnType(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n6, 2, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n7 = n3;
        if (n7 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n7);
        }
        n5 = n2;
        n4 = this.connection.adjust(n5);
        if (this.colBaseTypesNotAdjusted == null || this.colBaseTypesNotAdjusted.length < n) {
            int n8 = this.getColumnCount();
            this.colBaseTypesNotAdjusted = new int[n8];
            int n9 = 0;
            while (n9 < n8) {
                this.colBaseTypesNotAdjusted[n9] = -99999;
                ++n9;
            }
        }
        this.colBaseTypesNotAdjusted[n - 1] = n5;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(30, "DB2ColType", n4);
            DB2Trace.data(30, "DB2ColBaseTypeNotAdjusted", n5);
        }
        return n4;
    }

    public String getColumnTypeName(int n) throws SQLException {
        String string;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            string = this.SQLColAttributes(n, 14, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return string;
    }

    public boolean isReadOnly(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(0);
        n = this.getMappedColumn(n);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String string = this.SQLColAttributes(n, 10, n3, n2, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int n4 = n3;
        if (n4 != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, n4);
        }
        return n2 == 0;
    }

    public boolean isWritable(int n) throws SQLException {
        return !this.isReadOnly(n);
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        return false;
    }
}

