/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CallableStatement;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DB2Statement
implements Statement {
    protected static final short STMT_TYPE_QUERY = 24;
    protected static final short STMT_TYPE_CALL = 25;
    protected static final short STMT_TYPE_OTHER = 26;
    protected static final short STMT_TYPE_SQLJ = 27;
    protected int statementHandle;
    protected DB2Connection connection;
    SQLWarning warnings;
    protected int maxRows;
    protected int maxFieldSize;
    protected int rowCount;
    protected short colCount;
    protected int returnCode;
    protected boolean closed = false;
    protected boolean internalStmt = false;
    protected DB2ResultSet resultSet;
    protected boolean moreResults = true;
    protected boolean prefetchedMoreResults = false;
    protected SQLExceptionGenerator sqlExcptGen;
    protected String[] colNames4JSQL;
    protected int colCount4JSQL;
    protected String SQLState;
    protected String SQLmessage;
    protected int SQLnativeCode;
    protected byte[] SQLca;
    protected boolean cachedError = false;
    protected int SQLNextErrorRC;
    protected int sqlSuccess = 0;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int rsTypeAllocated = this.rsType;
    private boolean counted = false;
    private static int statementCount;
    private static int peakStatementCount;
    protected String sql;
    protected int[] batchReturn;

    protected native int SQLAllocStmt(int var1, int var2, int var3);

    protected native int SQLExecDirect(String var1, int var2, int var3);

    protected native int SQLGetColumnCount(int var1);

    protected native int SQLGetRowCount(int var1);

    protected native int SQLFreeStmt(int var1);

    protected native int SQLCancel(int var1);

    protected native int SQLMoreResults(int var1, int var2);

    protected native int SQLMaxFieldSize(int var1, int var2);

    protected native int SQLMaxRows(int var1, int var2);

    protected native int SQLScan(boolean var1, int var2);

    protected native int SQLSetQueryTimeout(int var1, int var2);

    protected native int SQLGetQueryTimeout(int var1);

    protected native int SQLSetCursorName(String var1, int var2, int var3);

    public String toString() {
        return this.toString("", true);
    }

    protected String toString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("\r\n" + string + "DB2Statement \r\n" + string + "{");
        if (this.connection != null) {
            stringBuffer.append(this.connection.toString(String.valueOf(string) + "    Connection -> "));
        } else {
            stringBuffer.append("\r\n" + string + "    Connection -> null");
        }
        if (bl) {
            if (this.resultSet != null) {
                stringBuffer.append(this.resultSet.toString(String.valueOf(string) + "    ResultSet -> ", false));
            } else {
                stringBuffer.append("\r\n" + string + "    ResultSet -> null\r\n");
            }
        }
        stringBuffer.append("\r\n");
        stringBuffer.append(String.valueOf(string) + "    statementHandle = " + this.getTraceHandle() + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    SQL = " + this.sql + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    maxRows = " + this.maxRows + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    maxFieldSize = " + this.maxFieldSize + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    rowCount = " + this.rowCount + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    colCount = " + this.colCount + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    closed = " + this.closed + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    internalStmt = " + this.internalStmt + "\r\n");
        stringBuffer.append(String.valueOf(string) + "    returnCode = " + this.returnCode + "\r\n");
        stringBuffer.append(String.valueOf(string) + "}\r\n");
        return stringBuffer.toString();
    }

    public DB2Statement(DB2Connection dB2Connection, int n, int n2) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Statement( con, " + n + ", " + n2 + " )");
            }
            this.connection = dB2Connection;
            this.sqlExcptGen = this.connection.sqlExcptGen;
            this.rsType = n;
            this.rsConcur = n2;
            this.rsTypeAllocated = n;
            this.returnCode = 0;
            this.statementHandle = this.SQLAllocStmt(this.connection.connectionHandle, n, n2);
            if (this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            this.incrementStatementCount();
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_5 = null;
                if (!DB2Trace.TraceOn) break block5;
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                DB2Trace.methodExit(this, "DB2Statement()");
            }
            throw throwable;
        }
        Object var5_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            DB2Trace.methodExit(this, "DB2Statement()");
        }
    }

    public DB2Statement(DB2Connection dB2Connection) throws SQLException {
        this(dB2Connection, 1003, 1007);
    }

    public DB2Statement(DB2Connection dB2Connection, boolean bl) throws SQLException {
        this(dB2Connection);
        this.internalStmt = bl;
    }

    private synchronized void incrementStatementCount() {
        if (!this.counted) {
            DB2Statement.adjustStatementCount(1);
            this.counted = true;
        }
    }

    private synchronized void decrementStatementCount() {
        if (this.counted) {
            DB2Statement.adjustStatementCount(-1);
            this.counted = false;
        }
    }

    private static synchronized void adjustStatementCount(int n) {
        if ((statementCount += n) > peakStatementCount) {
            peakStatementCount = statementCount;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Peak statements", peakStatementCount);
            }
            DriverManager.println("DB2 Peak statements = " + peakStatementCount);
        }
    }

    public static int getStatementCount() {
        return statementCount;
    }

    public static int getPeakStatementCount() {
        return peakStatementCount;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DB2Connection getDB2Connection() {
        return this.connection;
    }

    public int getHandle() {
        return this.statementHandle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String string) throws SQLException {
        boolean bl;
        boolean bl2;
        block6: {
            boolean bl3;
            block5: {
                this.sql = string;
                bl2 = false;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "execute( " + string + " )");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (string == null || string.trim().length() == 0) {
                        this.sqlExcptGen.throwNullError();
                    }
                    this.execute2(string);
                    this.getResultSet();
                    if (this.resultSet.numCols > 0) {
                        bl3 = bl2 = true;
                        Object var5_5 = null;
                        if (!DB2Trace.TraceOn) return bl3;
                        break block5;
                    }
                    bl = bl2 = false;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.methodExit((Object)this, "execute()", String.valueOf(bl2));
                    throw throwable;
                }
            }
            DB2Trace.methodExit((Object)this, "execute()", String.valueOf(bl2));
            return bl3;
        }
        Object var5_6 = null;
        if (!DB2Trace.TraceOn) return bl;
        DB2Trace.methodExit((Object)this, "execute()", String.valueOf(bl2));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet executeQuery(String string) throws SQLException {
        DB2ResultSet dB2ResultSet;
        this.sql = string;
        try {
            short s;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeQuery( " + string + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (string == null || string.trim().length() == 0) {
                this.sqlExcptGen.throwNullError();
            }
            if ((s = this.getStatementType(string)) != 24 && s != 25 && s != 27) {
                this.sqlExcptGen.throwInvalidQueryError();
            }
            this.execute2(string);
            this.getResultSet();
            dB2ResultSet = this.resultSet;
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) return dB2ResultSet;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "executeQuery()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "executeQuery()");
        return dB2ResultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected short getStatementType(String string) {
        int n;
        int n2;
        block23: {
            String string2;
            short s;
            block22: {
                n2 = 26;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getStatementType( " + string + " )");
                    }
                    if (string != null) {
                        int n3 = string.length();
                        int n4 = 0;
                        if (n3 > 0 && string.charAt(n4) == '#') {
                            s = 27;
                            Object var5_10 = null;
                            if (!DB2Trace.TraceOn) return s;
                            string2 = null;
                            break block22;
                        }
                        while (true) {
                            char c;
                            if (n4 >= n3 || !Character.isWhitespace(c = string.charAt(n4)) && c != '{' && c != ';' && c != '?' && c != '(' && c != '=') {
                                n2 = string.regionMatches(true, n4, "select", 0, 6) || string.regionMatches(true, n4, "values", 0, 6) || string.regionMatches(true, n4, "with", 0, 4) ? 24 : (string.regionMatches(true, n4, "call", 0, 4) ? 25 : 26);
                            }
                            ++n4;
                        }
                    }
                    n = n2;
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    String string3 = null;
                    switch (n2) {
                        case 24: {
                            string3 = "STMT_TYPE_QUERY (" + 24 + ")";
                            break;
                        }
                        case 25: {
                            string3 = "STMT_TYPE_CALL (" + 25 + ")";
                            break;
                        }
                        case 27: {
                            string3 = "STMT_TYPE_SQLJ (" + 27 + ")";
                            break;
                        }
                        default: {
                            string3 = "STMT_TYPE_OTHER (" + 26 + ")";
                        }
                    }
                    DB2Trace.methodExit((Object)this, "getStatementType()", string3);
                    throw throwable;
                }
            }
            switch (n2) {
                case 24: {
                    string2 = "STMT_TYPE_QUERY (" + 24 + ")";
                    break;
                }
                case 25: {
                    string2 = "STMT_TYPE_CALL (" + 25 + ")";
                    break;
                }
                case 27: {
                    string2 = "STMT_TYPE_SQLJ (" + 27 + ")";
                    break;
                }
                default: {
                    string2 = "STMT_TYPE_OTHER (" + 26 + ")";
                }
            }
            DB2Trace.methodExit((Object)this, "getStatementType()", string2);
            return s;
        }
        Object var5_11 = null;
        if (!DB2Trace.TraceOn) return (short)n;
        String string4 = null;
        switch (n2) {
            case 24: {
                string4 = "STMT_TYPE_QUERY (" + 24 + ")";
                break;
            }
            case 25: {
                string4 = "STMT_TYPE_CALL (" + 25 + ")";
                break;
            }
            case 27: {
                string4 = "STMT_TYPE_SQLJ (" + 27 + ")";
                break;
            }
            default: {
                string4 = "STMT_TYPE_OTHER (" + 26 + ")";
            }
        }
        DB2Trace.methodExit((Object)this, "getStatementType()", string4);
        return (short)n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdate(String string) throws SQLException {
        int n;
        this.sql = string;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeUpdate( " + string + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.getStatementType(string) == 24) {
                this.sqlExcptGen.throwInvalidUpdateError();
            }
            this.execute2(string);
            n = n2 = this.getUpdateCount();
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "executeUpdate", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "executeUpdate", n2);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute2(String string) throws SQLException {
        block14: {
            block13: {
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "execute2( " + string + " )");
                        DB2Trace.data(10, "StatementHandle ", this.getTraceHandle());
                    }
                    this.moreResults = true;
                    this.prefetchedMoreResults = false;
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    if (string == null || string.trim().length() == 0) {
                        this.sqlExcptGen.throwNullError();
                    }
                    this.warnings = null;
                    if (this.resultSet != null) {
                        this.resultSet.realClose();
                    }
                    this.rowCount = 0;
                    this.returnCode = 0;
                    DB2Connection dB2Connection = this.connection;
                    synchronized (dB2Connection) {
                        this.returnCode = (short)this.SQLExecDirect(string, this.statementHandle, this.connection.connectionHandle);
                    }
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "SQLExecDirect - returnCode ", this.returnCode);
                    }
                    if (this.returnCode == 100) {
                        this.rowCount = 0;
                        Object var3_3 = null;
                        if (!DB2Trace.TraceOn) return;
                        break block13;
                    }
                    if (this.returnCode != 0) {
                        this.sqlExcptGen.check_return_code(this, this.returnCode);
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "rowCount", this.rowCount);
                    DB2Trace.methodExit(this, "execute2()");
                    throw throwable;
                }
            }
            DB2Trace.data(10, "rowCount", this.rowCount);
            DB2Trace.methodExit(this, "execute2()");
            return;
        }
        Object var3_4 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.data(10, "rowCount", this.rowCount);
        DB2Trace.methodExit(this, "execute2()");
    }

    public void close() throws SQLException {
        block4: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "close()");
                    DB2Trace.data(10, "StatementHandle ", this.getTraceHandle());
                }
                if (this.closed) break block4;
                this.close2(true);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var2_2 = null;
                    if (!DB2Trace.TraceOn) break block5;
                    DB2Trace.methodExit(this, "close()");
                }
                throw throwable;
            }
        }
        Object var2_1 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "close()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void close2(boolean bl) throws SQLException {
        int n;
        block18: {
            block19: {
                block16: {
                    block15: {
                        n = 0;
                        try {
                            if (DB2Trace.TraceOn) {
                                DB2Trace.methodEntry(this, "close2( " + bl + " )");
                            }
                            this.closed = true;
                            this.decrementStatementCount();
                            if (this.connection == null) {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.data(10, "connection is null");
                                }
                                Object var4_3 = null;
                                if (!DB2Trace.TraceOn) return;
                                break block15;
                            }
                            if (this.statementHandle == 0) {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.data(20, "statementHandle = 0");
                                }
                                break block16;
                            }
                            DB2Connection dB2Connection = this.connection;
                            synchronized (dB2Connection) {
                                block17: {
                                    if (this.connection.closed) {
                                        if (DB2Trace.TraceOn) {
                                            DB2Trace.data(30, "connection is closed");
                                        }
                                        Object var6_9 = null;
                                        break block17;
                                    }
                                    if (this.resultSet != null) {
                                        this.resultSet.clearIsList();
                                    }
                                    if (!this.connection.SPConnected || this.connection.SPConnected && bl) {
                                        n = this.SQLFreeStmt(this.statementHandle);
                                        if (this.returnCode != 0) {
                                            this.sqlExcptGen.check_return_code(this, n);
                                        }
                                        this.statementHandle = 0;
                                    }
                                    break block18;
                                }
                            }
                            break block19;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            if (!DB2Trace.TraceOn) throw throwable;
                            DB2Trace.methodExit((Object)this, "close2()", n);
                            throw throwable;
                        }
                    }
                    DB2Trace.methodExit((Object)this, "close2()", n);
                    return;
                }
                Object var4_4 = null;
                if (!DB2Trace.TraceOn) return;
                DB2Trace.methodExit((Object)this, "close2()", n);
                return;
            }
            Object var4_5 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.methodExit((Object)this, "close2()", n);
            return;
        }
        Object var4_6 = null;
        if (!DB2Trace.TraceOn) return;
        DB2Trace.methodExit((Object)this, "close2()", n);
    }

    public void finalize() throws SQLException {
        block5: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "finalize()");
                }
                if (this.closed) break block5;
                String string = null;
                string = this instanceof DB2CallableStatement ? "DB2CallableStatement closed in finalizer: \"" + this.sql + "\"" : (this instanceof DB2PreparedStatement ? "DB2PreparedStatement closed in finalizer: \"" + this.sql + "\"" : "DB2Statement closed in finalizer, last SQL: \"" + this.sql + "\"");
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, string);
                }
                DriverManager.println(string);
                this.close();
            }
            catch (Throwable throwable) {
                block6: {
                    Object var2_3 = null;
                    if (!DB2Trace.TraceOn) break block6;
                    DB2Trace.methodExit(this, "finalize()");
                }
                throw throwable;
            }
        }
        Object var2_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "finalize()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getMoreResults() throws SQLException {
        boolean bl;
        block14: {
            boolean bl2;
            block13: {
                boolean bl3;
                block12: {
                    boolean bl4;
                    block11: {
                        boolean bl5;
                        block10: {
                            try {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.methodEntry(this, "getMoreResults()");
                                }
                                if (this.prefetchedMoreResults) {
                                    this.prefetchedMoreResults = false;
                                    bl5 = this.moreResults;
                                    Object var3_6 = null;
                                    if (!DB2Trace.TraceOn) return bl5;
                                    break block10;
                                }
                                if (this.connection.closed) {
                                    this.sqlExcptGen.throwConnectionClosedError();
                                }
                                if (this.closed) {
                                    this.sqlExcptGen.throwClosedError();
                                }
                                if (!this.moreResults) {
                                    bl4 = false;
                                    break block11;
                                }
                                this.rowCount = 0;
                                this.returnCode = 0;
                                this.returnCode = (short)this.SQLMoreResults(this.statementHandle, this.connection.connectionHandle);
                                if (this.returnCode == 100) {
                                    this.moreResults = false;
                                    bl3 = false;
                                    break block12;
                                }
                                if (this.returnCode != 0) {
                                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                                }
                                if (this.returnCode == 0 || this.returnCode == 1) {
                                    bl2 = this.moreResults = true;
                                    break block13;
                                }
                                bl = this.moreResults = false;
                                break block14;
                            }
                            catch (Throwable throwable) {
                                Object var3_11 = null;
                                if (!DB2Trace.TraceOn) throw throwable;
                                DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                                throw throwable;
                            }
                        }
                        DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                        return bl5;
                    }
                    Object var3_7 = null;
                    if (!DB2Trace.TraceOn) return bl4;
                    DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                    return bl4;
                }
                Object var3_8 = null;
                if (!DB2Trace.TraceOn) return bl3;
                DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                return bl3;
            }
            Object var3_9 = null;
            if (!DB2Trace.TraceOn) return bl2;
            DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
            return bl2;
        }
        Object var3_10 = null;
        if (!DB2Trace.TraceOn) return bl;
        DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
        return bl;
    }

    protected int getColCount() {
        this.colCount = (short)this.SQLGetColumnCount(this.statementHandle);
        return this.colCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet getResultSet() throws SQLException {
        DB2ResultSet dB2ResultSet;
        block13: {
            ResultSet resultSet;
            block12: {
                ResultSet resultSet2;
                block11: {
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "getResultSet()");
                            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                        }
                        if (this.prefetchedMoreResults) {
                            resultSet2 = null;
                            Object var3_4 = null;
                            if (!DB2Trace.TraceOn) return resultSet2;
                            break block11;
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        if (this.closed) {
                            this.sqlExcptGen.throwClosedError();
                        }
                        if (this.resultSet == null) {
                            this.resultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(this, 0) : new DB2ResultSet(this, 0);
                        } else if (!(this instanceof DB2PreparedStatement) || ((DB2PreparedStatement)this).statementType != 24) {
                            this.resultSet.reset(this.resultSet.numCols);
                        } else {
                            this.resultSet.setClosed(false);
                        }
                        if (this.resultSet.numCols <= 0 || !this.moreResults) {
                            resultSet = null;
                            break block12;
                        }
                        dB2ResultSet = this.resultSet;
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var3_7 = null;
                        if (!DB2Trace.TraceOn) throw throwable;
                        DB2Trace.methodExit(this, "getResultSet()");
                        throw throwable;
                    }
                }
                DB2Trace.methodExit(this, "getResultSet()");
                return resultSet2;
            }
            Object var3_5 = null;
            if (!DB2Trace.TraceOn) return resultSet;
            DB2Trace.methodExit(this, "getResultSet()");
            return resultSet;
        }
        Object var3_6 = null;
        if (!DB2Trace.TraceOn) return dB2ResultSet;
        DB2Trace.methodExit(this, "getResultSet()");
        return dB2ResultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getUpdateCount() throws SQLException {
        int n;
        int n2;
        block9: {
            int n3;
            block8: {
                n2 = 0;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getUpdateCount()");
                        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                    }
                    if (this.connection.closed) {
                        this.sqlExcptGen.throwConnectionClosedError();
                    }
                    if (this.closed) {
                        this.sqlExcptGen.throwClosedError();
                    }
                    this.colCount = (short)this.SQLGetColumnCount(this.statementHandle);
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "colCount", this.colCount);
                    }
                    if (this.colCount > 0 || !this.moreResults) {
                        n3 = n2 = -1;
                        Object var4_4 = null;
                        if (!DB2Trace.TraceOn) return n3;
                        break block8;
                    }
                    if (this.rowCount == 0) {
                        this.rowCount = this.SQLGetRowCount(this.statementHandle);
                    }
                    n2 = this.rowCount < 0 ? 0 : this.rowCount;
                    n = n2;
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    DB2Trace.data(10, "rowCount", this.rowCount);
                    DB2Trace.methodExit((Object)this, "getUpdateCount()", n2);
                    throw throwable;
                }
            }
            DB2Trace.data(10, "rowCount", this.rowCount);
            DB2Trace.methodExit((Object)this, "getUpdateCount()", n2);
            return n3;
        }
        Object var4_5 = null;
        if (!DB2Trace.TraceOn) return n;
        DB2Trace.data(10, "rowCount", this.rowCount);
        DB2Trace.methodExit((Object)this, "getUpdateCount()", n2);
        return n;
    }

    public void setCursorName(String string) throws SQLException {
        int n;
        block9: {
            n = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setCursorName( " + string + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                DB2Connection dB2Connection = this.connection;
                synchronized (dB2Connection) {
                    n = this.SQLSetCursorName(string, this.statementHandle, this.connection.connectionHandle);
                }
                if (n == 0) break block9;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var4_5 = null;
                    if (!DB2Trace.TraceOn) break block10;
                    DB2Trace.data(10, "SQLSetCursorName - rc ", n);
                    DB2Trace.methodExit(this, "setCursorName()");
                }
                throw throwable;
            }
        }
        Object var4_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "SQLSetCursorName - rc ", n);
            DB2Trace.methodExit(this, "setCursorName()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMaxFieldSize() throws SQLException {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getMaxFieldSize()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            n = this.maxFieldSize;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getMaxFieldSize()", this.maxFieldSize);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getMaxFieldSize()", this.maxFieldSize);
        return n;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setMaxFieldSize( " + n + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 0) {
                this.sqlExcptGen.throwOutOfRangeError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if ((n2 = this.SQLMaxFieldSize(n, this.statementHandle)) != 0) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
            this.maxFieldSize = n;
        }
        catch (Throwable throwable) {
            block9: {
                Object var4_4 = null;
                if (!DB2Trace.TraceOn) break block9;
                DB2Trace.data(10, "SQLMaxFieldSize- rc ", n2);
                DB2Trace.data(10, "maxFieldSize ", this.maxFieldSize);
                DB2Trace.methodExit(this, "setMaxFieldSize()");
            }
            throw throwable;
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "SQLMaxFieldSize- rc ", n2);
            DB2Trace.data(10, "maxFieldSize ", this.maxFieldSize);
            DB2Trace.methodExit(this, "setMaxFieldSize()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMaxRows() throws SQLException {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getMaxRows()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            n = this.maxRows;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getMaxRows()", this.maxRows);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getMaxRows()", this.maxRows);
        return n;
    }

    public void setMaxRows(int n) throws SQLException {
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setMaxRows( " + n + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 0) {
                this.sqlExcptGen.throwOutOfRangeError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if ((n2 = this.SQLMaxRows(n, this.statementHandle)) != 0) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
            this.maxRows = n;
        }
        catch (Throwable throwable) {
            block9: {
                Object var3_4 = null;
                if (!DB2Trace.TraceOn) break block9;
                DB2Trace.data(10, "maxRows ", this.maxRows);
                DB2Trace.methodExit(this, "setMaxRows()");
            }
            throw throwable;
        }
        Object var3_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "maxRows ", this.maxRows);
            DB2Trace.methodExit(this, "setMaxRows()");
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        int n;
        block6: {
            n = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setEscapeProcessing( " + bl + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if ((n = this.SQLScan(bl, this.statementHandle)) == 0) break block6;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_4 = null;
                    if (!DB2Trace.TraceOn) break block7;
                    DB2Trace.data(10, "SQLScan- rc ", n);
                    DB2Trace.methodExit(this, "setEscapeProcessing()");
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "SQLScan- rc ", n);
            DB2Trace.methodExit(this, "setEscapeProcessing()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getQueryTimeout() throws SQLException {
        int n;
        int n2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getQueryTimeOut()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.returnCode = 0;
            n2 = this.SQLGetQueryTimeout(this.statementHandle);
            if (this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            n = n2;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getQueryTimeOut()", n2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getQueryTimeOut()", n2);
        return n;
    }

    public void setQueryTimeout(int n) throws SQLException {
        int n2;
        block7: {
            n2 = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "setQueryTimeOut( " + n + " )");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if (n < 0) {
                    this.sqlExcptGen.throwOutOfRangeError();
                }
                if ((n2 = this.SQLSetQueryTimeout(n, this.statementHandle)) == 0) break block7;
                this.sqlExcptGen.check_return_code(this, n2);
            }
            catch (Throwable throwable) {
                block8: {
                    Object var4_4 = null;
                    if (!DB2Trace.TraceOn) break block8;
                    DB2Trace.data(10, " SQLSetQueryTimeout- rc ", n2);
                    DB2Trace.methodExit(this, "setQueryTimeOut()");
                }
                throw throwable;
            }
        }
        Object var4_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, " SQLSetQueryTimeout- rc ", n2);
            DB2Trace.methodExit(this, "setQueryTimeOut()");
        }
    }

    public void cancel() throws SQLException {
        int n;
        block6: {
            n = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "cancel()");
                    DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if (this.statementHandle == 0 || (n = this.SQLCancel(this.statementHandle)) == 0) break block6;
                this.sqlExcptGen.check_return_code(this, n);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var3_3 = null;
                    if (!DB2Trace.TraceOn) break block7;
                    DB2Trace.data(10, "SQLCancel- rc ", n);
                    DB2Trace.methodExit(this, "cancel()");
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "SQLCancel- rc ", n);
            DB2Trace.methodExit(this, "cancel()");
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    protected void addWarning(SQLWarning sQLWarning) {
        block6: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "addWarning()");
                }
                if (this.warnings == null) {
                    this.warnings = sQLWarning;
                    break block6;
                }
                SQLWarning sQLWarning2 = this.warnings;
                while (sQLWarning2.getNextWarning() != null) {
                    sQLWarning2 = sQLWarning2.getNextWarning();
                }
                sQLWarning2.setNextWarning(sQLWarning);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var3_4 = null;
                    if (!DB2Trace.TraceOn) break block7;
                    DB2Trace.methodExit(this, "addWarning()");
                }
                throw throwable;
            }
        }
        Object var3_3 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "addWarning()");
        }
    }

    protected int getStatementHandle() throws SQLException {
        return this.statementHandle;
    }

    protected String getTraceHandle() {
        int n = this.statementHandle >> 16;
        int n2 = this.statementHandle & 0xFFFF;
        String string = String.valueOf(n) + ":" + n2;
        return string;
    }

    protected void newBatchUpdateException(String string, String string2, int n, int[] nArray) {
    }

    protected void selectInBatchUpdateException(int[] nArray) {
    }
}

