/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2DataTruncation;
import COM.ibm.db2.jdbc.app.DB2Driver;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import COM.ibm.db2.jdbc.app.DB2Warning;
import COM.ibm.db2.mri.DB2Messages;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ResourceBundle;

public class SQLExceptionGenerator {
    protected String SQLState;
    protected String SQLmessage;
    protected int SQLnativeCode;
    protected byte[] SQLca;
    protected DB2Messages errMsgClass;
    protected int PSMLineNumber;
    protected String SQLerrmc;

    protected native int SQLConnectionError(int var1, int var2);

    protected native int SQLStatementError(int var1, int var2);

    public SQLExceptionGenerator(ResourceBundle resourceBundle) {
        this.errMsgClass = new DB2Messages(resourceBundle);
    }

    protected void TraceException(String string) {
        DB2Trace.getTraceObj().traceEntry("SQLExceptionGenerator", string);
        DB2Trace.getTraceObj().println("SQLState = " + this.SQLState);
        DB2Trace.getTraceObj().println("SQLmessage = " + this.SQLmessage);
        DB2Trace.getTraceObj().println("SQLnativeCode = " + this.SQLnativeCode);
        DB2Trace.getTraceObj().traceExit("SQLExceptionGenerator", string);
        DB2Trace.flush();
    }

    public void throw_SQLException(DB2Connection dB2Connection) throws SQLException {
        DB2Exception dB2Exception = null;
        DB2Exception dB2Exception2 = null;
        int n = this.getSQLConnectionError(dB2Connection);
        while (n != 100 && n != -2) {
            String string = this.SQLState.trim();
            if (string.startsWith("01") && !string.equals("01004")) {
                dB2Connection.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca));
            } else if (dB2Exception2 == null) {
                dB2Exception = dB2Exception2 = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca);
            } else {
                DB2Exception dB2Exception3 = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca);
                dB2Exception.setNextException(dB2Exception3);
                dB2Exception = dB2Exception3;
            }
            n = this.getSQLConnectionError(dB2Connection);
        }
        if (dB2Exception2 != null) {
            throw dB2Exception2;
        }
    }

    public void throw_SQLException(DB2Statement dB2Statement) throws SQLException {
        this.throw_SQLException(dB2Statement, false);
    }

    public void throw_SQLException(DB2Statement dB2Statement, boolean bl) throws SQLException {
        DB2Exception dB2Exception = null;
        DB2Exception dB2Exception2 = null;
        int n = this.getSQLStatementError(dB2Statement);
        while (n != 100 && n != -2) {
            String string = this.SQLState.trim();
            if (string.startsWith("01") && !string.equals("01004")) {
                if (string.equals("01004")) {
                    dB2Statement.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                } else if (string.equals("01592")) {
                    dB2Statement.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                } else {
                    dB2Statement.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                }
            } else if (dB2Exception == null) {
                dB2Exception2 = dB2Exception = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc);
            } else {
                DB2Exception dB2Exception3 = null;
                dB2Exception3 = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc);
                dB2Exception2.setNextException(dB2Exception3);
                dB2Exception2 = dB2Exception3;
            }
            n = this.getSQLStatementError(dB2Statement);
        }
        if (n == -2) {
            this.throwClosedError();
            return;
        }
        if (dB2Exception != null) {
            throw dB2Exception;
        }
    }

    public void addWarning(DB2Connection dB2Connection) {
        if (this.getSQLConnectionError(dB2Connection) != 100) {
            if (DB2Trace.TraceOn) {
                this.TraceException("addWarning(DB2Connection)");
            }
            dB2Connection.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca));
        }
    }

    public void addWarning(DB2Statement dB2Statement) {
        if (this.getSQLStatementError(dB2Statement) != 100) {
            String string;
            if (DB2Trace.TraceOn) {
                this.TraceException("addWarning(DB2Statement)");
            }
            if ((string = this.SQLState.trim()).equals("01004")) {
                dB2Statement.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                return;
            }
            if (string.equals("01592")) {
                dB2Statement.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                return;
            }
            dB2Statement.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
        }
    }

    public void addWarning(DB2Statement dB2Statement, DB2ResultSet dB2ResultSet) {
        if (this.getSQLStatementError(dB2Statement) != 100) {
            String string;
            if (DB2Trace.TraceOn) {
                this.TraceException("addWarning(DB2Statement, DB2ResultSet)");
            }
            if ((string = this.SQLState.trim()).equals("01004")) {
                dB2ResultSet.addWarning(new DB2DataTruncation(-1, false, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                return;
            }
            if (string.equals("01592")) {
                dB2ResultSet.addWarning(new DB2DataTruncation(-1, false, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                return;
            }
            dB2ResultSet.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca));
        }
    }

    public void check_return_code(DB2Connection dB2Connection, int n) throws SQLException {
        switch (n) {
            case 1: {
                this.addWarning(dB2Connection);
                return;
            }
            case -2: {
                dB2Connection.close();
                throw new DB2Exception(this.errMsgClass.getString("0600"), "S1000", -99999, null);
            }
            default: {
                this.throw_SQLException(dB2Connection);
            }
            case 0: 
        }
    }

    public void check_return_code(DB2Statement dB2Statement, int n) throws SQLException {
        switch (n) {
            case 1: {
                this.addWarning(dB2Statement);
                return;
            }
            case -2: {
                this.throwClosedError();
            }
            default: {
                this.throw_SQLException(dB2Statement);
            }
            case 0: 
        }
    }

    public void check_return_code(DB2Statement dB2Statement, DB2ResultSet dB2ResultSet, int n) throws SQLException {
        switch (n) {
            case 1: {
                this.addWarning(dB2Statement, dB2ResultSet);
                return;
            }
            case -2: {
                this.throwClosedError();
            }
            default: {
                this.throw_SQLException(dB2Statement);
            }
            case 0: 
        }
    }

    public void check_address(long l, boolean bl) throws SQLException {
        if (l == 0L) {
            throw new DB2Exception(this.errMsgClass.getString("0603"), "S1010", -99999, null);
        }
        if (!bl) {
            throw new DB2Exception(this.errMsgClass.getString("0604"), "S1010", -99999, null);
        }
    }

    public void check_type(int n, int n2) throws SQLException {
        if (n != n2) {
            throw new DB2Exception(this.errMsgClass.getString("0605"), "22005", -99999, null);
        }
    }

    public void checkColumnIndex(int n, int n2) throws SQLException {
        if (n < 1 || n > n2) {
            throw new DB2Exception(this.errMsgClass.getString("0610"), "S1002", -99999, null);
        }
    }

    public void checkParamIndex(int n, int n2) throws SQLException {
        if (n < 1 || n > n2) {
            throw new DB2Exception(this.errMsgClass.getString("0612"), "S1093", -99999, null);
        }
    }

    public void throwNotOutputParameterError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0603"), "S1010", -99999, null);
    }

    public void throwNotExecutedError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0604"), "S1010", -99999, null);
    }

    public void throwTypeError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0605"), "22005", -99999, null);
    }

    public void throwOutOfRangeError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0609"), "22003", -99999, null);
    }

    public void throwConnectionClosedError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0600"), "S1000", -99999, null);
    }

    public void throwInvalidQueryError() throws SQLException {
        String[] stringArray = new String[]{"QUERY"};
        throw new DB2Exception(this.errMsgClass.getString("0637", stringArray), "S1000", -99999, null);
    }

    public void throwInvalidUpdateError() throws SQLException {
        String[] stringArray = new String[]{"UPDATE"};
        throw new DB2Exception(this.errMsgClass.getString("0637", stringArray), "S1000", -99999, null);
    }

    public void throwNullError() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0639"));
    }

    public void throwColumnIndexError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0610"), "S1002", -99999, null);
    }

    public void throwColumnDataTypeError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0606"), "22005", -99999, null);
    }

    public void throwParamIndexError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0612"), "S1093", -99999, null);
    }

    public void throwClosedError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0601"), "S1000", -99999, null);
    }

    public void pstmtException(String string) throws SQLException {
        if (string.equals("S1003")) {
            throw new DB2Exception(this.errMsgClass.getString("0613"), "S1003", -99999, null);
        }
        if (string.equals("22003")) {
            throw new DB2Exception(this.errMsgClass.getString("0609"), "22003", -99999, null);
        }
    }

    public void rsException(String string) throws SQLException {
        if (string.equals("S0022")) {
            throw new DB2Exception(this.errMsgClass.getString("0611"), "S0022", -99999, null);
        }
        if (string.equals("22005")) {
            throw new DB2Exception(this.errMsgClass.getString("0606"), "22005", -99999, null);
        }
        if (string.equals("07006")) {
            throw new DB2Exception(this.errMsgClass.getString("0608"), "07006", -99999, null);
        }
    }

    public void throw_IOException(IOException iOException) throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0620"), "22021", -99999, null);
    }

    public void connException(String string) throws SQLException {
        if (string.trim().equals("S1C00")) {
            throw new DB2Exception(this.errMsgClass.getString("0700"), "S1C00", -99999, null);
        }
    }

    protected int getSQLConnectionError(DB2Connection dB2Connection) {
        int n = 0;
        DB2Connection dB2Connection2 = dB2Connection;
        synchronized (dB2Connection2) {
            try {
                n = this.SQLConnectionError(dB2Connection.connectionHandle, DB2Driver.getJVMHenv());
            }
            catch (SQLException sQLException) {}
        }
        return n;
    }

    protected int getSQLStatementError(DB2Statement dB2Statement) {
        int n = 0;
        if (dB2Statement.cachedError) {
            this.SQLState = dB2Statement.SQLState;
            this.SQLmessage = dB2Statement.SQLmessage;
            this.SQLnativeCode = dB2Statement.SQLnativeCode;
            this.SQLca = dB2Statement.SQLca;
            dB2Statement.cachedError = false;
            dB2Statement.SQLState = null;
            dB2Statement.SQLmessage = null;
            dB2Statement.SQLnativeCode = 0;
        } else {
            this.SQLState = "";
            this.SQLmessage = "";
            this.SQLnativeCode = 0;
            this.SQLca = null;
            this.PSMLineNumber = 0;
            this.SQLerrmc = "";
            DB2Connection dB2Connection = dB2Statement.connection;
            synchronized (dB2Connection) {
                n = this.SQLStatementError(dB2Statement.statementHandle, dB2Statement.connection.connectionHandle);
            }
        }
        return n;
    }
}

