/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2CallableStatement;
import COM.ibm.db2.jdbc.net.DB2CallableStatementTrace;
import COM.ibm.db2.jdbc.net.DB2DatabaseMetaData;
import COM.ibm.db2.jdbc.net.DB2DatabaseMetaDataTrace;
import COM.ibm.db2.jdbc.net.DB2PreparedStatement;
import COM.ibm.db2.jdbc.net.DB2PreparedStatementTrace;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2Socket;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.DB2StatementTrace;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;

public class DB2Connection
implements Connection {
    public static final short DB2JDBC_CLIENT_VERSION = 2;
    public static short DB2JDBC_SERVER_VERSION;
    protected DB2Socket db2socket;
    protected DB2Request db2req;
    protected SQLExceptionGenerator sqlExcptGen;
    protected ResourceBundle errMsgClass;
    private String server;
    private String portStr;
    private String source;
    private String user = "";
    private String password = "";
    private String language;
    private int SQL_SUCCESS = 0;
    private DB2Statement inputStreamStmt;
    private StringBuffer conArgs = new StringBuffer("");
    protected boolean closed = false;
    private boolean isLDCompat = true;
    protected boolean autoCommit = true;
    protected boolean isReadOnly = false;
    protected boolean autoClose = false;
    protected int connectionHandle;
    protected boolean fConnected = false;
    SQLWarning warnings;
    protected boolean littleEndian = true;
    protected int hostType = 0;
    private int JDBCLevel = 100;

    public String toString() {
        return this.toString("");
    }

    protected String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("\n" + string + "DB2Connection\n" + string + "{\n");
        stringBuffer.append(String.valueOf(string) + "    connectionHandle = " + this.connectionHandle + "\n");
        stringBuffer.append(String.valueOf(string) + "    server = " + this.server + "\n");
        stringBuffer.append(String.valueOf(string) + "    port = " + this.portStr + "\n");
        stringBuffer.append(String.valueOf(string) + "    source = " + this.source + "\n");
        stringBuffer.append(String.valueOf(string) + "    user = " + this.user + "\n");
        stringBuffer.append(String.valueOf(string) + "    conArgs = " + this.conArgs + "\n");
        stringBuffer.append(String.valueOf(string) + "    closed = " + this.closed + "\n");
        stringBuffer.append(String.valueOf(string) + "    isReadOnly = " + this.isReadOnly + "\n");
        stringBuffer.append(String.valueOf(string) + "    autoClose = " + this.autoClose + "\n");
        stringBuffer.append(String.valueOf(string) + "    LONGDATA compat = " + this.isLDCompat + "\n");
        stringBuffer.append(String.valueOf(string) + "}\n");
        return stringBuffer.toString();
    }

    public DB2Connection() {
    }

    public DB2Connection(String string, int n, String string2, Properties properties, int n2, boolean bl) throws SQLException {
        this.connectionHandle = n2;
        this.fConnected = bl;
        this.create(string, n, string2, properties);
    }

    public DB2Connection(String string, int n, String string2, Properties properties) throws SQLException {
        this.create(string, n, string2, properties);
    }

    public DB2Connection(String string, String string2, Properties properties) throws SQLException {
        this.create(string, 6789, string2, properties);
    }

    public DB2Connection(String string, Properties properties) throws SQLException {
        this.create("cerberus", 6789, string, properties);
    }

    protected void create(String string, int n, String string2, Properties properties) throws SQLException {
        this.loadDefaultMessage();
        this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
        DriverManager.println("Server " + string + " port " + n + " source " + string2);
        try {
            this.db2socket = new DB2Socket(new Socket(string, n), this);
            this.db2req = new DB2Request(this.db2socket);
        }
        catch (Exception exception) {
            DriverManager.println(exception.toString());
            this.sqlExcptGen.socketException("08S01c");
        }
        this.source = string2;
        this.server = string;
        this.portStr = String.valueOf(n);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string3.equals("user")) {
                this.user = properties.getProperty("user", "");
                if (this.user.trim().length() != 0) continue;
                this.sqlExcptGen.check_return_code(this, -101);
                continue;
            }
            if (string3.equals("password")) {
                this.password = properties.getProperty("password", "");
                continue;
            }
            if (string3.equals("connectionAttribute")) {
                this.conArgs.append(";" + properties.getProperty(string3, ""));
                continue;
            }
            if (string3.equals("language")) {
                this.language = properties.getProperty("language", "En_US");
                continue;
            }
            this.conArgs.append(";" + string3 + "=" + properties.getProperty(string3, ""));
        }
        this.SQLConnect();
    }

    public void SQLConnect() throws SQLException {
        this.SQLConnect(true);
    }

    public void SQLConnect(boolean bl) throws SQLException {
        if (!bl) {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "SQLConnect()");
            }
            return;
        }
        try {
            String string = "DSN=" + this.source + ";UID=" + this.user + ";PWD=" + this.password + this.conArgs.toString();
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)1);
                this.db2req.write((short)2);
                this.db2req.write(false);
                this.db2req.write(string);
                this.db2req.write((short)this.password.length());
                this.db2req.write(this.language);
                this.db2req.write("n030617");
                this.db2req.write(this.JDBCLevel);
                this.db2req.write(this.connectionHandle);
                this.db2req.write(this.fConnected);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n);
                }
                this.connectionHandle = this.db2req.readInt();
                DB2JDBC_SERVER_VERSION = this.db2req.readShort();
                this.littleEndian = this.db2req.readBoolean();
                DB2Trace.TraceOn = this.db2req.readBoolean();
                if (DB2Trace.TraceOn) {
                    DB2Trace.TraceFlush = this.db2req.readBoolean();
                }
                this.JDBCLevel = this.db2req.readInt();
                String string2 = null;
                try {
                    string2 = this.db2req.readString();
                }
                catch (EOFException eOFException) {}
                if (string2 == null || string2.length() != "n030617".length() || !string2.substring(1).equals("n030617".substring(1))) {
                    this.sqlExcptGen.check_return_code(this, -111);
                }
                this.hostType = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.close2();
            this.sqlExcptGen.socketException("08S01a");
        }
        if (DB2Trace.TraceOn) {
            if (!DB2Trace.isInitialized()) {
                new DB2Trace(this.server, Integer.parseInt(this.portStr));
            }
            DB2Trace.methodEntry(this, "SQLConnect()");
            DB2Trace.data(10, "server = " + this.server + "; port = " + this.portStr + "; source = " + this.source + "; user = " + this.user + "; password = ******" + "; conArgs = " + this.conArgs.toString());
            DB2Trace.methodExit(this, "SQLConnect()");
            this.db2req = new DB2RequestTrace(this.db2socket);
        }
    }

    protected void loadDefaultMessage() {
        this.errMsgClass = ResourceBundle.getBundle("COM.ibm.db2.mri.DB2ErrorMessages");
    }

    public String getSource() {
        return String.valueOf(this.server) + ":" + this.portStr + "/" + this.source;
    }

    public boolean getPlatform() {
        return this.littleEndian;
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(false);
    }

    protected Statement createStatement(boolean bl) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "createStatement( " + bl + " )");
        }
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        DB2Statement dB2Statement = DB2Trace.TraceOn ? new DB2StatementTrace(this, bl) : new DB2Statement(this, bl);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "createStatement()");
        }
        return dB2Statement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "prepareStatement( " + string + " )");
        }
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        DB2PreparedStatement dB2PreparedStatement = DB2Trace.TraceOn ? new DB2PreparedStatementTrace(string, this) : new DB2PreparedStatement(string, this);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "prepareStatement()");
        }
        return dB2PreparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "prepareCall( " + string + " )");
        }
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        DB2CallableStatement dB2CallableStatement = DB2Trace.TraceOn ? new DB2CallableStatementTrace(string, this) : new DB2CallableStatement(string, this);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "prepareCall()");
        }
        return dB2CallableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "nativeSQL( " + string + " )");
        }
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        String string2 = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)7);
                this.db2req.write(string);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n);
                }
                string2 = this.db2req.readString();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "nativeSQL()", string2);
        }
        return string2;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setAutoCommit( " + bl + " )");
        }
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.autoCommit != bl) {
            int n = 0;
            if (bl) {
                n = 1;
            }
            int n2 = 0;
            DB2Connection dB2Connection = this;
            synchronized (dB2Connection) {
                try {
                    DB2Request dB2Request = this.db2req;
                    synchronized (dB2Request) {
                        this.db2req.write((short)3);
                        this.db2req.write((short)102);
                        this.db2req.write(n);
                        this.db2req.sendAndRecv();
                        n2 = this.db2req.readInt();
                    }
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.socketException("08S01a");
                }
                if (n2 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n2);
                }
                this.autoCommit = bl;
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setAutoCommit()");
        }
    }

    public void commit() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "commit()");
        }
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        try {
            int n;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)5);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
            }
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "commit()");
        }
    }

    public void rollback() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "rollback()");
        }
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        try {
            int n;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)6);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
            }
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "rollback()");
        }
    }

    public synchronized void close() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "close()");
        }
        if (!this.closed) {
            this.close2();
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "close()");
            DB2Trace.flush();
        }
    }

    protected synchronized void close2() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "close2()");
            DB2Trace.data(10, "connectionHandle", this.connectionHandle);
        }
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.flush();
            }
            if (this.inputStreamStmt != null) {
                try {
                    this.inputStreamStmt.close();
                }
                catch (SQLException sQLException) {}
                this.inputStreamStmt = null;
            }
            if (this.db2req != null) {
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)2);
                    this.db2req.sendAndRecv();
                    this.db2req.readInt();
                    this.db2req.close();
                    this.db2req = null;
                }
            }
            if (this.db2socket != null) {
                this.db2socket.close();
                this.db2socket = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.sqlExcptGen.socketException("08S01d");
        }
        this.closed = true;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "close2()");
        }
    }

    public void finalize() throws SQLException {
        block5: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "finalize()");
                }
                if (this.closed) break block5;
                String string = "DB2Connection closed in finalizer" + this.toString();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, string);
                }
                DriverManager.println(string);
                this.close();
            }
            catch (Throwable throwable) {
                block6: {
                    Object var2_3 = null;
                    if (!DB2Trace.TraceOn) break block6;
                    DB2Trace.methodExit(this, "finalize()");
                }
                throw throwable;
            }
        }
        Object var2_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "finalize()");
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    synchronized void setClosed(boolean bl) {
        this.closed = bl;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getMetaData()");
        }
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        DB2DatabaseMetaData dB2DatabaseMetaData = null;
        dB2DatabaseMetaData = DB2Trace.TraceOn ? new DB2DatabaseMetaDataTrace(this) : new DB2DatabaseMetaData(this);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "getMetaData()");
        }
        return dB2DatabaseMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setReadOnly( " + bl + " )");
        }
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.isReadOnly == bl) {
            DB2Trace.methodExit(this, "setReadOnly()");
            return;
        }
        int n = 0;
        if (bl) {
            n = 1;
        }
        int n2 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)3);
                this.db2req.write((short)101);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        if (n2 != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
        this.isReadOnly = bl;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setReadOnly()");
        }
    }

    public boolean isReadOnly() throws SQLException {
        return this.isReadOnly;
    }

    public void setLongDataCompat(boolean bl) throws SQLException {
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.isLDCompat == bl) {
            return;
        }
        int n = 0;
        if (bl) {
            n = 1;
        }
        int n2 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)3);
                this.db2req.write((short)1253);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        if (n2 != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n2);
        }
        this.isLDCompat = bl;
    }

    public boolean isLongDataCompat() throws SQLException {
        return this.isLDCompat;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)3);
                this.db2req.write((short)108);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
                return;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        int n = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)4);
                this.db2req.write((short)108);
                this.db2req.sendAndRecv();
                int n2 = this.db2req.readInt();
                if (n2 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n2);
                }
                n = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n;
    }

    public void setAutoClose(boolean bl) throws SQLException {
        if (bl) {
            this.sqlExcptGen.connException("S1C00");
        }
    }

    public boolean getAutoClose() throws SQLException {
        return this.autoClose;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized DB2Statement getInputStreamStmt() throws SQLException {
        DB2Statement dB2Statement;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getInputStreamStmt()");
            }
            if (this.inputStreamStmt == null) {
                this.inputStreamStmt = new DB2Statement(this, true);
            }
            dB2Statement = this.inputStreamStmt;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return dB2Statement;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getInputStreamStmt()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getInputStreamStmt()");
        return dB2Statement;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
            return;
        }
        SQLWarning sQLWarning2 = this.warnings;
        while (sQLWarning2.getNextWarning() != null) {
            sQLWarning2 = sQLWarning2.getNextWarning();
        }
        sQLWarning2.setNextWarning(sQLWarning);
    }

    ResourceBundle getErrMsgClass() {
        return this.errMsgClass;
    }

    public int getHandle() {
        return this.connectionHandle;
    }

    public DB2Socket getSocket() {
        return this.db2socket;
    }

    public void setConnectOption(int n, String string) throws SQLException {
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (string == null) {
            string = "";
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)8);
                this.db2req.write((short)n);
                this.db2req.write(string);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
                return;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public void setConnectOption(int n, int n2) throws SQLException {
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        try {
            int n3;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)3);
                this.db2req.write((short)n);
                this.db2req.write(n2);
                this.db2req.sendAndRecv();
                n3 = this.db2req.readInt();
            }
            if (n3 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n3);
                return;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public int getConnectOption(int n) throws SQLException {
        if (this.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        int n2 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)4);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                int n3 = this.db2req.readInt();
                if (n3 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n3);
                }
                n2 = this.db2req.readInt();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n2;
    }

    int adjust(int n) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "adjust( " + n + " )");
        }
        int n2 = n;
        switch (n) {
            case 9: {
                n2 = 91;
                break;
            }
            case 10: {
                n2 = 92;
                break;
            }
            case 11: {
                n2 = 93;
                break;
            }
            case -95: 
            case -8: {
                n2 = 1;
                break;
            }
            case -96: 
            case -9: {
                n2 = 12;
                break;
            }
            case -97: 
            case -10: {
                n2 = -1;
                break;
            }
            case -350: {
                n2 = -99;
                break;
            }
            case -400: {
                n2 = 70;
                break;
            }
        }
        if (n2 == -99 || n2 == -98) {
            n2 = n2 == -99 ? -1 : -4;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "adjust()", n2);
        }
        return n2;
    }

    public void setDQPFlag(int n) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setDQPFlag( " + n + " )");
        }
        this.setConnectOption(2466, n);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setDQPFlag()");
        }
    }

    public int getDQPFlag() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getDQPFlag()");
        }
        int n = this.getConnectOption(2466);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "getDQPFlag()");
        }
        return n;
    }

    protected int getHostType() {
        return this.hostType;
    }

    String getServer() {
        return this.server;
    }

    String getPortStr() {
        return this.portStr;
    }
}

