/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2PreparedStatement
extends DB2Statement
implements PreparedStatement {
    protected int maxNumParams;
    protected String SQLJCursorName;
    protected byte[] SQLJPID;
    protected short[] direction;
    protected int[] sqltypes;
    protected int[] ctypes;
    protected int[] maxWholeDigits;
    protected int[] precisions;
    protected int[] scales;
    protected boolean[] sameType;
    protected boolean[] wasBound;
    protected ParamElement[] paramRow;
    protected Vector paramSet;
    protected int[] maxParamLength;
    protected static final int BUFLEN = 32699;
    protected static final int MAXCHAR = 254;
    protected static final int MAXVCHAR = 4000;
    protected boolean executed = false;
    protected short statementType;
    private boolean[] SQLJParmIsGraphic;
    private String sqljDescribeInfo;

    public DB2PreparedStatement(String string, DB2Connection dB2Connection, int n, int n2) throws SQLException {
        int n3;
        this.connection = dB2Connection;
        this.sqlExcptGen = dB2Connection.sqlExcptGen;
        if (string == null || string.trim().length() == 0) {
            this.sqlExcptGen.throwNullError();
        }
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Connection) : new DB2RequestTrace(dB2Connection);
        this.statementType = this.getStatementType(string);
        this.sql = this.statementType == 27 ? this.parseSQLJ(string) : string;
        try {
            this.db2req.write((short)61);
            this.db2req.write(this.sql);
            this.db2req.write((short)this.rsType);
            this.db2req.write(this.SQLJCursorName);
            this.db2req.write(this.SQLJPID);
            this.db2req.sendAndRecv();
            n3 = this.db2req.readInt();
            this.statementHandle = this.db2req.readInt();
            this.maxNumParams = this.db2req.readInt();
            this.rsType = this.db2req.readInt();
            if (n3 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n3);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.direction = new short[this.maxNumParams];
        this.sqltypes = new int[this.maxNumParams];
        this.ctypes = new int[this.maxNumParams];
        this.maxWholeDigits = new int[this.maxNumParams];
        this.precisions = new int[this.maxNumParams];
        this.scales = new int[this.maxNumParams];
        this.sameType = new boolean[this.maxNumParams];
        this.wasBound = new boolean[this.maxNumParams];
        this.paramSet = new Vector();
        this.paramRow = new ParamElement[this.maxNumParams];
        this.maxParamLength = new int[this.maxNumParams];
        n3 = 0;
        while (n3 < this.maxNumParams) {
            this.direction[n3] = 0;
            this.sqltypes[n3] = 0;
            this.ctypes[n3] = 0;
            this.maxWholeDigits[n3] = 0;
            this.precisions[n3] = 0;
            this.scales[n3] = 0;
            this.sameType[n3] = false;
            this.wasBound[n3] = false;
            this.paramRow[n3] = new ParamElement();
            this.maxParamLength[n3] = 0;
            ++n3;
        }
        if (this.statementType == 27 && this.sqljDescribeInfo != null) {
            this.processSQLJDescribeInfo();
        }
    }

    public DB2PreparedStatement(String string, DB2Connection dB2Connection) throws SQLException {
        this(string, dB2Connection, 1003, 1007);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseSQLJ(String var1_1) throws SQLException {
        block27: {
            block26: {
                var2_2 = null;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "parseSQLJ( " + var1_1 + " )");
                    }
                    var2_2 = var1_1.substring(var1_1.indexOf("{"));
                    var6_3 = var2_2.indexOf("db2jrt");
                    var7_5 = 6;
                    var8_6 = var1_1.indexOf(",");
                    var9_7 = Integer.parseInt(var1_1.substring(1, var8_6));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "numOfTokens", var9_7);
                    }
                    if (var9_7 > 0) {
                        var10_8 = new int[var9_7];
                        var11_10 = 0;
                        ++var8_6;
                        var12_11 = 0;
                        while (var12_11 < var9_7) {
                            var11_10 = var1_1.indexOf(",", var8_6);
                            var10_8[var12_11] = Integer.parseInt(var1_1.substring(var8_6, var11_10));
                            var8_6 = var11_10 + 1;
                            ++var12_11;
                        }
                        this.colCount4JSQL = var9_7;
                        this.colNames4JSQL = new String[var9_7];
                        var13_12 = 0;
                        while (var13_12 < var9_7) {
                            var11_10 = var8_6 + var10_8[var13_12];
                            this.colNames4JSQL[var13_12] = new String(var1_1.substring(var8_6, var11_10));
                            var8_6 = var11_10;
                            ++var13_12;
                        }
                    }
                    var10_9 = var1_1.indexOf(",", ++var8_6);
                    var11_10 = Integer.parseInt(var1_1.substring(var8_6, var10_9));
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(20, "cursorName_len", var11_10);
                    }
                    if (var11_10 > 0) {
                        var8_6 = var10_9 + 1;
                        var10_9 = var1_1.indexOf(",", var8_6);
                        var12_11 = Integer.parseInt(var1_1.substring(var8_6, var10_9));
                        var8_6 = var10_9 + 1;
                        var10_9 = var1_1.indexOf(",", var8_6);
                        var13_12 = Integer.parseInt(var1_1.substring(var8_6, var10_9));
                        var14_13 = var2_2.substring(var12_11, var13_12);
                        var8_6 = var10_9 + 1;
                        var10_9 = var8_6 + var11_10;
                        this.SQLJCursorName = String.valueOf(new String(var1_1.substring(var8_6, var10_9))) + "," + var14_13;
                        if (DB2Trace.TraceOn) {
                            DB2Trace.data(20, "cursor_pid_ep", var13_12);
                            DB2Trace.data(20, "cursorName", this.SQLJCursorName);
                        }
                    } else {
                        var13_12 = var2_2.lastIndexOf(125);
                        var13_12 = var2_2.lastIndexOf(41, var13_12 - 1);
                        var13_12 = var2_2.lastIndexOf(39, var13_12 - 1);
                        var12_11 = var2_2.lastIndexOf("','", var13_12 - 1);
                        var14_13 = var2_2.substring(var12_11 + 3, var13_12);
                        var13_12 = var12_11;
                        var15_14 = var2_2.substring((var12_11 = var2_2.lastIndexOf("','", var13_12 - 1)) + 3, var13_12);
                        if (var15_14.length() > 0 || var14_13.length() > 0) {
                            var12_11 = var6_3 + var7_5;
                            var12_11 = var2_2.indexOf("'", var12_11) + 1;
                            var13_12 = var2_2.indexOf(44, var12_11);
                            var16_15 = var2_2.indexOf("',", var13_12);
                            var17_16 = var2_2.substring(var12_11, var13_12);
                            var18_17 = var2_2.substring(var13_12 + 1, var16_15);
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(20, "CursorName", var17_16);
                                DB2Trace.data(20, "PIDString", var18_17);
                            }
                            var2_2 = String.valueOf(var15_14) + var17_16 + var14_13;
                            var19_18 = new ByteArrayOutputStream(162);
                            var20_19 = 0;
                            var21_20 = var18_17.length();
                            var23_21 = 0;
                            while (var23_21 < var21_20) {
                                var22_22 = var18_17.charAt(var23_21);
                                if (var22_22 == ',') {
                                    var19_18.write(var20_19);
                                    var20_19 = 0;
                                } else if (var22_22 != ' ') {
                                    var20_19 = var20_19 * 10 + Character.digit(var22_22, 10);
                                }
                                ++var23_21;
                            }
                            this.SQLJPID = var19_18.toByteArray();
                        }
                    }
                    if (var2_2.indexOf("db2jrt") != -1) {
                        var8_6 = var2_2.indexOf("db2jrt");
                        var12_11 = 0;
                        while (var12_11 < 5) {
                            var8_6 = var2_2.indexOf("'", var8_6 + 1);
                            ++var12_11;
                        }
                        var10_9 = var2_2.indexOf("'", var8_6 + 1);
                        if (var2_2.substring(var8_6, var10_9 + 1).indexOf(",") != -1) {
                            this.sqljDescribeInfo = var2_2.substring(var8_6 + 1, var10_9);
                        }
                    }
                    if (this.sqljDescribeInfo == null) {
                        var8_6 = var2_2.indexOf(39, var6_3 + var7_5 + 1);
                        var8_6 = var2_2.indexOf(39, var8_6 + 1);
                        var8_6 = var2_2.indexOf(44, var8_6 + 1);
                        var8_6 = var2_2.indexOf(44, var8_6 + 1);
                        var8_6 = var2_2.indexOf(44, var8_6 + 1);
                        var8_6 = var2_2.indexOf(44, var8_6 + 1);
                        var10_9 = var2_2.indexOf(39, (var8_6 = var2_2.indexOf(39, var8_6 + 1)) + 1);
                        if (var10_9 - var8_6 > 1) {
                            this.SQLJParmIsGraphic = new boolean[var10_9 - var8_6 - 1];
                            ++var8_6;
                            var12_11 = 0;
                            while (var12_11 < this.SQLJParmIsGraphic.length) {
                                if (var2_2.charAt(var8_6) == '1') {
                                    this.SQLJParmIsGraphic[var12_11] = true;
                                }
                                ++var12_11;
                                ++var8_6;
                            }
                        }
                    }
                    var3_23 = var2_2;
                    var5_24 = null;
                    if (DB2Trace.TraceOn == false) return var3_23;
                    if (this.SQLJParmIsGraphic == null) break block26;
                    var6_3 = 0;
                    ** while (var6_3 < this.SQLJParmIsGraphic.length)
                }
                catch (Throwable var4_26) {
                    var5_25 = null;
                    if (!DB2Trace.TraceOn) throw var4_26;
                    if (this.SQLJParmIsGraphic == null) break block27;
                    var6_4 = 0;
                    ** while (var6_4 < this.SQLJParmIsGraphic.length)
                }
lbl-1000:
                // 1 sources

                {
                    DB2Trace.data(100, "SQLJParmIsGraphic[" + var6_3 + "]", String.valueOf(this.SQLJParmIsGraphic[var6_3]));
                    ++var6_3;
                    continue;
                }
            }
            DB2Trace.methodExit((Object)this, "parseSQLJ()", var2_2);
            return var3_23;
lbl-1000:
            // 1 sources

            {
                DB2Trace.data(100, "SQLJParmIsGraphic[" + var6_4 + "]", String.valueOf(this.SQLJParmIsGraphic[var6_4]));
                ++var6_4;
                continue;
            }
        }
        DB2Trace.methodExit((Object)this, "parseSQLJ()", var2_2);
        throw var4_26;
    }

    private void checkForSQLJGraphic(int n) {
        int n2;
        block10: {
            n2 = n - 1;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "checkForSQLJGraphic( " + n + " )");
                    DB2Trace.data(10, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
                }
                if (this.statementType != 27 || this.SQLJParmIsGraphic == null || this.SQLJParmIsGraphic.length <= n2 || !this.SQLJParmIsGraphic[n2]) break block10;
                int n3 = this.sqltypes[n2];
                switch (this.sqltypes[n2]) {
                    case 1: {
                        this.sqltypes[n2] = -95;
                        break;
                    }
                    case 12: {
                        this.sqltypes[n2] = -96;
                        break;
                    }
                    case -1: {
                        this.sqltypes[n2] = -97;
                        break;
                    }
                    case -99: {
                        this.sqltypes[n2] = -350;
                        break;
                    }
                }
                if (this.sqltypes[n2] == n3) break block10;
                this.wasBound[n2] = false;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var4_5 = null;
                    if (!DB2Trace.TraceOn) break block11;
                    DB2Trace.data(100, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
                    DB2Trace.methodExit(this, "checkForSQLJGraphic()");
                }
                throw throwable;
            }
        }
        Object var4_4 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(100, "sqltypes[" + n2 + "]", this.sqltypes[n2]);
            DB2Trace.methodExit(this, "checkForSQLJGraphic()");
        }
    }

    private void processSQLJDescribeInfo() {
        block9: {
            try {
                StringTokenizer stringTokenizer;
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "processSQLJDescribeInfo()");
                }
                if ((stringTokenizer = new StringTokenizer(this.sqljDescribeInfo, ",", false)).countTokens() <= 0) break block9;
                int n = stringTokenizer.countTokens() - 1;
                String string = "";
                stringTokenizer.nextToken();
                int n2 = 0;
                while (n2 < n) {
                    string = stringTokenizer.nextToken();
                    int n3 = 0;
                    int n4 = 0;
                    if (string.indexOf(" ") != -1) {
                        n4 = string.indexOf("(");
                        this.sqltypes[n2] = new Integer(string.substring(n3, n4));
                        n3 = n4 + 1;
                        n4 = string.indexOf(" ");
                        this.precisions[n2] = new Integer(string.substring(n3, n4));
                        string.substring(n3, n4);
                        n3 = n4 + 1;
                        n4 = string.indexOf(")");
                        this.scales[n2] = new Integer(string.substring(n3, n4));
                    } else if (string.indexOf("(") != -1) {
                        n4 = string.indexOf("(");
                        this.sqltypes[n2] = new Integer(string.substring(n3, n4));
                        n3 = n4 + 1;
                        n4 = string.indexOf(")");
                        this.precisions[n2] = new Integer(string.substring(n3, n4));
                    } else {
                        this.sqltypes[n2] = new Integer(string);
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                block10: {
                    Object var2_8 = null;
                    if (!DB2Trace.TraceOn) break block10;
                    DB2Trace.methodExit(this, "processSQLJDescribeInfo()");
                }
                throw throwable;
            }
        }
        Object var2_7 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "processSQLJDescribeInfo()");
        }
    }

    protected boolean setDirection(int n, int n2, int n3) {
        return this.setDirection(n, n2, n3, -1);
    }

    protected boolean setDirection(int n, int n2, int n3, int n4) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setDirection( " + n + ", " + n2 + ", " + n3 + ", " + n4 + " )");
        }
        int n5 = n - 1;
        boolean bl = true;
        if (this.direction[n5] == 4) {
            this.direction[n5] = 2;
            bl = false;
        } else if (this.direction[n5] == 0) {
            this.direction[n5] = 1;
            bl = false;
        }
        if (this.sqltypes[n5] == 0) {
            this.sqltypes[n5] = n2;
            bl = false;
        }
        if ((this.sqltypes[n5] == 3 || this.sqltypes[n5] == 2) && n4 != -1 && n4 != this.scales[n5]) {
            this.scales[n5] = n4;
            bl = false;
        }
        if (this.ctypes[n5] != n3) {
            this.ctypes[n5] = n3;
            bl = false;
        }
        if (!bl) {
            this.wasBound[n5] = false;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "setDirection()", bl);
        }
        return bl;
    }

    protected int loadParameters() throws SQLException {
        int n = -1;
        int n2 = 99;
        try {
            while (n2 == 99) {
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)76);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n2 = this.db2req.readInt();
                    if (n2 != this.SQL_SUCCESS && n2 != this.SQL_SUCCESS_WITH_INFO && n2 != 99) {
                        this.sqlExcptGen.check_return_code(this, n2);
                    }
                    if (n2 == 99) {
                        int n3;
                        Closeable closeable;
                        n = this.db2req.readInt();
                        int n4 = n - 1;
                        int n5 = this.paramRow[n4].getLength();
                        if (this.maxFieldSize != 0) {
                            n5 = Math.min(n5, this.maxFieldSize);
                        }
                        if (!this.paramRow[n4].doConversion()) {
                            closeable = (InputStream)this.paramRow[n4].getValue();
                            byte[] byArray = new byte[Math.min(32699, n5)];
                            while ((n3 = ((InputStream)closeable).read(byArray, 0, Math.min(32699, n5))) != -1 && n5 != 0) {
                                n5 -= n3;
                                this.db2req.write((short)75);
                                this.db2req.write(this.statementHandle);
                                this.db2req.write((short)0);
                                this.db2req.write(byArray, n3);
                                this.db2req.sendAndRecv();
                                int n6 = this.db2req.readInt();
                                if (n6 == this.SQL_SUCCESS) continue;
                                this.sqlExcptGen.check_return_code(this, n6);
                            }
                        } else {
                            int n7;
                            closeable = new BufferedReader((Reader)this.paramRow[n4].getValue());
                            int n8 = this.paramRow[n4].getLength();
                            n3 = Math.min(16349, n8);
                            char[] cArray = new char[n3];
                            while ((n7 = ((BufferedReader)closeable).read(cArray, 0, n3)) != -1 && n8 != 0) {
                                n3 = Math.min(16349, n8 -= n7);
                                this.db2req.write((short)75);
                                this.db2req.write(this.statementHandle);
                                this.db2req.write((short)1);
                                this.db2req.write(new String(cArray, 0, n7));
                                this.db2req.sendAndRecv();
                                int n9 = this.db2req.readInt();
                                if (n9 == this.SQL_SUCCESS) continue;
                                this.sqlExcptGen.check_return_code(this, n9);
                            }
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n2;
    }

    public ResultSet executeQuery() throws SQLException {
        int n;
        if (this.statementType != 24 && this.statementType != 25 && this.statementType != 27) {
            this.sqlExcptGen.throwInvalidQueryError();
        }
        if ((n = this.execute2()) != 100 && n != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n);
        }
        this.getResultSet();
        return this.resultSet;
    }

    public int executeUpdate() throws SQLException {
        int n;
        if (this.statementType == 24) {
            this.sqlExcptGen.throwInvalidUpdateError();
        }
        if ((n = this.execute2()) == 100) {
            this.rowCount = 0;
        } else if (n != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n);
        }
        return this.getUpdateCount();
    }

    protected synchronized int execute2() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n = 0;
        this.warnings = null;
        this.moreResults = true;
        this.prefetchedMoreResults = false;
        if (this.resultSet != null) {
            this.resultSet.realClose();
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)79);
                this.db2req.write(this.statementHandle);
                this.paramToServer();
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
                this.executed = true;
                if (n == this.SQL_SUCCESS) {
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                    this.CLIBlockSize = this.db2req.readInt();
                    if (this.resultSet != null) {
                        this.resultSet.closed = false;
                    }
                } else if (n == this.SQL_SUCCESS_WITH_INFO) {
                    this.sqlExcptGen.check_return_code(this, n);
                    this.getCounts();
                    if (this.resultSet != null) {
                        this.resultSet.closed = false;
                    }
                    n = this.SQL_SUCCESS;
                }
            }
            if (n == 99 && (n = this.loadParameters()) == this.SQL_SUCCESS) {
                this.getCounts();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    protected void paramToServer() throws IOException, SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "paramToServer()");
            }
            var3_1 = 0;
            while (var3_1 < this.maxNumParams) {
                this.db2req.write(this.direction[var3_1]);
                if (this.direction[var3_1] != 0) {
                    this.db2req.write((short)this.ctypes[var3_1]);
                    if (this.statementType == 27 && this.sqljDescribeInfo == null) {
                        this.checkForSQLJGraphic(var3_1 + 1);
                    }
                    this.db2req.write((short)this.sqltypes[var3_1]);
                    if (this.sqltypes[var3_1] == 2 || this.sqltypes[var3_1] == 3) {
                        this.db2req.write((short)this.scales[var3_1]);
                    }
                    this.db2req.write((short)(this.wasBound[var3_1] != false));
                    if (this.paramRow[var3_1].isSet()) {
                        if (this.direction[var3_1] != 4) {
                            if (this.paramRow[var3_1].isStream()) {
                                this.db2req.write(-2);
                            } else {
                                this.db2req.write(this.paramRow[var3_1].getLength());
                            }
                            if (this.paramRow[var3_1].getLength() != -1) {
                                switch (this.ctypes[var3_1]) {
                                    case 5: {
                                        this.db2req.write(((PrimitiveData)this.paramRow[var3_1].getValue()).shortValue());
                                        ** break;
                                    }
                                    case 4: {
                                        this.db2req.write(((PrimitiveData)this.paramRow[var3_1].getValue()).intValue());
                                        ** break;
                                    }
                                    case -25: {
                                        this.db2req.write(((PrimitiveData)this.paramRow[var3_1].getValue()).longValue());
                                        ** break;
                                    }
                                    case 7: {
                                        this.db2req.write(((PrimitiveData)this.paramRow[var3_1].getValue()).floatValue());
                                        ** break;
                                    }
                                    case 6: 
                                    case 8: {
                                        this.db2req.write(((PrimitiveData)this.paramRow[var3_1].getValue()).doubleValue());
                                        ** break;
                                    }
                                    case 91: {
                                        var4_2 = (int[])this.paramRow[var3_1].getValue();
                                        this.db2req.write((short)var4_2[0]);
                                        this.db2req.write((short)var4_2[1]);
                                        this.db2req.write((short)var4_2[2]);
                                        ** break;
                                    }
                                    case 92: {
                                        var5_3 = (int[])this.paramRow[var3_1].getValue();
                                        this.db2req.write((short)var5_3[0]);
                                        this.db2req.write((short)var5_3[1]);
                                        this.db2req.write((short)var5_3[2]);
                                        ** break;
                                    }
                                    case 93: {
                                        var6_4 = (int[])this.paramRow[var3_1].getValue();
                                        this.db2req.write((short)var6_4[0]);
                                        this.db2req.write((short)var6_4[1]);
                                        this.db2req.write((short)var6_4[2]);
                                        this.db2req.write((short)var6_4[3]);
                                        this.db2req.write((short)var6_4[4]);
                                        this.db2req.write((short)var6_4[5]);
                                        this.db2req.write(var6_4[6]);
                                        ** break;
                                    }
                                    case 2: 
                                    case 3: {
                                        this.db2req.write(this.paramRow[var3_1].getValue().toString());
                                        ** break;
                                    }
                                    case -8: 
                                    case 1: {
                                        if (this.paramRow[var3_1].isStream()) ** break;
                                        this.db2req.write((String)this.paramRow[var3_1].getValue());
                                        ** break;
                                    }
                                    case -2: {
                                        if (this.paramRow[var3_1].isStream()) ** break;
                                        this.db2req.write((byte[])this.paramRow[var3_1].getValue());
                                        ** break;
                                    }
                                    default: {
                                        this.sqlExcptGen.pstmtException("S1003");
                                        ** break;
                                    }
                                }
                            }
                        } else lbl-1000:
                        // 15 sources

                        {
                            this.wasBound[var3_1] = true;
                        }
                    }
                }
                ++var3_1;
            }
        }
        catch (Throwable var1_7) {
            block27: {
                var2_6 = null;
                if (!DB2Trace.TraceOn) break block27;
                DB2Trace.methodExit(this, "paramToServer()");
            }
            throw var1_7;
        }
        var2_5 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "paramToServer()");
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (n2 == 0) {
            this.sqlExcptGen.pstmtException("S1003");
        }
        int n3 = this.convert2SQLType(n2);
        int n4 = this.sqlType2cType(n3);
        this.sameType[n - 1] = this.setDirection(n, n3, n4);
        this.paramRow[n - 1].set(-1, null);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setBoolean(n, bl, 5);
    }

    protected void setBoolean(int n, boolean bl, int n2) throws SQLException {
        if (bl) {
            this.setShort(n, (short)1, n2);
            return;
        }
        this.setShort(n, (short)0, n2);
    }

    public void setByte(int n, byte by) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setByte(n, by, 5);
    }

    protected void setByte(int n, byte by, int n2) throws SQLException {
        this.setShort(n, by, n2);
    }

    public void setShort(int n, short s) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setShort(n, s, 5);
    }

    protected void setShort(int n, short s, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 5);
        this.paramRow[n - 1].set(0, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setInt(n, n2, 4);
    }

    protected void setInt(int n, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n3, 4);
        this.paramRow[n - 1].set(0, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setLong(n, l, -5);
    }

    protected void setLong(int n, long l, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        n2 = -5;
        this.sameType[n - 1] = this.setDirection(n, n2, -25);
        if (n2 == -5) {
            this.paramRow[n - 1].set(0, l);
            return;
        }
        this.paramRow[n - 1].set(0, (int)l);
    }

    public void setFloat(int n, float f) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setFloat(n, f, 7);
    }

    protected void setFloat(int n, float f, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 7);
        this.paramRow[n - 1].set(0, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setDouble(n, d, 8);
    }

    protected void setDouble(int n, double d, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 8);
        this.paramRow[n - 1].set(0, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.setBigDecimal(n, bigDecimal, 2);
    }

    protected void setBigDecimal(int n, BigDecimal bigDecimal, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n3 = n - 1;
        if (bigDecimal == null) {
            this.setNull(n, n2);
            this.maxWholeDigits[n3] = 31;
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n2, -8);
        this.setPrecisionAndScale(n3, bigDecimal);
    }

    protected void setPrecisionAndScale(int n, BigDecimal bigDecimal) {
        String string = bigDecimal.abs().toString();
        int n2 = 0;
        int n3 = string.length();
        if (string.indexOf(46) != -1) {
            n2 = 1;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (!string.startsWith("0", n4)) break;
            ++n2;
            ++n4;
        }
        int n5 = bigDecimal.scale();
        int n6 = n3 - n2;
        int n7 = (n6 = Math.max(n6, 1)) - n5;
        if (n7 > this.maxWholeDigits[n]) {
            this.maxWholeDigits[n] = n7;
        }
        if (n5 > this.scales[n]) {
            this.scales[n] = n5;
            this.wasBound[n] = false;
        } else {
            n6 += this.scales[n] - n5;
        }
        this.paramRow[n].set(n6, bigDecimal.toString());
    }

    public void setString(int n, String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (string == null) {
            this.setNull(n, 12);
            return;
        }
        if (this.maxFieldSize != 0 && string.length() > this.maxFieldSize) {
            string = string.substring(0, this.maxFieldSize);
        }
        int n2 = string.length() < 4000 ? 12 : -1;
        this.setString(n, string, n2, -1);
    }

    protected void setString(int n, String string, int n2) throws SQLException {
        this.setString(n, string, n2, -1);
    }

    protected void setString(int n, String string, int n2, int n3) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (this.maxFieldSize != 0 && string.length() > this.maxFieldSize) {
            string = string.substring(0, this.maxFieldSize);
        }
        this.sameType[n - 1] = this.setDirection(n, n2, -8, n3);
        int n4 = string.length();
        this.paramRow[n - 1].set(n4, string);
        if (n3 <= 0) {
            if (n4 > this.maxWholeDigits[n - 1]) {
                this.maxWholeDigits[n - 1] = n4;
                return;
            }
        } else {
            int n5 = n4 - n3;
            if (n5 > this.maxWholeDigits[n - 1]) {
                this.maxWholeDigits[n - 1] = n5;
            }
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        int n2;
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (byArray == null) {
            this.setNull(n, -3);
            return;
        }
        if (this.maxFieldSize != 0 && byArray.length > this.maxFieldSize) {
            byte[] byArray2 = byArray;
            byArray = new byte[this.maxFieldSize];
            System.arraycopy(byArray2, 0, byArray, 0, this.maxFieldSize);
        }
        int n3 = (n2 = byArray.length) < 4001 ? -3 : -4;
        this.setBytes(n, byArray, n3);
    }

    protected void setBytes(int n, byte[] byArray, int n2) throws SQLException {
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        switch (n2) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                this.sqlExcptGen.pstmtException("22003");
                break;
            }
        }
        if (this.maxFieldSize != 0 && byArray.length > this.maxFieldSize) {
            byte[] byArray2 = byArray;
            byArray = new byte[this.maxFieldSize];
            System.arraycopy(byArray2, 0, byArray, 0, this.maxFieldSize);
        }
        this.sameType[n - 1] = this.setDirection(n, n2, -2);
        this.paramRow[n - 1].set(byArray.length, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, 91, Calendar.getInstance());
    }

    protected void setDate(int n, Date date, int n2) throws SQLException {
        this.setDate(n, date, n2, Calendar.getInstance());
    }

    protected void setDate(int n, Date date, int n2, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNull(n, n2);
            return;
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 91);
        calendar = (Calendar)calendar.clone();
        calendar.setTime(date);
        int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5)};
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, 92, Calendar.getInstance());
    }

    protected void setTime(int n, Time time, int n2) throws SQLException {
        this.setTime(n, time, n2, Calendar.getInstance());
    }

    protected void setTime(int n, Time time, int n2, Calendar calendar) throws SQLException {
        if (time == null) {
            this.setNull(n, n2);
            return;
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 92);
        calendar = (Calendar)calendar.clone();
        calendar.setTime(time);
        int[] nArray = new int[]{calendar.get(11), calendar.get(12), calendar.get(13)};
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, 93, Calendar.getInstance());
    }

    protected void setTimestamp(int n, Timestamp timestamp, int n2) throws SQLException {
        this.setTimestamp(n, timestamp, n2, Calendar.getInstance());
    }

    protected void setTimestamp(int n, Timestamp timestamp, int n2, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, n2);
            return;
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.sameType[n - 1] = this.setDirection(n, n2, 93);
        calendar = (Calendar)calendar.clone();
        calendar.setTime(timestamp);
        int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), timestamp.getNanos()};
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "Year", nArray[0]);
            DB2Trace.data(10, "Month", nArray[1]);
            DB2Trace.data(10, "Day", nArray[2]);
            DB2Trace.data(10, "Hour_of_Day", nArray[3]);
            DB2Trace.data(10, "Minute", nArray[4]);
            DB2Trace.data(10, "Second", nArray[5]);
            DB2Trace.data(10, "Nano", nArray[6]);
        }
        this.paramRow[n - 1].set(0, nArray);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n3 = -1;
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 == 0) {
            String string = new String();
            this.setString(n, string);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n3, 1);
        this.paramRow[n - 1].set(n2, inputStream, true, false);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        int n3 = -1;
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        if (n2 == 0) {
            String string = new String();
            this.setString(n, string);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n3, -8);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UnicodeBig");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.paramRow[n - 1].set(n2 / 2, inputStreamReader, true, true);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        this.setBinaryStream(n, inputStream, n2, -4);
    }

    protected void setBinaryStream(int n, InputStream inputStream, int n2, int n3) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, n3);
            return;
        }
        if (n2 == 0) {
            this.setBytes(n, new byte[0], n3);
            return;
        }
        this.sameType[n - 1] = this.setDirection(n, n3, -2);
        this.paramRow[n - 1].set(n2, inputStream, true, false);
    }

    public synchronized void clearParameters() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n = 0;
        while (n < this.maxNumParams) {
            this.sameType[n] = false;
            this.wasBound[n] = false;
            this.paramRow[n].unset();
            ++n;
        }
        if (this.executed) {
            try {
                int n2;
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)77);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n2 = this.db2req.readInt();
                }
                if (n2 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n2);
                }
                this.executed = false;
                return;
            }
            catch (IOException iOException) {
                this.sqlExcptGen.socketException("08S01a");
                return;
            }
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, 0, -1);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, -1);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.maxNumParams) {
            this.sqlExcptGen.throwParamIndexError();
        }
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        if (n2 == 0) {
            try {
                if (object instanceof String) {
                    this.setString(n, (String)object);
                    return;
                }
                if (object instanceof Character) {
                    this.setString(n, ((Character)object).toString());
                    return;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = n3 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n3, 4);
                    this.setBigDecimal(n, bigDecimal);
                    return;
                }
                if (object instanceof Boolean) {
                    this.setBoolean(n, (Boolean)object);
                    return;
                }
                if (object instanceof Short) {
                    this.setShort(n, (Short)object);
                    return;
                }
                if (object instanceof Integer) {
                    this.setInt(n, (Integer)object);
                    return;
                }
                if (object instanceof Long) {
                    this.setLong(n, (Long)object);
                    return;
                }
                if (object instanceof Float) {
                    this.setFloat(n, ((Float)object).floatValue());
                    return;
                }
                if (object instanceof Double) {
                    this.setDouble(n, (Double)object);
                    return;
                }
                if (object instanceof byte[]) {
                    this.setBytes(n, (byte[])object);
                    return;
                }
                if (object instanceof Date) {
                    this.setDate(n, (Date)object, 91, Calendar.getInstance());
                    return;
                }
                if (object instanceof Time) {
                    this.setTime(n, (Time)object, 92, Calendar.getInstance());
                    return;
                }
                if (object instanceof Timestamp) {
                    this.setTimestamp(n, (Timestamp)object, 93, Calendar.getInstance());
                    return;
                }
                this.sqlExcptGen.pstmtException("S1003");
                return;
            }
            catch (ClassCastException classCastException) {
                this.sqlExcptGen.pstmtException("S1003");
                return;
            }
        }
        n2 = this.convert2SQLType(n2);
        try {
            if (object instanceof String) {
                if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 7) {
                    this.setString(n, DB2PreparedStatement.translateFloat((String)object), n2, n3);
                    return;
                }
                this.setString(n, (String)object, n2);
                return;
            }
            if (object instanceof Character) {
                if (n2 == 3 || n2 == 8 || n2 == 6 || n2 == 2 || n2 == 7) {
                    this.setString(n, DB2PreparedStatement.translateFloat(((Character)object).toString()), n2, n3);
                    return;
                }
                this.setString(n, ((Character)object).toString(), n2);
                return;
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = n3 == -1 ? (BigDecimal)object : ((BigDecimal)object).setScale(n3, 4);
                this.setBigDecimal(n, bigDecimal, n2);
                return;
            }
            if (object instanceof Boolean) {
                if (n2 == 1 || n2 == 12 || n2 == -1 || n2 == -99) {
                    this.setString(n, ((Boolean)object).toString(), n2);
                    return;
                }
                this.setBoolean(n, (Boolean)object, n2);
                return;
            }
            if (object instanceof Short) {
                this.setShort(n, (Short)object, n2);
                return;
            }
            if (object instanceof Integer) {
                this.setInt(n, (Integer)object, n2);
                return;
            }
            if (object instanceof Long) {
                this.setLong(n, (Long)object, n2);
                return;
            }
            if (object instanceof Float) {
                this.setFloat(n, ((Float)object).floatValue(), n2);
                return;
            }
            if (object instanceof Double) {
                this.setDouble(n, (Double)object, n2);
                return;
            }
            if (object instanceof byte[]) {
                this.setBytes(n, (byte[])object, n2);
                return;
            }
            if (object instanceof Date) {
                this.setDate(n, (Date)object, n2, Calendar.getInstance());
                return;
            }
            if (object instanceof Time) {
                this.setTime(n, (Time)object, n2, Calendar.getInstance());
                return;
            }
            if (object instanceof Timestamp) {
                this.setTimestamp(n, (Timestamp)object, n2, Calendar.getInstance());
                return;
            }
            this.sqlExcptGen.pstmtException("S1003");
            return;
        }
        catch (ClassCastException classCastException) {
            this.sqlExcptGen.pstmtException("S1003");
            return;
        }
    }

    public boolean execute() throws SQLException {
        int n = this.execute2();
        if (n == 100) {
            this.rowCount = 0;
        } else if (n != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n);
        }
        return this.colCount > 0;
    }

    protected int convert2SQLType(int n) {
        int n2 = n;
        switch (n2) {
            case -7: 
            case -6: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 8;
                break;
            }
            case 70: {
                n2 = -400;
                break;
            }
        }
        return n2;
    }

    protected int sqlType2cType(int n) {
        int n2;
        switch (n) {
            case -5: {
                n2 = -25;
                break;
            }
            case -98: 
            case -4: 
            case -3: 
            case -2: {
                n2 = -2;
                break;
            }
            case -400: 
            case -99: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 70: {
                n2 = -8;
                break;
            }
            default: {
                n2 = n;
            }
        }
        return n2;
    }

    protected void setTargetType(int n, int n2, String string) throws SQLException {
        try {
            switch (n2) {
                case 5: {
                    this.setShort(n, Short.parseShort(string));
                    return;
                }
                case 4: {
                    this.setInt(n, Integer.parseInt(string));
                    return;
                }
                case -5: {
                    this.setLong(n, Long.parseLong(string));
                    return;
                }
                case 6: 
                case 8: {
                    this.setDouble(n, Double.valueOf(DB2PreparedStatement.translateFloat(string)));
                    return;
                }
                case 7: {
                    this.setFloat(n, Float.valueOf(DB2PreparedStatement.translateFloat(string)).floatValue());
                    return;
                }
                case 91: {
                    this.setDate(n, Date.valueOf(string), 91, Calendar.getInstance());
                    return;
                }
                case 92: {
                    this.setTime(n, Time.valueOf(string), 92, Calendar.getInstance());
                    return;
                }
                case 93: {
                    this.setTimestamp(n, Timestamp.valueOf(string), 92, Calendar.getInstance());
                    return;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(n, new BigDecimal(DB2PreparedStatement.translateFloat(string)));
                    return;
                }
                case -97: 
                case -96: 
                case -95: 
                case -1: 
                case 1: 
                case 12: {
                    this.setString(n, string);
                    return;
                }
                case -4: 
                case -3: 
                case -2: {
                    int n3 = string.length();
                    byte[] byArray = new byte[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        byArray[n4] = (byte)string.charAt(n4);
                        ++n4;
                    }
                    this.setBytes(n, byArray);
                    return;
                }
                case -350: 
                case -99: {
                    this.setString(n, string);
                    return;
                }
                case -98: {
                    int n5 = string.length();
                    byte[] byArray = new byte[n5];
                    int n6 = 0;
                    while (n6 < n5) {
                        byArray[n6] = (byte)string.charAt(n6);
                        ++n6;
                    }
                    this.setBytes(n, byArray, -98);
                    return;
                }
            }
            this.sqlExcptGen.pstmtException("S1003");
            return;
        }
        catch (Exception exception) {
            this.sqlExcptGen.pstmtException("S1003");
            return;
        }
    }

    private static String translateFloat(String string) {
        char c = new DecimalFormatSymbols().getDecimalSeparator();
        if (c != '.') {
            return string.replace(c, '.');
        }
        return string;
    }

    class PrimitiveData {
        double doubleVal;
        int intVal;
        float floatVal;
        long longVal;
        short shortVal;

        public PrimitiveData() {
            DB2PreparedStatement.this = DB2PreparedStatement.this;
        }

        public double doubleValue() {
            return this.doubleVal;
        }

        public int intValue() {
            return this.intVal;
        }

        public float floatValue() {
            return this.floatVal;
        }

        public long longValue() {
            return this.longVal;
        }

        public short shortValue() {
            return this.shortVal;
        }

        public void set(double d) {
            this.doubleVal = d;
        }

        public void set(int n) {
            this.intVal = n;
        }

        public void set(float f) {
            this.floatVal = f;
        }

        public void set(long l) {
            this.longVal = l;
        }

        public void set(short s) {
            this.shortVal = s;
        }
    }

    class ParamElement {
        int length;
        Object value;
        boolean isStream;
        boolean doConversion;
        boolean fSet = false;
        PrimitiveData primitiveData = new PrimitiveData();

        public ParamElement() {
            DB2PreparedStatement.this = DB2PreparedStatement.this;
        }

        public ParamElement(int n, Object object) {
            DB2PreparedStatement.this = DB2PreparedStatement.this;
            this.length = n;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = false;
            this.doConversion = false;
            this.fSet = true;
        }

        public ParamElement(int n, Object object, boolean bl, boolean bl2) {
            this(n, object);
            this.isStream = bl;
            this.doConversion = bl2;
        }

        public void set(int n, double d) {
            this.primitiveData.set(d);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, int n2) {
            this.primitiveData.set(n2);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, float f) {
            this.primitiveData.set(f);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, long l) {
            this.primitiveData.set(l);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, short s) {
            this.primitiveData.set(s);
            this.set(n, this.primitiveData, false, false);
        }

        public void set(int n, Object object) {
            this.set(n, object, false, false);
        }

        public void set(int n, Object object, boolean bl, boolean bl2) {
            this.length = n;
            this.value = object;
            if (this.value == null) {
                this.length = -1;
            }
            this.isStream = bl;
            this.doConversion = bl2;
            this.fSet = true;
        }

        public void unset() {
            this.fSet = false;
        }

        public final boolean isSet() {
            return this.fSet;
        }

        public final int getLength() {
            return this.length;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean isStream() {
            return this.isStream;
        }

        public final boolean doConversion() {
            return this.doConversion;
        }
    }
}

