/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2InputStream;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2ResultSetMetaData;
import COM.ibm.db2.jdbc.net.DB2ResultSetMetaDataTrace;
import COM.ibm.db2.jdbc.net.DB2RowObject;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class DB2ResultSet
implements ResultSet {
    protected Hashtable name2Index;
    protected DB2ResultSetMetaData rsMetaData;
    protected DB2Statement statement;
    protected DB2RowObject rowObj;
    protected DB2Request db2req;
    protected SQLExceptionGenerator sqlExcptGen;
    protected int stmtHandle;
    protected boolean nullTag = true;
    protected boolean closed = false;
    protected Vector isList = new Vector();
    protected int colCount;
    protected boolean mappedRS = false;
    protected DB2Connection connection;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int nano;
    protected String[] mappedColumnNames;
    protected boolean[] preFetched;
    protected int SQL_NULL_DATA = -1;
    protected int fetchSize;
    protected int currentRowId;

    public DB2ResultSet(DB2Statement dB2Statement, int n, boolean bl) throws SQLException {
        this.mappedRS = bl;
        this.statement = dB2Statement;
        this.db2req = dB2Statement.db2req;
        this.sqlExcptGen = dB2Statement.sqlExcptGen;
        this.stmtHandle = this.statement.statementHandle;
        this.colCount = n;
        this.rowObj = new DB2RowObject(this);
        this.connection = dB2Statement.getDB2Connection();
        if (!DB2Trace.TraceOn) {
            this.rsMetaData = new DB2ResultSetMetaData(this.statement, this, this.colCount, this.mappedRS);
            return;
        }
        this.rsMetaData = new DB2ResultSetMetaDataTrace(this.statement, this, this.colCount, this.mappedRS);
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n) throws SQLException {
        this(dB2Statement, n, false);
    }

    public DB2ResultSet(DB2Statement dB2Statement, int n, String[] stringArray) throws SQLException {
        this(dB2Statement, n, false);
        this.mappedColumnNames = stringArray;
    }

    protected int getColumnCount() throws SQLException {
        return this.colCount;
    }

    protected void addIsList(DB2InputStream dB2InputStream) {
        if (dB2InputStream != null) {
            this.isList.addElement(dB2InputStream);
        }
    }

    protected void clearIsList() throws SQLException {
        if (this.isList.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.isList.elements();
        while (enumeration.hasMoreElements()) {
            DB2InputStream dB2InputStream = (DB2InputStream)enumeration.nextElement();
            dB2InputStream.close();
        }
        this.isList.removeAllElements();
    }

    public boolean next() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        boolean bl = false;
        this.clearIsList();
        this.clearWarnings();
        int n = this.rowObj.forwardOnlyNext();
        if (n == 0) {
            bl = true;
            ++this.currentRowId;
        } else if (n == 100) {
            bl = false;
            this.currentRowId = 0;
        } else {
            this.sqlExcptGen.check_return_code(this.statement, n);
            bl = true;
            ++this.currentRowId;
        }
        return bl;
    }

    public void close() throws SQLException {
        if (!this.closed && this.statement != null && !this.statement.closed) {
            this.statement.getMoreResults();
            if (this.statement.moreResults) {
                this.statement.prefetchedMoreResults = true;
                this.closed = true;
                return;
            }
            this.realClose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void realClose() throws SQLException {
        this.closed = true;
        if (this.statement == null) {
            if (!DB2Trace.TraceOn) return;
            DB2Trace.data(5, "statement is null");
            return;
        }
        DB2Statement dB2Statement = this.statement;
        synchronized (dB2Statement) {
            if (this.statement.closed) {
                if (!DB2Trace.TraceOn) return;
                DB2Trace.data(10, "statement is closed");
                return;
            }
            if (this.connection == null) {
                if (!DB2Trace.TraceOn) return;
                DB2Trace.data(20, "connection is null");
                return;
            }
            DB2Connection dB2Connection = this.connection;
            synchronized (dB2Connection) {
                if (this.connection.closed) {
                    if (!DB2Trace.TraceOn) return;
                    DB2Trace.data(25, "connection is closed");
                    return;
                }
                this.clearIsList();
                if (this.statement.internalStmt) {
                    this.statement.close();
                } else {
                    this.rowObj.reset();
                    try {
                        DB2Request dB2Request = this.db2req;
                        synchronized (dB2Request) {
                            this.db2req.write((short)48);
                            this.db2req.write(this.stmtHandle);
                            this.db2req.sendAndRecv();
                            this.db2req.readInt();
                            this.statement.prefetchedMoreResults = false;
                        }
                    }
                    catch (IOException iOException) {
                        this.sqlExcptGen.socketException("08S01a");
                    }
                }
            }
            return;
        }
    }

    protected void reset(int n) throws SQLException {
        this.clearIsList();
        this.colCount = n;
        this.nullTag = true;
        this.closed = false;
        this.name2Index = null;
        this.rowObj.reset();
        this.rsMetaData.activate(n);
        this.mappedRS = false;
    }

    public boolean wasNull() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.nullTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString(int n) throws SQLException {
        String string;
        String string2 = null;
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getString( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            string2 = this.preFetched[n2 = n - 1] ? this.rowObj.getString(n2) : this.getStringData(n);
            if (!this.nullTag && this.rsMetaData.colTypes[n2] == -400) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                int n3 = Integer.parseInt(string3);
                int n4 = string2.lastIndexOf(44) + 1;
                string2 = string2.substring(n4, n4 + n3);
            }
            if (!this.nullTag && this.statement.maxFieldSize != 0 && string2.length() > this.statement.maxFieldSize) {
                string2 = string2.substring(0, this.statement.maxFieldSize);
            }
            string = string2;
            Object var5_9 = null;
            if (!DB2Trace.TraceOn) return string;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getString()", string2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getString()", string2);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(int n) throws SQLException {
        boolean bl;
        boolean bl2 = false;
        try {
            String string;
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBoolean( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            bl2 = this.preFetched[n2 = n - 1] ? this.rowObj.getBoolean(n2) : (this.rowObj.sqltype[n2] == 1 || this.rowObj.sqltype[n2] == 12 || this.rowObj.sqltype[n2] == -1 || this.rowObj.sqltype[n2] == -99 ? ((string = this.getString(n)) == null ? false : ((string = string.trim()).equals("1") ? true : new Boolean(string))) : this.getBooleanData(n));
            bl = bl2;
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) return bl;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getBoolean()", bl2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getBoolean()", bl2);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte getByte(int n) throws SQLException {
        byte by;
        byte by2 = 0;
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getByte( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            by2 = this.preFetched[n2 = n - 1] ? this.rowObj.getByte(n2) : this.getByteData(n);
            by = by2;
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return by;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getByte()", by2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getByte()", by2);
        return by;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short getShort(int n) throws SQLException {
        short s;
        short s2 = 0;
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getShort( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            s2 = this.preFetched[n2 = n - 1] ? this.rowObj.getShort(n2) : this.getShortData(n);
            s = s2;
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return s;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getShort()", s2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getShort()", s2);
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInt(int n) throws SQLException {
        int n2;
        int n3 = 0;
        try {
            int n4;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getInt( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            n3 = this.preFetched[n4 = n - 1] ? this.rowObj.getInt(n4) : this.getIntData(n);
            n2 = n3;
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return n2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getInt()", n3);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getInt()", n3);
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLong(int n) throws SQLException {
        long l;
        long l2 = 0L;
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getLong( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            l2 = this.preFetched[n2 = n - 1] ? this.rowObj.getLong(n2) : this.getLongData(n);
            l = l2;
            Object var7_5 = null;
            if (!DB2Trace.TraceOn) return l;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getLong()", l2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getLong()", l2);
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getFloat(int n) throws SQLException {
        float f;
        float f2 = 0.0f;
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getFloat( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            f2 = this.preFetched[n2 = n - 1] ? this.rowObj.getFloat(n2) : this.getFloatData(n);
            f = f2;
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return f;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getFloat()", f2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getFloat()", f2);
        return f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getDouble(int n) throws SQLException {
        double d;
        double d2 = 0.0;
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDouble( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            d2 = this.preFetched[n2 = n - 1] ? this.rowObj.getDouble(n2) : this.getDoubleData(n);
            d = d2;
            Object var7_5 = null;
            if (!DB2Trace.TraceOn) return d;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getDouble()", d2);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getDouble()", d2);
        return d;
    }

    protected static String cvtScientific(String string) throws NumberFormatException {
        char c;
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < n) {
            c = string.charAt(n6);
            if (n2 < 0) {
                if (!Character.isWhitespace(c)) {
                    n2 = n5 = n6;
                    if (c == '.' || c == ',') {
                        n3 = n6;
                    }
                }
            } else if (n3 < 0 && n4 < 0 && (c == ',' || c == '.')) {
                n3 = n5 = n6;
            } else if (n4 < 0 && (c == 'e' || c == 'E')) {
                n4 = n5 = n6;
            } else if (!Character.isWhitespace(c)) {
                n5 = n6;
            }
            ++n6;
        }
        if (n2 < 0) {
            return "";
        }
        if (n4 < 0) {
            if (n2 > 0 || n5 < n - 1) {
                string = string.substring(n2, n5 + 1);
            }
            if (n3 >= 0 && string.charAt(n3) == ',') {
                string = string.replace(',', '.');
            }
        } else {
            int n7 = 1;
            int n8 = 0;
            n6 = n4 + 1;
            c = string.charAt(n6);
            if (c == '-') {
                n7 = -1;
                ++n6;
            } else if (c == '+') {
                ++n6;
            }
            while (n6 <= n5) {
                if (!Character.isDigit(c = string.charAt(n6++))) {
                    throw new NumberFormatException();
                }
                n8 = n8 * 10 + Character.digit(c, 10);
            }
            n8 *= n7;
            if (n3 >= 0) {
                n8 -= n4 - n3 - 1;
            }
            if ((c = string.charAt(n2)) == '-') {
                n7 = -1;
                ++n2;
            } else if (c == '+') {
                n7 = 1;
                ++n2;
            } else {
                n7 = 1;
            }
            int n9 = n4 - n2 - (n3 >= 0 ? 1 : 0);
            int n10 = 0;
            int n11 = -1;
            int n12 = 0;
            if (n8 >= 0) {
                n11 = -1;
                n10 = 0;
                n12 = n9 + n8;
            } else if (n8 < 0 && -n8 >= n9) {
                n11 = 0;
                n10 = -n8 - n9 + 1;
                n12 = n10 + n9;
            } else {
                n11 = n9 + n8;
                n10 = 0;
                n12 = n9 + 1;
            }
            if (n7 < 0) {
                if (n11 >= 0) {
                    ++n11;
                }
                ++n10;
                ++n12;
            }
            char[] cArray = new char[n12];
            n6 = 0;
            while (n6 < n12) {
                cArray[n6] = 48;
                ++n6;
            }
            if (n7 < 0) {
                cArray[0] = 45;
            }
            if (n11 >= 0) {
                cArray[n11] = 46;
            }
            n6 = n10;
            int n13 = n2;
            while (n13 < n4) {
                if (n13 == n3 && ++n13 >= n4) break;
                if (n6 == n11) {
                    ++n6;
                }
                cArray[n6] = string.charAt(n13);
                ++n6;
                ++n13;
            }
            string = new String(cArray);
        }
        return string;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBigDecimal( " + n + ", " + n2 + " )");
            }
            if ((bigDecimal = this.getBigDecimal(n)) != null) {
                bigDecimal = bigDecimal.setScale(n2, 4);
            }
            BigDecimal bigDecimal2 = bigDecimal;
            Object var6_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getBigDecimal()", bigDecimal == null ? null : bigDecimal.toString());
            }
            return bigDecimal2;
        }
        catch (Throwable throwable) {
            block5: {
                Object var6_6 = null;
                if (!DB2Trace.TraceOn) break block5;
                DB2Trace.methodExit((Object)this, "getBigDecimal()", bigDecimal == null ? null : bigDecimal.toString());
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray;
        byte[] byArray2 = null;
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBytes( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            byArray2 = this.preFetched[n2 = n - 1] ? this.rowObj.getBytes(n2) : this.getBytesData(n);
            byArray = byArray2;
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return byArray;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit(this, "getBytes()");
            throw throwable;
        }
        DB2Trace.methodExit(this, "getBytes()");
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        return this.getDateData(n, Calendar.getInstance());
    }

    public Time getTime(int n) throws SQLException {
        return this.getTimeData(n, Calendar.getInstance());
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestampData(n, Calendar.getInstance());
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            int n2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBigDecimal( " + n + " )");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            bigDecimal = this.preFetched[n2 = n - 1] ? this.rowObj.getBigDecimal(n2) : this.getBigDecimalData(n);
            BigDecimal bigDecimal2 = bigDecimal;
            Object var5_5 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getBigDecimal()", bigDecimal == null ? null : bigDecimal.toString());
            }
            return bigDecimal2;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_6 = null;
                if (!DB2Trace.TraceOn) break block7;
                DB2Trace.methodExit((Object)this, "getBigDecimal()", bigDecimal == null ? null : bigDecimal.toString());
            }
            throw throwable;
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        int n2;
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.colCount) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        if (this.preFetched[n2 = n - 1]) {
            return this.rowObj.getAsciiStream(n2);
        }
        String string = this.getASCIIStringData(n2);
        if (this.nullTag) {
            return null;
        }
        if (string == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(string.getBytes());
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        int n2;
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.colCount) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        if (this.preFetched[n2 = n - 1]) {
            return this.rowObj.getUnicodeStream(n2);
        }
        String string = this.getString(n);
        if (this.nullTag) {
            return null;
        }
        if (string == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            return new ByteArrayInputStream(string.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException(unsupportedEncodingException.toString());
        }
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        int n2;
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.colCount) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        if (this.preFetched[n2 = n - 1]) {
            return this.rowObj.getBinaryStream(n2);
        }
        byte[] byArray = this.getBytesData(n);
        if (this.nullTag) {
            return null;
        }
        if (byArray == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(byArray);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDateData(this.findColumn(string), Calendar.getInstance());
    }

    public Time getTime(String string) throws SQLException {
        return this.getTimeData(this.findColumn(string), Calendar.getInstance());
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestampData(this.findColumn(string), Calendar.getInstance());
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.statement.warnings;
    }

    public void clearWarnings() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        this.statement.warnings = null;
    }

    protected void addWarning(SQLWarning sQLWarning) {
        this.statement.addWarning(sQLWarning);
    }

    public String getCursorName() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        String string = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)44);
                this.db2req.write(this.stmtHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n == 0 || n == 1) {
                    string = this.db2req.readString();
                    if (n != 0) {
                        this.sqlExcptGen.check_return_code(this.statement, n);
                    }
                } else {
                    this.sqlExcptGen.check_return_code(this.statement, n);
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return string;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.rsMetaData;
    }

    public Object getObject(int n) throws SQLException {
        int n2;
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 1 || n > this.colCount) {
            this.sqlExcptGen.throwColumnIndexError();
        }
        if (this.preFetched[n2 = n - 1]) {
            return this.rowObj.getObject(n2);
        }
        return this.getObjectData(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n = 0;
        int n2 = 0;
        string = string.toUpperCase(Locale.US);
        if (this.name2Index == null) {
            n2 = this.statement.colCount4JSQL > 0 ? this.statement.colCount4JSQL : this.rsMetaData.getColumnCount();
            this.name2Index = new Hashtable((int)((double)n2 / 0.75 + 0.7));
            int n3 = 1;
            while (n3 <= n2) {
                String string2 = this.statement.colCount4JSQL > 0 ? this.statement.colNames4JSQL[n3 - 1] : this.rsMetaData.getColumnName(n3);
                if (string2 != null && !this.name2Index.containsKey(string2 = string2.toUpperCase(Locale.US))) {
                    this.name2Index.put(string2, new Integer(n3));
                    if (string2.equals(string)) {
                        n = n3;
                    }
                }
                ++n3;
            }
        } else {
            Integer n4 = (Integer)this.name2Index.get(string);
            if (n4 != null) {
                return n4;
            }
        }
        if (n == 0) {
            this.sqlExcptGen.rsException("S0022");
        }
        return n;
    }

    protected int getMappedColumn(int n) throws SQLException {
        return n;
    }

    protected String getStringData(int n) throws SQLException {
        int n2 = 0;
        String string = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n3;
                this.db2req.write((short)39);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n3 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    string = this.db2req.readString();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return string;
    }

    protected String getASCIIStringData(int n) throws SQLException {
        int n2 = 0;
        String string = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n3;
                this.db2req.write((short)33);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n3 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    string = this.db2req.readASCIIString();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return string;
    }

    protected boolean getBooleanData(int n) throws SQLException {
        int n2 = 0;
        boolean bl = false;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n3;
                this.db2req.write((short)36);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n3 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    int n4 = this.db2req.readInt();
                    if (n4 != 0) {
                        bl = true;
                    }
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return bl;
    }

    protected byte getByteData(int n) throws SQLException {
        int n2 = 0;
        short s = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n3;
                this.db2req.write((short)35);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n3 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    s = this.db2req.readShort();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return (byte)s;
    }

    protected short getShortData(int n) throws SQLException {
        int n2 = 0;
        short s = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n3;
                this.db2req.write((short)35);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n3 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    s = this.db2req.readShort();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return s;
    }

    protected int getIntData(int n) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n4;
                this.db2req.write((short)36);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    n3 = this.db2req.readInt();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n3;
    }

    protected long getLongData(int n) throws SQLException {
        int n2 = 0;
        long l = 0L;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n3;
                this.db2req.write((short)46);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n3 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    l = this.db2req.readLong();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return l;
    }

    protected float getFloatData(int n) throws SQLException {
        int n2 = 0;
        float f = 0.0f;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n3;
                this.db2req.write((short)37);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n3 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    f = this.db2req.readFloat();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return f;
    }

    protected double getDoubleData(int n) throws SQLException {
        int n2 = 0;
        double d = 0.0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n3;
                this.db2req.write((short)38);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n3 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    d = this.db2req.readDouble();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return d;
    }

    protected BigDecimal getBigDecimalData(int n) throws SQLException {
        int n2 = 0;
        BigDecimal bigDecimal = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n3;
                this.db2req.write((short)39);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n3 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    String string = this.db2req.readString();
                    try {
                        string = DB2ResultSet.cvtScientific(string);
                        bigDecimal = new BigDecimal(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.sqlExcptGen.rsException("22005");
                    }
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return bigDecimal;
    }

    protected byte[] getBytesData(int n) throws SQLException {
        int n2 = 0;
        byte[] byArray = null;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                int n3;
                this.db2req.write((short)40);
                this.db2req.write(this.stmtHandle);
                this.db2req.write((short)n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
                if (n2 != 0 && n2 != 1) {
                    this.sqlExcptGen.check_return_code(this.statement, n2);
                }
                if ((n3 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                    this.nullTag = false;
                    byArray = this.db2req.readBytes();
                } else {
                    this.nullTag = true;
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return byArray;
    }

    protected Date getDateData(int n, Calendar calendar) throws SQLException {
        int n2 = 0;
        Date date = null;
        try {
            int n3;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDateData(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            if (this.preFetched[n3 = n - 1]) {
                date = this.rowObj.getDate(n3, calendar);
            } else {
                try {
                    DB2Request dB2Request = this.db2req;
                    synchronized (dB2Request) {
                        int n4;
                        this.db2req.write((short)41);
                        this.db2req.write(this.stmtHandle);
                        this.db2req.write((short)n);
                        this.db2req.sendAndRecv();
                        n2 = this.db2req.readInt();
                        if (n2 != 0 && n2 != 1) {
                            this.sqlExcptGen.check_return_code(this.statement, n2);
                        }
                        if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                            this.nullTag = false;
                            this.year = this.db2req.readInt();
                            this.month = this.db2req.readInt();
                            this.day = this.db2req.readInt();
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Year(+1900)", this.year + 1900);
                                DB2Trace.data(10, "Month(+1)", this.month + 1);
                                DB2Trace.data(10, "Day", this.day);
                            }
                            calendar = (Calendar)calendar.clone();
                            calendar.set(this.year + 1900, this.month, this.day, 0, 0, 0);
                            calendar.set(14, 0);
                            date = new Date(calendar.getTime().getTime());
                        } else {
                            this.nullTag = true;
                        }
                    }
                    DB2Trace.data(20, "year");
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.socketException("08S01a");
                }
            }
            Date date2 = date;
            Object var8_9 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getDateData(...)", date == null ? "NULL" : date.toString());
            }
            return date2;
        }
        catch (Throwable throwable) {
            block18: {
                Object var8_10 = null;
                if (!DB2Trace.TraceOn) break block18;
                DB2Trace.methodExit((Object)this, "getDateData(...)", date == null ? "NULL" : date.toString());
            }
            throw throwable;
        }
    }

    protected Time getTimeData(int n, Calendar calendar) throws SQLException {
        int n2 = 0;
        Time time = null;
        try {
            int n3;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTimeData(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            if (this.preFetched[n3 = n - 1]) {
                time = this.rowObj.getTime(n3, calendar);
            } else {
                try {
                    DB2Request dB2Request = this.db2req;
                    synchronized (dB2Request) {
                        int n4;
                        this.db2req.write((short)42);
                        this.db2req.write(this.stmtHandle);
                        this.db2req.write((short)n);
                        this.db2req.sendAndRecv();
                        n2 = this.db2req.readInt();
                        if (n2 != 0 && n2 != 1) {
                            this.sqlExcptGen.check_return_code(this.statement, n2);
                        }
                        if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                            this.nullTag = false;
                            this.hour = this.db2req.readInt();
                            this.minute = this.db2req.readInt();
                            this.second = this.db2req.readInt();
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Hour", this.hour);
                                DB2Trace.data(10, "Minute", this.minute);
                                DB2Trace.data(10, "Second", this.second);
                            }
                            calendar = (Calendar)calendar.clone();
                            calendar.set(1970, 0, 1, this.hour, this.minute, this.second);
                            calendar.set(14, 0);
                            time = new Time(calendar.getTime().getTime());
                        } else {
                            this.nullTag = true;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.socketException("08S01a");
                }
            }
            Time time2 = time;
            Object var8_9 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTimeData(...)", time == null ? "NULL" : time.toString());
            }
            return time2;
        }
        catch (Throwable throwable) {
            block19: {
                Object var8_10 = null;
                if (!DB2Trace.TraceOn) break block19;
                DB2Trace.methodExit((Object)this, "getTimeData(...)", time == null ? "NULL" : time.toString());
            }
            throw throwable;
        }
    }

    protected Timestamp getTimestampData(int n, Calendar calendar) throws SQLException {
        int n2 = 0;
        Timestamp timestamp = null;
        try {
            int n3;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTimestampData(" + n + ", calTimeZone=" + calendar.getTimeZone().getID() + ")");
            }
            if (this.connection.closed) {
                SQLExceptionGenerator.throwConnectionClosedError();
            }
            if (this.statement.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (n < 1 || n > this.colCount) {
                this.sqlExcptGen.throwColumnIndexError();
            }
            if (this.preFetched[n3 = n - 1]) {
                timestamp = this.rowObj.getTimestamp(n3, calendar);
            } else {
                try {
                    DB2Request dB2Request = this.db2req;
                    synchronized (dB2Request) {
                        int n4;
                        this.db2req.write((short)43);
                        this.db2req.write(this.stmtHandle);
                        this.db2req.write((short)n);
                        this.db2req.sendAndRecv();
                        n2 = this.db2req.readInt();
                        if (n2 != 0 && n2 != 1) {
                            this.sqlExcptGen.check_return_code(this.statement, n2);
                        }
                        if ((n4 = this.db2req.readInt()) != this.SQL_NULL_DATA) {
                            this.nullTag = false;
                            this.year = this.db2req.readInt();
                            this.month = this.db2req.readInt();
                            this.day = this.db2req.readInt();
                            this.hour = this.db2req.readInt();
                            this.minute = this.db2req.readInt();
                            this.second = this.db2req.readInt();
                            this.nano = this.db2req.readInt();
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "Year(+1900)", this.year + 1900);
                                DB2Trace.data(10, "Month(+1)", this.month + 1);
                                DB2Trace.data(10, "Day", this.day);
                                DB2Trace.data(10, "Hour", this.hour);
                                DB2Trace.data(10, "Minute", this.minute);
                                DB2Trace.data(10, "Second", this.second);
                                DB2Trace.data(10, "Nano", this.nano);
                            }
                            calendar = (Calendar)calendar.clone();
                            calendar.set(this.year + 1900, this.month, this.day, this.hour, this.minute, this.second);
                            calendar.set(14, 0);
                            timestamp = new Timestamp(calendar.getTime().getTime());
                            timestamp.setNanos(this.nano);
                        } else {
                            this.nullTag = true;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.socketException("08S01a");
                }
            }
            Timestamp timestamp2 = timestamp;
            Object var8_9 = null;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTimestampData(...)", timestamp == null ? "NULL" : timestamp.toString());
            }
            return timestamp2;
        }
        catch (Throwable throwable) {
            block19: {
                Object var8_10 = null;
                if (!DB2Trace.TraceOn) break block19;
                DB2Trace.methodExit((Object)this, "getTimestampData(...)", timestamp == null ? "NULL" : timestamp.toString());
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getObjectData(int n) throws SQLException {
        Object var2_26;
        block51: {
            String string;
            block50: {
                byte[] byArray;
                block49: {
                    Timestamp timestamp;
                    block48: {
                        Time time;
                        block47: {
                            Date date;
                            block46: {
                                byte[] byArray2;
                                block45: {
                                    Double d;
                                    block44: {
                                        Object var2_18;
                                        block43: {
                                            Float f;
                                            block42: {
                                                Object var2_16;
                                                block41: {
                                                    Long l;
                                                    block40: {
                                                        Object var2_14;
                                                        block39: {
                                                            Integer n2;
                                                            block38: {
                                                                Object var2_12;
                                                                block37: {
                                                                    Integer n3;
                                                                    block36: {
                                                                        Object var2_10;
                                                                        block35: {
                                                                            Integer n4;
                                                                            block34: {
                                                                                Object var2_8;
                                                                                block33: {
                                                                                    Boolean bl;
                                                                                    block32: {
                                                                                        Object var2_6;
                                                                                        block31: {
                                                                                            BigDecimal bigDecimal;
                                                                                            block30: {
                                                                                                String string2;
                                                                                                block29: {
                                                                                                    try {
                                                                                                        int n5 = this.rowObj.sqltype[n - 1];
                                                                                                        if (DB2Trace.TraceOn) {
                                                                                                            DB2Trace.methodEntry(this, "getObjectData( " + n + " )");
                                                                                                            DB2Trace.data(10, "sqlType", n5);
                                                                                                        }
                                                                                                        if (n5 == -450) {
                                                                                                            n5 = this.rsMetaData.colBaseTypesNotAdjusted[n - 1];
                                                                                                        }
                                                                                                        if (DB2Trace.TraceOn) {
                                                                                                            DB2Trace.data(20, "sqlType", n5);
                                                                                                        }
                                                                                                        short s = 0;
                                                                                                        switch (n5) {
                                                                                                            case -97: 
                                                                                                            case -96: 
                                                                                                            case -95: 
                                                                                                            case -10: 
                                                                                                            case -9: 
                                                                                                            case -8: 
                                                                                                            case -1: 
                                                                                                            case 1: 
                                                                                                            case 12: {
                                                                                                                string2 = this.getStringData(n);
                                                                                                                Object var4_27 = null;
                                                                                                                if (!DB2Trace.TraceOn) return string2;
                                                                                                                break block29;
                                                                                                            }
                                                                                                            case 2: 
                                                                                                            case 3: {
                                                                                                                bigDecimal = this.getBigDecimalData(n);
                                                                                                                break block30;
                                                                                                            }
                                                                                                            case -7: {
                                                                                                                boolean bl2 = this.getBooleanData(n);
                                                                                                                if (this.wasNull()) {
                                                                                                                    var2_6 = null;
                                                                                                                    break block31;
                                                                                                                }
                                                                                                                bl = new Boolean(bl2);
                                                                                                                break block32;
                                                                                                            }
                                                                                                            case -6: {
                                                                                                                s = this.getShortData(n);
                                                                                                                if (this.wasNull()) {
                                                                                                                    var2_8 = null;
                                                                                                                    break block33;
                                                                                                                }
                                                                                                                n4 = new Integer(s);
                                                                                                                break block34;
                                                                                                            }
                                                                                                            case 5: {
                                                                                                                s = this.getShortData(n);
                                                                                                                if (this.wasNull()) {
                                                                                                                    var2_10 = null;
                                                                                                                    break block35;
                                                                                                                }
                                                                                                                n3 = new Integer(s);
                                                                                                                break block36;
                                                                                                            }
                                                                                                            case 4: {
                                                                                                                int n6 = this.getIntData(n);
                                                                                                                if (this.wasNull()) {
                                                                                                                    var2_12 = null;
                                                                                                                    break block37;
                                                                                                                }
                                                                                                                n2 = new Integer(n6);
                                                                                                                break block38;
                                                                                                            }
                                                                                                            case -5: {
                                                                                                                long l2 = this.getLongData(n);
                                                                                                                if (this.wasNull()) {
                                                                                                                    var2_14 = null;
                                                                                                                    break block39;
                                                                                                                }
                                                                                                                l = new Long(l2);
                                                                                                                break block40;
                                                                                                            }
                                                                                                            case 6: 
                                                                                                            case 7: {
                                                                                                                float f2 = this.getFloatData(n);
                                                                                                                if (this.wasNull()) {
                                                                                                                    var2_16 = null;
                                                                                                                    break block41;
                                                                                                                }
                                                                                                                f = new Float(f2);
                                                                                                                break block42;
                                                                                                            }
                                                                                                            case 8: {
                                                                                                                double d2 = this.getDoubleData(n);
                                                                                                                if (this.wasNull()) {
                                                                                                                    var2_18 = null;
                                                                                                                    break block43;
                                                                                                                }
                                                                                                                d = new Double(d2);
                                                                                                                break block44;
                                                                                                            }
                                                                                                            case -4: 
                                                                                                            case -3: 
                                                                                                            case -2: {
                                                                                                                byArray2 = this.getBytesData(n);
                                                                                                                break block45;
                                                                                                            }
                                                                                                            case 91: {
                                                                                                                date = this.getDateData(n, Calendar.getInstance());
                                                                                                                break block46;
                                                                                                            }
                                                                                                            case 92: {
                                                                                                                time = this.getTimeData(n, Calendar.getInstance());
                                                                                                                break block47;
                                                                                                            }
                                                                                                            case 93: {
                                                                                                                timestamp = this.getTimestampData(n, Calendar.getInstance());
                                                                                                                break block48;
                                                                                                            }
                                                                                                            case -98: 
                                                                                                            case 31: {
                                                                                                                byArray = this.getBytesData(n);
                                                                                                                break block49;
                                                                                                            }
                                                                                                            case -351: 
                                                                                                            case -350: 
                                                                                                            case -99: 
                                                                                                            case 41: {
                                                                                                                string = this.getStringData(n);
                                                                                                                break block50;
                                                                                                            }
                                                                                                            default: {
                                                                                                                this.sqlExcptGen.rsException("S1004");
                                                                                                                var2_26 = null;
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        break block51;
                                                                                                    }
                                                                                                    catch (Throwable throwable) {
                                                                                                        Object var4_50 = null;
                                                                                                        if (!DB2Trace.TraceOn) throw throwable;
                                                                                                        DB2Trace.methodExit(this, "getObjectData()");
                                                                                                        throw throwable;
                                                                                                    }
                                                                                                }
                                                                                                DB2Trace.methodExit(this, "getObjectData()");
                                                                                                return string2;
                                                                                            }
                                                                                            Object var4_28 = null;
                                                                                            if (!DB2Trace.TraceOn) return bigDecimal;
                                                                                            DB2Trace.methodExit(this, "getObjectData()");
                                                                                            return bigDecimal;
                                                                                        }
                                                                                        Object var4_29 = null;
                                                                                        if (!DB2Trace.TraceOn) return var2_6;
                                                                                        DB2Trace.methodExit(this, "getObjectData()");
                                                                                        return var2_6;
                                                                                    }
                                                                                    Object var4_30 = null;
                                                                                    if (!DB2Trace.TraceOn) return bl;
                                                                                    DB2Trace.methodExit(this, "getObjectData()");
                                                                                    return bl;
                                                                                }
                                                                                Object var4_31 = null;
                                                                                if (!DB2Trace.TraceOn) return var2_8;
                                                                                DB2Trace.methodExit(this, "getObjectData()");
                                                                                return var2_8;
                                                                            }
                                                                            Object var4_32 = null;
                                                                            if (!DB2Trace.TraceOn) return n4;
                                                                            DB2Trace.methodExit(this, "getObjectData()");
                                                                            return n4;
                                                                        }
                                                                        Object var4_33 = null;
                                                                        if (!DB2Trace.TraceOn) return var2_10;
                                                                        DB2Trace.methodExit(this, "getObjectData()");
                                                                        return var2_10;
                                                                    }
                                                                    Object var4_34 = null;
                                                                    if (!DB2Trace.TraceOn) return n3;
                                                                    DB2Trace.methodExit(this, "getObjectData()");
                                                                    return n3;
                                                                }
                                                                Object var4_35 = null;
                                                                if (!DB2Trace.TraceOn) return var2_12;
                                                                DB2Trace.methodExit(this, "getObjectData()");
                                                                return var2_12;
                                                            }
                                                            Object var4_36 = null;
                                                            if (!DB2Trace.TraceOn) return n2;
                                                            DB2Trace.methodExit(this, "getObjectData()");
                                                            return n2;
                                                        }
                                                        Object var4_37 = null;
                                                        if (!DB2Trace.TraceOn) return var2_14;
                                                        DB2Trace.methodExit(this, "getObjectData()");
                                                        return var2_14;
                                                    }
                                                    Object var4_38 = null;
                                                    if (!DB2Trace.TraceOn) return l;
                                                    DB2Trace.methodExit(this, "getObjectData()");
                                                    return l;
                                                }
                                                Object var4_39 = null;
                                                if (!DB2Trace.TraceOn) return var2_16;
                                                DB2Trace.methodExit(this, "getObjectData()");
                                                return var2_16;
                                            }
                                            Object var4_40 = null;
                                            if (!DB2Trace.TraceOn) return f;
                                            DB2Trace.methodExit(this, "getObjectData()");
                                            return f;
                                        }
                                        Object var4_41 = null;
                                        if (!DB2Trace.TraceOn) return var2_18;
                                        DB2Trace.methodExit(this, "getObjectData()");
                                        return var2_18;
                                    }
                                    Object var4_42 = null;
                                    if (!DB2Trace.TraceOn) return d;
                                    DB2Trace.methodExit(this, "getObjectData()");
                                    return d;
                                }
                                Object var4_43 = null;
                                if (!DB2Trace.TraceOn) return byArray2;
                                DB2Trace.methodExit(this, "getObjectData()");
                                return byArray2;
                            }
                            Object var4_44 = null;
                            if (!DB2Trace.TraceOn) return date;
                            DB2Trace.methodExit(this, "getObjectData()");
                            return date;
                        }
                        Object var4_45 = null;
                        if (!DB2Trace.TraceOn) return time;
                        DB2Trace.methodExit(this, "getObjectData()");
                        return time;
                    }
                    Object var4_46 = null;
                    if (!DB2Trace.TraceOn) return timestamp;
                    DB2Trace.methodExit(this, "getObjectData()");
                    return timestamp;
                }
                Object var4_47 = null;
                if (!DB2Trace.TraceOn) return byArray;
                DB2Trace.methodExit(this, "getObjectData()");
                return byArray;
            }
            Object var4_48 = null;
            if (!DB2Trace.TraceOn) return string;
            DB2Trace.methodExit(this, "getObjectData()");
            return string;
        }
        Object var4_49 = null;
        if (!DB2Trace.TraceOn) return var2_26;
        DB2Trace.methodExit(this, "getObjectData()");
        return var2_26;
    }

    protected String getTraceHandle() {
        String string = "??";
        if (this.statement != null) {
            string = this.statement.getTraceHandle();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRow() throws SQLException {
        int n;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getRow()");
            }
            n = this.currentRowId;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "getRow()", this.currentRowId);
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "getRow()", this.currentRowId);
        return n;
    }
}

