/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2CallableStatement;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2PreparedStatement;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2RequestTrace;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.net.DB2Socket;
import COM.ibm.db2.jdbc.net.SQLExceptionGenerator;
import java.io.IOException;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DB2Statement
implements Statement {
    protected static final short STMT_TYPE_QUERY = 24;
    protected static final short STMT_TYPE_CALL = 25;
    protected static final short STMT_TYPE_OTHER = 26;
    protected static final short STMT_TYPE_SQLJ = 27;
    protected int statementHandle;
    protected DB2Connection connection;
    protected SQLWarning warnings;
    protected int maxRows;
    protected int maxFieldSize;
    protected int rowCount;
    protected int colCount;
    protected boolean closed = false;
    protected boolean internalStmt = false;
    protected String[] colNames4JSQL;
    protected int colCount4JSQL;
    protected DB2Request db2req;
    protected SQLExceptionGenerator sqlExcptGen;
    protected DB2ResultSet resultSet;
    protected boolean moreResults = true;
    protected boolean prefetchedMoreResults = false;
    protected int CLIBlockSize;
    private boolean counted = false;
    private static int statementCount;
    private static int peakStatementCount;
    protected String sql;
    protected int SQL_SUCCESS = 0;
    protected int SQL_SUCCESS_WITH_INFO = 1;
    protected int rsType = 1003;
    protected int rsConcur = 1007;

    public DB2Statement(DB2Connection dB2Connection, boolean bl, int n, int n2) throws SQLException {
        this.connection = dB2Connection;
        this.internalStmt = bl;
        this.sqlExcptGen = dB2Connection.sqlExcptGen;
        this.rsType = n;
        this.rsConcur = n2;
        this.db2req = !DB2Trace.TraceOn ? new DB2Request(dB2Connection) : new DB2RequestTrace(dB2Connection);
        int n3 = 0;
        try {
            this.db2req.write((short)11);
            this.db2req.write((short)this.rsType);
            this.db2req.sendAndRecv();
            n3 = this.db2req.readInt();
            this.statementHandle = this.db2req.readInt();
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        if (n3 != this.SQL_SUCCESS) {
            this.sqlExcptGen.check_return_code(this, n3);
        }
        this.incrementStatementCount();
    }

    public DB2Statement(DB2Connection dB2Connection, boolean bl) throws SQLException {
        this(dB2Connection, bl, 1003, 1007);
    }

    public DB2Statement(DB2Connection dB2Connection) throws SQLException {
        this(dB2Connection, false);
    }

    public DB2Statement() throws SQLException {
    }

    private synchronized void incrementStatementCount() {
        if (!this.counted) {
            DB2Statement.adjustStatementCount(1);
            this.counted = true;
        }
    }

    private synchronized void decrementStatementCount() {
        if (this.counted) {
            DB2Statement.adjustStatementCount(-1);
            this.counted = false;
        }
    }

    private static synchronized void adjustStatementCount(int n) {
        if ((statementCount += n) > peakStatementCount) {
            peakStatementCount = statementCount;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Peak statements", peakStatementCount);
            }
            DriverManager.println("DB2 Peak statements = " + peakStatementCount);
        }
    }

    public static int getStatementCount() {
        return statementCount;
    }

    public static int getPeakStatementCount() {
        return peakStatementCount;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DB2Connection getDB2Connection() {
        return this.connection;
    }

    public int getHandle() {
        return this.statementHandle;
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.decrementStatementCount();
        if (this.connection == null) {
            return;
        }
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            if (this.connection.closed) {
                Object var2_2 = null;
                return;
            }
            if (this.resultSet != null) {
                this.resultSet.clearIsList();
                this.resultSet = null;
            }
            int n = 0;
            try {
                DB2Request dB2Request = this.db2req;
                synchronized (dB2Request) {
                    this.db2req.write((short)13);
                    this.db2req.write(this.statementHandle);
                    this.db2req.sendAndRecv();
                    n = this.db2req.readInt();
                }
            }
            catch (IOException iOException) {
                this.sqlExcptGen.socketException("08S01a");
            }
            this.statementHandle = 0;
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
            }
            return;
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    public void finalize() throws SQLException {
        block5: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "finalize()");
                }
                if (this.closed) break block5;
                String string = null;
                string = this instanceof DB2CallableStatement ? "DB2CallableStatement closed in finalizer: \"" + this.sql + "\"" : (this instanceof DB2PreparedStatement ? "DB2PreparedStatement closed in finalizer: \"" + this.sql + "\"" : "DB2Statement closed in finalizer, last SQL: \"" + this.sql + "\"");
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, string);
                }
                DriverManager.println(string);
                this.close();
            }
            catch (Throwable throwable) {
                block6: {
                    Object var2_3 = null;
                    if (!DB2Trace.TraceOn) break block6;
                    DB2Trace.methodExit(this, "finalize()");
                }
                throw throwable;
            }
        }
        Object var2_2 = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "finalize()");
        }
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.maxFieldSize;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 0) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        if (this.maxFieldSize == n) {
            return;
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)17);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.maxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        return this.maxRows;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.maxRows == n) {
            return;
        }
        if (n < 0) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)18);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        try {
            int n;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)19);
                this.db2req.write(this.statementHandle);
                short s = 0;
                if (bl) {
                    s = 1;
                }
                this.db2req.write(s);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
            }
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
                return;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public int getQueryTimeout() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        int n = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)21);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n2 = this.db2req.readInt();
                if (n2 != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n2);
                } else {
                    n = this.db2req.readInt();
                }
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return n;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (n < 0) {
            SQLExceptionGenerator.throwOutOfRangeError();
        }
        try {
            int n2;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)20);
                this.db2req.write(this.statementHandle);
                this.db2req.write(n);
                this.db2req.sendAndRecv();
                n2 = this.db2req.readInt();
            }
            if (n2 != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n2);
                return;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public void cancel() throws SQLException {
        DB2Request dB2Request;
        DB2Socket dB2Socket;
        block27: {
            Object object2;
            dB2Socket = null;
            dB2Request = null;
            int n = -99999;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "cancel()");
                }
                if (this.connection.closed) {
                    SQLExceptionGenerator.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                try {
                    object2 = this.connection.getServer();
                    int n2 = new Integer(this.connection.getPortStr());
                    dB2Socket = new DB2Socket(new Socket((String)object2, n2), this.connection);
                    DB2Request dB2Request2 = dB2Request = new DB2Request(dB2Socket);
                    synchronized (dB2Request2) {
                        dB2Request.write((short)23);
                        dB2Request.write(this.statementHandle);
                        dB2Request.sendAndRecv();
                        n = dB2Request.readInt();
                    }
                    if (n != 0 && n != 1) {
                        throw new DB2Exception("Cancel Failed");
                    }
                }
                catch (IOException iOException) {
                    this.sqlExcptGen.socketException("08S01a");
                }
                Object var5_8 = null;
            }
            catch (Throwable throwable) {
                block31: {
                    block30: {
                        Object var5_9 = null;
                        try {
                            if (dB2Request != null) {
                                dB2Request.write((short)2);
                                dB2Request.sendAndRecv();
                                dB2Request.readInt();
                            }
                        }
                        catch (Exception exception) {
                            if (!DB2Trace.TraceOn) break block30;
                            DB2Trace.data(10, "Exception occurred closing db2req2");
                            DB2Trace.data(10, "Exception", exception.getMessage());
                        }
                    }
                    try {
                        if (dB2Request != null) {
                            dB2Request.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (dB2Socket != null) {
                            dB2Socket.close();
                        }
                    }
                    catch (Exception exception) {}
                    dB2Request = null;
                    dB2Socket = null;
                    if (!DB2Trace.TraceOn) break block31;
                    DB2Trace.methodExit(this, "cancel()");
                }
                throw throwable;
            }
            try {
                if (dB2Request != null) {
                    dB2Request.write((short)2);
                    dB2Request.sendAndRecv();
                    dB2Request.readInt();
                }
            }
            catch (Exception object2) {
                if (!DB2Trace.TraceOn) break block27;
                DB2Trace.data(10, "Exception occurred closing db2req2");
                DB2Trace.data(10, "Exception", ((Throwable)object2).getMessage());
            }
        }
        try {
            if (dB2Request != null) {
                dB2Request.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (dB2Socket != null) {
                dB2Socket.close();
            }
        }
        catch (Exception exception) {}
        dB2Request = null;
        dB2Socket = null;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "cancel()");
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public int getStatementHandle() throws SQLException {
        return this.statementHandle;
    }

    public void setCursorName(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        try {
            int n;
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)22);
                this.db2req.write(this.statementHandle);
                this.db2req.write(string);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
            }
            if (n != this.SQL_SUCCESS) {
                this.sqlExcptGen.check_return_code(this, n);
                return;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.prefetchedMoreResults) {
            return null;
        }
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.resultSet == null) {
            this.resultSet = DB2Trace.TraceOn ? new DB2ResultSetTrace(this, this.colCount) : new DB2ResultSet(this, this.colCount);
        }
        if (this.colCount <= 0 || !this.moreResults) {
            return null;
        }
        return this.resultSet;
    }

    public int getUpdateCount() throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (this.colCount > 0 || !this.moreResults) {
            return -1;
        }
        if (this.rowCount < 0) {
            return 0;
        }
        return this.rowCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean getMoreResults() throws SQLException {
        if (this.prefetchedMoreResults) {
            this.prefetchedMoreResults = false;
            return this.moreResults;
        }
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (!this.moreResults) {
            return false;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)15);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n == 100) {
                    this.moreResults = false;
                    return false;
                }
                if (n == this.SQL_SUCCESS || n == this.SQL_SUCCESS_WITH_INFO) {
                    if (n != this.SQL_SUCCESS) {
                        this.sqlExcptGen.check_return_code(this, n);
                    }
                    this.colCount = this.db2req.readShort();
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                    }
                    if (this.colCount != 0) return true;
                    this.rowCount = this.db2req.readInt();
                    return true;
                }
                this.sqlExcptGen.check_return_code(this, n);
                this.moreResults = false;
                return false;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
            this.moreResults = false;
            return false;
        }
    }

    protected synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
            return;
        }
        SQLWarning sQLWarning2 = this.warnings;
        while (sQLWarning2.getNextWarning() != null) {
            sQLWarning2 = sQLWarning2.getNextWarning();
        }
        sQLWarning2.setNextWarning(sQLWarning);
    }

    protected int numberColumns() throws SQLException {
        if (this.colCount != -1) {
            return this.colCount;
        }
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)49);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                int n = this.db2req.readInt();
                if (n != this.SQL_SUCCESS) {
                    this.sqlExcptGen.check_return_code(this, n);
                }
                this.colCount = this.db2req.readShort();
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
        }
        return this.colCount;
    }

    public boolean execute(String string) throws SQLException {
        this.sql = string;
        this.execute2(string);
        return this.colCount > 0;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        short s;
        this.sql = string;
        if (string == null || string.trim().length() == 0) {
            this.sqlExcptGen.throwNullError();
        }
        if ((s = this.getStatementType(string)) != 24 && s != 25 && s != 27) {
            this.sqlExcptGen.throwInvalidQueryError();
        }
        this.execute2(string);
        this.getResultSet();
        return this.resultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected short getStatementType(String string) {
        int n;
        int n2;
        block23: {
            String string2;
            short s;
            block22: {
                n2 = 26;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getStatementType( " + string + " )");
                    }
                    if (string != null) {
                        int n3 = string.length();
                        int n4 = 0;
                        if (n3 > 0 && string.charAt(n4) == '#') {
                            s = 27;
                            Object var5_10 = null;
                            if (!DB2Trace.TraceOn) return s;
                            string2 = null;
                            break block22;
                        }
                        while (true) {
                            char c;
                            if (n4 >= n3 || !Character.isWhitespace(c = string.charAt(n4)) && c != '{' && c != ';' && c != '?' && c != '(' && c != '=') {
                                n2 = string.regionMatches(true, n4, "select", 0, 6) || string.regionMatches(true, n4, "values", 0, 6) || string.regionMatches(true, n4, "with", 0, 4) ? 24 : (string.regionMatches(true, n4, "call", 0, 4) ? 25 : 26);
                            }
                            ++n4;
                        }
                    }
                    n = n2;
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    String string3 = null;
                    switch (n2) {
                        case 24: {
                            string3 = "STMT_TYPE_QUERY (" + 24 + ")";
                            break;
                        }
                        case 25: {
                            string3 = "STMT_TYPE_CALL (" + 25 + ")";
                            break;
                        }
                        case 27: {
                            string3 = "STMT_TYPE_SQLJ (" + 27 + ")";
                            break;
                        }
                        default: {
                            string3 = "STMT_TYPE_OTHER (" + 26 + ")";
                        }
                    }
                    DB2Trace.methodExit((Object)this, "getStatementType()", string3);
                    throw throwable;
                }
            }
            switch (n2) {
                case 24: {
                    string2 = "STMT_TYPE_QUERY (" + 24 + ")";
                    break;
                }
                case 25: {
                    string2 = "STMT_TYPE_CALL (" + 25 + ")";
                    break;
                }
                case 27: {
                    string2 = "STMT_TYPE_SQLJ (" + 27 + ")";
                    break;
                }
                default: {
                    string2 = "STMT_TYPE_OTHER (" + 26 + ")";
                }
            }
            DB2Trace.methodExit((Object)this, "getStatementType()", string2);
            return s;
        }
        Object var5_11 = null;
        if (!DB2Trace.TraceOn) return (short)n;
        String string4 = null;
        switch (n2) {
            case 24: {
                string4 = "STMT_TYPE_QUERY (" + 24 + ")";
                break;
            }
            case 25: {
                string4 = "STMT_TYPE_CALL (" + 25 + ")";
                break;
            }
            case 27: {
                string4 = "STMT_TYPE_SQLJ (" + 27 + ")";
                break;
            }
            default: {
                string4 = "STMT_TYPE_OTHER (" + 26 + ")";
            }
        }
        DB2Trace.methodExit((Object)this, "getStatementType()", string4);
        return (short)n;
    }

    public int executeUpdate(String string) throws SQLException {
        this.sql = string;
        if (this.getStatementType(string) == 24) {
            this.sqlExcptGen.throwInvalidUpdateError();
        }
        this.execute2(string);
        return this.getUpdateCount();
    }

    protected void execute2(String string) throws SQLException {
        if (this.connection.closed) {
            SQLExceptionGenerator.throwConnectionClosedError();
        }
        if (this.closed) {
            this.sqlExcptGen.throwClosedError();
        }
        if (string == null || string.trim().length() == 0) {
            this.sqlExcptGen.throwNullError();
        }
        this.warnings = null;
        this.moreResults = true;
        this.prefetchedMoreResults = false;
        if (this.resultSet != null) {
            this.resultSet.realClose();
        }
        int n = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)12);
                this.db2req.write(this.statementHandle);
                this.db2req.write(string);
                this.db2req.write((short)this.rsType);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
                if (n == 100) {
                    this.rowCount = 0;
                    this.colCount = 0;
                } else if (n == this.SQL_SUCCESS) {
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                    this.CLIBlockSize = this.db2req.readInt();
                    this.rsType = this.db2req.readShort();
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                    }
                } else if (n == this.SQL_SUCCESS_WITH_INFO) {
                    this.sqlExcptGen.check_return_code(this, n);
                    this.getCounts();
                    if (this.resultSet != null && this.colCount > 0) {
                        this.resultSet.reset(this.colCount);
                    }
                } else {
                    this.sqlExcptGen.check_return_code(this, n);
                }
                return;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
            return;
        }
    }

    protected void getCounts() throws SQLException {
        int n = 0;
        try {
            DB2Request dB2Request = this.db2req;
            synchronized (dB2Request) {
                this.db2req.write((short)16);
                this.db2req.write(this.statementHandle);
                this.db2req.sendAndRecv();
                n = this.db2req.readInt();
                if (n == this.SQL_SUCCESS) {
                    this.rowCount = this.db2req.readInt();
                    this.colCount = this.db2req.readShort();
                    this.CLIBlockSize = this.db2req.readInt();
                }
                return;
            }
        }
        catch (IOException iOException) {
            this.sqlExcptGen.socketException("08S01a");
            return;
        }
    }

    protected String getTraceHandle() {
        int n = this.statementHandle >> 16;
        int n2 = this.statementHandle & 0xFFFF;
        String string = String.valueOf(n) + ":" + n2;
        return string;
    }
}

