/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.net;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.net.DB2Connection;
import COM.ibm.db2.jdbc.net.DB2Request;
import COM.ibm.db2.jdbc.net.DB2ResultSet;
import COM.ibm.db2.jdbc.net.DB2Statement;
import COM.ibm.db2.mri.DB2Messages;
import java.io.IOException;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ResourceBundle;

public class SQLExceptionGenerator {
    protected String SQLState;
    protected String SQLmessage;
    protected int SQLnativeCode;
    protected boolean closeConn = false;
    protected static DB2Messages errMsgClass = null;

    SQLExceptionGenerator(DB2Statement dB2Statement) {
        if (errMsgClass == null) {
            errMsgClass = new DB2Messages(dB2Statement.connection.errMsgClass);
        }
    }

    SQLExceptionGenerator(DB2Connection dB2Connection) {
        if (errMsgClass == null) {
            errMsgClass = new DB2Messages(dB2Connection.errMsgClass);
        }
    }

    SQLExceptionGenerator(DB2ResultSet dB2ResultSet) {
        if (errMsgClass == null) {
            errMsgClass = new DB2Messages(dB2ResultSet.statement.connection.errMsgClass);
        }
    }

    public SQLExceptionGenerator(ResourceBundle resourceBundle) {
        errMsgClass = new DB2Messages(resourceBundle);
    }

    protected void TraceException(DB2Connection dB2Connection, String string) {
        DB2Trace.getTraceObj(dB2Connection).traceEntry("SQLExceptionGenerator", string);
        DB2Trace.getTraceObj(dB2Connection).println("SQLState = " + this.SQLState);
        DB2Trace.getTraceObj(dB2Connection).println("SQLmessage = " + this.SQLmessage);
        DB2Trace.getTraceObj(dB2Connection).println("SQLnativeCode = " + this.SQLnativeCode);
        DB2Trace.getTraceObj(dB2Connection).traceExit("SQLExceptionGenerator", string);
    }

    public void throw_SQLException(DB2Connection dB2Connection) throws SQLException {
        DB2Exception dB2Exception = null;
        DB2Exception dB2Exception2 = null;
        boolean bl = this.closeConn;
        int n = this.getSQLConnectionError(dB2Connection);
        while (n != 100 && n != -200 && n != -201) {
            if (this.SQLState.trim().startsWith("01") && !this.SQLState.trim().equals("01004")) {
                dB2Connection.addWarning(new SQLWarning(this.SQLmessage, this.SQLState, this.SQLnativeCode));
            } else {
                if (dB2Exception2 == null) {
                    dB2Exception = dB2Exception2 = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode);
                } else {
                    DB2Exception dB2Exception3 = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode);
                    dB2Exception.setNextException(dB2Exception3);
                    dB2Exception = dB2Exception3;
                }
                if (!bl) {
                    bl = this.closeConn;
                }
            }
            n = this.getSQLConnectionError(dB2Connection);
        }
        if (n == -200) {
            dB2Connection.close();
            throw new DB2Exception(errMsgClass.getString("0623"), "XXXX1", -99999);
        }
        if (n == -201) {
            dB2Connection.close();
            throw new DB2Exception(errMsgClass.getString("0624"), "XXXX2", -99999);
        }
        if (dB2Exception2 != null) {
            if (bl) {
                dB2Connection.close();
            }
            throw dB2Exception2;
        }
    }

    public void throw_SQLException(DB2Statement dB2Statement) throws SQLException {
        this.throw_SQLException(dB2Statement, false);
    }

    public void throw_SQLException(DB2Statement dB2Statement, boolean bl) throws SQLException {
        DB2Exception dB2Exception = null;
        DB2Exception dB2Exception2 = null;
        int n = this.getSQLStatementError(dB2Statement);
        while (n != 100 && n != -200 && n != -201 && n != -2) {
            this.SQLState.trim().equals("08003");
            if (this.SQLState.trim().startsWith("01") && !this.SQLState.trim().equals("01004")) {
                if (this.SQLState.trim().equals("01004")) {
                    dB2Statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                } else if (this.SQLState.trim().equals("01592")) {
                    dB2Statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                } else {
                    dB2Statement.addWarning(new SQLWarning(this.SQLmessage, this.SQLState, this.SQLnativeCode));
                }
            } else if (dB2Exception == null) {
                dB2Exception2 = dB2Exception = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode);
            } else {
                DB2Exception dB2Exception3 = null;
                dB2Exception3 = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode);
                dB2Exception2.setNextException(dB2Exception3);
                dB2Exception2 = dB2Exception3;
            }
            n = this.getSQLStatementError(dB2Statement);
        }
        if (n == -2) {
            throw new DB2Exception(errMsgClass.getString("0601"), "S1000", -99999);
        }
        if (n == -200) {
            throw new DB2Exception(errMsgClass.getString("0623"), "XXXX1", -99999);
        }
        if (n == -201) {
            throw new DB2Exception(errMsgClass.getString("0624"), "XXXX2", -99999);
        }
        if (dB2Exception != null) {
            throw dB2Exception;
        }
    }

    public void addWarning(DB2Connection dB2Connection) throws SQLException {
        if (this.getSQLConnectionError(dB2Connection) != 100) {
            if (DB2Trace.TraceOn) {
                this.TraceException(dB2Connection, "addWarning(DB2Connection)");
            }
            dB2Connection.addWarning(new SQLWarning(this.SQLmessage, this.SQLState, this.SQLnativeCode));
        }
    }

    public void addWarning(DB2Statement dB2Statement) throws SQLException {
        if (this.getSQLStatementError(dB2Statement) != 100) {
            if (DB2Trace.TraceOn) {
                this.TraceException((DB2Connection)dB2Statement.getConnection(), "addWarning(DB2Statement)");
            }
            if (this.SQLState.trim().equals("01004")) {
                dB2Statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                return;
            }
            if (this.SQLState.trim().equals("01592")) {
                dB2Statement.addWarning(new DataTruncation(-1, true, false, -1, -1));
                return;
            }
            dB2Statement.addWarning(new SQLWarning(this.SQLmessage, this.SQLState, this.SQLnativeCode));
        }
    }

    public void addWarning(DB2Statement dB2Statement, DB2ResultSet dB2ResultSet) throws SQLException {
        if (this.getSQLStatementError(dB2Statement) != 100) {
            if (DB2Trace.TraceOn) {
                this.TraceException((DB2Connection)dB2ResultSet.statement.getConnection(), "addWarning(DB2Statement, DB2ResultSet)");
            }
            if (this.SQLState.trim().equals("01004")) {
                dB2ResultSet.addWarning(new DataTruncation(-1, false, false, -1, -1));
                return;
            }
            if (this.SQLState.trim().equals("01592")) {
                dB2ResultSet.addWarning(new DataTruncation(-1, false, false, -1, -1));
                return;
            }
            dB2ResultSet.addWarning(new SQLWarning(this.SQLmessage, this.SQLState, this.SQLnativeCode));
        }
    }

    public void check_return_code(DB2Connection dB2Connection, int n) throws SQLException {
        switch (n) {
            case 1: {
                this.addWarning(dB2Connection);
                return;
            }
            case -2: {
                dB2Connection.close();
                throw new DB2Exception(errMsgClass.getString("0600"), "S1000", -99999, null);
            }
            case -101: {
                dB2Connection.close();
                throw new DB2Exception(errMsgClass.getString("0618"), "28000", -99999);
            }
            case -111: {
                dB2Connection.close();
                throw new DB2Exception(errMsgClass.getString("0621"), "08004", -99999);
            }
            default: {
                this.throw_SQLException(dB2Connection);
            }
            case 0: 
        }
    }

    public void check_batch_return_code(DB2Statement dB2Statement, int n) throws SQLException {
        this.check_return_code(dB2Statement, n, true);
    }

    public void check_return_code(DB2Statement dB2Statement, int n) throws SQLException {
        this.check_return_code(dB2Statement, n, false);
    }

    public void check_return_code(DB2Statement dB2Statement, int n, boolean bl) throws SQLException {
        switch (n) {
            case 1: 
            case 100: {
                this.addWarning(dB2Statement);
                return;
            }
            case -2: {
                throw new DB2Exception(errMsgClass.getString("0601"), "S1000", -99999, null);
            }
            case -100: {
                throw new DB2Exception(errMsgClass.getString("0602"), "S1001", -99999);
            }
            case -200: {
                throw new DB2Exception(errMsgClass.getString("0623"), "XXXX1", -99999);
            }
            case -201: {
                throw new DB2Exception(errMsgClass.getString("0624"), "XXXX1", -99999);
            }
            default: {
                this.throw_SQLException(dB2Statement, bl);
            }
            case 0: 
        }
    }

    public static void throwNotOutputParameterError(DB2Connection dB2Connection) throws SQLException {
        throw new DB2Exception(dB2Connection.errMsgClass.getString("0603"), "S1010", -99999);
    }

    public static void throwNotExecutedError(DB2Connection dB2Connection) throws SQLException {
        throw new DB2Exception(dB2Connection.errMsgClass.getString("0604"), "S1010", -99999);
    }

    public static void throwTypeError(DB2Connection dB2Connection) throws SQLException {
        throw new DB2Exception(dB2Connection.errMsgClass.getString("0605"), "22005", -99999);
    }

    public static void throwOutOfRangeError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0609"), "22003", -99999);
    }

    public void throwInvalidQueryError() throws SQLException {
        String[] stringArray = new String[]{"QUERY"};
        throw new DB2Exception(errMsgClass.getString("0637", stringArray), "S1000", -99999, null);
    }

    public void throwInvalidUpdateError() throws SQLException {
        String[] stringArray = new String[]{"UPDATE"};
        throw new DB2Exception(errMsgClass.getString("0637", stringArray), "S1000", -99999, null);
    }

    public void throwNullError() throws SQLException {
        throw new SQLException(errMsgClass.getString("0639"));
    }

    public static void throwColumnIndexError(DB2Connection dB2Connection) throws SQLException {
        throw new DB2Exception(dB2Connection.errMsgClass.getString("0610"), "S1002", -99999);
    }

    public static void throwColumnDataTypeError(DB2Connection dB2Connection) throws SQLException {
        throw new DB2Exception(dB2Connection.errMsgClass.getString("0606"), "22005", -99999);
    }

    public static void throwParamIndexError(DB2Connection dB2Connection) throws SQLException {
        throw new DB2Exception(dB2Connection.errMsgClass.getString("0612"), "S1093", -99999);
    }

    public static void throwConnectionClosedError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0600"), "S1000", -99999);
    }

    public static void throwSendError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0614"), "08S01", -99999);
    }

    public static void throwReceiveError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0615"), "08S01", -99999);
    }

    public void throwNotOutputParameterError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0603"), "S1010", -99999, null);
    }

    public void throwNotExecutedError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0604"), "S1010", -99999, null);
    }

    public void throwTypeError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0605"), "22005", -99999, null);
    }

    public void throwColumnIndexError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0610"), "S1002", -99999, null);
    }

    public void throwColumnDataTypeError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0606"), "22005", -99999, null);
    }

    public void throwParamIndexError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0612"), "S1093", -99999, null);
    }

    public void throwClosedError() throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0601"), "S1000", -99999, null);
    }

    public void crs_throw_exception(DB2ResultSet dB2ResultSet, int n) throws SQLException {
        switch (n) {
            case 1: {
                dB2ResultSet.addWarning(new DataTruncation(-1, false, false, -1, -1));
                return;
            }
            case 2: {
                DB2Exception dB2Exception = new DB2Exception(errMsgClass.getString("0607"), "22007", -99999);
                throw dB2Exception;
            }
            case 3: {
                DB2Exception dB2Exception = new DB2Exception(errMsgClass.getString("0608"), "07006", -99999);
                throw dB2Exception;
            }
            case 4: {
                DB2Exception dB2Exception = new DB2Exception(errMsgClass.getString("0609"), "22003", -99999);
                throw dB2Exception;
            }
            case 5: {
                DB2Exception dB2Exception = new DB2Exception(errMsgClass.getString("0606"), "22005", -99999);
                throw dB2Exception;
            }
        }
    }

    public void pstmtException(String string) throws SQLException {
        if (string.equals("S1003")) {
            throw new DB2Exception(errMsgClass.getString("0613"), "S1003", -99999, null);
        }
        if (string.equals("22003")) {
            throw new DB2Exception(errMsgClass.getString("0609"), "22003", -99999, null);
        }
    }

    public void rsException(String string) throws SQLException {
        if (string.equals("S0022")) {
            throw new DB2Exception(errMsgClass.getString("0611"), "S0022", -99999, null);
        }
        if (string.equals("22005")) {
            throw new DB2Exception(errMsgClass.getString("0606"), "22005", -99999, null);
        }
        if (string.equals("07006")) {
            throw new DB2Exception(errMsgClass.getString("0608"), "07006", -99999, null);
        }
    }

    public void socketException(String string) throws SQLException {
        if (string.equals("08S01a")) {
            throw new DB2Exception(errMsgClass.getString("0614"), "08S01", -99999);
        }
        if (string.equals("08S01b")) {
            throw new DB2Exception(errMsgClass.getString("0615"), "08S01", -99999);
        }
        if (string.equals("08S01c")) {
            throw new DB2Exception(errMsgClass.getString("0616"), "08S01", -99999);
        }
        if (string.equals("08S01d")) {
            throw new DB2Exception(errMsgClass.getString("0617"), "08S01", -99999);
        }
    }

    public void throw_IOException(IOException iOException) throws SQLException {
        throw new DB2Exception(errMsgClass.getString("0620"), "22021", -99999, null);
    }

    public void connException(String string) throws SQLException {
        if (string.trim().equals("S1C00")) {
            throw new DB2Exception(errMsgClass.getString("0700"), "S1C00", -99999, null);
        }
    }

    protected int getSQLConnectionError(DB2Connection dB2Connection) throws SQLException {
        DB2Request dB2Request = dB2Connection.db2req;
        this.closeConn = false;
        int n = 0;
        try {
            dB2Request.write((short)55);
            dB2Request.sendAndRecv();
            n = dB2Request.readInt();
            if (n == 0) {
                this.SQLmessage = dB2Request.readString();
                this.SQLState = dB2Request.readString();
                this.SQLnativeCode = dB2Request.readInt();
                this.closeConn = dB2Request.readBoolean();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.socketException("08S01a");
        }
        return n;
    }

    protected int getSQLStatementError(DB2Statement dB2Statement) throws SQLException {
        DB2Request dB2Request = dB2Statement.db2req;
        int n = 0;
        try {
            dB2Request.write((short)56);
            dB2Request.write(dB2Statement.getHandle());
            dB2Request.sendAndRecv();
            n = dB2Request.readInt();
            if (n == 0) {
                this.SQLmessage = dB2Request.readString();
                this.SQLState = dB2Request.readString();
                this.SQLnativeCode = dB2Request.readInt();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.socketException("08S01a");
        }
        return n;
    }
}

